/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DbCredentialManager;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.passwordSafe.ui.PasswordPromptComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseCredentials {
    private static final String DB_SSH_PWD = "db:ssh:pwd@";
    private static final String DB_SSH_PHR = "db:ssh:phr@";
    private static final DatabaseCredentials ourInstance = new DatabaseCredentials();
    private final DbCredentialManager dbCredentialManager = new DbCredentialManager();
    private static final Object ourEDTLock = new Object();

    public static DatabaseCredentials getInstance() {
        return ourInstance;
    }

    public static DatabaseCredentials newUIInstance() {
        return new DatabaseCredentials(){
            boolean myForceMemoryProvider;

            @Override
            public void persistCredentials(@NotNull DatabaseSystem info) {
                if (info == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.myForceMemoryProvider && info instanceof LocalDataSource && ((LocalDataSource)info).isUseMasterKeyStorage()) {
                    ((LocalDataSource)info).setUseMasterKeyStorage(false);
                }
                super.persistCredentials(info);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials$1", "persistCredentials"));
            }
        };
    }

    @Nullable
    private static LocalDataSource getLocalDataSource(@Nullable DatabaseSystem info) {
        if (!(info instanceof LocalDataSource)) {
            return null;
        }
        if (!DbImplUtil.isAuthRequired((LocalDataSource)info)) {
            return null;
        }
        return (LocalDataSource)info;
    }

    protected static boolean isUseCredentialStore(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DatabaseCredentials.$$$reportNull$$$0(0);
        }
        return dataSource.getUniqueId() != null;
    }

    @Nullable
    public Credentials getCredentials(@NotNull DatabaseSystem info) {
        LocalDataSource dataSource;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(1);
        }
        if ((dataSource = DatabaseCredentials.getLocalDataSource(info)) == null) {
            return null;
        }
        if (dataSource.getUniqueId() == null) {
            return new Credentials(dataSource.getUsername(), dataSource.getPassword());
        }
        return new Credentials(dataSource.getUsername(), this.dbCredentialManager.getPasswordAsString(dataSource, null));
    }

    @NotNull
    public CompletionStage<Credentials> getCredentialsAsync(@NotNull DatabaseSystem info) {
        LocalDataSource dataSource;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(2);
        }
        if ((dataSource = DatabaseCredentials.getLocalDataSource(info)) == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                DatabaseCredentials.$$$reportNull$$$0(3);
            }
            return completableFuture;
        }
        if (dataSource.getUniqueId() == null) {
            CompletableFuture<Credentials> completableFuture = CompletableFuture.completedFuture(new Credentials(dataSource.getUsername(), dataSource.getPassword()));
            if (completableFuture == null) {
                DatabaseCredentials.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        CompletionStage<Credentials> completionStage = this.dbCredentialManager.getPasswordAsStringAsync(dataSource, null).thenApply(p -> new Credentials(dataSource.getUsername(), p));
        if (completionStage == null) {
            DatabaseCredentials.$$$reportNull$$$0(5);
        }
        return completionStage;
    }

    public boolean setCredentials(@NotNull DatabaseSystem info, @NotNull Credentials credentials) {
        LocalDataSource dataSource;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(6);
        }
        if (credentials == null) {
            DatabaseCredentials.$$$reportNull$$$0(7);
        }
        if ((dataSource = DatabaseCredentials.getLocalDataSource(info)) == null) {
            return false;
        }
        dataSource.setUsername(credentials.getUserName());
        if (dataSource.getUniqueId() == null) {
            dataSource.setPassword(credentials.getPasswordAsString());
        } else {
            this.dbCredentialManager.set(dataSource, credentials, dataSource.isUseMasterKeyStorage());
        }
        return true;
    }

    public boolean removeCredentials(@NotNull DatabaseSystem info) {
        LocalDataSource dataSource;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(8);
        }
        if ((dataSource = DatabaseCredentials.getLocalDataSource(info)) == null) {
            return false;
        }
        if (DatabaseCredentials.isUseCredentialStore(dataSource)) {
            this.dbCredentialManager.set(dataSource, null);
        } else {
            dataSource.setPassword(null);
        }
        return true;
    }

    public void copyCredentials(@NotNull DatabaseSystem from, @NotNull DatabaseSystem to) {
        Credentials credentials;
        if (from == null) {
            DatabaseCredentials.$$$reportNull$$$0(9);
        }
        if (to == null) {
            DatabaseCredentials.$$$reportNull$$$0(10);
        }
        if ((credentials = this.getCredentials(from)) != null && credentials.getUserName() != null) {
            this.setCredentials(to, credentials);
        }
    }

    public void persistCredentials(@NotNull DatabaseSystem info) {
        LocalDataSource dataSource;
        if (info == null) {
            DatabaseCredentials.$$$reportNull$$$0(11);
        }
        if ((dataSource = DatabaseCredentials.getLocalDataSource(info)) == null) {
            return;
        }
        String uid = dataSource.getUsername();
        String pwd = dataSource.getPassword();
        dataSource.setPassword(null);
        dataSource.setUsername(uid);
        if (dataSource.getUniqueId() == null) {
            dataSource.setPassword(pwd);
        } else {
            this.dbCredentialManager.set(dataSource, new Credentials(uid, pwd), dataSource.isUseMasterKeyStorage());
        }
    }

    @NotNull
    public CompletionStage<Credentials> askCredentialsWhenFailed(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String message, String userNameDef) {
        if (project == null) {
            DatabaseCredentials.$$$reportNull$$$0(12);
        }
        if (dataSource == null) {
            DatabaseCredentials.$$$reportNull$$$0(13);
        }
        if (message == null) {
            DatabaseCredentials.$$$reportNull$$$0(14);
        }
        if (DatabaseCredentials.getLocalDataSource(dataSource) == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                DatabaseCredentials.$$$reportNull$$$0(15);
            }
            return completableFuture;
        }
        if (project.isDefault()) {
            CompletableFuture<Credentials> completableFuture = AsyncUtil.cancelled();
            if (completableFuture == null) {
                DatabaseCredentials.$$$reportNull$$$0(16);
            }
            return completableFuture;
        }
        Credentials c1 = this.getCredentials(dataSource);
        CompletableFuture<Credentials> completableFuture = CompletableFuture.supplyAsync(AsyncUtil.captureIndicator(() -> {
            Credentials c2;
            if (dataSource == null) {
                DatabaseCredentials.$$$reportNull$$$0(30);
            }
            if (message == null) {
                DatabaseCredentials.$$$reportNull$$$0(31);
            }
            if (project == null) {
                DatabaseCredentials.$$$reportNull$$$0(32);
            }
            if (!Comparing.equal((Object)c1, (Object)(c2 = this.getCredentials(dataSource)))) {
                return c2;
            }
            PasswordPromptComponent component = new PasswordPromptComponent(dataSource.getUniqueId() == null, message);
            component.setUserName(StringUtil.notNullize((String)userNameDef));
            DialogBuilder builder = new DialogBuilder(project);
            builder.setTitle("Connecting to '" + dataSource.getName() + "'...");
            builder.setCenterPanel(component.getComponent());
            builder.setPreferredFocusComponent(component.getPreferredFocusedComponent());
            builder.addOkAction();
            builder.addCancelAction();
            if (builder.show() != 0) {
                return null;
            }
            Credentials credentials = new Credentials(component.getUserName(), component.getPassword());
            dataSource.setUsername(credentials.getUserName());
            if (dataSource.getUniqueId() == null) {
                dataSource.setPassword(new String(component.getPassword()));
            } else {
                boolean remember = component.isRememberSelected();
                dataSource.setUseMasterKeyStorage(remember);
                this.dbCredentialManager.set(dataSource, credentials, remember);
            }
            return credentials;
        }), this::invokeLater);
        if (completableFuture == null) {
            DatabaseCredentials.$$$reportNull$$$0(17);
        }
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(@NotNull Runnable r) {
        Application app;
        if (r == null) {
            DatabaseCredentials.$$$reportNull$$$0(18);
        }
        if ((app = ApplicationManager.getApplication()).isDispatchThread()) {
            r.run();
            return;
        }
        ProgressIndicator asyncProgress = AsyncUtil.getAsyncFriendlyIndicator();
        Runnable wrapped = () -> {
            if (r == null) {
                DatabaseCredentials.$$$reportNull$$$0(29);
            }
            AsyncUtil.underProgress(r, asyncProgress);
        };
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        Object object = ourEDTLock;
        synchronized (object) {
            if (indicator != null && indicator.isModal()) {
                UIUtil.invokeLaterIfNeeded((Runnable)wrapped);
            } else {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(wrapped);
            }
        }
    }

    public void setSshCredentials(@NotNull LocalDataSource dataSource, char[] pwd, char[] phr, boolean useMasterKey) {
        DataSourceSshTunnelConfiguration ssh;
        if (dataSource == null) {
            DatabaseCredentials.$$$reportNull$$$0(19);
        }
        if ((ssh = dataSource.getSshConfiguration()) == null || dataSource.getUniqueId() == null) {
            return;
        }
        this.dbCredentialManager.set(dataSource, new Credentials(dataSource.getUsername(), pwd), useMasterKey, DB_SSH_PWD);
        this.dbCredentialManager.set(dataSource, new Credentials(dataSource.getUsername(), phr), useMasterKey, DB_SSH_PHR);
    }

    public void removeSshCredentials(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DatabaseCredentials.$$$reportNull$$$0(20);
        }
        if (DatabaseCredentials.isUseCredentialStore(dataSource)) {
            this.dbCredentialManager.set(dataSource, null, true, DB_SSH_PWD);
            this.dbCredentialManager.set(dataSource, null, true, DB_SSH_PHR);
        }
    }

    @NotNull
    public Pair<String, String> getSshCredentials(@NotNull LocalDataSource dataSource) {
        DataSourceSshTunnelConfiguration ssh;
        if (dataSource == null) {
            DatabaseCredentials.$$$reportNull$$$0(21);
        }
        if ((ssh = dataSource.getSshConfiguration()) == null) {
            Pair pair = Pair.create((Object)"", (Object)"");
            if (pair == null) {
                DatabaseCredentials.$$$reportNull$$$0(22);
            }
            return pair;
        }
        if (DatabaseCredentials.isUseCredentialStore(dataSource)) {
            String pwd = this.dbCredentialManager.getPasswordAsString(dataSource, DB_SSH_PWD);
            String phr = this.dbCredentialManager.getPasswordAsString(dataSource, DB_SSH_PHR);
            Pair pair = Pair.create((Object)StringUtil.notNullize((String)pwd), (Object)StringUtil.notNullize((String)phr));
            if (pair == null) {
                DatabaseCredentials.$$$reportNull$$$0(23);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)PasswordUtil.decodePassword((String)ssh.getPassword()), (Object)PasswordUtil.decodePassword((String)ssh.getPassphrase()));
        if (pair == null) {
            DatabaseCredentials.$$$reportNull$$$0(24);
        }
        return pair;
    }

    @NotNull
    public CompletionStage<Pair<String, String>> getSshCredentialsAsync(@NotNull LocalDataSource dataSource) {
        DataSourceSshTunnelConfiguration ssh;
        if (dataSource == null) {
            DatabaseCredentials.$$$reportNull$$$0(25);
        }
        if ((ssh = dataSource.getSshConfiguration()) == null) {
            CompletableFuture<Pair<String, String>> completableFuture = CompletableFuture.completedFuture(Pair.create((Object)"", (Object)""));
            if (completableFuture == null) {
                DatabaseCredentials.$$$reportNull$$$0(26);
            }
            return completableFuture;
        }
        if (DatabaseCredentials.isUseCredentialStore(dataSource)) {
            CompletionStage<Pair<String, String>> completionStage = this.dbCredentialManager.getPasswordAsStringAsync(dataSource, DB_SSH_PWD).thenCombine(this.dbCredentialManager.getPasswordAsStringAsync(dataSource, DB_SSH_PHR), (pwd, phr) -> Pair.create((Object)StringUtil.notNullize((String)pwd), (Object)StringUtil.notNullize((String)phr)));
            if (completionStage == null) {
                DatabaseCredentials.$$$reportNull$$$0(27);
            }
            return completionStage;
        }
        CompletableFuture<Pair<String, String>> completableFuture = CompletableFuture.completedFuture(Pair.create((Object)PasswordUtil.decodePassword((String)ssh.getPassword()), (Object)PasswordUtil.decodePassword((String)ssh.getPassphrase())));
        if (completableFuture == null) {
            DatabaseCredentials.$$$reportNull$$$0(28);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/access/DatabaseCredentials";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 12: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/access/DatabaseCredentials";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentialsAsync";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "askCredentialsWhenFailed";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSshCredentials";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSshCredentialsAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUseCredentialStore";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCredentials";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCredentialsAsync";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCredentials";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeCredentials";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyCredentials";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "persistCredentials";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "askCredentialsWhenFailed";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setSshCredentials";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeSshCredentials";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSshCredentials";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSshCredentialsAsync";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invokeLater$2";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$askCredentialsWhenFailed$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

