/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.BasicElementAction;
import com.intellij.database.actions.GenerateScriptDialog;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000eH\u0014J\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000eH\u0014J.\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00140\u00132\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000eH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/actions/GenerateScriptAction;", "Lcom/intellij/database/actions/BasicElementAction;", "Lcom/intellij/database/model/basic/BasicScriptable;", "()V", "cast", "node", "Lcom/intellij/database/model/basic/BasicNode;", "doIt", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "selection", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/database/model/basic/BasicModel;", "enabled", "", "getElementsToGenerate", "Lkotlin/Pair;", "", "database-impl"})
public final class GenerateScriptAction
extends BasicElementAction<BasicScriptable> {
    @Override
    @Nullable
    protected BasicScriptable cast(@Nullable BasicNode node) {
        BasicNode basicNode = node;
        if (!(basicNode instanceof BasicScriptable)) {
            basicNode = null;
        }
        return (BasicScriptable)basicNode;
    }

    @Override
    protected boolean enabled(@NotNull MultiMap<BasicModel, BasicScriptable> selection) {
        Intrinsics.checkParameterIsNotNull(selection, (String)"selection");
        return selection.keySet().size() == 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doIt(@NotNull AnActionEvent e, @NotNull Project project, @NotNull MultiMap<BasicModel, BasicScriptable> selection) {
        void model;
        DbElement first;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(selection, (String)"selection");
        Pair<BasicModel, Collection<BasicNode>> pair = this.getElementsToGenerate(selection);
        BasicModel basicModel = (BasicModel)pair.component1();
        Collection elements = (Collection)pair.component2();
        if (elements.isEmpty()) {
            return;
        }
        DbElement dbElement = first = (DbElement)CollectionsKt.first((Iterable)DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class));
        Intrinsics.checkExpressionValueIsNotNull((Object)dbElement, (String)"first");
        GenerateScriptDialog dialog = new GenerateScriptDialog((BasicModel)model, project, dbElement);
        dialog.getSelection().addAll(elements);
        dialog.show();
    }

    private final Pair<BasicModel, Collection<BasicNode>> getElementsToGenerate(MultiMap<BasicModel, BasicScriptable> selection) {
        BasicModel firstModel = (BasicModel)CollectionsKt.first((Iterable)selection.keySet());
        Collection elements = selection.get((Object)firstModel);
        return new Pair((Object)firstModel, (Object)elements);
    }
}

