/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.GenerateScriptAction;
import com.intellij.database.actions.GenerateScriptDialog;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.scripting.CustomScriptingOptions;
import com.intellij.database.scripting.DefaultScriptingOptions;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingOption;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 K2\u00020\u0001:\u0003KLMB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010;\u001a\u00020<H\u0002J\b\u0010=\u001a\u00020<H\u0002J\b\u0010>\u001a\u00020<H\u0016J\b\u0010?\u001a\u00020<H\u0002J\b\u0010@\u001a\u00020<H\u0002J\b\u0010A\u001a\u00020<H\u0002J\n\u0010B\u001a\u0004\u0018\u00010CH\u0002J\u0006\u0010D\u001a\u00020EJ\u0006\u0010F\u001a\u00020<J\u0006\u0010G\u001a\u00020<J\u0006\u0010H\u001a\u00020<J\u000e\u0010I\u001a\u00020<2\u0006\u0010J\u001a\u00020\u001aR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00103\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u000305\u0012\u0004\u0012\u00020604X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/intellij/database/actions/GenerateScriptDialog;", "Lcom/intellij/openapi/Disposable;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/database/psi/DbElement;", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/psi/DbElement;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "availableTasks", "", "Lcom/intellij/database/scripting/ScriptingTask;", "getAvailableTasks", "()[Lcom/intellij/database/scripting/ScriptingTask;", "[Lcom/intellij/database/scripting/ScriptingTask;", "dialog", "Lcom/intellij/openapi/ui/DialogBuilder;", "done", "", "editorFactory", "Lcom/intellij/openapi/editor/EditorFactory;", "getElement", "()Lcom/intellij/database/psi/DbElement;", "generatedText", "", "generationInProgress", "Ljava/lang/Object;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "optionsPanel", "Ljavax/swing/JPanel;", "optionsPanel1", "optionsPanel2", "getProject", "()Lcom/intellij/openapi/project/Project;", "scriptingFactory", "Lcom/intellij/database/scripting/ScriptingFactory;", "selection", "", "Lcom/intellij/database/model/basic/BasicNode;", "getSelection", "()Ljava/util/List;", "task", "taskSelector", "Lcom/intellij/openapi/ui/ComboBox;", "toolbar1", "toolbar2", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "topPanel", "uiOptions", "Ljava/util/TreeMap;", "Lcom/intellij/database/scripting/ScriptingOption;", "Lcom/intellij/database/actions/GenerateScriptDialog$UiOption;", "viewer", "Lcom/intellij/ui/EditorTextField;", "viewerComponent", "Ljavax/swing/JComponent;", "adjustOptions", "", "close", "dispose", "doCopyToClipboard", "doOpenInConsole", "doSaveToFile", "findDsForModel", "Lcom/intellij/database/dataSource/LocalDataSource;", "getScriptingOptions", "Lcom/intellij/database/scripting/ScriptingOptions;", "prepareOptionComponents", "regenerate", "show", "showTheScript", "scriptText", "Companion", "FinalAction", "UiOption", "database-impl"})
public final class GenerateScriptDialog
implements Disposable {
    @NotNull
    private final ScriptingTask[] availableTasks;
    @NotNull
    private final List<BasicNode> selection;
    private final ScriptingFactory scriptingFactory;
    private final EditorFactory editorFactory;
    private final JComponent viewerComponent;
    private final JPanel topPanel;
    private final JPanel toolbar1;
    private final ActionToolbar toolbar2;
    private final JPanel optionsPanel;
    private final JPanel optionsPanel1;
    private final JPanel optionsPanel2;
    private final ComboBox<ScriptingTask> taskSelector;
    private EditorTextField viewer;
    private DialogBuilder dialog;
    private final TreeMap<ScriptingOption<?>, UiOption> uiOptions;
    private final SingleAlarm alarm;
    private final Object generationInProgress;
    private ScriptingTask task;
    private String generatedText;
    private boolean done;
    @NotNull
    private final BasicModel model;
    @NotNull
    private final Project project;
    @NotNull
    private final DbElement element;
    @NotNull
    private static final List<ScriptingTask> implementedTasks;
    public static final Companion Companion;

    @NotNull
    public final ScriptingTask[] getAvailableTasks() {
        return this.availableTasks;
    }

    @NotNull
    public final List<BasicNode> getSelection() {
        return this.selection;
    }

    /*
     * WARNING - void declaration
     */
    public final void prepareOptionComponents() {
        void $receiver$iv$iv;
        Iterable $receiver$iv = ScriptingOptionStatic.SCRIPTING_OPTIONS;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ScriptingOption it = (ScriptingOption)element$iv$iv;
            if (!it.getApplicableRdbms().contains(this.model.getRdbms())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List rdbmsApplicableOptions = (List)destination$iv$iv;
        for (ScriptingOption option : rdbmsApplicableOptions) {
            Object object;
            if (JvmClassMappingKt.getJavaClass(option.getValueClass()).isEnum()) {
                Object[] objectArray;
                void thisCollection$iv;
                void $receiver$iv2;
                ComboBox comboBox;
                Object element$iv$iv;
                JLabel itemLabel = new JLabel(option.getDisplayName() + ": ");
                element$iv$iv = option.getItems();
                ComboBox comboBox2 = comboBox;
                ComboBox comboBox3 = comboBox;
                if ($receiver$iv2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                if (thisCollection$iv.toArray(new Object[thisCollection$iv.size()]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                comboBox2(objectArray);
                ComboBox itemSelector = comboBox3;
                JPanel itemPanel = new JPanel(new BorderLayout(), false);
                itemPanel.add((Component)itemSelector, "Center");
                itemPanel.add((Component)itemLabel, "West");
                this.optionsPanel1.add(itemPanel);
                ScriptingOption scriptingOption = option;
                Intrinsics.checkExpressionValueIsNotNull((Object)scriptingOption, (String)"option");
                UiOption o = new UiOption(scriptingOption, itemPanel, option.getDefaultValue());
                itemSelector.addActionListener(new ActionListener(this, o, itemSelector, option){
                    final /* synthetic */ GenerateScriptDialog this$0;
                    final /* synthetic */ UiOption $o;
                    final /* synthetic */ ComboBox $itemSelector;
                    final /* synthetic */ ScriptingOption $option;

                    public final void actionPerformed(ActionEvent it) {
                        Enum enum_;
                        Object object = this.$itemSelector.getSelectedItem();
                        if (!(object instanceof Enum)) {
                            object = null;
                        }
                        if ((enum_ = (Enum)object) == null) {
                            enum_ = this.$option.getDefaultValue();
                        }
                        this.$o.setValue(enum_);
                        GenerateScriptDialog.access$getAlarm$p(this.this$0).cancelAndRequest();
                    }
                    {
                        this.this$0 = generateScriptDialog;
                        this.$o = uiOption;
                        this.$itemSelector = comboBox;
                        this.$option = scriptingOption;
                    }
                });
                object = this.uiOptions;
                ScriptingOption scriptingOption2 = option;
                UiOption uiOption = o;
                object.put(scriptingOption2, uiOption);
                continue;
            }
            if (!Intrinsics.areEqual(option.getValueClass(), (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) continue;
            JCheckBox checkbox = ComponentsKt.CheckBox((String)option.getDisplayName(), (boolean)false, null);
            this.optionsPanel2.add(checkbox);
            ScriptingOption scriptingOption = option;
            Intrinsics.checkExpressionValueIsNotNull((Object)scriptingOption, (String)"option");
            UiOption o = new UiOption(scriptingOption, checkbox, option.getDefaultValue());
            checkbox.addActionListener(new ActionListener(this, o, checkbox){
                final /* synthetic */ GenerateScriptDialog this$0;
                final /* synthetic */ UiOption $o;
                final /* synthetic */ JCheckBox $checkbox;

                public final void actionPerformed(ActionEvent it) {
                    this.$o.setValue(this.$checkbox.isSelected());
                    GenerateScriptDialog.access$getAlarm$p(this.this$0).cancelAndRequest();
                }
                {
                    this.this$0 = generateScriptDialog;
                    this.$o = uiOption;
                    this.$checkbox = jCheckBox;
                }
            });
            Map map2 = this.uiOptions;
            ScriptingOption scriptingOption3 = option;
            object = o;
            map2.put(scriptingOption3, object);
        }
    }

    public final void show() {
        this.adjustOptions();
        DialogBuilder dia = new DialogBuilder();
        dia.removeAllActions();
        dia.setTitle("SQL script generation");
        dia.setNorthPanel((JComponent)this.topPanel);
        dia.setCenterPanel(this.viewerComponent);
        EditorTextField editorTextField = this.viewer;
        if (editorTextField == null) {
            Intrinsics.throwNpe();
        }
        dia.setPreferredFocusComponent(editorTextField.getComponent());
        dia.addDisposable((Disposable)this);
        dia.setDimensionServiceKey(GenerateScriptAction.class.getSimpleName());
        dia.showNotModal();
        this.regenerate();
        this.dialog = dia;
    }

    private final void adjustOptions() {
        Iterable $receiver$iv;
        Iterable iterable;
        Iterable $receiver$iv2 = iterable = ($receiver$iv = (Iterable)this.uiOptions.values());
        for (Object element$iv : $receiver$iv2) {
            UiOption it = (UiOption)element$iv;
            it.getComponent().setVisible(it.getOption().getApplicableTasks().contains((Object)this.task));
        }
        this.optionsPanel.revalidate();
    }

    @NotNull
    public final ScriptingOptions getScriptingOptions() {
        TreeMap map2 = new TreeMap();
        for (UiOption o : this.uiOptions.values()) {
            if (Intrinsics.areEqual((Object)o.getValue(), o.getOption().getDefaultValue())) continue;
            Map map3 = map2;
            ScriptingOption<?> scriptingOption = o.getOption();
            Object object = o.getValue();
            map3.put(scriptingOption, object);
        }
        return map2.isEmpty() ? (ScriptingOptions)DefaultScriptingOptions.INSTANCE : (ScriptingOptions)new CustomScriptingOptions(map2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void regenerate() {
        Object object = this.generationInProgress;
        synchronized (object) {
            ScriptingOptions scriptingOptions = this.getScriptingOptions();
            JBIterable sel = JBIterable.from((Iterable)this.selection);
            JBIterable explicitDatabases = sel.filter(BasicDatabase.class);
            JBIterable explicitSchemas = sel.filter(BasicSchema.class);
            JBIterable explicitScriptableObjects = sel.filter(BasicScriptable.class);
            List schemasToGenerate2 = explicitDatabases.flatten((Function)regenerate.1.schemasToGenerate.1.INSTANCE).append((Iterable)explicitSchemas).toList();
            List objectsToGenerate2 = explicitScriptableObjects.filter((Condition)new Condition<BasicScriptable>(schemasToGenerate2){
                final /* synthetic */ List $schemasToGenerate;

                public final boolean value(BasicScriptable it) {
                    return !this.$schemasToGenerate.contains(it.getSchema());
                }
                {
                    this.$schemasToGenerate = list;
                }
            }).toList();
            ScriptingService service = ScriptingFactory.DefaultImpls.createScriptingService$default(this.scriptingFactory, this.model, null, 2, null);
            service.setOptions(scriptingOptions);
            Collection collection = schemasToGenerate2;
            if (!collection.isEmpty()) {
                List list = schemasToGenerate2;
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"schemasToGenerate");
                service.makeScript(this.task, list);
            }
            if (!(collection = (Collection)objectsToGenerate2).isEmpty()) {
                List list = objectsToGenerate2;
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"objectsToGenerate");
                ScriptingService.DefaultImpls.makeScript$default(service, this.task, list, false, 4, null);
            }
            this.generatedText = service.getScriptText();
            Unit unit = Unit.INSTANCE;
        }
        String string = this.generatedText;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.showTheScript(string);
    }

    public final void showTheScript(@NotNull String scriptText) {
        Intrinsics.checkParameterIsNotNull((Object)scriptText, (String)"scriptText");
        SwingUtilities.invokeLater(new Runnable(this, scriptText){
            final /* synthetic */ GenerateScriptDialog this$0;
            final /* synthetic */ String $scriptText;

            public final void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                    final /* synthetic */ showTheScript.1 this$0;

                    public final void run() {
                        EditorTextField editorTextField = GenerateScriptDialog.access$getViewer$p(this.this$0.this$0);
                        if (editorTextField == null) {
                            Intrinsics.throwNpe();
                        }
                        editorTextField.setText(this.this$0.$scriptText);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = generateScriptDialog;
                this.$scriptText = string;
            }
        });
    }

    private final void doCopyToClipboard() {
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.generatedText));
        this.done = true;
    }

    private final void doSaveToFile() {
    }

    private final void doOpenInConsole() {
        String string = this.generatedText;
        if (string == null) {
            return;
        }
        String text = string;
        LocalDataSource localDataSource = this.findDsForModel();
        if (localDataSource == null) {
            return;
        }
        LocalDataSource ds = localDataSource;
        VirtualFile virtualFile = DatabaseEditorHelper.createNewConsoleVirtualFile(ds);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return;
        }
        Document document2 = document;
        WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(document2, text){
            final /* synthetic */ Document $document;
            final /* synthetic */ String $text;

            public final void run() {
                this.$document.setText((CharSequence)this.$text);
            }
            {
                this.$document = document;
                this.$text = string;
            }
        });
        DatabaseEditorHelper.openConsoleForFile(this.project, null, virtualFile2);
        this.done = true;
    }

    private final LocalDataSource findDsForModel() {
        Object v0;
        block1: {
            Iterable $receiver$iv = DataSourceStorage.getProjectStorage(this.project).getDataSources();
            for (Object element$iv : $receiver$iv) {
                LocalDataSource ds = (LocalDataSource)element$iv;
                if (!Intrinsics.areEqual((Object)ds.getModel(), (Object)this.model)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void close() {
        DialogBuilder dia;
        EditorTextField v = this.viewer;
        if (v != null) {
            this.viewer = null;
        }
        if ((dia = this.dialog) != null) {
            dia.getWindow().setVisible(false);
            dia.dispose();
            this.dialog = null;
        }
    }

    public void dispose() {
        this.close();
    }

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DbElement getElement() {
        return this.element;
    }

    /*
     * WARNING - void declaration
     */
    public GenerateScriptDialog(@NotNull BasicModel model, @NotNull Project project, @NotNull DbElement element) {
        void $receiver$iv$iv;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.model = model;
        this.project = project;
        this.element = element;
        Iterable iterable = Companion.getImplementedTasks();
        GenerateScriptDialog generateScriptDialog = this;
        void var5_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ScriptingTask it = (ScriptingTask)((Object)element$iv$iv);
            if (!it.getApplicableRdbms().contains(this.model.getRdbms())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ScriptingTask[] scriptingTaskArray = (ScriptingTask[])destination$iv$iv;
        Collection thisCollection$iv = $receiver$iv = (Collection)scriptingTaskArray;
        ScriptingTask[] scriptingTaskArray2 = thisCollection$iv.toArray(new ScriptingTask[thisCollection$iv.size()]);
        if (scriptingTaskArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        scriptingTaskArray = scriptingTaskArray2;
        generateScriptDialog.availableTasks = scriptingTaskArray;
        this.selection = new ArrayList();
        this.uiOptions = new TreeMap();
        this.alarm = new SingleAlarm(new Runnable(this){
            final /* synthetic */ GenerateScriptDialog this$0;

            public final void run() {
                this.this$0.regenerate();
            }
            {
                this.this$0 = generateScriptDialog;
            }
        }, 250, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
        this.generationInProgress = new Object();
        this.task = ScriptingTask.CREATE_COMPLETE;
        Object object = ServiceManager.getService(ScriptingFactory.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026ptingFactory::class.java)");
        this.scriptingFactory = (ScriptingFactory)object;
        ActionManager actionManager = ActionManager.getInstance();
        EditorFactory editorFactory = EditorFactory.getInstance();
        if (editorFactory == null) {
            Intrinsics.throwNpe();
        }
        this.editorFactory = editorFactory;
        DasNamespace searchPathObject = DbImplUtil.getSearchPathObject(this.element);
        EditorTextField editorTextField = this.viewer = DatabaseDialogsHelper.createLanguageEditorArea(this.project, this.element.getDataSource(), CollectionsKt.listOf((Object)searchPathObject), "");
        if (editorTextField == null) {
            Intrinsics.throwNpe();
        }
        editorTextField.addSettingsProvider((EditorSettingsProvider)1.INSTANCE);
        EditorTextField editorTextField2 = this.viewer;
        if (editorTextField2 == null) {
            Intrinsics.throwNpe();
        }
        JComponent jComponent = editorTextField2.getComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"viewer!!.component");
        this.viewerComponent = jComponent;
        FinalAction doCopyToClipboardAction2 = new FinalAction(this, "Copy to Clipboard", null, AllIcons.Actions.Copy, (Function0)new Function0<Unit>(this){
            final /* synthetic */ GenerateScriptDialog this$0;

            public final void invoke() {
                GenerateScriptDialog.access$doCopyToClipboard(this.this$0);
            }
            {
                this.this$0 = generateScriptDialog;
                super(0);
            }
        }, 2, null);
        FinalAction doSaveToFileAction2 = new FinalAction(this, "Save into a File", null, AllIcons.Actions.Menu_saveall, (Function0)new Function0<Unit>(this){
            final /* synthetic */ GenerateScriptDialog this$0;

            public final void invoke() {
                GenerateScriptDialog.access$doSaveToFile(this.this$0);
            }
            {
                this.this$0 = generateScriptDialog;
                super(0);
            }
        }, 2, null);
        FinalAction doOpenInConsoleAction2 = new FinalAction(this, "Open in Console", null, DatabaseIcons.ConsoleRun, (Function0)new Function0<Unit>(this){
            final /* synthetic */ GenerateScriptDialog this$0;

            public final void invoke() {
                GenerateScriptDialog.access$doOpenInConsole(this.this$0);
            }
            {
                this.this$0 = generateScriptDialog;
                super(0);
            }
        }, 2, null);
        DefaultActionGroup actions2 = new DefaultActionGroup(new AnAction[]{doCopyToClipboardAction2, doSaveToFileAction2, doOpenInConsoleAction2});
        this.toolbar1 = new JPanel();
        ActionToolbar actionToolbar = actionManager.createActionToolbar("EditorToolbar", (ActionGroup)actions2, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionToolbar, (String)"actionManager.createActi\u2026_TOOLBAR, actions2, true)");
        this.toolbar2 = actionToolbar;
        JPanel toolBarStripe = new JPanel(new BorderLayout(), false);
        toolBarStripe.add((Component)this.toolbar1, "West");
        toolBarStripe.add((Component)this.toolbar2.getComponent(), "East");
        this.optionsPanel1 = new JPanel((LayoutManager)new VerticalLayout(0), false);
        this.optionsPanel2 = new JPanel((LayoutManager)new VerticalLayout(0), false);
        this.optionsPanel = new JPanel(new GridLayout(1, 2));
        this.optionsPanel.add(this.optionsPanel1);
        this.optionsPanel.add(this.optionsPanel2);
        this.taskSelector = new ComboBox((Object[])this.availableTasks);
        this.taskSelector.setEditable(false);
        this.taskSelector.setSelectedItem((Object)this.task);
        this.taskSelector.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                ScriptingTask selectedTask;
                Object object = taskSelector.getSelectedItem();
                if (!(object instanceof ScriptingTask)) {
                    object = null;
                }
                if ((selectedTask = (ScriptingTask)((Object)object)) != null) {
                    task = selectedTask;
                    this.adjustOptions();
                    alarm.cancelAndRequest();
                }
            }
        });
        this.toolbar1.add((Component)this.taskSelector);
        this.topPanel = new JPanel(new BorderLayout(), false);
        this.topPanel.add((Component)this.optionsPanel, "Center");
        this.topPanel.add((Component)toolBarStripe, "North");
        this.viewerComponent.setMinimumSize(new Dimension(360, 360));
        this.viewerComponent.setPreferredSize(new Dimension(600, 600));
        this.prepareOptionComponents();
    }

    static {
        Companion = new Companion(null);
        implementedTasks = CollectionsKt.listOf((Object[])new ScriptingTask[]{ScriptingTask.CREATE_COMPLETE, ScriptingTask.REFRESH});
    }

    public static final /* synthetic */ void access$setDone$p(GenerateScriptDialog $this, boolean bl) {
        $this.done = bl;
    }

    @Nullable
    public static final /* synthetic */ EditorTextField access$getViewer$p(GenerateScriptDialog $this) {
        return $this.viewer;
    }

    public static final /* synthetic */ void access$setViewer$p(GenerateScriptDialog $this, @Nullable EditorTextField editorTextField) {
        $this.viewer = editorTextField;
    }

    public static final /* synthetic */ void access$doCopyToClipboard(GenerateScriptDialog $this) {
        $this.doCopyToClipboard();
    }

    public static final /* synthetic */ void access$doSaveToFile(GenerateScriptDialog $this) {
        $this.doSaveToFile();
    }

    public static final /* synthetic */ void access$doOpenInConsole(GenerateScriptDialog $this) {
        $this.doOpenInConsole();
    }

    @NotNull
    public static final /* synthetic */ ScriptingTask access$getTask$p(GenerateScriptDialog $this) {
        return $this.task;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B!\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\r\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J+\u0010\u0017\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/actions/GenerateScriptDialog$UiOption;", "", "option", "Lcom/intellij/database/scripting/ScriptingOption;", "component", "Ljavax/swing/JComponent;", "value", "", "(Lcom/intellij/database/scripting/ScriptingOption;Ljavax/swing/JComponent;Ljava/lang/Object;)V", "getComponent", "()Ljavax/swing/JComponent;", "getOption", "()Lcom/intellij/database/scripting/ScriptingOption;", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "compareTo", "", "other", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "toString", "", "database-impl"})
    private static final class UiOption
    implements Comparable<UiOption> {
        @NotNull
        private final ScriptingOption<?> option;
        @NotNull
        private final JComponent component;
        @NotNull
        private Object value;

        @Override
        public int compareTo(@NotNull UiOption other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return this.option.compareTo(other.option);
        }

        @NotNull
        public final ScriptingOption<?> getOption() {
            return this.option;
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        public final void setValue(@NotNull Object object) {
            Intrinsics.checkParameterIsNotNull((Object)object, (String)"<set-?>");
            this.value = object;
        }

        public UiOption(@NotNull ScriptingOption<?> option, @NotNull JComponent component, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull(option, (String)"option");
            Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.option = option;
            this.component = component;
            this.value = value;
        }

        @NotNull
        public final ScriptingOption<?> component1() {
            return this.option;
        }

        @NotNull
        public final JComponent component2() {
            return this.component;
        }

        @NotNull
        public final Object component3() {
            return this.value;
        }

        @NotNull
        public final UiOption copy(@NotNull ScriptingOption<?> option, @NotNull JComponent component, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull(option, (String)"option");
            Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return new UiOption(option, component, value);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ UiOption copy$default(UiOption uiOption, ScriptingOption scriptingOption, JComponent jComponent, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                scriptingOption = uiOption.option;
            }
            if ((n & 2) != 0) {
                jComponent = uiOption.component;
            }
            if ((n & 4) != 0) {
                object = uiOption.value;
            }
            return uiOption.copy(scriptingOption, jComponent, object);
        }

        public String toString() {
            return "UiOption(option=" + this.option + ", component=" + this.component + ", value=" + this.value + ")";
        }

        public int hashCode() {
            ScriptingOption<?> scriptingOption = this.option;
            JComponent jComponent = this.component;
            Object object = this.value;
            return ((scriptingOption != null ? ((Object)scriptingOption).hashCode() : 0) * 31 + (jComponent != null ? jComponent.hashCode() : 0)) * 31 + (object != null ? object.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof UiOption)) break block3;
                    UiOption uiOption = (UiOption)object;
                    if (!Intrinsics.areEqual(this.option, uiOption.option) || !Intrinsics.areEqual((Object)this.component, (Object)uiOption.component) || !Intrinsics.areEqual((Object)this.value, (Object)uiOption.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/actions/GenerateScriptDialog$FinalAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "text", "", "description", "icon", "Ljavax/swing/Icon;", "action", "Lkotlin/Function0;", "", "(Lcom/intellij/database/actions/GenerateScriptDialog;Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;Lkotlin/jvm/functions/Function0;)V", "getAction", "()Lkotlin/jvm/functions/Function0;", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "database-impl"})
    public final class FinalAction
    extends AnAction {
        @NotNull
        private final Function0<Unit> action;
        final /* synthetic */ GenerateScriptDialog this$0;

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        public void actionPerformed(@Nullable AnActionEvent e) {
            this.action.invoke();
            if (this.this$0.done) {
                this.this$0.close();
            }
        }

        public FinalAction(@NotNull GenerateScriptDialog $outer, @Nullable String text, @Nullable String description, @NotNull Icon icon, Function0<Unit> action) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            super(text, description, icon);
            this.this$0 = $outer;
            this.action = action;
        }

        public /* synthetic */ FinalAction(GenerateScriptDialog generateScriptDialog, String string, String string2, Icon icon, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                icon = null;
            }
            this(generateScriptDialog, string, string2, icon, (Function0<Unit>)function0);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/actions/GenerateScriptDialog$Companion;", "", "()V", "implementedTasks", "", "Lcom/intellij/database/scripting/ScriptingTask;", "getImplementedTasks", "()Ljava/util/List;", "database-impl"})
    private static final class Companion {
        @NotNull
        public final List<ScriptingTask> getImplementedTasks() {
            return implementedTasks;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

