/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.SynchronizeHandler;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SynchronizeSchemaAction
extends AnAction
implements DumbAware {
    public SynchronizeSchemaAction() {
        super("Synchronize", null, PlatformIcons.SYNCHRONIZE_ICON);
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        JBIterable<DbElement> selection = DatabaseView.getSelectedElements(e.getDataContext(), true);
        boolean visible = enabled = !selection.isEmpty();
        for (DbElement o : selection) {
            DatabaseSystem delegate = o.getDataSource().getDelegate();
            visible &= delegate instanceof LocalDataSource;
            enabled &= DbImplUtil.canConnectTo(o);
        }
        e.getPresentation().setVisible(visible || e.isFromActionToolbar());
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        JBIterable<DbElement> selection = DatabaseView.getSelectedElements(e.getDataContext(), true);
        SynchronizeSchemaAction.refresh(e.getProject(), selection);
    }

    public static void refresh(Project project, JBIterable<DbElement> selection) {
        Map map2 = ContainerUtil.classify((Iterator)selection.iterator(), o -> o.getDataSource());
        HashSet dataSourceElements = new HashSet();
        dataSourceElements.addAll(map2.keySet());
        if (project != null) {
            for (SynchronizeHandler handler : (SynchronizeHandler[])SynchronizeHandler.EP_NAME.getExtensions()) {
                handler.synchronizationStarted(project, (Set)dataSourceElements);
            }
        }
        for (DbDataSource element : dataSourceElements) {
            Set elements = (Set)map2.get(element);
            if (elements.contains(element) && elements.size() > 1) {
                elements.retainAll(Collections.singletonList(element));
            }
            SynchronizeSchemaAction.refresh(element, elements);
        }
    }

    private static void refresh(DbDataSource element, Collection<DbElement> selection) {
        DatabaseSystem delegate = element.getDelegate();
        if (!(delegate instanceof LocalDataSource)) {
            return;
        }
        LocalDataSource dataSource = (LocalDataSource)delegate;
        LoaderContext context = SynchronizeSchemaAction.createLoaderContext(element, selection, dataSource);
        DataSourceUiUtil.performManualSyncTask(context);
    }

    static LoaderContext createLoaderContext(@NotNull DbDataSource dataSourceElement, @NotNull Collection<? extends DbElement> selection, @NotNull LocalDataSource dataSource) {
        if (dataSourceElement == null) {
            SynchronizeSchemaAction.$$$reportNull$$$0(0);
        }
        if (selection == null) {
            SynchronizeSchemaAction.$$$reportNull$$$0(1);
        }
        if (dataSource == null) {
            SynchronizeSchemaAction.$$$reportNull$$$0(2);
        }
        LoaderContext context = new LoaderContext(dataSourceElement.getProject(), dataSource);
        boolean loadEverything = selection.contains(dataSourceElement);
        if (loadEverything) {
            context.includeAllSchemas();
        }
        if (selection.size() > 1 || !loadEverything) {
            for (DbElement dbElement : selection) {
                if (dbElement == dataSourceElement || dbElement.getDataSource() != dataSourceElement) continue;
                DbElement parent = dbElement.getDbParent();
                if (parent instanceof DbTable || dbElement instanceof DbPackage) {
                    context.include(parent);
                    continue;
                }
                context.include(dbElement);
            }
        }
        return context;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dataSourceElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "selection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dataSource";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/actions/SynchronizeSchemaAction";
        objectArray[2] = "createLoaderContext";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

