/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliArgumentGroup;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.cli.lexer.DbCliLexerAdapter;
import com.intellij.database.cli.lexer.DbCliTokenType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbCliUtil {
    public static final String[] INPUT = new String[]{"<"};

    private DbCliUtil() {
    }

    @NotNull
    public static String cutParameter(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next) {
        if (text == null) {
            DbCliUtil.$$$reportNull$$$0(0);
        }
        if (current == null) {
            DbCliUtil.$$$reportNull$$$0(1);
        }
        if (next == null) {
            DbCliUtil.$$$reportNull$$$0(2);
        }
        String string = StringUtil.trim((String)text.substring(current.getEnd(), next.getStart()));
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static List<CliLexeme> filteredLexemes(@NotNull String text, @NotNull List<String> parameterizable) {
        if (text == null) {
            DbCliUtil.$$$reportNull$$$0(4);
        }
        if (parameterizable == null) {
            DbCliUtil.$$$reportNull$$$0(5);
        }
        List<CliLexeme> list = DbCliUtil.filterLexemes(DbCliUtil.rawLexemes(text), parameterizable);
        if (list == null) {
            DbCliUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public static List<Pair<CliLexeme, CliLexeme>> lexemePairs(@NotNull CliContextDescriptor state, @NotNull List<CliLexeme> lexemes, @NotNull String text, @NotNull CliComponent component) {
        if (state == null) {
            DbCliUtil.$$$reportNull$$$0(7);
        }
        if (lexemes == null) {
            DbCliUtil.$$$reportNull$$$0(8);
        }
        if (text == null) {
            DbCliUtil.$$$reportNull$$$0(9);
        }
        if (component == null) {
            DbCliUtil.$$$reportNull$$$0(10);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < lexemes.size(); ++i2) {
            CliLexeme next;
            CliLexeme current = lexemes.get(i2);
            CliLexeme cliLexeme = next = i2 < lexemes.size() - 1 ? lexemes.get(i2 + 1) : DbCliUtil.getLastCharacterLexeme(text);
            if (!component.isMyLexeme(text, current, next, state)) continue;
            result2.add(Pair.create((Object)current, (Object)next));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            DbCliUtil.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public static String clearString(@NotNull String s, @NotNull Function<String, String> unquoter) {
        if (s == null) {
            DbCliUtil.$$$reportNull$$$0(12);
        }
        if (unquoter == null) {
            DbCliUtil.$$$reportNull$$$0(13);
        }
        String string = DbCliUtil.unescapeAll(unquoter.apply(s));
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static List<String> getCommandLineArguments(@NotNull CliConfiguration.CliParameterProcessor processor, @NotNull String command, @NotNull List<String> parameterizable) {
        if (processor == null) {
            DbCliUtil.$$$reportNull$$$0(15);
        }
        if (command == null) {
            DbCliUtil.$$$reportNull$$$0(16);
        }
        if (parameterizable == null) {
            DbCliUtil.$$$reportNull$$$0(17);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        List<CliLexeme> lexemes = DbCliUtil.filteredLexemes(command, parameterizable);
        for (int i2 = 0; i2 < lexemes.size(); ++i2) {
            CliLexeme next;
            CliLexeme current = lexemes.get(i2);
            CliLexeme cliLexeme = next = i2 < lexemes.size() - 1 ? lexemes.get(i2 + 1) : DbCliUtil.getLastCharacterLexeme(command);
            if (current.isBad()) continue;
            result2.add(DbCliUtil.getArgument(command, current, next, processor, parameterizable));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            DbCliUtil.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    public static Condition<? super CliLexeme> lexemeFinder(@NotNull String text) {
        if (text == null) {
            DbCliUtil.$$$reportNull$$$0(19);
        }
        Condition condition = lexeme -> {
            if (text == null) {
                DbCliUtil.$$$reportNull$$$0(119);
            }
            return StringUtil.equals((CharSequence)lexeme.getText(), (CharSequence)text);
        };
        if (condition == null) {
            DbCliUtil.$$$reportNull$$$0(20);
        }
        return condition;
    }

    @NotNull
    public static Condition<CliArgument> argumentFinder(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        if (text == null) {
            DbCliUtil.$$$reportNull$$$0(21);
        }
        if (current == null) {
            DbCliUtil.$$$reportNull$$$0(22);
        }
        if (next == null) {
            DbCliUtil.$$$reportNull$$$0(23);
        }
        if (cd == null) {
            DbCliUtil.$$$reportNull$$$0(24);
        }
        Condition condition = argument -> {
            if (text == null) {
                DbCliUtil.$$$reportNull$$$0(115);
            }
            if (current == null) {
                DbCliUtil.$$$reportNull$$$0(116);
            }
            if (next == null) {
                DbCliUtil.$$$reportNull$$$0(117);
            }
            if (cd == null) {
                DbCliUtil.$$$reportNull$$$0(118);
            }
            return argument.isMyLexeme(text, current, next, cd);
        };
        if (condition == null) {
            DbCliUtil.$$$reportNull$$$0(25);
        }
        return condition;
    }

    @NotNull
    public static Condition<? super CliLexeme> argumentWithParameterFinder(@NotNull List<CliLexeme> rawLexemes, @NotNull LexemeIndicators indicators) {
        if (rawLexemes == null) {
            DbCliUtil.$$$reportNull$$$0(26);
        }
        if (indicators == null) {
            DbCliUtil.$$$reportNull$$$0(27);
        }
        Condition condition = lexeme -> {
            if (indicators == null) {
                DbCliUtil.$$$reportNull$$$0(113);
            }
            if (rawLexemes == null) {
                DbCliUtil.$$$reportNull$$$0(114);
            }
            return lexeme.isArgument() && ContainerUtil.find((Object[])indicators.getArgs(), DbCliUtil.stringFinder(lexeme)) != null && DbCliUtil.hasParameterAfterArgument(rawLexemes, lexeme, indicators);
        };
        if (condition == null) {
            DbCliUtil.$$$reportNull$$$0(28);
        }
        return condition;
    }

    @NotNull
    public static Condition<? super CliLexeme> lexemeFinder(@NotNull String[] args) {
        if (args == null) {
            DbCliUtil.$$$reportNull$$$0(29);
        }
        Condition condition = lexeme -> {
            if (args == null) {
                DbCliUtil.$$$reportNull$$$0(112);
            }
            return ContainerUtil.find((Object[])args, DbCliUtil.stringFinder(lexeme)) != null;
        };
        if (condition == null) {
            DbCliUtil.$$$reportNull$$$0(30);
        }
        return condition;
    }

    @NotNull
    public static Condition<String> stringFinder(@NotNull CliLexeme lexeme) {
        if (lexeme == null) {
            DbCliUtil.$$$reportNull$$$0(31);
        }
        Condition condition = s -> {
            if (lexeme == null) {
                DbCliUtil.$$$reportNull$$$0(111);
            }
            return StringUtil.equals((CharSequence)lexeme.getText(), (CharSequence)s);
        };
        if (condition == null) {
            DbCliUtil.$$$reportNull$$$0(32);
        }
        return condition;
    }

    @NotNull
    public static List<String> fromElementsToSeparated(@NotNull Collection<DbElement> elements, @NotNull Condition<DbElement> condition) {
        if (elements == null) {
            DbCliUtil.$$$reportNull$$$0(33);
        }
        if (condition == null) {
            DbCliUtil.$$$reportNull$$$0(34);
        }
        List list = ContainerUtil.map((Collection)ContainerUtil.filter(elements, condition), DasObject::getName);
        if (list == null) {
            DbCliUtil.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    public static List<String> getTablesNames(@NotNull Collection<DbElement> elements) {
        if (elements == null) {
            DbCliUtil.$$$reportNull$$$0(36);
        }
        List list = JBIterable.from(elements).filter(DasUtil.byClass(DbTable.class)).map(element -> (DbTable)element).map(DbCliUtil::getTableName).toList();
        if (list == null) {
            DbCliUtil.$$$reportNull$$$0(37);
        }
        return list;
    }

    @NotNull
    public static String getCommandWithout(@NotNull String command, LexemeIndicators ... indicators) {
        if (command == null) {
            DbCliUtil.$$$reportNull$$$0(38);
        }
        if (indicators == null) {
            DbCliUtil.$$$reportNull$$$0(39);
        }
        List<CliLexeme> lexemes = DbCliUtil.rawLexemes(command);
        for (LexemeIndicators indicator : indicators) {
            if (indicator == null) continue;
            int lexemeIndex = DbCliUtil.getIndexFromCommand(lexemes, indicator);
            while (lexemeIndex != -1 && lexemeIndex != lexemes.size() - 1) {
                lexemes.remove(lexemeIndex);
                if (indicator.hasParameter()) {
                    while (lexemes.get(lexemeIndex).isWhitespace()) {
                        lexemes.remove(lexemeIndex);
                    }
                    lexemes.remove(lexemeIndex);
                }
                lexemeIndex = DbCliUtil.getIndexFromCommand(lexemes, indicator);
            }
        }
        String string = StringUtil.join(lexemes, CliLexeme::getText, (String)"");
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    static int getIndexFromCommand(@NotNull List<CliLexeme> lexemes, @NotNull LexemeIndicators indicators) {
        if (lexemes == null) {
            DbCliUtil.$$$reportNull$$$0(41);
        }
        if (indicators == null) {
            DbCliUtil.$$$reportNull$$$0(42);
        }
        return ContainerUtil.lastIndexOf(lexemes, DbCliUtil.argumentWithParameterFinder(lexemes, indicators));
    }

    private static String getTableName(@NotNull DbTable table) {
        DasObject parent;
        if (table == null) {
            DbCliUtil.$$$reportNull$$$0(43);
        }
        String parentName = (parent = DasUtil.getParentOfKind((DasObject)table, (ObjectKind)ObjectKind.SCHEMA, (boolean)true)) == null ? "" : DbCliUtil.quote(parent.getName()) + ".";
        return parentName + DbCliUtil.quote(table.getName());
    }

    private static boolean hasParameterAfterArgument(@NotNull List<CliLexeme> lexemes, @NotNull CliLexeme lexeme, @NotNull LexemeIndicators indicators) {
        int index;
        if (lexemes == null) {
            DbCliUtil.$$$reportNull$$$0(44);
        }
        if (lexeme == null) {
            DbCliUtil.$$$reportNull$$$0(45);
        }
        if (indicators == null) {
            DbCliUtil.$$$reportNull$$$0(46);
        }
        if ((index = ContainerUtil.indexOf(lexemes, (Object)lexeme)) == -1) {
            return false;
        }
        if (!indicators.hasParameter()) {
            return true;
        }
        return lexemes.size() - 1 > index && lexemes.get(index + 1).isParameter() || lexemes.size() - 2 > index && lexemes.get(index + 1).isWhitespace() && lexemes.get(index + 2).isParameter();
    }

    @NotNull
    public static List<CliLexeme> extractArguments(@NotNull String text) {
        if (text == null) {
            DbCliUtil.$$$reportNull$$$0(47);
        }
        List<CliLexeme> list = DbCliUtil.getLexemes(text, DbCliUtil::index);
        if (list == null) {
            DbCliUtil.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    public static List<CliLexeme> rawLexemes(@NotNull String text) {
        if (text == null) {
            DbCliUtil.$$$reportNull$$$0(49);
        }
        List<CliLexeme> list = DbCliUtil.getLexemes(text, (lexemes, lexer) -> lexemes.add(DbCliUtil.lexeme(lexer)));
        if (list == null) {
            DbCliUtil.$$$reportNull$$$0(50);
        }
        return list;
    }

    @NotNull
    public static CliLexeme createLexeme(@NotNull CliComponent component, @NotNull CliContextDescriptor state) {
        if (component == null) {
            DbCliUtil.$$$reportNull$$$0(51);
        }
        if (state == null) {
            DbCliUtil.$$$reportNull$$$0(52);
        }
        CliLexeme cliLexeme = DbCliUtil.createLexeme(component, state, false);
        if (cliLexeme == null) {
            DbCliUtil.$$$reportNull$$$0(53);
        }
        return cliLexeme;
    }

    @NotNull
    public static CliLexeme createLexeme(@NotNull CliComponent component, @NotNull CliContextDescriptor state, boolean spaceAfter) {
        if (component == null) {
            DbCliUtil.$$$reportNull$$$0(54);
        }
        if (state == null) {
            DbCliUtil.$$$reportNull$$$0(55);
        }
        String result2 = " " + component.getFullArgument(state) + " ";
        CliLexeme cliLexeme = new CliLexeme(spaceAfter ? StringUtil.trimLeading((String)result2) : StringUtil.trimTrailing((String)result2), DbCliTokenType.SYNTHETIC, -1, -1);
        if (cliLexeme == null) {
            DbCliUtil.$$$reportNull$$$0(56);
        }
        return cliLexeme;
    }

    @NotNull
    public static <T extends CliArgument> List<CliComponent> createComponents(@NotNull CliArgumentGroup<T> group2, @NotNull Function<T, CliComponent> constructor) {
        if (group2 == null) {
            DbCliUtil.$$$reportNull$$$0(57);
        }
        if (constructor == null) {
            DbCliUtil.$$$reportNull$$$0(58);
        }
        List<CliComponent> list = Arrays.stream(group2.getArguments()).map(constructor).collect(Collectors.toList());
        if (list == null) {
            DbCliUtil.$$$reportNull$$$0(59);
        }
        return list;
    }

    @NotNull
    public static String extractParameterizable(String ... args) {
        String string = DbCliUtil.extract((Condition<String>)((Condition)s -> StringUtil.endsWith((CharSequence)s, (CharSequence)"=") || StringUtil.equals((CharSequence)"<", (CharSequence)s)), args);
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(60);
        }
        return string;
    }

    @NotNull
    public static String extractNonParameterizable(String ... args) {
        String string = DbCliUtil.extract((Condition<String>)((Condition)s -> !StringUtil.endsWith((CharSequence)s, (CharSequence)"=")), args);
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(61);
        }
        return string;
    }

    @NotNull
    private static String extract(@NotNull Condition<String> condition, String ... args) {
        if (condition == null) {
            DbCliUtil.$$$reportNull$$$0(62);
        }
        if (args == null || args.length == 0) {
            if ("" == null) {
                DbCliUtil.$$$reportNull$$$0(63);
            }
            return "";
        }
        String element = (String)ContainerUtil.find((Object[])args, condition);
        String string = StringUtil.notNullize((String)(element == null ? (String)ArrayUtil.getFirstElement((Object[])args) : element));
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(64);
        }
        return string;
    }

    @NotNull
    public static String pgQuote(@NotNull String s) {
        if (s == null) {
            DbCliUtil.$$$reportNull$$$0(65);
        }
        String string = "'" + DbCliUtil.quote(s) + "'";
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(66);
        }
        return string;
    }

    @NotNull
    public static String quote(@NotNull String s) {
        if (s == null) {
            DbCliUtil.$$$reportNull$$$0(67);
        }
        String string = !DbCliUtil.containsNonAlphaCharacters(s) ? s : StringUtil.wrapWithDoubleQuote((String)DbCliUtil.escapeAllQuotes(s));
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(68);
        }
        return string;
    }

    @NotNull
    public static String unescapeAll(@NotNull String s) {
        if (s == null) {
            DbCliUtil.$$$reportNull$$$0(69);
        }
        String string = StringUtil.unescapeChar((String)StringUtil.unescapeChar((String)StringUtil.unescapeChar((String)s, (char)'\"'), (char)'\''), (char)'\\');
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(70);
        }
        return string;
    }

    @NotNull
    public static String fromListToArgument(@NotNull List<String> strings, @NotNull String prefix, @NotNull Function<String, String> processor) {
        if (strings == null) {
            DbCliUtil.$$$reportNull$$$0(71);
        }
        if (prefix == null) {
            DbCliUtil.$$$reportNull$$$0(72);
        }
        if (processor == null) {
            DbCliUtil.$$$reportNull$$$0(73);
        }
        String string = StringUtil.join((Collection)ContainerUtil.map(strings, s -> {
            if (prefix == null) {
                DbCliUtil.$$$reportNull$$$0(109);
            }
            if (processor == null) {
                DbCliUtil.$$$reportNull$$$0(110);
            }
            return prefix + (String)processor.apply((String)s);
        }), (String)" ");
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(74);
        }
        return string;
    }

    @Nullable
    public static String getArgumentValue(@NotNull String command, @NotNull List<String> parameterizable, @NotNull String[] args) {
        List<CliLexeme> lexemes;
        int index;
        if (command == null) {
            DbCliUtil.$$$reportNull$$$0(75);
        }
        if (parameterizable == null) {
            DbCliUtil.$$$reportNull$$$0(76);
        }
        if (args == null) {
            DbCliUtil.$$$reportNull$$$0(77);
        }
        if ((index = ContainerUtil.lastIndexOf(lexemes = DbCliUtil.filteredLexemes(command, parameterizable), DbCliUtil.lexemeFinder(args))) == -1) {
            return null;
        }
        CliLexeme current = lexemes.get(index);
        CliLexeme next = index == lexemes.size() - 1 ? DbCliUtil.getLastCharacterLexeme(command) : lexemes.get(index + 1);
        return DbCliUtil.cutParameter(command, current, next);
    }

    @NotNull
    public static String[] withEquality(String ... strings) {
        if (strings == null) {
            DbCliUtil.$$$reportNull$$$0(78);
        }
        List longArgs = ContainerUtil.findAll((Object[])strings, s -> StringUtil.startsWith((CharSequence)s, (CharSequence)"--"));
        String[] result2 = new String[strings.length + longArgs.size()];
        System.arraycopy(strings, 0, result2, 0, strings.length);
        for (int i2 = 0; i2 < longArgs.size(); ++i2) {
            result2[strings.length + i2] = (String)longArgs.get(i2) + "=";
        }
        if (result2 == null) {
            DbCliUtil.$$$reportNull$$$0(79);
        }
        return result2;
    }

    @NotNull
    static CliLexeme getLastCharacterLexeme(@NotNull String text) {
        if (text == null) {
            DbCliUtil.$$$reportNull$$$0(80);
        }
        CliLexeme cliLexeme = new CliLexeme("", DbCliTokenType.BAD, text.length(), text.length());
        if (cliLexeme == null) {
            DbCliUtil.$$$reportNull$$$0(81);
        }
        return cliLexeme;
    }

    @NotNull
    private static String getArgument(@NotNull String command, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliConfiguration.CliParameterProcessor processor, @NotNull List<String> parameterizable) {
        if (command == null) {
            DbCliUtil.$$$reportNull$$$0(82);
        }
        if (current == null) {
            DbCliUtil.$$$reportNull$$$0(83);
        }
        if (next == null) {
            DbCliUtil.$$$reportNull$$$0(84);
        }
        if (processor == null) {
            DbCliUtil.$$$reportNull$$$0(85);
        }
        if (parameterizable == null) {
            DbCliUtil.$$$reportNull$$$0(86);
        }
        String string = DbCliUtil.isParameterizable(current, parameterizable) ? DbCliUtil.getArgumentWithParameter(command, current, next, processor) : DbCliUtil.unescapeAll(StringUtil.unquoteString((String)current.getText()));
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(87);
        }
        return string;
    }

    @NotNull
    private static String getArgumentWithParameter(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliConfiguration.CliParameterProcessor processor) {
        if (text == null) {
            DbCliUtil.$$$reportNull$$$0(88);
        }
        if (current == null) {
            DbCliUtil.$$$reportNull$$$0(89);
        }
        if (next == null) {
            DbCliUtil.$$$reportNull$$$0(90);
        }
        if (processor == null) {
            DbCliUtil.$$$reportNull$$$0(91);
        }
        String parameter = DbCliUtil.cutParameter(text, current, next);
        boolean needEquality = current.getType() == DbCliTokenType.LONG_PARAMETER && !current.getText().endsWith("=");
        String string = current.getText() + (needEquality && !StringUtil.isEmpty((String)DbCliUtil.unescapeAll(StringUtil.unquoteString((String)parameter))) ? "=" : "") + processor.process(current, parameter);
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(92);
        }
        return string;
    }

    @NotNull
    private static String escapeAllQuotes(@NotNull String s) {
        if (s == null) {
            DbCliUtil.$$$reportNull$$$0(93);
        }
        String string = StringUtil.escapeChars((String)s, (char[])new char[]{'\\', '\"', '\''});
        if (string == null) {
            DbCliUtil.$$$reportNull$$$0(94);
        }
        return string;
    }

    private static void index(@NotNull Collection<CliLexeme> lexemes, @NotNull Lexer lexer) {
        IElementType type;
        List toSkip;
        if (lexemes == null) {
            DbCliUtil.$$$reportNull$$$0(95);
        }
        if (lexer == null) {
            DbCliUtil.$$$reportNull$$$0(96);
        }
        if (ContainerUtil.containsIdentity((Iterable)(toSkip = ContainerUtil.list((Object[])new IElementType[]{DbCliTokenType.BAD, DbCliTokenType.VALUE})), (Object)(type = (IElementType)ObjectUtils.assertNotNull((Object)lexer.getTokenType())))) {
            return;
        }
        lexemes.add(DbCliUtil.lexeme(lexer));
    }

    @NotNull
    private static CliLexeme lexeme(@NotNull Lexer lexer) {
        if (lexer == null) {
            DbCliUtil.$$$reportNull$$$0(97);
        }
        CliLexeme cliLexeme = new CliLexeme(lexer.getTokenText(), (IElementType)ObjectUtils.assertNotNull((Object)lexer.getTokenType()), lexer.getTokenStart(), lexer.getTokenEnd());
        if (cliLexeme == null) {
            DbCliUtil.$$$reportNull$$$0(98);
        }
        return cliLexeme;
    }

    private static boolean containsNonAlphaCharacters(@NotNull String value) {
        if (value == null) {
            DbCliUtil.$$$reportNull$$$0(99);
        }
        for (int i2 = 0; i2 < value.length(); ++i2) {
            if (Character.isLetter(value.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<CliLexeme> getLexemes(@NotNull String text, @NotNull BiConsumer<List<CliLexeme>, Lexer> consumer) {
        if (text == null) {
            DbCliUtil.$$$reportNull$$$0(100);
        }
        if (consumer == null) {
            DbCliUtil.$$$reportNull$$$0(101);
        }
        ArrayList lexemes = ContainerUtil.newArrayList();
        DbCliLexerAdapter lexer = new DbCliLexerAdapter();
        lexer.start(text);
        while (lexer.getTokenType() != null) {
            consumer.accept(lexemes, (Lexer)lexer);
            lexer.advance();
        }
        List list = ContainerUtil.sorted((Collection)lexemes);
        if (list == null) {
            DbCliUtil.$$$reportNull$$$0(102);
        }
        return list;
    }

    @NotNull
    public static List<CliLexeme> filterLexemes(@NotNull List<CliLexeme> lexemes, @NotNull List<String> parameterizable) {
        Pair<CliLexeme, Integer> lexemeOffset;
        if (lexemes == null) {
            DbCliUtil.$$$reportNull$$$0(103);
        }
        if (parameterizable == null) {
            DbCliUtil.$$$reportNull$$$0(104);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < lexemes.size(); i2 += (Integer)lexemeOffset.getSecond() + 1) {
            lexemeOffset = DbCliUtil.getCurrentLexemeWithOffset(lexemes, i2);
            CliLexeme current = (CliLexeme)lexemeOffset.getFirst();
            CliLexeme previous = i2 == 0 ? new CliLexeme("", DbCliTokenType.BAD, 0, 0) : lexemes.get(i2 - 1);
            boolean isPrevParameterizable = DbCliUtil.isParameterizable(previous, parameterizable);
            if (!current.isArgument() && isPrevParameterizable) continue;
            result2.add(current);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            DbCliUtil.$$$reportNull$$$0(105);
        }
        return arrayList;
    }

    @NotNull
    private static Pair<CliLexeme, Integer> getCurrentLexemeWithOffset(List<CliLexeme> lexemes, int index) {
        int offset = 0;
        while (index < lexemes.size() - 1 && lexemes.get(index).isWhitespaceOrBad()) {
            ++index;
            ++offset;
        }
        Pair pair = Pair.create((Object)lexemes.get(index), (Object)offset);
        if (pair == null) {
            DbCliUtil.$$$reportNull$$$0(106);
        }
        return pair;
    }

    private static boolean isParameterizable(@NotNull CliLexeme lexeme, @NotNull List<String> parameterizable) {
        if (lexeme == null) {
            DbCliUtil.$$$reportNull$$$0(107);
        }
        if (parameterizable == null) {
            DbCliUtil.$$$reportNull$$$0(108);
        }
        return ArrayUtil.contains((String)lexeme.getText(), (String[])new String[]{"<", ">"}) || lexeme.isArgument() && (lexeme.getText().endsWith("=") || ContainerUtil.indexOf(parameterizable, (Object)lexeme.getText()) != -1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 74: 
            case 79: 
            case 81: 
            case 87: 
            case 92: 
            case 94: 
            case 98: 
            case 102: 
            case 105: 
            case 106: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 74: 
            case 79: 
            case 81: 
            case 87: 
            case 92: 
            case 94: 
            case 98: 
            case 102: 
            case 105: 
            case 106: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 22: 
            case 83: 
            case 89: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 2: 
            case 23: 
            case 84: 
            case 90: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 74: 
            case 79: 
            case 81: 
            case 87: 
            case 92: 
            case 94: 
            case 98: 
            case 102: 
            case 105: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/DbCliUtil";
                break;
            }
            case 5: 
            case 17: 
            case 76: 
            case 86: 
            case 104: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterizable";
                break;
            }
            case 7: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: 
            case 41: 
            case 44: 
            case 95: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexemes";
                break;
            }
            case 10: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 12: 
            case 65: 
            case 67: 
            case 69: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquoter";
                break;
            }
            case 15: 
            case 73: 
            case 85: 
            case 91: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: 
            case 38: 
            case 75: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 24: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cd";
                break;
            }
            case 26: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawLexemes";
                break;
            }
            case 27: 
            case 39: 
            case 42: 
            case 46: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicators";
                break;
            }
            case 29: 
            case 77: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 31: 
            case 45: 
            case 107: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexeme";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 34: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 71: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 72: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 96: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/DbCliUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "cutParameter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredLexemes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "lexemePairs";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "clearString";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineArguments";
                break;
            }
            case 20: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "lexemeFinder";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "argumentFinder";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "argumentWithParameterFinder";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "stringFinder";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "fromElementsToSeparated";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getTablesNames";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandWithout";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "extractArguments";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "rawLexemes";
                break;
            }
            case 53: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexeme";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponents";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "extractParameterizable";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNonParameterizable";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "extract";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "pgQuote";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "quote";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeAll";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "fromListToArgument";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "withEquality";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCharacterLexeme";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgument";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentWithParameter";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeAllQuotes";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "lexeme";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexemes";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "filterLexemes";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLexemeWithOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cutParameter";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 74: 
            case 79: 
            case 81: 
            case 87: 
            case 92: 
            case 94: 
            case 98: 
            case 102: 
            case 105: 
            case 106: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filteredLexemes";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lexemePairs";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearString";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCommandLineArguments";
                break;
            }
            case 19: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lexemeFinder";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "argumentFinder";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "argumentWithParameterFinder";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "stringFinder";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "fromElementsToSeparated";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTablesNames";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getCommandWithout";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getIndexFromCommand";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getTableName";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "hasParameterAfterArgument";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "extractArguments";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "rawLexemes";
                break;
            }
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createLexeme";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createComponents";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "pgQuote";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "unescapeAll";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "fromListToArgument";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentValue";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "withEquality";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getLastCharacterLexeme";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getArgument";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentWithParameter";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "escapeAllQuotes";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "index";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "lexeme";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "containsNonAlphaCharacters";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getLexemes";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "filterLexemes";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "isParameterizable";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fromListToArgument$9";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "lambda$stringFinder$4";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "lambda$lexemeFinder$3";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "lambda$argumentWithParameterFinder$2";
                break;
            }
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "lambda$argumentFinder$1";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "lambda$lexemeFinder$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 74: 
            case 79: 
            case 81: 
            case 87: 
            case 92: 
            case 94: 
            case 98: 
            case 102: 
            case 105: 
            case 106: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

