/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.component;

import com.intellij.database.cli.CliArgumentGroup;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.cli.argument.DefaultValueCliArgument;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CliComboBox
extends CliComponent {
    private final CliArgumentGroup<DefaultValueCliArgument> myGroup;
    private final ComboBox<CliArgument> myCombo;

    public CliComboBox(@NotNull CliArgumentGroup<DefaultValueCliArgument> group2) {
        if (group2 == null) {
            CliComboBox.$$$reportNull$$$0(0);
        }
        if (((DefaultValueCliArgument[])group2.getArguments()).length == 0) {
            throw new IllegalArgumentException("Empty argument group");
        }
        this.myGroup = group2;
        this.myCombo = new ComboBox(new DefaultComboBoxModel<CliArgument>(group2.getArguments()));
        this.myCombo.setRenderer((ListCellRenderer)((Object)new DumpComboRenderer()));
        this.myCombo.addItemListener(e -> this.fireComponentChanged());
        this.myCombo.setSelectedItem((Object)this.getDefault());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        ComboBox<CliArgument> comboBox = this.myCombo;
        if (comboBox == null) {
            CliComboBox.$$$reportNull$$$0(1);
        }
        return comboBox;
    }

    @Override
    @Nullable
    public String getLabel() {
        return this.myGroup.getUiName();
    }

    @Override
    @NotNull
    public DefaultValueCliArgument getArgument() {
        DefaultValueCliArgument defaultValueCliArgument = (DefaultValueCliArgument)this.myCombo.getSelectedItem();
        if (defaultValueCliArgument == null) {
            CliComboBox.$$$reportNull$$$0(2);
        }
        return defaultValueCliArgument;
    }

    @Override
    @NotNull
    public String getFullArgument(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            CliComboBox.$$$reportNull$$$0(3);
        }
        String string = this.getArgument().getCommandLineArgument(cd);
        if (string == null) {
            CliComboBox.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isMyLexeme(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        if (text == null) {
            CliComboBox.$$$reportNull$$$0(5);
        }
        if (current == null) {
            CliComboBox.$$$reportNull$$$0(6);
        }
        if (next == null) {
            CliComboBox.$$$reportNull$$$0(7);
        }
        if (cd == null) {
            CliComboBox.$$$reportNull$$$0(8);
        }
        return !ContainerUtil.filter((Object[])this.myGroup.getArguments(), DbCliUtil.argumentFinder(text, current, next, cd)).isEmpty();
    }

    @Override
    public void changeState(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        CliArgument arg;
        if (text == null) {
            CliComboBox.$$$reportNull$$$0(9);
        }
        if (current == null) {
            CliComboBox.$$$reportNull$$$0(10);
        }
        if (next == null) {
            CliComboBox.$$$reportNull$$$0(11);
        }
        if (cd == null) {
            CliComboBox.$$$reportNull$$$0(12);
        }
        this.myCombo.setSelectedItem((Object)((arg = (CliArgument)ContainerUtil.find((Object[])this.myGroup.getArguments(), DbCliUtil.argumentFinder(text, current, next, cd))) == null ? this.getFirst() : arg));
    }

    @Override
    public void reset(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            CliComboBox.$$$reportNull$$$0(13);
        }
        this.myCombo.setSelectedItem((Object)this.getDefault());
    }

    @NotNull
    public CliArgument getDefault() {
        CliArgument arg = (CliArgument)ContainerUtil.find((Object[])this.myGroup.getArguments(), DefaultValueCliArgument::isOnByDefault);
        CliArgument cliArgument = arg == null ? this.getFirst() : arg;
        if (cliArgument == null) {
            CliComboBox.$$$reportNull$$$0(14);
        }
        return cliArgument;
    }

    @NotNull
    private CliArgument getFirst() {
        CliArgument cliArgument = (CliArgument)ObjectUtils.assertNotNull((Object)ArrayUtil.getFirstElement((Object[])this.myGroup.getArguments()));
        if (cliArgument == null) {
            CliComboBox.$$$reportNull$$$0(15);
        }
        return cliArgument;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myGroup.getUiName();
        if (string == null) {
            CliComboBox.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/component/CliComboBox";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cd";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/component/CliComboBox";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgument";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullArgument";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirst";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFullArgument";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMyLexeme";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "changeState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DumpComboRenderer
    extends ListCellRendererWrapper<CliArgument> {
        private DumpComboRenderer() {
        }

        public void customize(JList list, CliArgument value, int index, boolean selected, boolean hasFocus) {
            if (value != null) {
                this.setText(value.getUiName());
            }
        }
    }
}

