/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.RemoteConsoleProcessSupport;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.sql.Driver;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcDriverManagerImpl
extends JdbcDriverManager {
    private final EventDispatcher<ModificationTrackerListener> myDispatcher = EventDispatcher.create(ModificationTrackerListener.class);
    private final RemoteConsoleProcessSupport<LocalDataSource, Driver> mySupport;
    private final Project myProject;
    private final Map<LocalDataSource, Pair<Session, Integer>> myTunnelMap = ContainerUtil.newConcurrentMap();

    public JdbcDriverManagerImpl(DbPsiFacade facade) {
        this.myProject = facade.getProject();
        this.mySupport = new RemoteConsoleProcessSupport<LocalDataSource, Driver>(Driver.class){

            protected void fireModificationCountChanged() {
                JdbcDriverManagerImpl.this.incModificationCount();
                ApplicationManager.getApplication().invokeLater(() -> ((ModificationTrackerListener)JdbcDriverManagerImpl.this.myDispatcher.getMulticaster()).modificationCountChanged((Object)JdbcDriverManagerImpl.this));
            }

            @Override
            protected ConsoleRunConfiguration.RunContext createRunContext(LocalDataSource target) {
                return new JdbcConsoleRunContext(target);
            }

            protected String getName(LocalDataSource dataSource) {
                return dataSource.getName();
            }

            @Override
            protected RunProfileState getRunProfileState(LocalDataSource target, ConsoleRunConfiguration configuration, Executor executor) throws ExecutionException {
                RunProfileState result2 = super.getRunProfileState(target, configuration, executor);
                JdbcDriverManagerImpl.this.createTunnel(target);
                return result2;
            }

            public void stopAll(boolean waitFor) {
                super.stopAll(waitFor);
                List sessions = ContainerUtil.map((Collection)ContainerUtil.newArrayList(JdbcDriverManagerImpl.this.myTunnelMap.values()), (Function)Functions.pairFirst());
                JdbcDriverManagerImpl.this.myTunnelMap.clear();
                for (Session session : sessions) {
                    JdbcDriverManagerImpl.destroyTunnelImpl(session);
                }
            }
        };
        facade.addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

            public void modificationCountChanged(DbPsiFacade source) {
                for (Pair pair : JdbcDriverManagerImpl.this.mySupport.getActiveConfigurations()) {
                    DbDataSource dataSource = source.findDataSource(((LocalDataSource)pair.first).getUniqueId());
                    if (dataSource != null && dataSource.getDelegate() == pair.first) continue;
                    JdbcDriverManagerImpl.this.releaseDriver((LocalDataSource)pair.first, null);
                }
            }
        }, (Disposable)this.myProject);
        Disposer.register((Disposable)this.myProject, this.mySupport);
    }

    @Override
    public ModificationTracker getModificationTracker() {
        return this;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public ConsoleRunConfiguration getDefaultRunConfiguration(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(0);
        }
        ConsoleRunConfiguration consoleRunConfiguration = JdbcDriverManagerImpl.chooseRunConfiguration(this.myProject, dataSource);
        if (consoleRunConfiguration == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(1);
        }
        return consoleRunConfiguration;
    }

    @Override
    public List<ConsoleRunConfiguration> getActiveConfigurations(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(2);
        }
        return this.mySupport.getActiveConfigurations(dataSource);
    }

    @Override
    public Driver getDriver(@NotNull LocalDataSource dataSource, @NotNull ConsoleRunConfiguration configuration) throws Exception {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(4);
        }
        return (Driver)this.mySupport.acquire(dataSource, (Object)configuration);
    }

    @Override
    @NotNull
    public Future<?> releaseDriver(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(5);
        }
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (dataSource == null) {
                JdbcDriverManagerImpl.$$$reportNull$$$0(9);
            }
            JdbcDriverManagerImpl.terminateConnections(dataSource, configuration);
            try {
                this.mySupport.release(dataSource, (Object)configuration).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.getActiveConfigurations(dataSource).isEmpty()) {
                this.destroyTunnel(dataSource);
            }
        });
        if (future == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(6);
        }
        return future;
    }

    @Override
    public void addModificationTrackerListener(ModificationTrackerListener<JdbcDriverManager> listener, Disposable disposable) {
        this.myDispatcher.addListener(listener, disposable);
    }

    @Override
    @Nullable
    public Integer getLocalPort(@NotNull LocalDataSource source) {
        Pair<Session, Integer> pair;
        if (source == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(7);
        }
        return (pair = this.myTunnelMap.get(source)) != null ? (Integer)pair.getSecond() : null;
    }

    private static ConsoleRunConfiguration chooseRunConfiguration(Project project, LocalDataSource dataSource) {
        ConsoleRunConfiguration configuration;
        JdbcDriverManager driverManager = JdbcDriverManagerImpl.getDriverManager(project);
        List<ConsoleRunConfiguration> active = driverManager.getActiveConfigurations(dataSource);
        if (!active.isEmpty()) {
            configuration = active.get(0);
        } else {
            configuration = ConsoleRunConfiguration.newConfiguration(project);
            configuration.setOptionsFromDataSource(dataSource);
        }
        return configuration;
    }

    private void createTunnel(LocalDataSource dataSource) throws ExecutionException {
        try {
            DataSourceSshTunnelConfiguration sshConfiguration = dataSource.getSshConfiguration();
            if (sshConfiguration != null) {
                Pair<Session, Integer> pair = sshConfiguration.createTunnel(dataSource);
                ContainerUtil.putIfNotNull((Object)dataSource, pair, this.myTunnelMap);
            }
        }
        catch (JSchException e) {
            throw new ExecutionException("SSH: " + e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw new ExecutionException("SSH: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void terminateConnections(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        if (dataSource == null) {
            JdbcDriverManagerImpl.$$$reportNull$$$0(8);
        }
        try {
            DatabaseConnectionManager.getInstance().terminateConnections(dataSource, configuration);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void destroyTunnel(LocalDataSource dataSource) {
        Pair<Session, Integer> pair = this.myTunnelMap.remove(dataSource);
        if (pair == null) {
            return;
        }
        JdbcDriverManagerImpl.destroyTunnelImpl((Session)pair.first);
    }

    private static void destroyTunnelImpl(Session session) {
        if (session == null) {
            return;
        }
        try {
            session.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcDriverManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcDriverManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRunConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "releaseDriver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRunConfiguration";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConfigurations";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDriver";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "releaseDriver";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPort";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "terminateConnections";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$releaseDriver$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

