/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.DataBus;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.console.AbstractEngine;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.SuppressUserStackTrace;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.QueryData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.datagrid.mutating.RowUpdateData;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteSavepoint;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.actions.TransactionAction;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.Alarm;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcEngine
extends AbstractEngine
implements DataProducer {
    private static final Logger LOG = Logger.getInstance(JdbcEngine.class);
    private static final TObjectHashingStrategy<RowQueryData> QUERY_DATA_HASHING_STRATEGY = new TObjectHashingStrategy<RowQueryData>(){

        public int computeHashCode(RowQueryData object) {
            return Comparing.hashcode(object.getColumnsData());
        }

        public boolean equals(RowQueryData o1, RowQueryData o2) {
            return Comparing.equal(o1.getColumnsData(), o2.getColumnsData());
        }
    };
    private static final Map<JdbcEngine, Statement> ourPendingStatements = ConcurrentCollectionFactory.createMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
    private static final SingleAlarm ourPendingStatementsAlarm = new SingleAlarm(JdbcEngine::printAllWarnings, 1000, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
    private final JdbcDriverManager myDriverManager;
    private final LocalDataSource myDataSource;
    private final ThrowableComputable<GuardedRef<DatabaseConnection>, Exception> myConnectionFactory;
    private volatile GuardedRef<DatabaseConnection> myConnection;
    private DataRequest.TxMarker myTxMarker;
    private ConsoleRunConfiguration myConfiguration;
    private final AtomicReference<State> myState;
    private volatile SearchPath mySearchPath;
    private DatabaseDialectEx myDialect;
    private DatabaseFamilyId myFamilyId;

    public JdbcEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus, @NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        if (project == null) {
            JdbcEngine.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            JdbcEngine.$$$reportNull$$$0(1);
        }
        if (dataSource == null) {
            JdbcEngine.$$$reportNull$$$0(2);
        }
        this(project, messageBus, dataSource, configuration, dataSource.isAutoCommit());
    }

    public JdbcEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus, @NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration, boolean autoCommit) {
        if (project == null) {
            JdbcEngine.$$$reportNull$$$0(3);
        }
        if (messageBus == null) {
            JdbcEngine.$$$reportNull$$$0(4);
        }
        if (dataSource == null) {
            JdbcEngine.$$$reportNull$$$0(5);
        }
        super(project, messageBus);
        this.myState = new AtomicReference<State>(State.IDLE);
        this.myDataSource = dataSource;
        this.myDriverManager = JdbcDriverManager.getDriverManager(project);
        this.myConfiguration = configuration;
        this.myConnectionFactory = configuration == null ? () -> {
            this.myConfiguration = this.myDriverManager.getDefaultRunConfiguration(this.myDataSource);
            return this.createConnection();
        } : this::createConnection;
        this.myTxMarker = DataRequest.getInitialTxMarker(autoCommit);
    }

    @Nullable
    private GuardedRef<DatabaseConnection> createConnection() throws SQLException {
        ObjectPath currentNamespace = this.getCurrentNamespace();
        GuardedRef<DatabaseConnection> connection = DatabaseConnectionManager.getInstance().build(this.getProject(), this.myDataSource).setRunConfiguration(this.myConfiguration).setDestination(currentNamespace).create();
        if (connection != null) {
            String dest = "";
            if (connection.get().getConnectionPoint() != this.myDataSource) {
                String bounded;
                DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
                DatabaseDriver.Bounds bounds = driver == null ? null : driver.getConnectionBounds();
                String string = bounded = bounds != null ? JdbcUrlParserUtil.getObjectItem(currentNamespace, bounds.boundTo) : null;
                if (StringUtil.isNotEmpty((String)bounded)) {
                    dest = " to " + bounded;
                }
            }
            this.getDataAuditor().print(this.getRequestContext(), "Connected" + dest);
        }
        return connection;
    }

    @Nullable
    public DatabaseConnection getCurrentConnection() {
        return this.myConnection == null ? null : this.myConnection.get();
    }

    @Nullable
    public DatabaseConnection getConnection() throws Exception {
        return this.getConnection(true);
    }

    @Nullable
    public SearchPath requestSearchPath() {
        try {
            DatabaseConnection connection = this.getCurrentConnection();
            this.setSearchPath(connection == null ? null : this.myDialect.tryToLoadSearchPath(this.myDataSource, connection));
            return this.mySearchPath;
        }
        catch (Exception e) {
            LOG.warn(JdbcEngine.getErrorMessage(e, this.myDataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource)));
            return this.mySearchPath;
        }
    }

    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath;
    }

    void setSearchPath(@Nullable SearchPath searchPath) {
        this.mySearchPath = searchPath;
        DataRequest.Context context = this.getRequestContextIfAny();
        if (context != null && this.mySearchPath != null) {
            ((MyContext)context).searchPath = this.mySearchPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DatabaseConnection getConnection(boolean setCurrentSchema) throws Exception {
        DatabaseConnection connection = this.getCurrentConnection();
        boolean freshConnection = false;
        if (!this.isConnectionReady(connection)) {
            ThrowableComputable<GuardedRef<DatabaseConnection>, Exception> throwableComputable = this.myConnectionFactory;
            synchronized (throwableComputable) {
                GuardedRef ref;
                this.releaseConnection();
                this.myConnection = ref = (GuardedRef)this.myConnectionFactory.compute();
                connection = ref == null ? null : (DatabaseConnection)ref.get();
                freshConnection = true;
            }
            this.myFamilyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource);
            this.myDialect = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(this.myFamilyId), (Object)GenericDialect.INSTANCE);
        }
        if (!this.isConnectionReady(connection)) {
            this.releaseConnection();
            this.myConnection = null;
            connection = null;
        }
        if (connection == null) {
            this.getDataAuditor().error(this.getRequestContext(), "Connection failed", null);
        } else {
            this.prepareConnection(connection, setCurrentSchema && freshConnection);
        }
        return connection;
    }

    @Override
    public boolean cancelPendingRequests() {
        super.cancelPendingRequests();
        DataRequest.Context context = this.getRequestContextIfAny();
        if (context == null) {
            return false;
        }
        if (this.myState.compareAndSet(State.STREAMING, State.CANCELED)) {
            this.getDataAuditor().print(context, "Cancelling...");
            return true;
        }
        if (this.myState.compareAndSet(State.RUNNING, State.CANCELED)) {
            Statement statement = ourPendingStatements.get(this);
            if (statement == null) {
                return true;
            }
            AppExecutorUtil.getAppExecutorService().submit(() -> {
                if (this.getRequestContextIfAny() == context) {
                    TimeoutUtil.sleep((long)500L);
                    if (this.getRequestContextIfAny() == context) {
                        this.getDataAuditor().print(context, "Cancelling...");
                        try {
                            statement.cancel();
                        }
                        catch (Throwable ex) {
                            context.reportException(ex, null);
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeTransaction(DataRequest.TxRequest r) throws Exception {
        if (this.myTxMarker.getOwner() == null || this.getCurrentConnection() == null) {
            this.getDataAuditor().txCompleted(this.getRequestContext(), r.command == DataRequest.TxCommand.COMMIT);
            return true;
        }
        DatabaseConnection connection = this.getConnection();
        if (connection == null || !this.isConnectionReady(connection)) {
            return false;
        }
        boolean autoCommit = connection.getAutoCommit();
        try {
            if (!autoCommit && this.myTxMarker.getOwner() != null) {
                if (r.command == DataRequest.TxCommand.COMMIT) {
                    connection.commit();
                } else {
                    connection.rollback();
                }
                this.getDataAuditor().txCompleted(this.getRequestContext(), r.command == DataRequest.TxCommand.COMMIT);
            }
        }
        finally {
            this.myTxMarker = DataRequest.NONE;
            this.printWarnings(connection);
        }
        return true;
    }

    public LocalDataSource getDataSource() {
        return this.myDataSource;
    }

    public boolean isStarted() {
        return this.myDriverManager.getActiveConfigurations(this.myDataSource).contains((Object)this.myConfiguration);
    }

    @Override
    public void terminate() {
        super.terminate();
        GuardedRef<DatabaseConnection> connection = this.myConnection;
        ConsoleRunConfiguration configuration = this.myConfiguration;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (connection != null) {
                connection.close();
            }
            this.myDriverManager.releaseDriver(this.myDataSource, configuration);
        });
        this.myConnection = null;
    }

    @Override
    public void visitQuery(@NotNull DataRequest.QueryRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(6);
        }
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            if (r == null) {
                JdbcEngine.$$$reportNull$$$0(104);
            }
            return r instanceof DataRequest.ConditionQueryRequest ? this.executeConditionQueryRequest((DataRequest.ConditionQueryRequest)r) : this.executeQueryRequest(r);
        }));
    }

    @Override
    public void visitUpdate(@NotNull DataRequest.UpdateRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(7);
        }
        this.executeUpdateStatement(r, ContainerUtil.list((Object[])new QueryData[]{this.buildDataForUpdate(r)}));
    }

    @Override
    public void visitInsert(@NotNull DataRequest.InsertRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(8);
        }
        this.executeUpdateStatement(r, ContainerUtil.list((Object[])new QueryData[]{this.buildDataForInsert(r)}));
    }

    @Override
    public void visitDelete(@NotNull DataRequest.DeleteRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(9);
        }
        this.executeUpdateStatement(r, ContainerUtil.list((Object[])new QueryData[]{this.buildDataForDelete(r)}));
    }

    @Override
    public void visitComposite(DataRequest.CompositeRequest r) {
        final ArrayList infos = ContainerUtil.newArrayList();
        for (DataRequest.DmlRequest request : r.requests) {
            request.accept(new DataRequest.Visitor(){

                @Override
                public void visitInsert(DataRequest.InsertRequest r) {
                    infos.add(JdbcEngine.this.buildDataForInsert(r));
                }

                @Override
                public void visitUpdate(DataRequest.UpdateRequest r) {
                    infos.add(JdbcEngine.this.buildDataForUpdate(r));
                }

                @Override
                public void visitDelete(DataRequest.DeleteRequest r) {
                    infos.add(JdbcEngine.this.buildDataForDelete(r));
                }
            });
        }
        this.executeUpdateStatement(r, infos);
    }

    @Override
    public void visitTx(DataRequest.TxRequest r) {
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> this.completeTransaction(r)));
    }

    @Override
    public void visitSchemaSwitch(@NotNull DataRequest.SchemaSwitchRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(10);
        }
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            DatabaseConnection connection;
            if (r == null) {
                JdbcEngine.$$$reportNull$$$0(103);
            }
            DatabaseConnection prevConnection = connection = this.getCurrentConnection();
            boolean reconnect = this.willReconnect(r.path.getCurrent());
            if (!r.forced && reconnect && connection != null) {
                return Boolean.FALSE;
            }
            if (reconnect && connection != null) {
                this.releaseConnection();
            }
            if (connection == null && !r.forced) {
                this.setSearchPath(r.path);
                return Boolean.TRUE;
            }
            if (reconnect) {
                this.setSearchPath(r.path);
                connection = this.getConnection(true);
                return connection != null;
            }
            connection = this.getConnection(false);
            return connection != null && this.performSchemaSwitch(connection, r.path, r, prevConnection == connection);
        }));
    }

    @Override
    public void visitRaw(DataRequest.RawRequest r) {
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            DatabaseConnection connection = this.getConnection();
            if (connection == null) {
                return false;
            }
            try {
                this.getDataAuditor().requestStarted(this.getRequestContext());
                try {
                    r.processRaw(this.getRequestContext(), connection);
                    this.printWarnings(connection);
                }
                catch (ProcessCanceledException processCanceledException) {
                    this.printWarnings(connection);
                }
                catch (Throwable ex) {
                    try {
                        this.getRequestContext().reportException(ex, null);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.printWarnings(connection);
                    }
                }
            }
            finally {
                this.getDataAuditor().requestFinished(this.getRequestContext());
            }
            return true;
        }));
    }

    @Override
    @NotNull
    protected DataRequest.Context createRequestContext(@NotNull DataRequest request) {
        boolean ownerFailed;
        if (request == null) {
            JdbcEngine.$$$reportNull$$$0(11);
        }
        boolean startedTransaction = false;
        if (!this.isConnectionReady(this.getCurrentConnection()) || this.myTxMarker == DataRequest.NONE) {
            this.myTxMarker = DataRequest.getInitialTxMarker(this.myTxMarker == DataRequest.AUTO_COMMIT || this.myTxMarker == DataRequest.NONE);
        }
        boolean bl = ownerFailed = this.myTxMarker.getOwner() != null && this.myTxMarker != request.txMarker;
        if (!(ownerFailed || request instanceof DataRequest.TxRequest || request.txMarker != DataRequest.START_NEW && this.myTxMarker != DataRequest.START_NEW)) {
            startedTransaction = true;
            this.myTxMarker = DataRequest.newTxMarker("@" + request.owner.getDisplayName(), request.owner);
            final DataRequest.TxMarker marker = this.myTxMarker;
            if (marker.getOwner() instanceof Disposable) {
                Disposer.register((Disposable)((Disposable)request.owner), (Disposable)new Disposable(){

                    public void dispose() {
                        if (JdbcEngine.this.isDisposed()) {
                            return;
                        }
                        JdbcEngine.this.processRequest(DataRequest.newTxRollback(marker));
                    }
                });
            }
        }
        MyContext context = new MyContext(this, request, startedTransaction);
        if (ownerFailed) {
            ExecutionException th = new ExecutionException("locked by transaction: " + this.myTxMarker);
            ((DataRequest.Context)context).reportException(th, null);
            throw new ProcessCanceledException((Throwable)th);
        }
        MyContext myContext = context;
        if (myContext == null) {
            JdbcEngine.$$$reportNull$$$0(12);
        }
        return myContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeQueryInner(@NotNull DataRequest.QueryRequest r, @NotNull String queryText, @NotNull ThrowableNotNullFunction<DatabaseConnection, Statement, Exception> statementCreator) throws Exception {
        DatabaseConnection connection;
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(13);
        }
        if (queryText == null) {
            JdbcEngine.$$$reportNull$$$0(14);
        }
        if (statementCreator == null) {
            JdbcEngine.$$$reportNull$$$0(15);
        }
        if ((connection = this.getConnection()) == null) {
            return false;
        }
        ValidConnectionStateGuard connectionGuard = this.createConnectionGuard(connection);
        Statement statement = null;
        DataRequest.Constraints constraints = r.constraints;
        try {
            statement = (Statement)statementCreator.fun((Object)connection);
            int maxRows = -1;
            if (constraints.offset >= 0 && !DbImplUtil.isPageSizeUnlimited(constraints.limit)) {
                Object type = null;
                try {
                    LocalDataSource dataSource = this.getDataSource();
                    type = r instanceof ConsoleDataRequest ? ((ConsoleDataRequest)r).resultType : DbSqlUtil.parseQueryType(this.getProject(), DbSqlUtil.getSqlDialect(dataSource), DbSqlUtil.findAnyContext(this.getProject(), dataSource, this.getCurrentNamespace()), queryText, null);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
                if (type instanceof SqlTableType) {
                    maxRows = constraints.offset + constraints.limit + 1;
                    statement.setMaxRows(maxRows);
                    this.requestSearchPath();
                }
            }
            int maxAllowedChunkSize = maxRows < 0 ? Integer.MAX_VALUE : maxRows;
            int defaultPrefetchSize = DatabaseSettings.getSettings().getPrefetchSize();
            int chunkSize = Math.min(maxAllowedChunkSize, Math.max(constraints.limit / 10, defaultPrefetchSize <= 0 ? 100 : defaultPrefetchSize));
            this.configurePreFetchSize(statement, chunkSize);
            try {
                Ref resultSetRef = Ref.create();
                boolean resultSetHere = statement instanceof PreparedStatement ? JdbcEngine.executePreparedStatement((PreparedStatement)statement, (Ref<ResultSet>)resultSetRef) : JdbcEngine.executeStatement(statement, (Ref<ResultSet>)resultSetRef, r, queryText);
                this.myState.compareAndSet(State.RUNNING, State.STREAMING);
                ResultSet resultSet = (ResultSet)resultSetRef.get();
                int updateCount = JdbcEngine.getUpdateCountSafe(statement);
                int resultSetIndex = 0;
                int maxResultSetIndex = Registry.intValue((String)"database.result.set.limit");
                do {
                    this.checkCanceled();
                    if ((updateCount == -1 || resultSetHere) && resultSet == null) {
                        resultSet = statement.getResultSet();
                    }
                    if (resultSet != null) {
                        if (r.constraints.resultSetNumber <= 0 || r.constraints.resultSetNumber == ++resultSetIndex) {
                            if (resultSetIndex > maxResultSetIndex) {
                                if (resultSetIndex == maxResultSetIndex + 1) {
                                    this.getDataAuditor().error(this.getRequestContext(), "The maximum number of result sets per query is reached (" + maxResultSetIndex + ").", null);
                                }
                            } else {
                                this.checkCanceled();
                                int[] rowCount = new int[]{0};
                                try {
                                    this.getDataAuditor().fetchStarted(this.getRequestContext(), resultSetIndex);
                                    this.printResultSet(resultSet, resultSetIndex, constraints.offset, constraints.limit, chunkSize, rowCount);
                                }
                                finally {
                                    this.getDataAuditor().fetchFinished(this.getRequestContext(), resultSetIndex, rowCount[0]);
                                    this.printWarnings(resultSet);
                                }
                            }
                        }
                    } else {
                        this.getDataAuditor().updateCountReceived(this.getRequestContext(), updateCount);
                    }
                    resultSet = null;
                    resultSetHere = statement.getMoreResults();
                    updateCount = JdbcEngine.getUpdateCountSafe(statement);
                } while (resultSetHere || updateCount != -1);
                this.printWarnings(statement);
                if (resultSetIndex > maxResultSetIndex) {
                    this.getDataAuditor().warn(this.getRequestContext(), "The query yielded " + resultSetIndex + " result sets, only " + maxResultSetIndex + " were retrieved.");
                }
            }
            catch (Exception e) {
                this.printWarnings(statement);
                throw e;
            }
            connectionGuard.free(true);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.getRequestContext().reportException(e, queryText);
            try {
                connectionGuard.free(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeStatement(statement);
            this.printWarnings(connection);
        }
    }

    @NotNull
    private ValidConnectionStateGuard createConnectionGuard(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(16);
        }
        ValidConnectionStateGuard validConnectionStateGuard = connection.getAutoCommit() ? new ValidConnectionStateGuard.Inactive() : (this.myFamilyId.isRedshift() ? new ValidConnectionStateGuard.Rollback(connection) : new ValidConnectionStateGuard.RollbackToSavepoint(connection));
        if (validConnectionStateGuard == null) {
            JdbcEngine.$$$reportNull$$$0(17);
        }
        return validConnectionStateGuard;
    }

    private static boolean willScrollResultSet(DataRequest.Constraints constraints) {
        return constraints.offset != 0 && constraints.offset != 1;
    }

    private static boolean executePreparedStatement(@NotNull PreparedStatement statement, @NotNull Ref<ResultSet> ref) throws SQLException {
        if (statement == null) {
            JdbcEngine.$$$reportNull$$$0(18);
        }
        if (ref == null) {
            JdbcEngine.$$$reportNull$$$0(19);
        }
        ref.set((Object)statement.executeQuery());
        return !ref.isNull();
    }

    private static boolean executeStatement(@NotNull Statement statement, @NotNull Ref<ResultSet> ref, @NotNull DataRequest r, @NotNull String queryText) throws SQLException {
        if (statement == null) {
            JdbcEngine.$$$reportNull$$$0(20);
        }
        if (ref == null) {
            JdbcEngine.$$$reportNull$$$0(21);
        }
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(22);
        }
        if (queryText == null) {
            JdbcEngine.$$$reportNull$$$0(23);
        }
        if (r instanceof ConsoleDataRequest && ((ConsoleDataRequest)r).resultType instanceof SqlTableType) {
            ref.set((Object)statement.executeQuery(queryText));
            return !ref.isNull();
        }
        return statement.execute(queryText);
    }

    @Nullable
    public ObjectPath getCurrentNamespace() {
        return SearchPath.getCurrent(this.mySearchPath);
    }

    private void configurePreFetchSize(Statement statement, int chunkSize) {
        try {
            if (this.myFamilyId.isMysql()) {
                statement.setFetchSize(Integer.MIN_VALUE);
            } else {
                statement.setFetchSize(chunkSize);
            }
        }
        catch (SQLException e) {
            LOG.warn((Throwable)e);
        }
    }

    public static int getUpdateCountSafe(@NotNull Statement statement) {
        if (statement == null) {
            JdbcEngine.$$$reportNull$$$0(24);
        }
        try {
            return statement.getUpdateCount();
        }
        catch (Exception ignored) {
            return -1;
        }
    }

    private void printWarnings(@Nullable DatabaseConnection connection) {
        if (connection == null) {
            return;
        }
        this.printWarnings((ThrowableComputable<List<SQLWarning>, Throwable>)((ThrowableComputable)() -> ((RemoteConnection)RemoteUtil.castToRemoteNotNull((Object)connection.getJdbcConnection(), RemoteConnection.class)).getAllWarnings()));
    }

    private void printWarnings(@Nullable Statement statement) {
        if (statement == null) {
            return;
        }
        this.printWarnings((ThrowableComputable<List<SQLWarning>, Throwable>)((ThrowableComputable)() -> ((RemoteStatement)RemoteUtil.castToRemoteNotNull((Object)statement, RemoteStatement.class)).getAllWarnings()));
    }

    private void printWarnings(@Nullable ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        this.printWarnings((ThrowableComputable<List<SQLWarning>, Throwable>)((ThrowableComputable)() -> ((RemoteResultSet)RemoteUtil.castToRemoteNotNull((Object)resultSet, RemoteResultSet.class)).getAllWarnings()));
    }

    private void printWarnings(@NotNull ThrowableComputable<List<SQLWarning>, Throwable> producer) {
        if (producer == null) {
            JdbcEngine.$$$reportNull$$$0(25);
        }
        try {
            List warnings = (List)producer.compute();
            for (SQLWarning throwables : warnings) {
                this.getDataAuditor().warn(this.getRequestContext(), JdbcUtil.getLongMessage((Throwable)throwables));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void printAllWarnings() {
        for (JdbcEngine engine : ourPendingStatements.keySet()) {
            Statement statement;
            DatabaseFamilyId familyId;
            if (engine.myState.get() != State.RUNNING || (familyId = engine.myFamilyId) != DatabaseFamilyId.REDSHIFT && familyId != DatabaseFamilyId.POSTGRES && familyId != DatabaseFamilyId.MSSQL || (statement = ourPendingStatements.get(engine)) == null) continue;
            try {
                engine.printWarnings(statement);
            }
            catch (Throwable throwable) {}
        }
        if (!ourPendingStatements.isEmpty()) {
            ourPendingStatementsAlarm.cancelAndRequest();
        }
    }

    private void changeCurrentStatement(@Nullable Statement oldValue, @Nullable Statement newValue) {
        if (newValue == null) {
            ourPendingStatements.remove(this);
            this.myState.set(State.IDLE);
        } else {
            ourPendingStatements.put(this, newValue);
            this.myState.set(State.RUNNING);
        }
        ourPendingStatementsAlarm.request();
    }

    private boolean isConnectionReady(@Nullable DatabaseConnection connection) {
        if (connection == null) {
            return false;
        }
        try {
            if (this.myFamilyId.isMysql()) {
                return connection.getJdbcConnection().isValid(20);
            }
            return !connection.getJdbcConnection().isClosed();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void prepareConnection(@NotNull DatabaseConnection connection, boolean setCurrentSchema) throws Exception {
        boolean autoCommit;
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(26);
        }
        boolean bl = autoCommit = this.myTxMarker == DataRequest.AUTO_COMMIT;
        if (connection.getAutoCommit() != autoCommit) {
            connection.setAutoCommit(autoCommit);
        }
        this.setTxIsolation(connection);
        try {
            if (autoCommit) {
                connection.setReadOnly(this.myDataSource.isReadOnly());
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        SearchPath schema = this.mySearchPath;
        if (setCurrentSchema && schema != null) {
            if (DbImplUtil.supportsDynamicSchemaSwitching(this.myDataSource)) {
                DataRequest.Context context = this.getRequestContextIfAny();
                DataRequest.SchemaSwitchRequest request = (DataRequest.SchemaSwitchRequest)ObjectUtils.tryCast((Object)(context != null ? context.request : null), DataRequest.SchemaSwitchRequest.class);
                this.performSchemaSwitch(connection, schema, request, false);
            }
        } else if (schema == null) {
            this.requestSearchPath();
        }
    }

    private void setTxIsolation(@NotNull DatabaseConnection dbConnection) throws SQLException {
        if (dbConnection == null) {
            JdbcEngine.$$$reportNull$$$0(27);
        }
        DataRequest.Context context = this.getRequestContextIfAny();
        if (!TransactionAction.TxIsolation.levelsSupported(this.myFamilyId) || context == null) {
            return;
        }
        DataRequest.TxIsolationOwner owner = (DataRequest.TxIsolationOwner)ObjectUtils.tryCast((Object)context.request.owner, DataRequest.TxIsolationOwner.class);
        if (owner == null || !this.shouldChangeIsolation(dbConnection, owner, context)) {
            return;
        }
        dbConnection.getJdbcConnection().setTransactionIsolation(owner.getTxIsolation());
    }

    private void storeTxIsolation(@NotNull DatabaseConnection connection) {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(28);
        }
        if (!TransactionAction.TxIsolation.levelsSupported(this.myFamilyId)) {
            return;
        }
        Connection jdbcConnection = connection.getJdbcConnection();
        DataRequest.Context context = this.getRequestContextIfAny();
        if (context == null) {
            return;
        }
        try {
            if (!connection.getMetaData().supportsTransactions()) {
                return;
            }
            int isolation = jdbcConnection.getTransactionIsolation();
            ObjectUtils.consumeIfCast((Object)context, DataRequest.TxContext.class, ex -> {
                ex.isolation = isolation;
            });
        }
        catch (SQLException e) {
            LOG.warn((Throwable)e);
        }
    }

    private boolean shouldChangeIsolation(@NotNull DatabaseConnection connection, @NotNull DataRequest.TxIsolationOwner owner, @NotNull DataRequest.Context context) throws SQLException {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(29);
        }
        if (owner == null) {
            JdbcEngine.$$$reportNull$$$0(30);
        }
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(31);
        }
        DatabaseMetaData data = connection.getMetaData();
        Connection jdbcConnection = connection.getJdbcConnection();
        int ownerIsolation = owner.getTxIsolation();
        return !(!data.supportsTransactions() || context.request.txMarker != DataRequest.AUTO_COMMIT && context.request.txMarker != DataRequest.START_NEW || ownerIsolation == TransactionAction.TxIsolation.DEFAULT.getIsolation() || !this.myFamilyId.isSybase() && !data.supportsTransactionIsolationLevel(ownerIsolation) || jdbcConnection.getTransactionIsolation() == ownerIsolation);
    }

    private boolean performSchemaSwitch(@NotNull DatabaseConnection connection, @NotNull SearchPath searchPath, @Nullable DataRequest.SchemaSwitchRequest request, boolean allowReset) throws Exception {
        boolean result2;
        String setSchemaSql;
        String sql;
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(32);
        }
        if (searchPath == null) {
            JdbcEngine.$$$reportNull$$$0(33);
        }
        if ((sql = (setSchemaSql = DbImplUtil.getSearchPath(searchPath, this.myDataSource, this.myDialect)) == null && allowReset && searchPath.getCurrent().kind == ObjectKind.DATABASE && JdbcUrlParserUtil.isDatabaseBounded(connection.getConnectionPoint()) ? this.myDialect.sqlResetSearchPath() : setSchemaSql) == null) {
            return false;
        }
        boolean bl = result2 = request == null ? this.performImplicitSchemaSwitch(connection, sql) : this.performExplicitSchemaSwitch(connection, sql);
        if (result2) {
            if (sql == setSchemaSql) {
                this.setSearchPath(searchPath);
            } else {
                this.requestSearchPath();
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performImplicitSchemaSwitch(@NotNull DatabaseConnection connection, @NotNull String setSchemaSql) throws SQLException {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(34);
        }
        if (setSchemaSql == null) {
            JdbcEngine.$$$reportNull$$$0(35);
        }
        this.getDataAuditor().print(this.getRequestContext(), setSchemaSql);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(setSchemaSql);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.printWarnings(statement);
            String errorMessage = JdbcEngine.getErrorMessage(e, this.myDataSource.getName(), this.myDataSource.getFamilyId());
            this.getDataAuditor().print(this.getRequestContext(), "Failed to switch schema.\n" + errorMessage);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    this.getDataAuditor().print(this.getRequestContext(), JdbcEngine.getErrorMessage(e, this.myDataSource.getName(), this.myDataSource.getFamilyId()));
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performExplicitSchemaSwitch(@NotNull DatabaseConnection connection, @NotNull String setSchemaSql) throws Exception {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(36);
        }
        if (setSchemaSql == null) {
            JdbcEngine.$$$reportNull$$$0(37);
        }
        Statement statement = null;
        try {
            statement = this.openStatement(connection, setSchemaSql, false);
            statement.execute(setSchemaSql);
            boolean bl = true;
            this.closeStatement(statement);
            return bl;
        }
        catch (SQLException e) {
            try {
                this.printWarnings(statement);
                this.getRequestContext().reportException(e, statement);
                this.closeStatement(statement);
            }
            catch (Throwable throwable) {
                this.closeStatement(statement);
                throw throwable;
            }
        }
        return false;
    }

    @Nullable
    private RowQueryData buildDataForSelect(@NotNull DataRequest.ConditionQueryRequest r) throws Exception {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(38);
        }
        RowQueryData data = r.rowQueryData;
        String sql = data.getSql();
        String alias = r.table == null ? DbImplUtil.findFreeAlias(this.getProject(), this.myDialect, sql, "a") : "t";
        DdlBuilder builder = this.getConditionRequestQuery(r, alias);
        if (builder == null) {
            return null;
        }
        builder.space().keyword("WHERE").space();
        List<ColumnQueryData> newData = DbImplUtil.composeWhereConditionWithParameters(builder, data, alias, this.myDialect);
        return new RowQueryData(newData, data.getRow(), builder.getStatement());
    }

    @Nullable
    private DdlBuilder getConditionRequestQuery(@NotNull DataRequest.ConditionQueryRequest r, @NotNull String alias) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(39);
        }
        if (alias == null) {
            JdbcEngine.$$$reportNull$$$0(40);
        }
        if (r.table != null) {
            return DbImplUtil.createSelectAllQuery(r.table, this.myDialect, this.myDataSource);
        }
        String sql = r.rowQueryData.getSql();
        return DbImplUtil.wrapSelectQuery(this.getProject(), this.myDialect, sql, alias);
    }

    @NotNull
    public QueryData buildDataForDelete(@NotNull DataRequest.DeleteRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(41);
        }
        QueryData queryData = JdbcEngine.mergedQueryData(r.context.getMutations(), (Function<RowMutation, RowQueryData>)((Function)mutation -> {
            if (r == null) {
                JdbcEngine.$$$reportNull$$$0(102);
            }
            DdlBuilder builder = DbImplUtil.createBuilderForExec(this.myDialect);
            List<ColumnQueryData> filtered = DbImplUtil.getWhereClauseColumns(r.context.getTable(), mutation.getData(), this.myDialect);
            builder.keyword("DELETE").space().keyword("FROM").space().qualifiedRef((DasObject)r.context.getTable()).space();
            builder.keyword("WHERE").space();
            List<ColumnQueryData> whereData = DbImplUtil.composeWhereConditionWithParameters(builder, filtered, null, this.myDialect);
            String sql = builder.getStatement();
            return new RowQueryData(whereData, mutation.getRow(), sql);
        }));
        if (queryData == null) {
            JdbcEngine.$$$reportNull$$$0(42);
        }
        return queryData;
    }

    @NotNull
    public QueryData buildDataForUpdate(@NotNull DataRequest.UpdateRequest r) {
        DatabaseFamilyId familyId;
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(43);
        }
        boolean alias = !(familyId = this.myDataSource.getFamilyId()).isSqlite() && !familyId.isPostgres() && !familyId.isTransactSql() && familyId != DatabaseFamilyId.VERTICA;
        QueryData queryData = JdbcEngine.mergedQueryData(r.context.getMutations(), (Function<RowMutation, RowQueryData>)((Function)mutation -> {
            if (r == null) {
                JdbcEngine.$$$reportNull$$$0(101);
            }
            DataConsumer.Row row = mutation.getRow();
            List keyColumns = DbImplUtil.getWhereClauseColumns(r.context.getTable(), (List)ObjectUtils.assertNotNull(r.context.getColumns()), this.myDialect);
            DdlBuilder builder = DbImplUtil.createBuilderForExec(this.myDialect);
            builder.keyword("UPDATE").space().qualifiedRef((DasObject)r.context.getTable()).space();
            if (alias) {
                builder.alias("t").space();
            }
            builder.keyword("SET").space();
            boolean first = true;
            ArrayList columnsData = ContainerUtil.newArrayList();
            for (ColumnQueryData data : mutation.getData()) {
                DataConsumer.Column targetColumn = data.getColumn();
                if (!first) {
                    builder.symbol(",").space();
                } else {
                    first = false;
                }
                if (alias) {
                    builder.alias("t").symbol(".");
                }
                builder.identifier(targetColumn.name).space().symbol("=").space();
                Object value = data.getObject();
                if (value == ReservedCellValue.DEFAULT) {
                    builder.keyword("DEFAULT");
                    continue;
                }
                builder.symbol("?");
                columnsData.add(data);
            }
            builder.space().keyword("WHERE").space();
            String s = alias ? "t" : null;
            List keyData = ContainerUtil.map(keyColumns, column -> new ColumnQueryData((DataConsumer.Column)column, column.getValue(row)));
            List<ColumnQueryData> whereData = DbImplUtil.composeWhereConditionWithParameters(builder, keyData, s, this.myDialect);
            String sql = builder.getStatement();
            columnsData.addAll(whereData);
            return new RowQueryData(columnsData, mutation.getRow(), sql);
        }));
        if (queryData == null) {
            JdbcEngine.$$$reportNull$$$0(44);
        }
        return queryData;
    }

    @NotNull
    public QueryData buildDataForInsert(@NotNull DataRequest.InsertRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(45);
        }
        DatabaseDialectEx dialect = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(this.myDataSource), (Object)GenericDialect.INSTANCE);
        ArrayList params2 = ContainerUtil.newArrayList();
        List<RowMutation> mutations = r.context.getMutations();
        DdlBuilder builder = DbImplUtil.createBuilderForExec(dialect);
        for (RowMutation mutation : mutations) {
            List<AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>> delegateDescriptors = JdbcEngine.createDescriptors(mutation);
            Condition isDefault = d -> !d.isComputed() && !d.isAutogenerated() && !d.hasDefault();
            List forInsert = ContainerUtil.filter(delegateDescriptors, (Condition)isDefault);
            List<String> placeholders = JdbcEngine.getPlaceholdersForInsert(delegateDescriptors, dialect);
            List<String> colNames = JdbcEngine.getColumnNamesForInsert(delegateDescriptors, dialect);
            dialect.sqlInsertInto(builder, r.context.getTable(), colNames, placeholders);
            String sql = builder.getStatement();
            RowQueryData qData = new RowQueryData(ContainerUtil.map((Collection)forInsert, AutoValueDescriptor.DelegateDescriptor::getDelegate), mutation.getRow(), sql);
            params2.add(new RowUpdateData(qData, 1));
            builder.clear();
        }
        QueryData queryData = new QueryData(params2);
        if (queryData == null) {
            JdbcEngine.$$$reportNull$$$0(46);
        }
        return queryData;
    }

    @NotNull
    private static List<AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>> createDescriptors(@NotNull RowMutation mutation) {
        if (mutation == null) {
            JdbcEngine.$$$reportNull$$$0(47);
        }
        DataConsumer.Row row = mutation.getRow();
        List list = JBIterable.from(mutation.getData()).map(data -> {
            DataConsumer.Column column = data.getColumn();
            Object value = column.getValue(row);
            boolean autogenerated = value == ReservedCellValue.GENERATED;
            boolean isDefault = value == ReservedCellValue.DEFAULT;
            boolean isComputed = value == ReservedCellValue.COMPUTED;
            return new AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>((ColumnQueryData)data, autogenerated, isDefault, isComputed);
        }).toList();
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(48);
        }
        return list;
    }

    public void executeUpdateStatement(@NotNull DataRequest request, @NotNull List<QueryData> infos) {
        if (request == null) {
            JdbcEngine.$$$reportNull$$$0(49);
        }
        if (infos == null) {
            JdbcEngine.$$$reportNull$$$0(50);
        }
        this.submitRequest(request, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            if (infos == null) {
                JdbcEngine.$$$reportNull$$$0(100);
            }
            return this.executeUpdateStatementInner(infos);
        }));
    }

    private boolean executeConditionQueryRequest(@NotNull DataRequest.ConditionQueryRequest r) throws Exception {
        RowQueryData data;
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(51);
        }
        if ((data = this.buildDataForSelect(r)) == null) {
            return false;
        }
        return this.executeQueryInner(r, data.getSql(), (ThrowableNotNullFunction<DatabaseConnection, Statement, Exception>)((ThrowableNotNullFunction)connection -> {
            this.getRequestContext().query.set(data.getSql());
            PreparedStatement statement = this.openPreparedStatement((DatabaseConnection)connection, data.getSql());
            this.completeStatement(statement, data, 0);
            return statement;
        }));
    }

    private boolean executeQueryRequest(@NotNull DataRequest.QueryRequest r) throws Exception {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(52);
        }
        return this.executeQueryInner(r, r.query, (ThrowableNotNullFunction<DatabaseConnection, Statement, Exception>)((ThrowableNotNullFunction)connection -> {
            if (r == null) {
                JdbcEngine.$$$reportNull$$$0(99);
            }
            return this.openStatement((DatabaseConnection)connection, r.query, JdbcEngine.willScrollResultSet(r.constraints));
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeUpdateStatementInner(@NotNull List<QueryData> queryData) throws Exception {
        DatabaseConnection connection;
        if (queryData == null) {
            JdbcEngine.$$$reportNull$$$0(53);
        }
        if ((connection = this.getConnection()) == null) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (QueryData info : queryData) {
            sb.append(info.getFullSql());
        }
        String sql = sb.toString();
        UnexpectedUpdatesGuard guard = connection.getAutoCommit() ? new AutoCommitGuard(connection, sql, JdbcEngine.getExpectedUpdateCounts(queryData)) : new AutoCommitOffGuard(connection, sql, JdbcEngine.getExpectedUpdateCounts(queryData));
        try {
            this.startUpdate(sql);
            IntArrayList updateCounts = new IntArrayList();
            for (QueryData data : queryData) {
                IntArrayList counts = this.executeUpdateStatementAndGetUpdateCounts(connection, data);
                if (counts == null) {
                    boolean bl = guard.updateComplete(null);
                    return bl;
                }
                updateCounts.add(counts.toArray());
            }
            int sum = IntStream.of(updateCounts.toArray()).sum();
            this.getDataAuditor().updateCountReceived(this.getRequestContext(), sum);
            boolean bl = guard.updateComplete(updateCounts);
            return bl;
        }
        finally {
            this.endUpdate();
            guard.free();
            this.printWarnings(connection);
        }
    }

    @NotNull
    private static IntArrayList getExpectedUpdateCounts(@NotNull List<QueryData> queryData) {
        if (queryData == null) {
            JdbcEngine.$$$reportNull$$$0(54);
        }
        IntArrayList list = new IntArrayList();
        queryData.stream().flatMap(qData -> qData.getUpdateData().stream()).mapToInt(uData -> uData.getUpdateCount()).forEach(i2 -> list.add(i2));
        IntArrayList intArrayList = list;
        if (intArrayList == null) {
            JdbcEngine.$$$reportNull$$$0(55);
        }
        return intArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private IntArrayList executeUpdateStatementAndGetUpdateCounts(@NotNull DatabaseConnection connection, @NotNull QueryData data) {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(56);
        }
        if (data == null) {
            JdbcEngine.$$$reportNull$$$0(57);
        }
        IntArrayList updateCounts = new IntArrayList(data.size());
        PreparedStatement statement = null;
        try {
            for (RowUpdateData rowInfo : data) {
                RowQueryData qData = rowInfo.getQueryData();
                String sql = qData.getSql();
                int escapeIdx = StringUtil.startsWithIgnoreCase((String)sql, (String)"update") ? 1 : (StringUtil.startsWithIgnoreCase((String)sql, (String)"delete") ? 0 : qData.size());
                statement = this.openPreparedStatement(connection, sql);
                this.completeStatement(statement, qData, escapeIdx);
                updateCounts.add(statement.executeUpdate());
                this.closeStatement(statement, false);
            }
        }
        catch (Exception e) {
            updateCounts = null;
            this.getRequestContext().reportException(e, statement);
        }
        finally {
            this.closeStatement(statement, false);
        }
        return updateCounts;
    }

    private void completeStatement(PreparedStatement statement, RowQueryData rowInfo, int escapeIdx) throws Exception {
        int idx = 0;
        for (ColumnQueryData updateData : rowInfo) {
            Object object = updateData.getObject();
            DbImplUtil.setStatementParameter(statement, updateData, object, this.myDialect, idx >= escapeIdx, ++idx);
        }
    }

    public static void handleException(@NotNull DataRequest.Context context, @NotNull Throwable th, @NotNull DataAuditor dataAuditor, @NotNull DatabaseSystem dataSource) {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(58);
        }
        if (th == null) {
            JdbcEngine.$$$reportNull$$$0(59);
        }
        if (dataAuditor == null) {
            JdbcEngine.$$$reportNull$$$0(60);
        }
        if (dataSource == null) {
            JdbcEngine.$$$reportNull$$$0(61);
        }
        if (th instanceof ProcessCanceledException) {
            return;
        }
        String message = JdbcEngine.getErrorMessage(th, dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource));
        dataAuditor.error(context, message, null);
    }

    @NotNull
    public static String getErrorMessage(Throwable th, String sourceName, DatabaseFamilyId familyId) {
        StringBuilder sb = new StringBuilder();
        String string = JdbcEngine.appendErrorMessage(sb, th, sourceName, familyId).toString().trim();
        if (string == null) {
            JdbcEngine.$$$reportNull$$$0(62);
        }
        return string;
    }

    @NotNull
    public static <T extends AutoValueDescriptor> List<String> getColumnNamesForInsert(@NotNull Collection<T> descriptors, @NotNull DatabaseDialectEx dialect) {
        if (descriptors == null) {
            JdbcEngine.$$$reportNull$$$0(63);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(64);
        }
        List list = JdbcEngine.shouldParticipateInInsert(descriptors, dialect).map(ColumnDescriptor::getName).toList();
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(65);
        }
        return list;
    }

    @NotNull
    public static <T extends AutoValueDescriptor> List<String> getPlaceholdersForInsert(@NotNull Collection<T> descriptors, @NotNull DatabaseDialectEx dialect) {
        if (descriptors == null) {
            JdbcEngine.$$$reportNull$$$0(66);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(67);
        }
        List list = JdbcEngine.shouldParticipateInInsert(descriptors, dialect).map(d -> d.isAutogenerated() || d.hasDefault() ? "DEFAULT" : "?").toList();
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(68);
        }
        return list;
    }

    @NotNull
    private static <T extends AutoValueDescriptor> JBIterable<T> shouldParticipateInInsert(@NotNull Collection<T> descriptors, @NotNull DatabaseDialectEx dialect) {
        if (descriptors == null) {
            JdbcEngine.$$$reportNull$$$0(69);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(70);
        }
        JBIterable jBIterable = JBIterable.from(descriptors).filter(d -> {
            if (dialect == null) {
                JdbcEngine.$$$reportNull$$$0(98);
            }
            return !d.isComputed() && (!d.isAutogenerated() || dialect.supportsInsertDefaultIntoAutoVal());
        });
        if (jBIterable == null) {
            JdbcEngine.$$$reportNull$$$0(71);
        }
        return jBIterable;
    }

    @NotNull
    private static QueryData mergedQueryData(@NotNull List<RowMutation> mutations, @NotNull Function<RowMutation, RowQueryData> converter) {
        if (mutations == null) {
            JdbcEngine.$$$reportNull$$$0(72);
        }
        if (converter == null) {
            JdbcEngine.$$$reportNull$$$0(73);
        }
        TObjectIntHashMap map2 = new TObjectIntHashMap(QUERY_DATA_HASHING_STRATEGY);
        for (RowMutation mutation : mutations) {
            RowQueryData qData = (RowQueryData)converter.fun((Object)mutation);
            if (map2.increment((Object)qData)) continue;
            map2.put((Object)qData, 1);
        }
        QueryData queryData = new QueryData(Arrays.stream(map2.keys()).map(o -> new RowUpdateData((RowQueryData)o, map2.get((Object)((RowQueryData)o)))).collect(Collectors.toList()));
        if (queryData == null) {
            JdbcEngine.$$$reportNull$$$0(74);
        }
        return queryData;
    }

    private static StringBuilder appendErrorMessage(@NotNull StringBuilder sb, @NotNull Throwable e, @NotNull String processName, @NotNull DatabaseFamilyId familyId) {
        String message;
        Throwable t;
        if (sb == null) {
            JdbcEngine.$$$reportNull$$$0(75);
        }
        if (e == null) {
            JdbcEngine.$$$reportNull$$$0(76);
        }
        if (processName == null) {
            JdbcEngine.$$$reportNull$$$0(77);
        }
        if (familyId == null) {
            JdbcEngine.$$$reportNull$$$0(78);
        }
        if (e != (t = ExceptionUtil.getRootCause((Throwable)e)) && e instanceof SQLException && StringUtil.indexOf((CharSequence)sb, (CharSequence)(message = JdbcUtil.getMessage((Throwable)e))) == -1) {
            sb.append(JdbcUtil.getMessagePrefix((Throwable)e)).append(message).append("\n");
        }
        if (t instanceof SQLException) {
            SQLException next;
            message = JdbcUtil.getMessage((Throwable)t);
            if (StringUtil.indexOf((CharSequence)sb, (CharSequence)message) == -1) {
                sb.append(JdbcUtil.getMessagePrefix((Throwable)t)).append(message);
            }
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
            if (StringUtil.contains((CharSequence)sb, (CharSequence)"ORA-12705:")) {
                sb.append("\n").append(DatabaseMessages.message((String)"error.message.ora.nls", (Object[])new Object[]{processName}));
            }
            if ((next = ((SQLException)t).getNextException()) != null && next != t) {
                JdbcEngine.appendErrorMessage(sb.append("\n"), next, processName, familyId);
            }
        } else if (t instanceof RemoteException) {
            sb.append(t.toString());
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else if (t instanceof EOFException && e instanceof RemoteException) {
            sb.append(processName).append(": process exited");
        } else if (t instanceof IOException) {
            sb.append(t.toString());
        } else if (t instanceof ExecutionException) {
            sb.append(JdbcUtil.getMessage((Throwable)t));
        } else if (t instanceof SuppressUserStackTrace) {
            sb.append(JdbcUtil.getMessage((Throwable)t));
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else if (t instanceof UnsafeUpdateRolledBackException) {
            sb.append(t.getMessage());
        } else if (t instanceof OutOfMemoryError) {
            sb.append(DatabaseMessages.message((String)"error.message.remote.oomerror", (Object[])new Object[]{processName}));
            LOG.info(t);
        } else if (t instanceof RuntimeException && familyId.isDerby() && sb.length() > 0) {
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else {
            sb.append(ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG));
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printResultSet(@NotNull ResultSet resultSet, int resultSetIndex, int start, int pageSize, int chunkSize, int[] rowCount) throws Exception {
        if (resultSet == null) {
            JdbcEngine.$$$reportNull$$$0(79);
        }
        this.checkCanceled();
        DataRequest request = this.getRequestContext().request;
        DataConsumer handler = this.getDataConsumer();
        if (request instanceof DataRequest.IsolatedQueryRequest) {
            handler = (DataConsumer)((Object)request);
        }
        if (start < 0) {
            handler = new LastPageHandler(handler, start, pageSize);
            pageSize = -1;
        }
        RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemoteNotNull((Object)resultSet, RemoteResultSet.class);
        DataConsumer.Column[] columnsDescr = JdbcEngine.getColumnDescriptors(resultSet, this.myDialect);
        handler.setColumns(this.getRequestContext(), resultSetIndex, columnsDescr, Math.max(1, start));
        rowCount[0] = 0;
        int rowNum = 0;
        boolean hasNext = true;
        ArrayList<DataConsumer.Row> rows = ContainerUtil.newArrayListWithCapacity((int)chunkSize);
        try {
            rowNum = remoteResultSet.scrollToPosition(0, start - 1);
            if (request instanceof DataRequest.RawQueryRequest) {
                while (hasNext = resultSet.next()) {
                    this.checkCanceled();
                    DataConsumer.Row row = JdbcEngine.getCurrentRow(resultSet, columnsDescr, rowNum++, this.myDialect);
                    handler.addRows(this.getRequestContext(), Collections.singletonList(row));
                    rowCount[0] = rowCount[0] + 1;
                    if (DbImplUtil.isPageSizeUnlimited(pageSize) || rowCount[0] < pageSize) continue;
                    break;
                }
                this.printWarnings(resultSet);
            } else {
                int maxLobLength = DatabaseSettings.getSettings().getMaxLobLength();
                while (hasNext) {
                    int rowsToLoad;
                    this.checkCanceled();
                    int n = rowsToLoad = DbImplUtil.isPageSizeUnlimited(pageSize) ? chunkSize : Math.min(chunkSize, pageSize - rowCount[0]);
                    if (rowsToLoad == 0) break;
                    List<Object[]> data = JdbcEngine.getObjects(resultSet, this.myDialect, this, maxLobLength, rowsToLoad);
                    this.printWarnings(resultSet);
                    hasNext = data.size() == rowsToLoad;
                    rowCount[0] = rowCount[0] + data.size();
                    for (Object[] rowData : data) {
                        rows.add(DataConsumer.Row.create(rowNum++, rowData));
                        if (rows.size() != chunkSize) continue;
                        handler.addRows(this.getRequestContext(), (List<DataConsumer.Row>)rows);
                        rows = new ArrayList<DataConsumer.Row>(chunkSize);
                    }
                }
                if (hasNext) {
                    hasNext = remoteResultSet.next();
                }
            }
        }
        finally {
            if (!rows.isEmpty()) {
                handler.addRows(this.getRequestContext(), (List<DataConsumer.Row>)rows);
            }
            if (start < 0) {
                rowCount[0] = ((LastPageHandler)handler).getRowCount();
            }
            try {
                if (hasNext && rowCount[0] != 0) {
                    ++rowNum;
                }
            }
            finally {
                handler.afterLastRowAdded(this.getRequestContext(), rowNum);
            }
        }
    }

    @NotNull
    public static List<Object[]> getObjects(@NotNull ResultSet resultSet, @NotNull DatabaseDialect dialect, @NotNull Object requestor, int maxLobLength, int rowsToLoad) throws Exception {
        if (resultSet == null) {
            JdbcEngine.$$$reportNull$$$0(80);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(81);
        }
        if (requestor == null) {
            JdbcEngine.$$$reportNull$$$0(82);
        }
        RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemoteNotNull((Object)resultSet, RemoteResultSet.class);
        List list = (List)RemoteUtil.handleRemoteResult((Object)remoteResultSet.getObjects(DbImplUtil.getRdbms(dialect), rowsToLoad, maxLobLength), List.class, (Object)requestor);
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(83);
        }
        return list;
    }

    public static DataConsumer.Column[] getColumnDescriptors(@NotNull ResultSet resultSet, @NotNull DatabaseDialect dialect) throws SQLException {
        if (resultSet == null) {
            JdbcEngine.$$$reportNull$$$0(84);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(85);
        }
        ResultSetMetaData metaData = resultSet.getMetaData();
        int count = metaData.getColumnCount();
        DataConsumer.Column[] columnsDescr = new DataConsumer.Column[count];
        int columnNum = 0;
        for (int i2 = 1; i2 <= count; ++i2) {
            String name = null;
            try {
                name = metaData.getColumnLabel(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String typeName = null;
            try {
                typeName = metaData.getColumnTypeName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int type = 1111;
            try {
                type = metaData.getColumnType(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String clazz = null;
            try {
                clazz = metaData.getColumnClassName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String catalog = null;
            try {
                catalog = metaData.getCatalogName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String schema = null;
            try {
                schema = metaData.getSchemaName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String table = null;
            try {
                table = metaData.getTableName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int precision = -1;
            try {
                precision = metaData.getPrecision(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int scale = -1;
            try {
                scale = metaData.getScale(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dialect.getFamilyId().isMysql()) {
                if (type == 91 && "YEAR".equals(typeName) && "java.lang.Short".equals(clazz)) {
                    type = 5;
                }
            } else if (dialect.getFamilyId().isPostgres()) {
                if (Arrays.asList("bit", "varbit", "tid", "uuid").contains(typeName)) {
                    type = 12;
                } else if ("money".equals(typeName)) {
                    type = 1111;
                }
            } else if (dialect.getFamilyId().isOracle()) {
                if (type == -101 || type == -102) {
                    type = 93;
                } else if (type == 2007) {
                    type = 12;
                }
            } else if (dialect.getFamilyId().isSqlite()) {
                catalog = "";
            } else if (dialect.getFamilyId().isDb2()) {
                schema = schema == null ? null : StringUtil.trimTrailing((String)schema);
            }
            columnsDescr[i2 - 1] = new DataConsumer.Column(columnNum++, name, type, typeName, clazz, precision, scale, catalog, schema, table);
        }
        return columnsDescr;
    }

    private void checkCanceled() {
        if (this.myState.get() == State.CANCELED) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private Statement openStatement(@NotNull DatabaseConnection connection, @NotNull String sql, boolean withScrollableResultSet) throws Exception {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(86);
        }
        if (sql == null) {
            JdbcEngine.$$$reportNull$$$0(87);
        }
        if (ourPendingStatements.get(this) != null) {
            throw new AssertionError();
        }
        this.getRequestContext().query.set(sql);
        this.getDataAuditor().requestStarted(this.getRequestContext());
        Statement statement = this.openStatement(connection, withScrollableResultSet);
        this.changeCurrentStatement(null, statement);
        Statement statement2 = statement;
        if (statement2 == null) {
            JdbcEngine.$$$reportNull$$$0(88);
        }
        return statement2;
    }

    @NotNull
    private Statement openStatement(@NotNull DatabaseConnection connection, boolean withScrollableResultSet) throws Exception {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(89);
        }
        Statement statement = withScrollableResultSet && Registry.is((String)"database.scrollable.result.sets") ? this.openStatementWithScrollableResultSetType(connection) : null;
        Statement statement2 = statement != null ? statement : connection.createStatement();
        if (statement2 == null) {
            JdbcEngine.$$$reportNull$$$0(90);
        }
        return statement2;
    }

    @Nullable
    private Statement openStatementWithScrollableResultSetType(@NotNull DatabaseConnection connection) {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(91);
        }
        try {
            if (this.myFamilyId.isDb2()) {
                return null;
            }
            if (connection.getMetaData().supportsResultSetType(1004)) {
                return connection.createStatement(1004, 1007);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to create a statement with a scrollable result set type", (Throwable)e);
        }
        return null;
    }

    @NotNull
    private PreparedStatement openPreparedStatement(@NotNull DatabaseConnection connection, @NotNull String sql) throws Exception {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(92);
        }
        if (sql == null) {
            JdbcEngine.$$$reportNull$$$0(93);
        }
        if (ourPendingStatements.get(this) != null) {
            throw new AssertionError();
        }
        this.getDataAuditor().requestStarted(this.getRequestContext());
        PreparedStatement statement = connection.prepareStatement(sql);
        this.changeCurrentStatement(null, statement);
        PreparedStatement preparedStatement = statement;
        if (preparedStatement == null) {
            JdbcEngine.$$$reportNull$$$0(94);
        }
        return preparedStatement;
    }

    private void startUpdate(@NotNull String sql) {
        if (sql == null) {
            JdbcEngine.$$$reportNull$$$0(95);
        }
        this.getRequestContext().query.set(sql);
        this.getDataAuditor().requestStarted(this.getRequestContext());
    }

    private void endUpdate() {
        try {
            DatabaseConnection connection = this.getCurrentConnection();
            if (connection != null) {
                this.storeTxIsolation(connection);
            }
            this.getDataAuditor().requestFinished(this.getRequestContext());
        }
        finally {
            this.getRequestContext().query.set(null);
        }
    }

    private void closeStatement(Statement statement) {
        this.closeStatement(statement, true);
    }

    private void closeStatement(Statement statement, boolean shouldEndUpdate) {
        try {
            if (statement == null) {
                return;
            }
            this.changeCurrentStatement(statement, null);
            this.closeStatementWithReport(statement);
        }
        finally {
            if (shouldEndUpdate) {
                this.endUpdate();
            }
        }
    }

    private void closeStatementWithReport(@NotNull Statement statement) {
        if (statement == null) {
            JdbcEngine.$$$reportNull$$$0(96);
        }
        try {
            if (this.myConnection != null) {
                statement.close();
            }
        }
        catch (Exception e) {
            this.getRequestContext().reportException(e, statement);
        }
    }

    @Override
    protected void releaseConnection() {
        if (this.myConnection == null) {
            return;
        }
        boolean inTran = this.myTxMarker.getOwner() != null;
        try (GuardedRef<DatabaseConnection> connection = this.myConnection;){
            MyContext requestContext;
            this.myConnection = null;
            if (!connection.get().getAutoCommit()) {
                connection.get().rollback();
            }
            if ((requestContext = (MyContext)ObjectUtils.tryCast((Object)this.getRequestContextIfAny(), MyContext.class)) != null) {
                if (inTran && !requestContext.startedTransaction) {
                    this.getDataAuditor().txCompleted(requestContext, false);
                    JdbcEngine.printAllWarnings();
                }
                this.getDataAuditor().print(requestContext, "Disconnected");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static DataConsumer.Row getCurrentRow(ResultSet resultSet, DataConsumer.Column[] columnsDescr, int rowNum, DatabaseDialect dialect) throws SQLException {
        Object[] objects = new Object[columnsDescr.length];
        Set<Integer> longs = JdbcEngine.findOracleLongs(dialect, columnsDescr);
        for (Integer aLong : longs) {
            objects[aLong.intValue() - 1] = resultSet.getObject(aLong);
        }
        for (int i2 = 1; i2 <= columnsDescr.length; ++i2) {
            if (longs.contains(i2)) continue;
            DataConsumer.Column column = columnsDescr[i2 - 1];
            int jdbcType = ExtractorsUtil.guessJdbcType(column);
            objects[i2 - 1] = JdbcEngine.getObject(resultSet, dialect, column, i2, jdbcType);
        }
        return DataConsumer.Row.create(rowNum, objects);
    }

    private static Object getObject(ResultSet resultSet, DatabaseDialect dialect, DataConsumer.Column column, int index, int jdbcType) throws SQLException {
        if (jdbcType == 2004 || jdbcType == 2005) {
            return JdbcEngine.getBlobOrClob(resultSet, index, jdbcType);
        }
        if (dialect.getFamilyId().isPostgres() && ("bit".equals(column.typeName) || "varbit".equals(column.typeName))) {
            return resultSet.getString(index);
        }
        return resultSet.getObject(index);
    }

    private static Object getBlobOrClob(ResultSet resultSet, int i2, int jdbcType) throws SQLException {
        try {
            if (jdbcType == 2004) {
                return resultSet.getBlob(i2);
            }
            return resultSet.getClob(i2);
        }
        catch (SQLException e) {
            return resultSet.getObject(i2);
        }
    }

    private static Set<Integer> findOracleLongs(DatabaseDialect dialect, DataConsumer.Column[] columns2) throws SQLException {
        if (!dialect.getFamilyId().isOracle()) {
            return ContainerUtil.set((Object[])new Integer[0]);
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (int i2 = 1; i2 <= columns2.length; ++i2) {
            if (columns2[i2 - 1].type != -1) continue;
            result2.add(i2);
        }
        return result2;
    }

    private boolean willReconnect(@NotNull ObjectPath needed) {
        if (needed == null) {
            JdbcEngine.$$$reportNull$$$0(97);
        }
        ObjectPath current = this.getCurrentNamespace();
        DatabaseConnection connection = this.getCurrentConnection();
        return current == null ? JdbcUrlParserUtil.outOfBounds(connection == null ? this.myDataSource : connection.getConnectionPoint(), needed) : JdbcUrlParserUtil.outOfBounds(this.myDataSource, current, needed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 17: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 55: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 74: 
            case 83: 
            case 88: 
            case 90: 
            case 94: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 17: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 55: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 74: 
            case 83: 
            case 88: 
            case 90: 
            case 94: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: 
            case 5: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 22: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 51: 
            case 52: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 11: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 12: 
            case 17: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 55: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 74: 
            case 83: 
            case 88: 
            case 90: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcEngine";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementCreator";
                break;
            }
            case 16: 
            case 26: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 56: 
            case 86: 
            case 89: 
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 18: 
            case 20: 
            case 24: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbConnection";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 31: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPath";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setSchemaSql";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutation";
                break;
            }
            case 50: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryData";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataAuditor";
                break;
            }
            case 63: 
            case 66: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 64: 
            case 67: 
            case 70: 
            case 81: 
            case 85: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processName";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyId";
                break;
            }
            case 79: 
            case 80: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 87: 
            case 93: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sql";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "needed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcEngine";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequestContext";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createConnectionGuard";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDataForDelete";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDataForUpdate";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDataForInsert";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptors";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedUpdateCounts";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnNamesForInsert";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholdersForInsert";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldParticipateInInsert";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "mergedQueryData";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjects";
                break;
            }
            case 88: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "openStatement";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "openPreparedStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitQuery";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitInsert";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitDelete";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitSchemaSwitch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRequestContext";
                break;
            }
            case 12: 
            case 17: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 55: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 74: 
            case 83: 
            case 88: 
            case 90: 
            case 94: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeQueryInner";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createConnectionGuard";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "executePreparedStatement";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "executeStatement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateCountSafe";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "printWarnings";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "prepareConnection";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setTxIsolation";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "storeTxIsolation";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "shouldChangeIsolation";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "performSchemaSwitch";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "performImplicitSchemaSwitch";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "performExplicitSchemaSwitch";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForSelect";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getConditionRequestQuery";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForDelete";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForUpdate";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForInsert";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptors";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "executeUpdateStatement";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "executeConditionQueryRequest";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "executeQueryRequest";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "executeUpdateStatementInner";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedUpdateCounts";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "executeUpdateStatementAndGetUpdateCounts";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "handleException";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNamesForInsert";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholdersForInsert";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "shouldParticipateInInsert";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "mergedQueryData";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "appendErrorMessage";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "printResultSet";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getObjects";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getColumnDescriptors";
                break;
            }
            case 86: 
            case 87: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "openStatement";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "openStatementWithScrollableResultSetType";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "openPreparedStatement";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "startUpdate";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "closeStatementWithReport";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "willReconnect";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "lambda$shouldParticipateInInsert$23";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeQueryRequest$18";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeUpdateStatement$16";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildDataForUpdate$13";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildDataForDelete$11";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "lambda$visitSchemaSwitch$5";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "lambda$visitQuery$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 17: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 55: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 74: 
            case 83: 
            case 88: 
            case 90: 
            case 94: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyContext
    extends DataRequest.TxContext {
        final boolean startedTransaction;
        volatile SearchPath searchPath;

        MyContext(@NotNull JdbcEngine engine, @NotNull DataRequest request, boolean startedTransaction) {
            if (engine == null) {
                MyContext.$$$reportNull$$$0(0);
            }
            if (request == null) {
                MyContext.$$$reportNull$$$0(1);
            }
            super(engine, request, engine.myTxMarker);
            this.startedTransaction = startedTransaction;
        }

        @Override
        public void reportException(@NotNull Throwable th, Object parameter) {
            if (th == null) {
                MyContext.$$$reportNull$$$0(2);
            }
            JdbcEngine engine = (JdbcEngine)ObjectUtils.notNull((Object)((JdbcEngine)this.producer));
            JdbcEngine.handleException(this, th, engine.getDataAuditor(), engine.getDataSource());
        }

        @Override
        @Nullable
        public SearchPath getSearchPath() {
            return this.searchPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "engine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "th";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$MyContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reportException";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnsafeUpdateRolledBackException
    extends Exception {
        public UnsafeUpdateRolledBackException(String message) {
            super(message);
        }
    }

    private static interface ValidConnectionStateGuard {
        public void free(boolean var1) throws Exception;

        public static class RollbackToSavepoint
        implements ValidConnectionStateGuard {
            final RemoteSavepoint mySavepoint;
            final DatabaseConnection myGuardedConnection;

            RollbackToSavepoint(@NotNull DatabaseConnection connection) {
                if (connection == null) {
                    RollbackToSavepoint.$$$reportNull$$$0(0);
                }
                this.myGuardedConnection = connection;
                this.mySavepoint = this.createSavepoint();
            }

            boolean isAvailable() {
                return this.mySavepoint != null;
            }

            @Override
            public void free(boolean success) throws Exception {
                RemoteConnection connection = (RemoteConnection)RemoteUtil.castToRemote((Object)this.myGuardedConnection.getJdbcConnection(), RemoteConnection.class);
                if (connection == null || this.mySavepoint == null) {
                    return;
                }
                try {
                    if (!success) {
                        connection.rollback(this.mySavepoint);
                    }
                }
                catch (SQLException e) {
                    throw new SQLException(DatabaseMessages.message((String)"message.text.error.failed.to.rollback.to.a.savepoint", (Object[])new Object[0]), e);
                }
                finally {
                    try {
                        connection.releaseSavepoint(this.mySavepoint);
                    }
                    catch (SQLException sQLException) {}
                }
            }

            @Nullable
            private RemoteSavepoint createSavepoint() {
                RemoteConnection connection = (RemoteConnection)RemoteUtil.castToRemote((Object)this.myGuardedConnection.getJdbcConnection(), RemoteConnection.class);
                if (connection == null) {
                    return null;
                }
                try {
                    if (!connection.getMetaData().supportsSavepoints()) {
                        return null;
                    }
                    return connection.setSavepoint();
                }
                catch (Exception e) {
                    LOG.info("Exception while setting an unnamed savepoint", (Throwable)e);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$ValidConnectionStateGuard$RollbackToSavepoint", "<init>"));
            }
        }

        public static class Rollback
        implements ValidConnectionStateGuard {
            private final DatabaseConnection myConnection;

            private Rollback(@NotNull DatabaseConnection connection) {
                if (connection == null) {
                    Rollback.$$$reportNull$$$0(0);
                }
                this.myConnection = connection;
            }

            @Override
            public void free(boolean success) throws Exception {
                if (success) {
                    return;
                }
                this.myConnection.rollback();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$ValidConnectionStateGuard$Rollback", "<init>"));
            }
        }

        public static class Inactive
        implements ValidConnectionStateGuard {
            @Override
            public void free(boolean success) throws Exception {
            }
        }
    }

    class AutoCommitOffGuard
    extends UnexpectedUpdatesGuard {
        private final ValidConnectionStateGuard.RollbackToSavepoint myConnectionGuard;
        private boolean myRollback;

        public AutoCommitOffGuard(@NotNull DatabaseConnection connection, @NotNull String statement, IntArrayList expectedUpdateCounts) {
            if (JdbcEngine.this == null) {
                AutoCommitOffGuard.$$$reportNull$$$0(0);
            }
            if (connection == null) {
                AutoCommitOffGuard.$$$reportNull$$$0(1);
            }
            if (statement == null) {
                AutoCommitOffGuard.$$$reportNull$$$0(2);
            }
            if (expectedUpdateCounts == null) {
                AutoCommitOffGuard.$$$reportNull$$$0(3);
            }
            super(statement, expectedUpdateCounts);
            this.myRollback = true;
            this.myConnectionGuard = new ValidConnectionStateGuard.RollbackToSavepoint(connection);
        }

        @Override
        public boolean updateComplete(@Nullable IntArrayList updateCounts) {
            Trinity<Integer, Integer, Integer> counts = updateCounts != null ? this.getActualExpectedAndStatementNumber(updateCounts) : null;
            boolean unexpectedUpdateCount = updateCounts != null && this.hasUnexpectedUpdateCount(counts);
            boolean bl = this.myRollback = updateCounts == null || unexpectedUpdateCount;
            if (unexpectedUpdateCount) {
                if (this.myConnectionGuard.isAvailable()) {
                    this.reportChangesWillBeRolledBack(counts);
                } else {
                    this.reportUnexpectedUpdateCount(counts);
                }
            }
            return !this.myRollback;
        }

        @Override
        public void free() throws Exception {
            this.myConnectionGuard.free(!this.myRollback);
        }

        private void reportUnexpectedUpdateCount(@NotNull Trinity<Integer, Integer, Integer> trinity) {
            if (trinity == null) {
                AutoCommitOffGuard.$$$reportNull$$$0(4);
            }
            String message = DatabaseMessages.message((String)"message.text.error.unexpected.update.count", (Object[])new Object[0]) + this.getDiffString(trinity) + ". Rollback the current transaction to undo changes made by: \n" + this.myStatement;
            JdbcEngine.this.getDataAuditor().print(JdbcEngine.this.getRequestContext(), message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "this$0";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedUpdateCounts";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trinity";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$AutoCommitOffGuard";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reportUnexpectedUpdateCount";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class AutoCommitGuard
    extends UnexpectedUpdatesGuard {
        final DatabaseConnection myGuardedConnection;
        private boolean myRollback;

        public AutoCommitGuard(@NotNull DatabaseConnection connection, @NotNull String statement, IntArrayList expectedUpdateCounts) throws SQLException {
            if (JdbcEngine.this == null) {
                AutoCommitGuard.$$$reportNull$$$0(0);
            }
            if (connection == null) {
                AutoCommitGuard.$$$reportNull$$$0(1);
            }
            if (statement == null) {
                AutoCommitGuard.$$$reportNull$$$0(2);
            }
            if (expectedUpdateCounts == null) {
                AutoCommitGuard.$$$reportNull$$$0(3);
            }
            super(statement, expectedUpdateCounts);
            this.myRollback = true;
            this.myGuardedConnection = connection;
            this.myGuardedConnection.setAutoCommit(false);
        }

        @Override
        public boolean updateComplete(@Nullable IntArrayList updateCounts) {
            Trinity<Integer, Integer, Integer> counts = updateCounts != null ? this.getActualExpectedAndStatementNumber(updateCounts) : null;
            boolean unexpectedUpdateCount = this.hasUnexpectedUpdateCount(counts);
            boolean bl = this.myRollback = updateCounts == null || unexpectedUpdateCount;
            if (unexpectedUpdateCount) {
                this.reportChangesWillBeRolledBack(counts);
            }
            return !this.myRollback;
        }

        @Override
        public void free() throws Exception {
            if (this.myRollback) {
                this.myGuardedConnection.rollback();
            } else {
                this.myGuardedConnection.commit();
            }
            this.myGuardedConnection.setAutoCommit(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "this$0";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "statement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expectedUpdateCounts";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/JdbcEngine$AutoCommitGuard";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class UnexpectedUpdatesGuard {
        protected final String myStatement;
        private final int myExpectedUpdateCount;
        private final IntArrayList myExpectedUpdateCounts;

        public UnexpectedUpdatesGuard(@NotNull String statement, IntArrayList expectedUpdateCounts) {
            if (JdbcEngine.this == null) {
                UnexpectedUpdatesGuard.$$$reportNull$$$0(0);
            }
            if (statement == null) {
                UnexpectedUpdatesGuard.$$$reportNull$$$0(1);
            }
            if (expectedUpdateCounts == null) {
                UnexpectedUpdatesGuard.$$$reportNull$$$0(2);
            }
            this.myStatement = statement;
            this.myExpectedUpdateCount = IntStream.of(expectedUpdateCounts.toArray()).sum();
            this.myExpectedUpdateCounts = expectedUpdateCounts;
        }

        public abstract boolean updateComplete(@Nullable IntArrayList var1);

        public abstract void free() throws Exception;

        protected final boolean hasUnexpectedUpdateCount(@Nullable Trinity<Integer, Integer, Integer> trinity) {
            return trinity != null && !Comparing.equal((Object)trinity.getFirst(), (Object)trinity.getSecond());
        }

        @NotNull
        protected final Trinity<Integer, Integer, Integer> getActualExpectedAndStatementNumber(@NotNull IntArrayList updateCounts) {
            if (updateCounts == null) {
                UnexpectedUpdatesGuard.$$$reportNull$$$0(3);
            }
            int sum = 0;
            int size = updateCounts.size();
            for (int i2 = 0; i2 < size; ++i2) {
                int count = updateCounts.get(i2);
                if (this.myExpectedUpdateCounts.size() > i2 && this.myExpectedUpdateCounts.get(i2) != count) {
                    Trinity trinity = Trinity.create((Object)count, (Object)1, (Object)(i2 + 1));
                    if (trinity == null) {
                        UnexpectedUpdatesGuard.$$$reportNull$$$0(4);
                    }
                    return trinity;
                }
                sum += count;
            }
            Trinity trinity = Trinity.create((Object)sum, (Object)this.myExpectedUpdateCount, null);
            if (trinity == null) {
                UnexpectedUpdatesGuard.$$$reportNull$$$0(5);
            }
            return trinity;
        }

        protected final void reportChangesWillBeRolledBack(@NotNull Trinity<Integer, Integer, Integer> trinity) {
            if (trinity == null) {
                UnexpectedUpdatesGuard.$$$reportNull$$$0(6);
            }
            String message = DatabaseMessages.message((String)"message.text.error.unexpected.update.count", (Object[])new Object[0]) + this.getDiffString(trinity) + "Changes will be rolled back. SQL: \n" + this.myStatement;
            JdbcEngine.this.getRequestContext().reportException(new UnsafeUpdateRolledBackException(message), null);
        }

        @NotNull
        protected final String getDiffString(@NotNull Trinity<Integer, Integer, Integer> trinity) {
            if (trinity == null) {
                UnexpectedUpdatesGuard.$$$reportNull$$$0(7);
            }
            int actual = (Integer)trinity.getFirst();
            int expected = (Integer)trinity.getSecond();
            Integer statementNumber = (Integer)trinity.getThird();
            String diffString = (statementNumber == null ? "" : " in statement %s") + " (Actual: %s, Expected: %s). ";
            String string = statementNumber == null ? String.format(diffString, actual, expected) : String.format(diffString, statementNumber, actual, expected);
            if (string == null) {
                UnexpectedUpdatesGuard.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "0";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedUpdateCounts";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updateCounts";
                    break;
                }
                case 4: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$UnexpectedUpdatesGuard";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trinity";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$UnexpectedUpdatesGuard";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActualExpectedAndStatementNumber";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDiffString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getActualExpectedAndStatementNumber";
                    break;
                }
                case 4: 
                case 5: 
                case 8: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "reportChangesWillBeRolledBack";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getDiffString";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LastPageHandler
    implements DataConsumer {
        private final DataConsumer delegate;
        private int resultSetIndex;
        private DataConsumer.Column[] columnInfos;
        private RowsCyclicBuffer myBuffer;

        public LastPageHandler(DataConsumer handler, int start, int size) {
            this.delegate = handler;
            this.myBuffer = new RowsCyclicBuffer(Math.max(size, -start));
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] infos, int firstRowNum) {
            if (context == null) {
                LastPageHandler.$$$reportNull$$$0(0);
            }
            this.resultSetIndex = resultSetIndex;
            this.columnInfos = infos;
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                LastPageHandler.$$$reportNull$$$0(1);
            }
            this.myBuffer.addRows(rows);
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            List<DataConsumer.Row> rows;
            if (context == null) {
                LastPageHandler.$$$reportNull$$$0(2);
            }
            if ((rows = this.myBuffer.getRows()).isEmpty()) {
                this.delegate.setColumns(context, this.resultSetIndex, this.columnInfos, 0);
                this.delegate.afterLastRowAdded(context, 0);
                return;
            }
            this.delegate.setColumns(context, this.resultSetIndex, this.columnInfos, rows.get((int)0).rowNum);
            this.delegate.addRows(context, rows);
            this.delegate.afterLastRowAdded(context, total);
        }

        public int getRowCount() {
            return this.myBuffer.getRows().size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "context";
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$LastPageHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class RowsCyclicBuffer {
            private final DataConsumer.Row[] myBuffer;
            private int myFirstIdx = 0;
            private int myLastIdx = -1;

            public RowsCyclicBuffer(int bufferSize) {
                this.myBuffer = new DataConsumer.Row[bufferSize];
            }

            public void addRows(@NotNull Iterable<DataConsumer.Row> rows) {
                if (rows == null) {
                    RowsCyclicBuffer.$$$reportNull$$$0(0);
                }
                for (DataConsumer.Row row : rows) {
                    if (this.myLastIdx != -1 && this.nextIdx(this.myLastIdx) == this.myFirstIdx) {
                        this.myFirstIdx = this.nextIdx(this.myFirstIdx);
                    }
                    this.myLastIdx = this.nextIdx(this.myLastIdx);
                    this.myBuffer[this.myLastIdx] = row;
                }
            }

            @NotNull
            public List<DataConsumer.Row> getRows() {
                if (this.myLastIdx == -1) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        RowsCyclicBuffer.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                if (this.myFirstIdx == 0) {
                    List list = ContainerUtil.newArrayList((Object[])this.myBuffer, (int)0, (int)(this.myLastIdx + 1));
                    if (list == null) {
                        RowsCyclicBuffer.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                ArrayList rows = ContainerUtil.newArrayListWithCapacity((int)this.myBuffer.length);
                ImmutableList bufferAsList = ContainerUtil.immutableList((Object[])this.myBuffer);
                rows.addAll(bufferAsList.subList(this.myFirstIdx, this.myBuffer.length));
                rows.addAll(bufferAsList.subList(0, this.myLastIdx + 1));
                ArrayList arrayList = rows;
                if (arrayList == null) {
                    RowsCyclicBuffer.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            private int nextIdx(int idx) {
                return (idx + 1) % this.myBuffer.length;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rows";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRows";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "addRows";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static enum State {
        IDLE,
        RUNNING,
        STREAMING,
        CANCELED;

    }
}

