/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationRequest;
import com.intellij.database.console.evaluation.EvaluationResultFetcher;
import com.intellij.database.console.evaluation.OwnerBasedEvaluationRequestor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DasObjectRequestor
extends OwnerBasedEvaluationRequestor {
    private final DasObject myObject;

    protected DasObjectRequestor(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource source, @NotNull DasObject object) {
        if (project == null) {
            DasObjectRequestor.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            DasObjectRequestor.$$$reportNull$$$0(1);
        }
        if (source == null) {
            DasObjectRequestor.$$$reportNull$$$0(2);
        }
        if (object == null) {
            DasObjectRequestor.$$$reportNull$$$0(3);
        }
        super(project, dialect, source);
        this.myObject = object;
    }

    @Override
    @Nullable
    public EvaluationRequest createRequest(@NotNull DataRequest.OwnerEx owner, @NotNull CompletableFuture<DatabaseExpressionEvaluator.Result> future) {
        if (owner == null) {
            DasObjectRequestor.$$$reportNull$$$0(4);
        }
        if (future == null) {
            DasObjectRequestor.$$$reportNull$$$0(5);
        }
        Optional<String> query = this.getQueryIfAny();
        return query.map(s -> {
            if (owner == null) {
                DasObjectRequestor.$$$reportNull$$$0(8);
            }
            if (future == null) {
                DasObjectRequestor.$$$reportNull$$$0(9);
            }
            return new MyRequest(owner, this.myProject, this.myDialect, future, (String)s, this.myObject, this.mySource);
        }).orElse(null);
    }

    @Override
    @NotNull
    public String getQuery() {
        String string = this.getQueryIfAny().orElse(this.myObject.getName());
        if (string == null) {
            DasObjectRequestor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean isEmpty() {
        return QueryBuilder.of(this.myObject) == null;
    }

    @NotNull
    private Optional<String> getQueryIfAny() {
        QueryBuilder builder = QueryBuilder.of(this.myObject);
        Optional<Object> optional = Optional.ofNullable(builder == null ? null : builder.build(this.myObject, this.myDialect, (DatabaseSystem)this.mySource, 0, 10));
        if (optional == null) {
            DasObjectRequestor.$$$reportNull$$$0(7);
        }
        return optional;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/evaluation/DasObjectRequestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/evaluation/DasObjectRequestor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuery";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryIfAny";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRequest$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum QueryBuilder {
        TABLE{

            @Override
            boolean canBuild(@NotNull DasObject object) {
                if (object == null) {
                    1.$$$reportNull$$$0(0);
                }
                return object instanceof DasTable;
            }

            @Override
            @NotNull
            String build(@NotNull DasObject object, @NotNull DatabaseDialectEx dialect, @NotNull DatabaseSystem system, int start, int load) {
                if (object == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (dialect == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (system == null) {
                    1.$$$reportNull$$$0(3);
                }
                String string = DbImplUtil.createSelectAllQuery((DasTable)object, dialect, system, start + load + 1).getStatement();
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dialect";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "system";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "build";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "canBuild";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "build";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        ,
        COLUMN{

            @Override
            boolean canBuild(@NotNull DasObject object) {
                if (object == null) {
                    2.$$$reportNull$$$0(0);
                }
                return object instanceof DasColumn && object.getDbParent() instanceof DasTable;
            }

            @Override
            @NotNull
            String build(@NotNull DasObject object, @NotNull DatabaseDialectEx dialect, @NotNull DatabaseSystem system, int start, int load) {
                if (object == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (dialect == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (system == null) {
                    2.$$$reportNull$$$0(3);
                }
                DasTable table = (DasTable)ObjectUtils.notNull((Object)((DasTable)object.getDbParent()));
                String string = dialect.sqlSelectColumns(DbImplUtil.createBuilderForUIExec(dialect, (DasObject)table), table, system, null, null, ContainerUtil.list((Object[])new DasColumn[]{(DasColumn)object}), false, start == -1 ? -1 : start + load + 1).getStatement();
                if (string == null) {
                    2.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dialect";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "system";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder$2";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "build";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "canBuild";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "build";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };


        @NotNull
        abstract String build(@NotNull DasObject var1, @NotNull DatabaseDialectEx var2, @NotNull DatabaseSystem var3, int var4, int var5);

        abstract boolean canBuild(@NotNull DasObject var1);

        @Nullable
        static QueryBuilder of(@NotNull DasObject object) {
            if (object == null) {
                QueryBuilder.$$$reportNull$$$0(0);
            }
            for (QueryBuilder builder : QueryBuilder.values()) {
                if (!builder.canBuild(object)) continue;
                return builder;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder", "of"));
        }
    }

    private static class MyFetcher
    extends EvaluationResultFetcher {
        private final DasObject myObject;

        MyFetcher(@NotNull List<DataConsumer.Row> rows, @NotNull List<DataConsumer.Column> columns2, @NotNull Project project, @NotNull DataRequest.OwnerEx ex, @NotNull DbDataSource source, @NotNull DatabaseDialectEx dialect, @NotNull String query, @NotNull DasObject object, boolean loaded) {
            if (rows == null) {
                MyFetcher.$$$reportNull$$$0(0);
            }
            if (columns2 == null) {
                MyFetcher.$$$reportNull$$$0(1);
            }
            if (project == null) {
                MyFetcher.$$$reportNull$$$0(2);
            }
            if (ex == null) {
                MyFetcher.$$$reportNull$$$0(3);
            }
            if (source == null) {
                MyFetcher.$$$reportNull$$$0(4);
            }
            if (dialect == null) {
                MyFetcher.$$$reportNull$$$0(5);
            }
            if (query == null) {
                MyFetcher.$$$reportNull$$$0(6);
            }
            if (object == null) {
                MyFetcher.$$$reportNull$$$0(7);
            }
            super(rows, columns2, project, ex, source, dialect, query, loaded);
            this.myObject = object;
        }

        @Override
        @NotNull
        protected String getQuery(int start, int load) {
            String string = ((QueryBuilder)((Object)ObjectUtils.notNull((Object)((Object)QueryBuilder.of(this.myObject))))).build(this.myObject, this.myDialect, (DatabaseSystem)this.mySource, start, load);
            if (string == null) {
                MyFetcher.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Override
        @Nullable
        protected String getCountQuery(@NotNull String alias) {
            if (alias == null) {
                MyFetcher.$$$reportNull$$$0(9);
            }
            String query = ((QueryBuilder)((Object)ObjectUtils.notNull((Object)((Object)QueryBuilder.of(this.myObject))))).build(this.myObject, this.myDialect, (DatabaseSystem)this.mySource, -1, -1);
            return DbImplUtil.createSelectCountQuery(this.myProject, this.myDialect, query, this.mySource);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ex";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/DasObjectRequestor$MyFetcher";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alias";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/DasObjectRequestor$MyFetcher";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getCountQuery";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyRequest
    extends EvaluationRequest {
        private final DasObject myObject;

        MyRequest(@NotNull DataRequest.OwnerEx owner, @NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull CompletableFuture<DatabaseExpressionEvaluator.Result> future, @NotNull String query, @NotNull DasObject object, @NotNull DbDataSource source) {
            if (owner == null) {
                MyRequest.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyRequest.$$$reportNull$$$0(1);
            }
            if (dialect == null) {
                MyRequest.$$$reportNull$$$0(2);
            }
            if (future == null) {
                MyRequest.$$$reportNull$$$0(3);
            }
            if (query == null) {
                MyRequest.$$$reportNull$$$0(4);
            }
            if (object == null) {
                MyRequest.$$$reportNull$$$0(5);
            }
            if (source == null) {
                MyRequest.$$$reportNull$$$0(6);
            }
            super(owner, project, dialect, future, query, source);
            this.myObject = object;
        }

        @Override
        @NotNull
        protected EvaluationResultFetcher createFetcher(@NotNull List<DataConsumer.Row> rows, @NotNull List<DataConsumer.Column> columns2, boolean loaded) {
            if (rows == null) {
                MyRequest.$$$reportNull$$$0(7);
            }
            if (columns2 == null) {
                MyRequest.$$$reportNull$$$0(8);
            }
            MyFetcher myFetcher = new MyFetcher(rows, columns2, this.myProject, (DataRequest.OwnerEx)this.owner, this.mySource, this.myDialect, this.query, this.myObject, loaded);
            if (myFetcher == null) {
                MyRequest.$$$reportNull$$$0(9);
            }
            return myFetcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "future";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/DasObjectRequestor$MyRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/DasObjectRequestor$MyRequest";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFetcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createFetcher";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

