/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDomain
extends Domain {
    private final Cardinality.TextCardinality myCardinality;
    private final long myDefaultValue;
    private final boolean myNarrowable;
    private final long myLength;

    public TextDomain(@NotNull String name, @NotNull ConversionPoint descriptor, long maxLength) {
        if (name == null) {
            TextDomain.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            TextDomain.$$$reportNull$$$0(1);
        }
        this(name, descriptor, maxLength, -1L, false);
    }

    /*
     * WARNING - void declaration
     */
    public TextDomain(@NotNull String name, @NotNull ConversionPoint descriptor, long maxLength, long defaultValue, boolean bl) {
        void narrowable;
        if (name == null) {
            TextDomain.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            TextDomain.$$$reportNull$$$0(3);
        }
        super(descriptor, PhysicalDomainType.TEXT, name);
        this.myLength = maxLength;
        this.myCardinality = new Cardinality.TextCardinality(maxLength);
        this.myDefaultValue = defaultValue;
        this.myNarrowable = narrowable;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(4);
        }
        Compatibility compatibility = domain instanceof BinaryDomain ? this.compareWithLength((BinaryDomain)domain) : (domain instanceof TextDomain ? (((TextDomain)domain).myLength <= this.myLength ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType())) : Compatibility.uncompatibleLossless(this.cardinality(), TextDomain.getLogicalType(domain), this.getLogicType()));
        if (compatibility == null) {
            TextDomain.$$$reportNull$$$0(5);
        }
        return compatibility;
    }

    @NotNull
    private static LogicalType getLogicalType(@NotNull Domain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(6);
        }
        LogicalType logicalType = domain instanceof TextPreferrable ? ((TextPreferrable)((Object)domain)).getFakeType() : domain.getLogicType();
        if (logicalType == null) {
            TextDomain.$$$reportNull$$$0(7);
        }
        return logicalType;
    }

    @NotNull
    private Compatibility compareWithLength(@NotNull BinaryDomain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(8);
        }
        Compatibility compatibility = domain.getUpperBound() <= this.getLength() ? Compatibility.uncompatibleLossless(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.uncompatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType());
        if (compatibility == null) {
            TextDomain.$$$reportNull$$$0(9);
        }
        return compatibility;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.TextCardinality textCardinality = this.myCardinality;
        if (textCardinality == null) {
            TextDomain.$$$reportNull$$$0(10);
        }
        return textCardinality;
    }

    public long getLength() {
        return this.myLength;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            TextDomain.$$$reportNull$$$0(11);
        }
        return this.getLength() != 0L && o instanceof String ? ((String)o).substring(0, (int)Math.min(this.getLength(), (long)((String)o).length())) : o;
    }

    public long getDefaultValue() {
        return this.myDefaultValue;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            TextDomain.$$$reportNull$$$0(12);
        }
        TextDomain textDomain = this.myNarrowable && domain instanceof TextDomain ? new TextDomain(this.simpleName(), this.getPoint(), Math.min(((TextDomain)domain).getLength(), this.getLength()), this.myDefaultValue, true) : this;
        if (textDomain == null) {
            TextDomain.$$$reportNull$$$0(13);
        }
        return textDomain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            TextDomain.$$$reportNull$$$0(14);
        }
        TextDomain textDomain = this.myNarrowable ? new TextDomain(this.simpleName(), this.getPoint(), Math.min((long)provider.getSize(), this.getLength()), this.myDefaultValue, true) : this;
        if (textDomain == null) {
            TextDomain.$$$reportNull$$$0(15);
        }
        return textDomain;
    }

    @Override
    @NotNull
    public String name() {
        String string = this.myLength == this.myDefaultValue || !this.myNarrowable || this.getLength() <= 0L ? super.name() : this.simpleName() + "(" + this.getLength() + ")";
        if (string == null) {
            TextDomain.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/TextDomain";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/TextDomain";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibility";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "compareWithLength";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "cardinality";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "narrow";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibility";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLogicalType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareWithLength";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "narrow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface TextPreferrable {
        @NotNull
        public LogicalType getFakeType();
    }
}

