/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSshTunnelConfiguration {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.database.dataSource.DataSourceSshTunnelConfiguration");
    public static final String ELEMENT_NAME = "ssh-properties";
    private final String myProxyHost;
    private final String myProxyPort;
    private final boolean myUseMasterKeyStorage;
    private final String myUser;
    private final String myPassword;
    private final String myPrivateKeyPath;
    private final String myPassphrase;
    private final boolean myEnabled;
    private final boolean myUsePassword;

    public DataSourceSshTunnelConfiguration(@NotNull String proxyHost, @NotNull String proxyPort, boolean useMasterKeyStorage, @NotNull String user, @NotNull String password, @NotNull String privateKeyPath, @NotNull String passphrase, boolean enabled, boolean usePassword) {
        if (proxyHost == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(0);
        }
        if (proxyPort == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(1);
        }
        if (user == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(2);
        }
        if (password == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(3);
        }
        if (privateKeyPath == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(4);
        }
        if (passphrase == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(5);
        }
        this.myProxyHost = proxyHost;
        this.myProxyPort = proxyPort;
        this.myUseMasterKeyStorage = useMasterKeyStorage;
        this.myUser = user;
        this.myPassword = password;
        this.myPrivateKeyPath = privateKeyPath;
        this.myPassphrase = passphrase;
        this.myEnabled = enabled;
        this.myUsePassword = usePassword;
    }

    public static boolean equal(@Nullable DataSourceSshTunnelConfiguration c1, @Nullable DataSourceSshTunnelConfiguration c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.equalConfiguration(c2);
    }

    @Nullable
    public static DataSourceSshTunnelConfiguration deserialize(@NotNull HierarchicalStreamReader xmlReader, @NotNull LocalDataSource dataSource) {
        DataSourceSshTunnelConfiguration configuration;
        if (xmlReader == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(6);
        }
        if (dataSource == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(7);
        }
        String proxyHost = "";
        String proxyPort = "";
        String user = "";
        String password = "";
        String privateKeyPath = "";
        String passphrase = "";
        String remoteHost = "";
        String remotePort = "";
        String localPort = "";
        boolean enabled = false;
        boolean usePassword = true;
        boolean useMasterKey = false;
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String name = xmlReader.getNodeName();
            String value = xmlReader.getValue();
            if ("proxy-host".equals(name)) {
                proxyHost = value;
            } else if ("proxy-port".equals(name)) {
                proxyPort = value;
            } else if ("secret-storage".equals(name)) {
                useMasterKey = "MASTER_KEY".equalsIgnoreCase(xmlReader.getValue());
            } else if ("user".equals(name)) {
                user = value;
            } else if ("use-password".equals(name)) {
                usePassword = StringUtil.parseBoolean((String)value, (boolean)true);
            } else if ("private-key-path".equals(name)) {
                privateKeyPath = value;
            } else if ("remote-host".equals(name)) {
                remoteHost = value;
            } else if ("remote-port".equals(name)) {
                remotePort = value;
            } else if ("local-port".equals(name)) {
                localPort = value;
            } else if ("enabled".equals(name)) {
                enabled = StringUtil.parseBoolean((String)value, (boolean)false);
            }
            xmlReader.moveUp();
        }
        if (!(StringUtil.isEmpty((String)remoteHost) || StringUtil.isEmpty((String)remotePort) || StringUtil.isEmpty((String)localPort))) {
            String url = dataSource.getUrl();
            url = url.replace(localPort, remotePort);
            url = url.replace("localhost", remoteHost);
            url = url.replace("127.0.0.1", remoteHost);
            dataSource.setUrl(url);
        }
        return (configuration = new DataSourceSshTunnelConfiguration(proxyHost, proxyPort, useMasterKey, user, password, privateKeyPath, passphrase, enabled, usePassword)).isEmpty() ? null : configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Pair<Session, Integer> createTunnel(@NotNull LocalDataSource dataSource) throws JSchException {
        Session session;
        int localPort;
        block14: {
            if (dataSource == null) {
                DataSourceSshTunnelConfiguration.$$$reportNull$$$0(8);
            }
            if (!this.isEnabled() || dataSource.getDatabaseDriver() == null) {
                return null;
            }
            String connectionUrl = dataSource.getUrl();
            if (connectionUrl == null) {
                return null;
            }
            Pair.NonNull<String, String> hostPort = JdbcUrlParserUtil.extractHostPort(dataSource.getDatabaseDriver().getJDBCUrlParsers(), connectionUrl, null);
            if (hostPort == null) {
                throw new UnsupportedOperationException("Unable to find host/port in URL");
            }
            try (ServerSocket serverSocket = new ServerSocket(0);){
                localPort = serverSocket.getLocalPort();
            }
            catch (IOException e) {
                throw new JSchException("Can't find a free port", (Throwable)e);
            }
            JSch jsch = new JSch();
            JSch.setConfig((String)"kex", (String)"diffie-hellman-group1-sha1,diffie-hellman-group14-sha1,diffie-hellman-group-exchange-sha1,diffie-hellman-group-exchange-sha256");
            Pair<String, String> pair = DatabaseCredentials.getInstance().getSshCredentials(dataSource);
            if (!this.isUsePassword()) {
                jsch.addIdentity(this.getPrivateKeyPath(), (String)pair.second);
            }
            session = jsch.getSession(this.getUser(), this.getProxyHost(), StringUtil.parseInt((String)this.getProxyPort(), (int)-1));
            if (this.isUsePassword()) {
                session.setPassword((String)pair.first);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            config.put("TCPKeepAlive", "yes");
            session.setConfig(config);
            session.setServerAliveInterval((int)TimeUnit.MINUTES.toMillis(2L));
            session.setServerAliveCountMax(1000);
            session.connect();
            try {
                session.setPortForwardingL(localPort, (String)hostPort.first, StringUtil.parseInt((String)((String)hostPort.second), (int)-1));
            }
            catch (JSchException e) {
                if (e.getCause() instanceof BindException) break block14;
                throw e;
            }
        }
        LOG.info("SSH tunnel created: " + Arrays.asList(session.getPortForwardingL()) + " via " + session.getHost() + ":" + session.getPort() + " on localhost:" + localPort);
        return Pair.create((Object)session, (Object)localPort);
    }

    public void serialize(@NotNull HierarchicalStreamWriter serializer) {
        if (serializer == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(9);
        }
        serializer.startNode(ELEMENT_NAME);
        LocalDataSource.writeTag(serializer, "enabled", Boolean.toString(this.myEnabled));
        LocalDataSource.writeTag(serializer, "proxy-host", this.myProxyHost);
        LocalDataSource.writeTag(serializer, "proxy-port", this.myProxyPort);
        if (this.myUseMasterKeyStorage) {
            LocalDataSource.writeTag(serializer, "secret-storage", StringUtil.toLowerCase((String)"MASTER_KEY"));
        }
        LocalDataSource.writeTag(serializer, "user", this.myUser);
        LocalDataSource.writeTag(serializer, "use-password", Boolean.toString(this.myUsePassword));
        LocalDataSource.writeTag(serializer, "private-key-path", this.myPrivateKeyPath);
        serializer.endNode();
    }

    @NotNull
    public String getProxyHost() {
        String string = this.myProxyHost;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getUser() {
        String string = this.myUser;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getProxyPort() {
        String string = this.myProxyPort;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getPassword() {
        String string = this.myPassword;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getPrivateKeyPath() {
        String string = this.myPrivateKeyPath;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getPassphrase() {
        String string = this.myPassphrase;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(15);
        }
        return string;
    }

    public boolean isUseMasterKeyStorage() {
        return this.myUseMasterKeyStorage;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean isUsePassword() {
        return this.myUsePassword;
    }

    public boolean equalConfiguration(@NotNull DataSourceSshTunnelConfiguration configuration) {
        if (configuration == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(16);
        }
        if (this.myEnabled != configuration.myEnabled) {
            return false;
        }
        if (this.myUsePassword != configuration.myUsePassword) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myProxyHost), (CharSequence)StringUtil.nullize((String)configuration.myProxyHost))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myProxyPort), (CharSequence)StringUtil.nullize((String)configuration.myProxyPort))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myUser), (CharSequence)StringUtil.nullize((String)configuration.myUser))) {
            return false;
        }
        if (this.myUseMasterKeyStorage != configuration.isUseMasterKeyStorage()) {
            return false;
        }
        return StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myPrivateKeyPath), (CharSequence)StringUtil.nullize((String)configuration.myPrivateKeyPath));
    }

    public boolean isEmpty() {
        if (this.myEnabled) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myProxyHost)) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myUser)) {
            return false;
        }
        return !StringUtil.isNotEmpty((String)this.myPrivateKeyPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyPort";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "privateKeyPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passphrase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyHost";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUser";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyPort";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassword";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrivateKeyPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassphrase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTunnel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "equalConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

