/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DataSourceProblemsHolder;
import com.intellij.database.dataSource.validation.DataSourceProblemsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceProblemsCollector<Key> {
    private final DataSourceProblemsHolder myDataSourceProblemsHolder;
    private final Map<Key, Errors> myErrors;

    public DataSourceProblemsCollector(@NotNull DataSourceProblemsHolder dataSourceProblemsHolder) {
        if (dataSourceProblemsHolder == null) {
            DataSourceProblemsCollector.$$$reportNull$$$0(0);
        }
        this.myErrors = ContainerUtil.newHashMap();
        this.myDataSourceProblemsHolder = dataSourceProblemsHolder;
    }

    public void add(@NotNull Key object, @NotNull DataSourceProblemsProvider provider) {
        if (object == null) {
            DataSourceProblemsCollector.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            DataSourceProblemsCollector.$$$reportNull$$$0(2);
        }
        this.myErrors.put(object, new Errors(provider, this.myDataSourceProblemsHolder));
    }

    public boolean contains(@NotNull Key object) {
        if (object == null) {
            DataSourceProblemsCollector.$$$reportNull$$$0(3);
        }
        return this.myErrors.containsKey(object);
    }

    public void update(@NotNull Key object) {
        Errors errors;
        if (object == null) {
            DataSourceProblemsCollector.$$$reportNull$$$0(4);
        }
        if ((errors = this.myErrors.get(object)) != null) {
            errors.update();
        }
    }

    public void remove(@NotNull Key object) {
        Errors errors;
        if (object == null) {
            DataSourceProblemsCollector.$$$reportNull$$$0(5);
        }
        if ((errors = this.myErrors.get(object)) != null) {
            errors.setErrors(null);
        }
        this.myErrors.remove(object);
    }

    @Nullable
    public Set<DataSourceProblem> getProblems(Key object) {
        Errors errors = this.myErrors.get(object);
        return errors == null ? null : errors.myErrors;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceProblemsHolder";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/validation/DataSourceProblemsCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Errors {
        private final DataSourceProblemsProvider myProvider;
        private final DataSourceProblemsHolder myDataSourceProblemsHolder;
        private Set<DataSourceProblem> myErrors;

        public Errors(@NotNull DataSourceProblemsProvider provider, @NotNull DataSourceProblemsHolder dataSourceProblemsHolder) {
            if (provider == null) {
                Errors.$$$reportNull$$$0(0);
            }
            if (dataSourceProblemsHolder == null) {
                Errors.$$$reportNull$$$0(1);
            }
            this.myProvider = provider;
            this.myDataSourceProblemsHolder = dataSourceProblemsHolder;
            this.update();
        }

        public void update() {
            this.setErrors(this.getErrors());
        }

        @Nullable
        private Set<DataSourceProblem> getErrors() {
            Set<DataSourceProblem> errors = this.myProvider.getErrors();
            return errors.isEmpty() ? null : errors;
        }

        public void setErrors(@Nullable Set<DataSourceProblem> errors) {
            if (this.myErrors != null) {
                for (DataSourceProblem error : this.myErrors) {
                    if (errors != null && errors.contains(error)) continue;
                    this.myDataSourceProblemsHolder.removeError(error);
                }
            }
            this.myErrors = errors;
            if (errors != null) {
                for (DataSourceProblem error : errors) {
                    this.myDataSourceProblemsHolder.addError(error);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSourceProblemsHolder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/validation/DataSourceProblemsCollector$Errors";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

