/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataHookUpBase;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridPagingModelImpl;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class DataBusGridDataHookUp
extends GridDataHookUpBase<DataConsumer.Row, DataConsumer.Column>
implements DataRequest.OwnerEx {
    protected final AtomicReference<DataRequest.TxMarker> myTxMarker;
    protected final DataBus.Consuming myMessageBus;
    protected final DataProducer myProducer;
    protected final DataAuditor.BusyCounter myBusyCounter;
    protected final DataGridListModel myModel;
    protected final GridPagingModelImpl.MultiPage<DataConsumer.Row, DataConsumer.Column> myPageModel;
    protected final DataBusLoader myLoader;
    protected final Map<DataRequest, GridRequestSource<DataConsumer.Row, DataConsumer.Column>> myRequestSourceMap;

    protected DataBusGridDataHookUp(@NotNull Project project, @NotNull DataBus.Consuming messageBus) {
        if (project == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(1);
        }
        super(project);
        this.myTxMarker = new AtomicReference<DataRequest.TxMarker>(DataRequest.AUTO_COMMIT);
        this.myRequestSourceMap = new WeakHashMap<DataRequest, GridRequestSource<DataConsumer.Row, DataConsumer.Column>>();
        this.myMessageBus = messageBus.filterFor(this);
        this.myProducer = messageBus.getDataProducer();
        this.myBusyCounter = new DataAuditor.BusyCounter(this);
        this.myModel = new DataGridListModel();
        this.myPageModel = new GridPagingModelImpl.MultiPage<DataConsumer.Row, DataConsumer.Column>(this.myModel);
        this.myLoader = this.createLoader();
        this.myMessageBus.addAuditor(this.createAuditor());
        this.myMessageBus.addConsumer(DataGridUtil.createEDTSafeWrapper(this.myLoader, this));
    }

    @NotNull
    public DataGridListModel getModel() {
        DataGridListModel dataGridListModel = this.myModel;
        if (dataGridListModel == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(2);
        }
        return dataGridListModel;
    }

    @Override
    @NotNull
    public GridPagingModel<DataConsumer.Row, DataConsumer.Column> getPageModel() {
        GridPagingModelImpl.MultiPage<DataConsumer.Row, DataConsumer.Column> multiPage = this.myPageModel;
        if (multiPage == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(3);
        }
        return multiPage;
    }

    @NotNull
    public DataBusLoader getLoader() {
        DataBusLoader dataBusLoader = this.myLoader;
        if (dataBusLoader == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(4);
        }
        return dataBusLoader;
    }

    @Override
    public int getBusyCount() {
        return this.myBusyCounter.getCount();
    }

    @Override
    public void cancelRequests() {
        this.getMessageBus().getDataProducer().processRequest(new DataRequest.Cancel(this));
    }

    @Override
    public DataBus.Consuming getMessageBus() {
        return this.myMessageBus;
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        DataRequest.TxMarker txMarker = this.myTxMarker.get();
        if (txMarker == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(5);
        }
        return txMarker;
    }

    public void setCurrentTx(@NotNull DataRequest.TxMarker txMarker) {
        if (txMarker == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(6);
        }
        this.myTxMarker.set(txMarker);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.setCurrentTx(autoCommit ? DataRequest.AUTO_COMMIT : DataRequest.START_NEW);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = StringUtil.notNullize((String)this.myLoader.getQueryText());
        if (string == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void dispose() {
    }

    public int getResultSetIndex() {
        return this.myLoader.getResultSetIndex();
    }

    @Nullable
    public String getQueryText() {
        return this.myLoader.getQueryText();
    }

    @Nullable
    public String getUnlimitedQueryText() {
        return this.getQueryText();
    }

    @NotNull
    protected DataBusLoader createLoader() {
        DataBusLoader dataBusLoader = new DataBusLoader();
        if (dataBusLoader == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(8);
        }
        return dataBusLoader;
    }

    @NotNull
    protected BusAuditor createAuditor() {
        BusAuditor busAuditor = new BusAuditor();
        if (busAuditor == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(9);
        }
        return busAuditor;
    }

    protected void processRequest(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull DataRequest request, ReloadPolicy reloadPolicy) {
        if (source == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(10);
        }
        if (request == null) {
            DataBusGridDataHookUp.$$$reportNull$$$0(11);
        }
        this.myRequestSourceMap.put(request, source);
        request.getPromise().processed(aVoid -> {
            boolean isDone;
            if (request == null) {
                DataBusGridDataHookUp.$$$reportNull$$$0(12);
            }
            if (source == null) {
                DataBusGridDataHookUp.$$$reportNull$$$0(13);
            }
            boolean bl = isDone = request.getPromise().getState() == Promise.State.FULFILLED;
            if (reloadPolicy == ReloadPolicy.WHEN_PROCESSED || reloadPolicy == ReloadPolicy.WHEN_DONE && isDone) {
                this.myLoader.reloadCurrentPage(source);
            } else {
                this.notifyRequestFinished(source, isDone);
            }
        });
        this.myProducer.processRequest(request);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataBusGridDataHookUp";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "txMarker";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataBusGridDataHookUp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPageModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoader";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTx";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoader";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createAuditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentTx";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processRequest";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processRequest$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class BusAuditor
    extends DataAuditor.Adapter {
        protected BusAuditor() {
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
            GridRequestSource<DataConsumer.Row, DataConsumer.Column> source;
            if (context == null) {
                BusAuditor.$$$reportNull$$$0(0);
            }
            if ((source = DataBusGridDataHookUp.this.myRequestSourceMap.get(context.request)) != null) {
                DataBusGridDataHookUp.this.notifyRequestError(source, message, th);
            }
        }

        @Override
        public void updateCountReceived(@NotNull DataRequest.Context context, int updateCount) {
            GridRequestSource<DataConsumer.Row, DataConsumer.Column> source;
            if (context == null) {
                BusAuditor.$$$reportNull$$$0(1);
            }
            if ((source = DataBusGridDataHookUp.this.myRequestSourceMap.get(context.request)) != null) {
                DataBusGridDataHookUp.this.notifyUpdateCountReceived(source, updateCount);
            }
        }

        @Override
        public void requestStarted(@NotNull DataRequest.Context context) {
            if (context == null) {
                BusAuditor.$$$reportNull$$$0(2);
            }
            DataBusGridDataHookUp.this.setCurrentTx(context.txMarker);
        }

        @Override
        public void txCompleted(@NotNull DataRequest.Context context, boolean committed) {
            if (context == null) {
                BusAuditor.$$$reportNull$$$0(3);
            }
            DataBusGridDataHookUp.this.setCurrentTx(DataRequest.START_NEW);
            if (!committed) {
                int startIdx = DataBusGridDataHookUp.this.myPageModel.getPageStart();
                int pageSize = DataBusGridDataHookUp.this.myPageModel.getPageSize();
                DataBusGridDataHookUp.this.myLoader.updateQueryText(DbImplUtil.isPageSizeUnlimited(pageSize) ? null : Integer.valueOf(startIdx + pageSize));
                String query = (String)ObjectUtils.assertNotNull((Object)DataBusGridDataHookUp.this.myLoader.getQueryText());
                int resultSetIdx = DataBusGridDataHookUp.this.myLoader.getResultSetIndex();
                DataRequest.Constraints constraints = DataRequest.newConstraints(startIdx, pageSize, resultSetIdx);
                DataRequest request = DataRequest.newRequest(DataBusGridDataHookUp.this, DataRequest.AUTO_COMMIT, query, constraints);
                request.getPromise().processed(aVoid -> DataBusGridDataHookUp.this.setCurrentTx(DataRequest.START_NEW));
                DataBusGridDataHookUp.this.myProducer.processRequest(request);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "context";
            objectArray2[1] = "com/intellij/database/datagrid/DataBusGridDataHookUp$BusAuditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCountReceived";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestStarted";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "txCompleted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static enum ReloadPolicy {
        WHEN_DONE,
        WHEN_PROCESSED,
        DO_NOT_RELOAD;

    }

    public class DataBusLoader
    implements DataConsumer,
    GridLoader<DataConsumer.Row, DataConsumer.Column> {
        private String myQueryText;
        private boolean myQueryInvalidated;
        private boolean myTotalRowCountInvalidated;
        private int myResultSetIndex;
        private int myRowsLoaded = -1;

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] columns2, int firstRowNum) {
            boolean sameQuery;
            if (context == null) {
                DataBusLoader.$$$reportNull$$$0(0);
            }
            if (!(sameQuery = Comparing.equal((String)this.myQueryText, (String)context.getQuery())) || this.myTotalRowCountInvalidated) {
                DataBusGridDataHookUp.this.myPageModel.setTotalRowCount(0, false);
            }
            DataBusGridDataHookUp.this.myPageModel.setPageStart(firstRowNum);
            DataBusGridDataHookUp.this.myPageModel.setPageEnd(firstRowNum - 1);
            this.myRowsLoaded = 0;
            DataBusGridDataHookUp.this.myModel.setUpdatingNow(true);
            this.myResultSetIndex = resultSetIndex;
            this.setQueryText(context.getQuery());
            DataBusGridDataHookUp.this.setCurrentTx(context.txMarker);
            columns2 = this.prepareColumns(columns2);
            boolean sameColumns = this.sameColumnsAsInModel(columns2);
            if (!sameQuery || !sameColumns) {
                DataBusGridDataHookUp.this.myModel.removeRows(0, DataBusGridDataHookUp.this.myModel.getRowCount());
                DataBusGridDataHookUp.this.myModel.setColumns(Arrays.asList(columns2));
            }
            this.validateRowCount();
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                DataBusLoader.$$$reportNull$$$0(1);
            }
            if (rows.isEmpty()) {
                return;
            }
            if (this.myRowsLoaded == 0) {
                DataBusGridDataHookUp.this.myPageModel.setPageStart(rows.get((int)0).rowNum);
            }
            DataBusGridDataHookUp.this.myPageModel.setPageEnd(rows.get((int)(rows.size() - 1)).rowNum);
            DataBusGridDataHookUp.this.myModel.setRows(this.myRowsLoaded, rows);
            this.myRowsLoaded += rows.size();
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                DataBusLoader.$$$reportNull$$$0(2);
            }
            if (this.myRowsLoaded >= 0 && this.myRowsLoaded < DataBusGridDataHookUp.this.myModel.getRowCount()) {
                int rowsToRemove = DataBusGridDataHookUp.this.myModel.getRowCount() - this.myRowsLoaded;
                DataBusGridDataHookUp.this.myModel.removeRows(DataBusGridDataHookUp.this.myModel.getRowCount() - rowsToRemove, rowsToRemove);
            }
            DataBusGridDataHookUp.this.myModel.setUpdatingNow(false);
            if (total > DataBusGridDataHookUp.this.myPageModel.getTotalRowCount() || DataBusGridDataHookUp.this.myPageModel.getPageEnd() == total) {
                DataBusGridDataHookUp.this.myPageModel.setTotalRowCount(total, DataBusGridDataHookUp.this.myPageModel.getPageEnd() >= total);
            }
        }

        @Override
        public void reloadCurrentPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(3);
            }
            this.load(source, DataBusGridDataHookUp.this.myPageModel.getPageStart(), true);
        }

        @Override
        public void loadNextPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(4);
            }
            this.load(source, DataBusGridDataHookUp.this.myPageModel.getPageEnd() + 1, true);
        }

        @Override
        public void loadPreviousPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(5);
            }
            this.load(source, Math.max(1, DataBusGridDataHookUp.this.myPageModel.getPageStart()), false);
        }

        @Override
        public void loadLastPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            int pageSize;
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(6);
            }
            this.load(source, -((pageSize = DataBusGridDataHookUp.this.myPageModel.getPageSize()) > 0 ? pageSize : 100), false, true);
        }

        @Override
        public void loadFirstPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(7);
            }
            this.load(source, 1, true);
        }

        @Override
        public void load(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int rowDataIdx) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(8);
            }
            this.load(source, rowDataIdx, true);
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(9);
            }
            DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
        }

        @Override
        public void applyFilter(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(10);
            }
            DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
        }

        @Nullable
        public String getQueryText() {
            return this.myQueryText;
        }

        public int getResultSetIndex() {
            return this.myResultSetIndex;
        }

        public void invalidateQuery() {
            this.myQueryInvalidated = true;
        }

        @NotNull
        protected Promise<Void> load(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int startIndex, boolean forward) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(11);
            }
            Promise<Void> promise = this.load(source, startIndex, true, forward);
            if (promise == null) {
                DataBusLoader.$$$reportNull$$$0(12);
            }
            return promise;
        }

        @NotNull
        protected Promise<Void> load(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int startIndex, boolean limit, boolean forward) {
            if (source == null) {
                DataBusLoader.$$$reportNull$$$0(13);
            }
            this.updateQueryText(!limit || DbImplUtil.isPageSizeUnlimited(DataBusGridDataHookUp.this.myPageModel.getPageSize()) ? null : Integer.valueOf(startIndex + DataBusGridDataHookUp.this.myPageModel.getPageSize()));
            if (this.myQueryText == null) {
                DataBusGridDataHookUp.this.notifyRequestFinished(source, false);
                Promise promise = Promises.rejectedPromise();
                if (promise == null) {
                    DataBusLoader.$$$reportNull$$$0(14);
                }
                return promise;
            }
            DataBusGridDataHookUp owner = DataBusGridDataHookUp.this;
            DataRequest r = DataRequest.newRequest(owner, this.myQueryText, startIndex, forward, DataBusGridDataHookUp.this.myPageModel.getPageSize(), this.myResultSetIndex);
            DataBusGridDataHookUp.this.processRequest(source, r, ReloadPolicy.DO_NOT_RELOAD);
            AsyncPromise<Void> asyncPromise = r.getPromise();
            if (asyncPromise == null) {
                DataBusLoader.$$$reportNull$$$0(15);
            }
            return asyncPromise;
        }

        protected boolean canUpdateQueryText() {
            return false;
        }

        protected final void updateQueryText(@Nullable Integer limit) {
            if (this.canUpdateQueryText()) {
                this.setQueryText(this.createQueryText(limit));
            }
        }

        @Nullable
        protected String createQueryText(@Nullable Integer limit) {
            return null;
        }

        protected DataConsumer.Column[] prepareColumns(@NotNull DataConsumer.Column[] columns2) {
            if (columns2 == null) {
                DataBusLoader.$$$reportNull$$$0(16);
            }
            return columns2;
        }

        protected void setQueryText(String query) {
            this.myQueryText = query;
            this.validateQuery();
        }

        protected void invalidateRowCount() {
            this.myTotalRowCountInvalidated = true;
        }

        protected boolean isQueryInvalidated() {
            return this.myQueryInvalidated;
        }

        protected boolean sameColumnsAsInModel(DataConsumer.Column[] columns2) {
            if (columns2.length != DataBusGridDataHookUp.this.myModel.getColumnCount()) {
                return false;
            }
            for (int i2 = 0; i2 < columns2.length; ++i2) {
                if (Comparing.equal((Object)columns2[i2], (Object)DataBusGridDataHookUp.this.myModel.getColumn(ModelIndex.forColumn(DataBusGridDataHookUp.this.myModel, i2)))) continue;
                return false;
            }
            return true;
        }

        private void validateQuery() {
            this.myQueryInvalidated = false;
        }

        private void validateRowCount() {
            this.myTotalRowCountInvalidated = false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 12: 
                case 14: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 12: 
                case 14: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 12: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DataBusGridDataHookUp$DataBusLoader";
                    break;
                }
                case 12: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "load";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setColumns";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addRows";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "afterLastRowAdded";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "reloadCurrentPage";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "loadNextPage";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "loadPreviousPage";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "loadLastPage";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "loadFirstPage";
                    break;
                }
                case 8: 
                case 11: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "load";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "updateTotalRowCount";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFilter";
                    break;
                }
                case 12: 
                case 14: 
                case 15: {
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareColumns";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 12: 
                case 14: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

