/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.mutating.DmlMutationContext;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.model.DasTable;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.vfs.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public abstract class DataRequest {
    public static final TxMarker NONE = DataRequest.newTxMarker("NONE", null);
    public static final TxMarker AUTO_COMMIT = DataRequest.newTxMarker("AUTO_COMMIT", null);
    public static final TxMarker START_NEW = DataRequest.newTxMarker("START_NEW", null);
    public final Owner owner;
    public final TxMarker txMarker;
    private final AsyncPromise<Void> promise;

    @NotNull
    public AsyncPromise<Void> getPromise() {
        AsyncPromise<Void> asyncPromise = this.promise;
        if (asyncPromise == null) {
            DataRequest.$$$reportNull$$$0(0);
        }
        return asyncPromise;
    }

    @NotNull
    public static Owner newOwner() {
        final String title = "Owner:" + ((Class)ObjectUtils.assertNotNull((Object)ReflectionUtil.findCallerClass((int)2))).getSimpleName();
        Owner owner = new Owner(){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = title;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest$1", "getDisplayName"));
            }
        };
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(1);
        }
        return owner;
    }

    @NotNull
    public static OwnerEx newOwnerEx(final @NotNull Project project) {
        if (project == null) {
            DataRequest.$$$reportNull$$$0(2);
        }
        final String title = "OwnerEx:" + ((Class)ObjectUtils.assertNotNull((Object)ReflectionUtil.findCallerClass((int)2))).getSimpleName();
        OwnerEx ownerEx = new OwnerEx(){
            final DataBus.Consuming messageBus;
            {
                this.messageBus = SimpleRequestBroker.newInstance(project, title).filterFor(this);
            }

            @Override
            public DataBus.Consuming getMessageBus() {
                return this.messageBus;
            }

            @Override
            @NotNull
            public TxMarker getCurrentTx() {
                TxMarker txMarker = NONE;
                if (txMarker == null) {
                    2.$$$reportNull$$$0(0);
                }
                return txMarker;
            }

            @Override
            public void setAutoCommit(boolean autoCommit) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public String getDisplayName() {
                String string = title;
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void dispose() {
            }

            public String toString() {
                return this.getDisplayName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/database/datagrid/DataRequest$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCurrentTx";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (ownerEx == null) {
            DataRequest.$$$reportNull$$$0(3);
        }
        return ownerEx;
    }

    @NotNull
    public static TxMarker getInitialTxMarker(boolean autoCommit) {
        TxMarker txMarker = autoCommit ? AUTO_COMMIT : START_NEW;
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(4);
        }
        return txMarker;
    }

    @NotNull
    public static TxMarker newTxMarker(final @NotNull String title, final @Nullable Owner owner) {
        if (title == null) {
            DataRequest.$$$reportNull$$$0(5);
        }
        TxMarker txMarker = new TxMarker(){

            @Override
            public Owner getOwner() {
                return owner;
            }

            @Override
            @NotNull
            public String toString() {
                String string = title;
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest$3", "toString"));
            }
        };
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(6);
        }
        return txMarker;
    }

    @NotNull
    public static DataRequest newRequest(@NotNull Owner owner, @NotNull TxMarker marker, @NotNull String query) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(7);
        }
        if (marker == null) {
            DataRequest.$$$reportNull$$$0(8);
        }
        if (query == null) {
            DataRequest.$$$reportNull$$$0(9);
        }
        QueryRequest queryRequest = new QueryRequest(owner, marker, query, DataRequest.newConstraints(0, -1, -1), null);
        if (queryRequest == null) {
            DataRequest.$$$reportNull$$$0(10);
        }
        return queryRequest;
    }

    @NotNull
    public static DataRequest newRequest(@NotNull OwnerEx owner, @NotNull String query) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(11);
        }
        if (query == null) {
            DataRequest.$$$reportNull$$$0(12);
        }
        QueryRequest queryRequest = new QueryRequest(owner, owner.getCurrentTx(), query, DataRequest.newConstraints(), null);
        if (queryRequest == null) {
            DataRequest.$$$reportNull$$$0(13);
        }
        return queryRequest;
    }

    @NotNull
    public static DataRequest newRequest(@NotNull OwnerEx owner, @NotNull String query, int start, boolean forward, int pageSize, int resultSetIndex) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(14);
        }
        if (query == null) {
            DataRequest.$$$reportNull$$$0(15);
        }
        QueryRequest queryRequest = new QueryRequest(owner, owner.getCurrentTx(), query, DataRequest.newConstraints(start, forward, pageSize, resultSetIndex), null);
        if (queryRequest == null) {
            DataRequest.$$$reportNull$$$0(16);
        }
        return queryRequest;
    }

    @NotNull
    public static DataRequest newRequest(@NotNull Owner owner, @NotNull TxMarker txMarker, @NotNull String query, @NotNull Constraints constraints) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(17);
        }
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(18);
        }
        if (query == null) {
            DataRequest.$$$reportNull$$$0(19);
        }
        if (constraints == null) {
            DataRequest.$$$reportNull$$$0(20);
        }
        QueryRequest queryRequest = new QueryRequest(owner, txMarker, query, constraints, null);
        if (queryRequest == null) {
            DataRequest.$$$reportNull$$$0(21);
        }
        return queryRequest;
    }

    @NotNull
    public static DmlRequest newInsertRequest(@NotNull OwnerEx owner, @NotNull DmlMutationContext context) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(22);
        }
        if (context == null) {
            DataRequest.$$$reportNull$$$0(23);
        }
        InsertRequest insertRequest = new InsertRequest(owner, owner.getCurrentTx(), context);
        if (insertRequest == null) {
            DataRequest.$$$reportNull$$$0(24);
        }
        return insertRequest;
    }

    @NotNull
    public static DmlRequest newUpdateRequest(@NotNull OwnerEx owner, @NotNull DmlMutationContext context) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(25);
        }
        if (context == null) {
            DataRequest.$$$reportNull$$$0(26);
        }
        UpdateRequest updateRequest = new UpdateRequest(owner, owner.getCurrentTx(), context);
        if (updateRequest == null) {
            DataRequest.$$$reportNull$$$0(27);
        }
        return updateRequest;
    }

    @NotNull
    public static DmlRequest newDeleteRequest(@NotNull OwnerEx owner, @NotNull DmlMutationContext context) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(28);
        }
        if (context == null) {
            DataRequest.$$$reportNull$$$0(29);
        }
        DeleteRequest deleteRequest = new DeleteRequest(owner, owner.getCurrentTx(), context);
        if (deleteRequest == null) {
            DataRequest.$$$reportNull$$$0(30);
        }
        return deleteRequest;
    }

    public static DataRequest newCompositeRequest(@NotNull OwnerEx owner, @NotNull List<DmlRequest> requests) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(31);
        }
        if (requests == null) {
            DataRequest.$$$reportNull$$$0(32);
        }
        return new CompositeRequest(owner, owner.getCurrentTx(), requests);
    }

    @NotNull
    public static DataRequest newTxCommit(@NotNull OwnerEx owner) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(33);
        }
        TxRequest txRequest = new TxRequest(owner, owner.getCurrentTx(), TxCommand.COMMIT);
        if (txRequest == null) {
            DataRequest.$$$reportNull$$$0(34);
        }
        return txRequest;
    }

    @NotNull
    public static DataRequest newTxRollback(@NotNull OwnerEx owner) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(35);
        }
        TxRequest txRequest = new TxRequest(owner, owner.getCurrentTx(), TxCommand.ROLLBACK);
        if (txRequest == null) {
            DataRequest.$$$reportNull$$$0(36);
        }
        return txRequest;
    }

    @NotNull
    public static DataRequest newTxRollback(@NotNull TxMarker txMarker) {
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(37);
        }
        TxRequest txRequest = new TxRequest(txMarker.getOwner(), txMarker, TxCommand.ROLLBACK);
        if (txRequest == null) {
            DataRequest.$$$reportNull$$$0(38);
        }
        return txRequest;
    }

    @NotNull
    public static DataRequest newSchemaSwitchRequest(@NotNull OwnerEx owner, @NotNull SearchPath schema, boolean forced) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(39);
        }
        if (schema == null) {
            DataRequest.$$$reportNull$$$0(40);
        }
        SchemaSwitchRequest schemaSwitchRequest = new SchemaSwitchRequest(owner, schema, forced);
        if (schemaSwitchRequest == null) {
            DataRequest.$$$reportNull$$$0(41);
        }
        return schemaSwitchRequest;
    }

    @NotNull
    public static Context newContext(@NotNull OwnerEx owner, @Nullable DataProducer producer, String query) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(42);
        }
        Context context = new Context(producer, DataRequest.newRequest(owner, query), NONE){

            @Override
            public void reportException(@NotNull Throwable th, Object parameter) {
                if (th == null) {
                    4.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "th", "com/intellij/database/datagrid/DataRequest$4", "reportException"));
            }
        };
        if (context == null) {
            DataRequest.$$$reportNull$$$0(43);
        }
        return context;
    }

    public static Constraints newConstraints() {
        return DataRequest.newConstraints(1, DatabaseSettings.getSettings().getPageSize(), 0);
    }

    public static Constraints newConstraints(int offset, int limit, int resultSetIndex) {
        return new Constraints(offset, limit, true, "", resultSetIndex, Collections.emptyList());
    }

    public static Constraints newConstraints(int offset, boolean forward, int limit, int resultSetIndex) {
        return new Constraints(offset, limit, forward, "", resultSetIndex, Collections.emptyList());
    }

    protected DataRequest(@NotNull Owner owner, @NotNull TxMarker txMarker) {
        if (owner == null) {
            DataRequest.$$$reportNull$$$0(44);
        }
        if (txMarker == null) {
            DataRequest.$$$reportNull$$$0(45);
        }
        this.promise = new AsyncPromise();
        this.owner = owner;
        this.txMarker = txMarker;
    }

    public void accept(Visitor visitor) {
        visitor.visitRequest(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataRequest";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 18: 
            case 37: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "txMarker";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPromise";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newOwner";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataRequest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newOwnerEx";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialTxMarker";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newTxMarker";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "newRequest";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "newInsertRequest";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "newUpdateRequest";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "newDeleteRequest";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "newTxCommit";
                break;
            }
            case 36: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "newTxRollback";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "newSchemaSwitchRequest";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "newContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "newOwnerEx";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newTxMarker";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "newRequest";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "newInsertRequest";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "newUpdateRequest";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "newDeleteRequest";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "newCompositeRequest";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "newTxCommit";
                break;
            }
            case 35: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "newTxRollback";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "newSchemaSwitchRequest";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "newContext";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Visitor {
        public void visitRequest(DataRequest r) {
        }

        public void visitCancel(Cancel r) {
            this.visitRequest(r);
        }

        public void visitTx(TxRequest r) {
            this.visitRequest(r);
        }

        public void visitDml(DmlRequest r) {
            this.visitRequest(r);
        }

        public void visitInsert(InsertRequest r) {
            this.visitDml(r);
        }

        public void visitUpdate(UpdateRequest r) {
            this.visitDml(r);
        }

        public void visitDelete(DeleteRequest r) {
            this.visitDml(r);
        }

        public void visitComposite(CompositeRequest r) {
            this.visitRequest(r);
        }

        public void visitRaw(RawRequest r) {
            this.visitRequest(r);
        }

        public void visitQuery(QueryRequest r) {
            this.visitRequest(r);
        }

        public void visitSchemaSwitch(SchemaSwitchRequest r) {
            this.visitRequest(r);
        }
    }

    public static class Constraints {
        public final int offset;
        public final int limit;
        public final String filter;
        public final int resultSetNumber;
        public final List<RowSortOrder<String>> orders;

        public Constraints(int offset, int limit, boolean forward, String filter, int resultSetNumber, List<RowSortOrder<String>> orders) {
            this.offset = forward ? (offset == 0 ? 1 : offset) : Math.max(offset - limit, 0);
            this.limit = limit;
            this.filter = filter;
            this.resultSetNumber = resultSetNumber;
            this.orders = orders;
        }
    }

    public static abstract class TxContext
    extends Context {
        public volatile int isolation;

        public TxContext(@Nullable DataProducer producer, @NotNull DataRequest request, @NotNull TxMarker txMarker) {
            if (request == null) {
                TxContext.$$$reportNull$$$0(0);
            }
            if (txMarker == null) {
                TxContext.$$$reportNull$$$0(1);
            }
            super(producer, request, txMarker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "txMarker";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$TxContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Context {
        public final DataProducer producer;
        public final DataRequest request;
        public final TxMarker txMarker;
        public final AtomicReference<String> query;

        public Context(@Nullable DataProducer producer, @NotNull DataRequest request, @NotNull TxMarker txMarker) {
            if (request == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (txMarker == null) {
                Context.$$$reportNull$$$0(1);
            }
            this.query = new AtomicReference();
            this.producer = producer;
            this.request = request;
            this.txMarker = txMarker;
        }

        @NotNull
        public String getQuery() {
            String string = this.request instanceof ConditionQueryRequest || !(this.request instanceof QueryRequest) ? StringUtil.notNullize((String)this.query.get()) : ((QueryRequest)this.request).query;
            if (string == null) {
                Context.$$$reportNull$$$0(2);
            }
            return string;
        }

        public abstract void reportException(@NotNull Throwable var1, @Nullable Object var2);

        @Nullable
        public SearchPath getSearchPath() {
            return null;
        }

        public String toString() {
            return this.request + " in " + this.txMarker;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "txMarker";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DataRequest$Context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DataRequest$Context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface TxMarker {
        @Nullable
        public Owner getOwner();

        @NotNull
        public String toString();
    }

    public static interface TxIsolationOwner
    extends OwnerEx {
        public int getTxIsolation();

        public void setTxIsolation(int var1);
    }

    public static interface OwnerEx
    extends Owner,
    Disposable {
        public DataBus.Consuming getMessageBus();

        @NotNull
        public TxMarker getCurrentTx();

        public void setAutoCommit(boolean var1);
    }

    public static interface Owner {
        @NotNull
        public String getDisplayName();
    }

    public static abstract class RawQueryRequest
    extends IsolatedQueryRequest {
        protected RawQueryRequest(Owner owner, TxMarker txMarker, String query, Constraints constraints) {
            super(owner, txMarker, query, constraints, null);
        }

        @Override
        public void setColumns(@NotNull Context context, int resultSetIndex, DataConsumer.Column[] infos, int firstRowNum) {
            if (context == null) {
                RawQueryRequest.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void afterLastRowAdded(@NotNull Context context, int total) {
            if (context == null) {
                RawQueryRequest.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "context";
            objectArray2[1] = "com/intellij/database/datagrid/DataRequest$RawQueryRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class IsolatedQueryRequest
    extends QueryRequest
    implements DataConsumer {
        protected IsolatedQueryRequest(@NotNull Owner owner, @NotNull TxMarker marker, @NotNull String query, @NotNull Constraints constraints, @Nullable Object params2) {
            if (owner == null) {
                IsolatedQueryRequest.$$$reportNull$$$0(0);
            }
            if (marker == null) {
                IsolatedQueryRequest.$$$reportNull$$$0(1);
            }
            if (query == null) {
                IsolatedQueryRequest.$$$reportNull$$$0(2);
            }
            if (constraints == null) {
                IsolatedQueryRequest.$$$reportNull$$$0(3);
            }
            super(owner, marker, query, constraints, params2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "marker";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "query";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "constraints";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$IsolatedQueryRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UpdateRequest
    extends DmlRequest {
        UpdateRequest(Owner owner, TxMarker marker, DmlMutationContext context) {
            super(owner, marker, context);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitUpdate(this);
        }
    }

    public static class CompositeRequest
    extends DataRequest {
        public final List<DmlRequest> requests;

        CompositeRequest(Owner owner, TxMarker marker, List<DmlRequest> requests) {
            super(owner, marker);
            this.requests = ContainerUtil.immutableList((List)ContainerUtil.newArrayList(requests));
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitComposite(this);
        }
    }

    public static class DeleteRequest
    extends DmlRequest {
        DeleteRequest(Owner owner, TxMarker marker, DmlMutationContext context) {
            super(owner, marker, context);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitDelete(this);
        }
    }

    public static class InsertRequest
    extends DmlRequest {
        InsertRequest(Owner owner, TxMarker marker, DmlMutationContext context) {
            super(owner, marker, context);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitInsert(this);
        }
    }

    public static abstract class DmlRequest
    extends DataRequest {
        public final DmlMutationContext context;

        DmlRequest(Owner owner, TxMarker marker, DmlMutationContext context) {
            super(owner, marker);
            this.context = context;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitDml(this);
        }
    }

    public static class QueryRequest
    extends DataRequest {
        public final String query;
        public final Constraints constraints;
        public final Object params;

        protected QueryRequest(@NotNull Owner owner, @NotNull TxMarker marker, @NotNull String query, @NotNull Constraints constraints, @Nullable Object params2) {
            if (owner == null) {
                QueryRequest.$$$reportNull$$$0(0);
            }
            if (marker == null) {
                QueryRequest.$$$reportNull$$$0(1);
            }
            if (query == null) {
                QueryRequest.$$$reportNull$$$0(2);
            }
            if (constraints == null) {
                QueryRequest.$$$reportNull$$$0(3);
            }
            super(owner, marker);
            this.query = query;
            this.constraints = constraints;
            this.params = params2;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitQuery(this);
        }

        public String toString() {
            return this.query + "@" + this.owner.getDisplayName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "marker";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "query";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "constraints";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$QueryRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ConditionQueryRequest
    extends RawQueryRequest {
        public final RowQueryData rowQueryData;
        public final DasTable table;

        protected ConditionQueryRequest(@NotNull Owner owner, @NotNull TxMarker txMarker, @NotNull RowQueryData rowQueryData, @NotNull Constraints constraints, @Nullable DasTable table) {
            if (owner == null) {
                ConditionQueryRequest.$$$reportNull$$$0(0);
            }
            if (txMarker == null) {
                ConditionQueryRequest.$$$reportNull$$$0(1);
            }
            if (rowQueryData == null) {
                ConditionQueryRequest.$$$reportNull$$$0(2);
            }
            if (constraints == null) {
                ConditionQueryRequest.$$$reportNull$$$0(3);
            }
            super(owner, txMarker, rowQueryData.getSql(), constraints);
            this.rowQueryData = rowQueryData;
            this.table = table;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "txMarker";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rowQueryData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "constraints";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$ConditionQueryRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class RawRequest
    extends DataRequest {
        protected RawRequest(OwnerEx owner) {
            super(owner, owner.getCurrentTx());
        }

        public abstract void processRaw(Context var1, DatabaseConnection var2) throws Exception;

        @Override
        public void accept(Visitor visitor) {
            visitor.visitRaw(this);
        }
    }

    public static class SchemaSwitchRequest
    extends DataRequest {
        public final SearchPath path;
        public final boolean forced;

        protected SchemaSwitchRequest(@NotNull OwnerEx owner, @NotNull SearchPath path, boolean forced) {
            if (owner == null) {
                SchemaSwitchRequest.$$$reportNull$$$0(0);
            }
            if (path == null) {
                SchemaSwitchRequest.$$$reportNull$$$0(1);
            }
            super(owner, owner.getCurrentTx());
            this.path = path;
            this.forced = forced;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitSchemaSwitch(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataRequest$SchemaSwitchRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Cancel
    extends DataRequest {
        public Cancel(@NotNull OwnerEx owner) {
            if (owner == null) {
                Cancel.$$$reportNull$$$0(0);
            }
            super(owner, owner.getCurrentTx());
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitCancel(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest$Cancel", "<init>"));
        }
    }

    public static class TxRequest
    extends DataRequest {
        public final TxCommand command;

        TxRequest(Owner owner, TxMarker marker, TxCommand command) {
            super(owner, marker);
            this.command = command;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitTx(this);
        }
    }

    public static enum TxCommand {
        COMMIT,
        ROLLBACK;

    }
}

