/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.editor.GotoRowAction;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridPositionWidget
implements StatusBarWidget,
Consumer<MouseEvent>,
StatusBarWidget.TextPresentation,
StatusBarWidget.Multiframe,
FileEditorManagerListener {
    public static final Topic<Listener> TOPIC = new Topic("Grid Position", Listener.class);
    private final Project myProject;
    private DataGrid myGrid;
    private GotoRowAction.Counter myCounter;

    public GridPositionWidget(@NotNull Project project) {
        if (project == null) {
            GridPositionWidget.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public String ID() {
        if ("GridPosition" == null) {
            GridPositionWidget.$$$reportNull$$$0(1);
        }
        return "GridPosition";
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            GridPositionWidget.$$$reportNull$$$0(2);
        }
        return this;
    }

    public void install(final @NotNull StatusBar statusBar) {
        if (statusBar == null) {
            GridPositionWidget.$$$reportNull$$$0(3);
        }
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(TOPIC, (Object)new Listener(){

            @Override
            public void changed(@NotNull DataGrid grid) {
                if (grid == null) {
                    1.$$$reportNull$$$0(0);
                }
                GridPositionWidget.this.set(grid, statusBar);
            }

            @Override
            public void closed() {
                GridPositionWidget.this.set(null, statusBar);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/GridPositionWidget$1", "changed"));
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                DataGrid grid = GridPositionWidget.this.getDataGrid(statusBar);
                GridPositionWidget.this.set(grid, statusBar);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/datagrid/GridPositionWidget$2", "selectionChanged"));
            }
        });
    }

    public void dispose() {
    }

    public void consume(MouseEvent event) {
        if (!this.isReady()) {
            return;
        }
        GotoRowAction.showGoToDialog(this.myGrid);
    }

    @Nullable
    public String getTooltipText() {
        return !this.isReady() ? null : UIBundle.message((String)"go.to.line.command.double.click", (Object[])new Object[0]);
    }

    @Nullable
    public Consumer<MouseEvent> getClickConsumer() {
        return this;
    }

    @NotNull
    public String getText() {
        if (this.myGrid == null) {
            if ("" == null) {
                GridPositionWidget.$$$reportNull$$$0(4);
            }
            return "";
        }
        StringBuilder sb = new StringBuilder();
        SelectionModel model = this.myGrid.getSelectionModel();
        int cellCount = model.getSelectedColumnCount() * model.getSelectedRowCount();
        if (cellCount == 0) {
            if ("" == null) {
                GridPositionWidget.$$$reportNull$$$0(5);
            }
            return "";
        }
        boolean editing = this.myGrid.isEditing();
        if (cellCount > 1) {
            sb.append(cellCount).append(" ").append(StringUtil.pluralize((String)"cell", (int)cellCount));
            if (editing) {
                String string = sb.toString();
                if (string == null) {
                    GridPositionWidget.$$$reportNull$$$0(6);
                }
                return string;
            }
            sb.append("     ");
        }
        if (editing) {
            if ("" == null) {
                GridPositionWidget.$$$reportNull$$$0(7);
            }
            return "";
        }
        int minRow = this.myCounter.verticalUnit(this.myGrid);
        int minColumn = this.myCounter.horizontalUnit(this.myGrid);
        if (minColumn == -1 || minRow == -1) {
            String string = sb.toString();
            if (string == null) {
                GridPositionWidget.$$$reportNull$$$0(8);
            }
            return string;
        }
        sb.append(minRow + 1).append(":").append(minColumn + 1);
        String string = sb.toString();
        if (string == null) {
            GridPositionWidget.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getMaxPossibleText() {
        if ("0000000000000" == null) {
            GridPositionWidget.$$$reportNull$$$0(10);
        }
        return "0000000000000";
    }

    public float getAlignment() {
        return 1.0f;
    }

    public StatusBarWidget copy() {
        return new GridPositionWidget(this.myProject);
    }

    @Nullable
    private DataGrid getDataGrid(@NotNull StatusBar bar) {
        if (bar == null) {
            GridPositionWidget.$$$reportNull$$$0(11);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor((Project)this.myProject, (StatusBar)bar);
        return fileEditor instanceof TableEditorBase ? ((TableEditorBase)fileEditor).getDataGrid() : null;
    }

    private boolean isReady() {
        return this.myGrid != null && !this.myGrid.isEditing() && this.myGrid.getVisibleRowsCount() * this.myGrid.getVisibleColumns().size() > 0;
    }

    private void set(@Nullable DataGrid grid, @NotNull StatusBar statusBar) {
        if (statusBar == null) {
            GridPositionWidget.$$$reportNull$$$0(12);
        }
        if (grid != null && !this.isOurGrid(grid, statusBar)) {
            return;
        }
        this.myGrid = grid;
        this.myCounter = grid == null ? null : GotoRowAction.Counter.get(grid);
        statusBar.updateWidget(this.ID());
    }

    private boolean isOurGrid(@NotNull DataGrid grid, @NotNull StatusBar bar) {
        if (grid == null) {
            GridPositionWidget.$$$reportNull$$$0(13);
        }
        if (bar == null) {
            GridPositionWidget.$$$reportNull$$$0(14);
        }
        return GridPositionWidget.isOurComponent(grid.getComponent(), this.myProject, bar);
    }

    private static boolean isOurComponent(@NotNull JComponent component, @NotNull Project project, @NotNull StatusBar bar) {
        if (component == null) {
            GridPositionWidget.$$$reportNull$$$0(15);
        }
        if (project == null) {
            GridPositionWidget.$$$reportNull$$$0(16);
        }
        if (bar == null) {
            GridPositionWidget.$$$reportNull$$$0(17);
        }
        return WindowManager.getInstance().getStatusBar((Component)component, project) == bar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridPositionWidget";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bar";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridPositionWidget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxPossibleText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDataGrid";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isOurGrid";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isOurComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Installer
    implements StartupActivity {
        Installer() {
        }

        public void runActivity(@NotNull Project project) {
            StatusBar bar;
            if (project == null) {
                Installer.$$$reportNull$$$0(0);
            }
            if ((bar = WindowManager.getInstance().getStatusBar(project)) != null) {
                bar.addWidget((StatusBarWidget)new GridPositionWidget(project), "before Position", (Disposable)project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/GridPositionWidget$Installer", "runActivity"));
        }
    }

    public static interface Listener {
        public void changed(@NotNull DataGrid var1);

        public void closed();
    }
}

