/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.datagrid.CsvLexer;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.dbimport.OffsetBatchRecords;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamCsvFormatParser {
    private static final int ERROR_TEXT_SIZE = 15;
    private static final int NOT_IMPORTANT = -1;
    private final int myMaxChars;
    private final CsvFormat myDataFormat;
    private final CsvLexer myLexer;
    private List<ErrorRecord> myErrors;
    private Token[] myHeader;

    public StreamCsvFormatParser(@NotNull CsvFormat format, int maxChars) {
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(0);
        }
        this.myDataFormat = format;
        this.myMaxChars = maxChars;
        this.myLexer = new CsvLexer();
        this.myLexer.setCsvFormat((CsvRecordFormat)ObjectUtils.chooseNotNull((Object)format.headerRecord, (Object)format.dataRecord));
    }

    @Nullable
    public CsvParserResult parse(@NotNull Reader reader) throws IOException {
        long startCharacters;
        if (reader == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(1);
        }
        if ((startCharacters = this.myLexer.getCharacters()) != 0L && this.myHeader == null) {
            return null;
        }
        this.myErrors = ContainerUtil.newArrayList();
        ArrayList result2 = ContainerUtil.newArrayList();
        if (!this.parseHeader(reader, startCharacters)) {
            if (this.myErrors.isEmpty()) {
                this.myErrors.add(new MyRecord());
            }
            return new CsvParserResult(null, ContainerUtil.emptyList(), this.myErrors, this.myLexer.getCharacters() - startCharacters);
        }
        if (startCharacters == 0L && this.myDataFormat.headerRecord == null) {
            result2.add(this.myHeader);
        }
        this.parseRecords(reader, result2, startCharacters);
        return !result2.isEmpty() || !this.myErrors.isEmpty() ? new CsvParserResult(this.myHeader, result2, this.myErrors, this.myLexer.getCharacters() - startCharacters) : null;
    }

    private void parseRecords(@NotNull Reader reader, @NotNull List<Token[]> result2, long startCharacters) throws IOException {
        Token[] e;
        int count;
        if (reader == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(3);
        }
        int n = count = this.myDataFormat.rowNumbers ? this.myHeader.length + 1 : this.myHeader.length;
        while (CsvLexer.isReady(reader) && (this.myLexer.getCharacters() - startCharacters < (long)this.myMaxChars || result2.isEmpty()) && (e = this.getRecord(reader, this.myDataFormat.dataRecord, count)) != null) {
            result2.add(e);
        }
    }

    private boolean parseHeader(@NotNull Reader reader, long startCharacters) throws IOException {
        CsvRecordFormat headerFormat;
        if (reader == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(4);
        }
        if (this.myHeader != null) {
            return true;
        }
        CsvRecordFormat csvRecordFormat = headerFormat = this.myDataFormat.headerRecord == null ? this.myDataFormat.dataRecord : this.myDataFormat.headerRecord;
        while (this.myLexer.getCharacters() - startCharacters < (long)this.myMaxChars && CsvLexer.isReady(reader) && this.myHeader == null) {
            this.myHeader = this.getRecord(reader, headerFormat, -1);
        }
        this.myLexer.setCsvFormat(this.myDataFormat.dataRecord);
        return this.myHeader != null;
    }

    @Nullable
    private Token[] getRecord(@NotNull Reader reader, @NotNull CsvRecordFormat format, int count) throws IOException {
        if (reader == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(5);
        }
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(6);
        }
        List<Token> record = null;
        while (CsvLexer.isReady(reader) && record == null) {
            try {
                record = this.parseRecord(reader, this.myLexer, format, count);
            }
            catch (CsvParserException e) {
                this.myErrors.add((ErrorRecord)new OffsetBatchRecords.OffsetRecord((Exception)e, e.getLine(), e.getOffset()));
            }
        }
        return record == null ? null : (Token[])ContainerUtil.toArray(record, Token[]::new);
    }

    @NotNull
    private List<Token> parseRecord(@NotNull Reader reader, @NotNull CsvLexer lexer, @NotNull CsvRecordFormat format, int count) throws IOException, CsvParserException {
        if (reader == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(7);
        }
        if (lexer == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(8);
        }
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(9);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        ParserChain chain = new ParserChain(format).advance().maybe(CsvLexer.TokenType.PREFIX).stopIfNull().member(this.valuesChain(format, lexer, result2, count)).member((r, l) -> {
            if (format == null) {
                StreamCsvFormatParser.$$$reportNull$$$0(32);
            }
            StreamCsvFormatParser.checkUnexpectedCount(format, result2, r, l, count);
        }).maybe(CsvLexer.TokenType.SUFFIX).typesOrNull(CsvLexer.TokenType.RECORD_SEPARATOR);
        chain.keep(reader, lexer);
        List list = result2.isEmpty() || !this.myDataFormat.rowNumbers ? result2 : ContainerUtil.subList((List)result2, (int)1);
        if (list == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private ParserChain valuesChain(@NotNull CsvRecordFormat format, @NotNull CsvLexer lexer, @NotNull List<Token> result2, int count) throws CsvParserException, IOException {
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(11);
        }
        if (lexer == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(12);
        }
        if (result2 == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(13);
        }
        ParserChain valueChain = new ParserChain(format);
        ParserChain chain = new ParserChain(format).memberWhile((Condition<CsvLexer>)((Condition)StreamCsvFormatParser::shouldReadValue), valueChain);
        ParserChain countChain = new ParserChain(format).maybe(CsvLexer.TokenType.SUFFIX).typesOrNull(CsvLexer.TokenType.RECORD_SEPARATOR);
        valueChain.types(CsvLexer.TokenType.VALUE, CsvLexer.TokenType.QUOTED_VALUE).member((r, l) -> {
            if (result2 == null) {
                StreamCsvFormatParser.$$$reportNull$$$0(31);
            }
            result2.add(this.createValueToken(l));
        }).advance().memberIf((Condition<CsvLexer>)((Condition)l -> {
            if (result2 == null) {
                StreamCsvFormatParser.$$$reportNull$$$0(29);
            }
            if (lexer == null) {
                StreamCsvFormatParser.$$$reportNull$$$0(30);
            }
            return count != -1 && count == result2.size() && lexer.getType() != null;
        }), countChain).stopIfTypesOrNull(CsvLexer.TokenType.RECORD_SEPARATOR, CsvLexer.TokenType.SUFFIX).types(CsvLexer.TokenType.VALUE_SEPARATOR).advance();
        ParserChain parserChain = chain;
        if (parserChain == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(14);
        }
        return parserChain;
    }

    @Nullable
    private Token createValueToken(@NotNull CsvLexer lexer) {
        String text;
        if (lexer == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(15);
        }
        if ((text = lexer.getText()) == null) {
            return null;
        }
        if (text.length() >= 0x500000) {
            this.myErrors.add((ErrorRecord)new OffsetBatchRecords.OffsetRecord((Exception)new MaxCharactersReachedException(StreamCsvFormatParser.cut(text)), lexer.getTokenLine(), lexer.getOffset()));
        }
        return StreamCsvFormatParser.createToken(lexer);
    }

    private static void checkUnexpectedCount(@NotNull CsvRecordFormat format, @NotNull List<Token> result2, @NotNull Reader r, @NotNull CsvLexer l, int count) throws CsvParserException, IOException {
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(16);
        }
        if (result2 == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(17);
        }
        if (r == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(18);
        }
        if (l == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(19);
        }
        if (count != -1 && result2.size() < count) {
            throw StreamCsvFormatParser.newParserException(format, r, l, CsvLexer.TokenType.VALUE);
        }
    }

    private static boolean shouldReadValue(@NotNull CsvLexer lexer) {
        CsvLexer.TokenType type;
        if (lexer == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(20);
        }
        return (type = lexer.getType()) != null && type != CsvLexer.TokenType.SUFFIX && type != CsvLexer.TokenType.RECORD_SEPARATOR;
    }

    @NotNull
    private static CsvParserException newParserException(@NotNull CsvRecordFormat format, @NotNull Reader reader, @NotNull CsvLexer lexer, CsvLexer.TokenType ... types) throws IOException {
        CsvLexer.TokenType type;
        if (format == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(21);
        }
        if (reader == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(22);
        }
        if (lexer == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(23);
        }
        if (types == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(24);
        }
        boolean hasToken = (type = lexer.getType()) == null;
        String text = hasToken ? StreamCsvFormatParser.cut(CsvLexer.readAhead(reader, 15)) : lexer.getText();
        long character = hasToken ? lexer.getLineCharacters() : lexer.getOffset();
        long line = hasToken ? lexer.getLine() : lexer.getTokenLine();
        CsvParserException csvParserException = new CsvParserException(text == null ? null : StringUtil.wrapWithDoubleQuote((String)text), StreamCsvFormatParser.createToken(lexer), format, character, line, types);
        if (csvParserException == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(25);
        }
        return csvParserException;
    }

    @Contract(value="null -> null; !null -> !null")
    private static String cut(@Nullable String text) {
        return text == null ? null : text.substring(0, Math.min(text.length(), 15)) + "...";
    }

    @Nullable
    private static Token createToken(@NotNull CsvLexer lexer) {
        if (lexer == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(26);
        }
        return lexer.hasToken() ? new Token((String)ObjectUtils.assertNotNull((Object)lexer.getText()), (CsvLexer.TokenType)ObjectUtils.assertNotNull((Object)lexer.getType()), lexer.getTokenLine(), lexer.getOffset(), lexer.getStart(), lexer.getEnd()) : null;
    }

    private static void restore(@NotNull CsvLexer lexer, @NotNull Reader reader) throws IOException {
        if (lexer == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(27);
        }
        if (reader == null) {
            StreamCsvFormatParser.$$$reportNull$$$0(28);
        }
        while (CsvLexer.isReady(reader) && lexer.getType() != CsvLexer.TokenType.RECORD_SEPARATOR) {
            lexer.advance(reader);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 14: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 14: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 3: 
            case 13: 
            case 17: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 12: 
            case 15: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 10: 
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/StreamCsvFormatParser";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/StreamCsvFormatParser";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRecord";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "valuesChain";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "newParserException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseRecords";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseHeader";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRecord";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseRecord";
                break;
            }
            case 10: 
            case 14: 
            case 25: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "valuesChain";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createValueToken";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkUnexpectedCount";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldReadValue";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "newParserException";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createToken";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$valuesChain$3";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$valuesChain$2";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$parseRecord$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 14: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyRecord
    extends ErrorRecord {
        protected MyRecord() {
            super(0L);
        }

        @NotNull
        public String getMessage() {
            if ("couldn't parse header" == null) {
                MyRecord.$$$reportNull$$$0(0);
            }
            return "couldn't parse header";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$MyRecord", "getMessage"));
        }
    }

    public static class MaxCharactersReachedException
    extends Exception {
        public MaxCharactersReachedException(@NotNull String text) {
            if (text == null) {
                MaxCharactersReachedException.$$$reportNull$$$0(0);
            }
            super(String.format("too long value: \"%s\"", StringUtil.escapeStringCharacters((String)text)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/datagrid/StreamCsvFormatParser$MaxCharactersReachedException", "<init>"));
        }
    }

    private static interface Member {
        public void keep(@NotNull Reader var1, @NotNull CsvLexer var2) throws IOException, CsvParserException;
    }

    private static class ParserChain
    implements Member {
        private final List<Member> myMembers;
        private final CsvRecordFormat myFormat;

        public ParserChain(@NotNull CsvRecordFormat format) {
            if (format == null) {
                ParserChain.$$$reportNull$$$0(0);
            }
            this.myFormat = format;
            this.myMembers = ContainerUtil.newArrayList();
        }

        @Override
        public void keep(@NotNull Reader reader, @NotNull CsvLexer lexer) throws IOException, CsvParserException {
            if (reader == null) {
                ParserChain.$$$reportNull$$$0(1);
            }
            if (lexer == null) {
                ParserChain.$$$reportNull$$$0(2);
            }
            try {
                for (Member member : this.myMembers) {
                    member.keep(reader, lexer);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @NotNull
        public ParserChain stopIfNull() {
            ParserChain parserChain = this.member((reader, lexer) -> {
                if (lexer.getType() == null) {
                    throw new IllegalStateException();
                }
            });
            if (parserChain == null) {
                ParserChain.$$$reportNull$$$0(3);
            }
            return parserChain;
        }

        @NotNull
        public ParserChain stopIfTypesOrNull(CsvLexer.TokenType ... types) {
            if (types == null) {
                ParserChain.$$$reportNull$$$0(4);
            }
            ParserChain parserChain = this.member((reader, lexer) -> {
                if (types == null) {
                    ParserChain.$$$reportNull$$$0(31);
                }
                if (lexer.getType() == null || ArrayUtil.contains((Object)lexer.getType(), (Object[])types)) {
                    throw new IllegalStateException();
                }
            });
            if (parserChain == null) {
                ParserChain.$$$reportNull$$$0(5);
            }
            return parserChain;
        }

        @NotNull
        public ParserChain memberWhile(@NotNull Condition<CsvLexer> lexerCondition, @NotNull ParserChain resultChain) {
            if (lexerCondition == null) {
                ParserChain.$$$reportNull$$$0(6);
            }
            if (resultChain == null) {
                ParserChain.$$$reportNull$$$0(7);
            }
            ParserChain parserChain = this.member((reader, lexer) -> {
                if (lexerCondition == null) {
                    ParserChain.$$$reportNull$$$0(29);
                }
                if (resultChain == null) {
                    ParserChain.$$$reportNull$$$0(30);
                }
                while (lexerCondition.value((Object)lexer)) {
                    resultChain.keep(reader, lexer);
                }
            });
            if (parserChain == null) {
                ParserChain.$$$reportNull$$$0(8);
            }
            return parserChain;
        }

        @NotNull
        public ParserChain maybe(@NotNull CsvLexer.TokenType type) {
            if (type == null) {
                ParserChain.$$$reportNull$$$0(9);
            }
            ParserChain parserChain = this.member((reader, lexer) -> {
                CsvLexer.TokenType tokenType;
                if (type == null) {
                    ParserChain.$$$reportNull$$$0(28);
                }
                if ((tokenType = lexer.getType()) == type) {
                    lexer.advance(reader);
                }
            });
            if (parserChain == null) {
                ParserChain.$$$reportNull$$$0(10);
            }
            return parserChain;
        }

        @NotNull
        public ParserChain member(@NotNull Member member) {
            if (member == null) {
                ParserChain.$$$reportNull$$$0(11);
            }
            this.myMembers.add(member);
            ParserChain parserChain = this;
            if (parserChain == null) {
                ParserChain.$$$reportNull$$$0(12);
            }
            return parserChain;
        }

        public ParserChain memberIf(@NotNull Condition<CsvLexer> condition, @NotNull Member member) {
            if (condition == null) {
                ParserChain.$$$reportNull$$$0(13);
            }
            if (member == null) {
                ParserChain.$$$reportNull$$$0(14);
            }
            return this.member((reader, lexer) -> {
                if (condition == null) {
                    ParserChain.$$$reportNull$$$0(26);
                }
                if (member == null) {
                    ParserChain.$$$reportNull$$$0(27);
                }
                if (condition.value((Object)lexer)) {
                    member.keep(reader, lexer);
                }
            });
        }

        @NotNull
        public ParserChain typesOrNull(CsvLexer.TokenType ... types) {
            if (types == null) {
                ParserChain.$$$reportNull$$$0(15);
            }
            ParserChain parserChain = this.member((reader, lexer) -> {
                if (types == null) {
                    ParserChain.$$$reportNull$$$0(25);
                }
                if (lexer.getType() == null) {
                    return;
                }
                ParserChain.assertTokenType(this.myFormat, lexer, reader, types);
            });
            if (parserChain == null) {
                ParserChain.$$$reportNull$$$0(16);
            }
            return parserChain;
        }

        @NotNull
        public ParserChain types(CsvLexer.TokenType ... types) {
            if (types == null) {
                ParserChain.$$$reportNull$$$0(17);
            }
            ParserChain parserChain = this.member((reader, lexer) -> {
                if (types == null) {
                    ParserChain.$$$reportNull$$$0(24);
                }
                ParserChain.assertTokenType(this.myFormat, lexer, reader, types);
            });
            if (parserChain == null) {
                ParserChain.$$$reportNull$$$0(18);
            }
            return parserChain;
        }

        @NotNull
        public ParserChain advance() {
            ParserChain parserChain = this.member((reader, lexer) -> lexer.advance(reader));
            if (parserChain == null) {
                ParserChain.$$$reportNull$$$0(19);
            }
            return parserChain;
        }

        private static void assertTokenType(@NotNull CsvRecordFormat format, @NotNull CsvLexer lexer, @NotNull Reader reader, CsvLexer.TokenType ... types) throws IOException, CsvParserException {
            CsvLexer.TokenType type;
            if (format == null) {
                ParserChain.$$$reportNull$$$0(20);
            }
            if (lexer == null) {
                ParserChain.$$$reportNull$$$0(21);
            }
            if (reader == null) {
                ParserChain.$$$reportNull$$$0(22);
            }
            if (types == null) {
                ParserChain.$$$reportNull$$$0(23);
            }
            if ((type = lexer.getType()) != null && ArrayUtil.contains((Object)type, (Object[])types)) {
                return;
            }
            CsvParserException e = StreamCsvFormatParser.newParserException(format, reader, lexer, types);
            if (type != null && type == CsvLexer.TokenType.RECORD_SEPARATOR) {
                throw e;
            }
            StreamCsvFormatParser.restore(lexer, reader);
            throw e;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: 
                case 12: 
                case 16: 
                case 18: 
                case 19: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: 
                case 12: 
                case 16: 
                case 18: 
                case 19: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 2: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lexer";
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: 
                case 12: 
                case 16: 
                case 18: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain";
                    break;
                }
                case 4: 
                case 15: 
                case 17: 
                case 23: 
                case 24: 
                case 25: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 6: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lexerCondition";
                    break;
                }
                case 7: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultChain";
                    break;
                }
                case 9: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 11: 
                case 14: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 13: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stopIfNull";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stopIfTypesOrNull";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "memberWhile";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "maybe";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "member";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "typesOrNull";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "types";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "advance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "keep";
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: 
                case 12: 
                case 16: 
                case 18: 
                case 19: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "stopIfTypesOrNull";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "memberWhile";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "maybe";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "member";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "memberIf";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "typesOrNull";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "types";
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "assertTokenType";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$types$6";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$typesOrNull$5";
                    break;
                }
                case 26: 
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$memberIf$4";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$maybe$3";
                    break;
                }
                case 29: 
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$memberWhile$2";
                    break;
                }
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$stopIfTypesOrNull$1";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: 
                case 12: 
                case 16: 
                case 18: 
                case 19: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Token {
        private final String myText;
        private final CsvLexer.TokenType myType;
        private final long myLine;
        private final long myOffset;
        private final long myStart;
        private final long myEnd;

        /*
         * WARNING - void declaration
         */
        public Token(@NotNull String text, @NotNull CsvLexer.TokenType type, long line, long offset, long l, long l2) {
            void end;
            void start;
            if (text == null) {
                Token.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Token.$$$reportNull$$$0(1);
            }
            this.myText = text;
            this.myType = type;
            this.myLine = line;
            this.myOffset = offset;
            this.myStart = start;
            this.myEnd = end;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                Token.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getRepresentation() {
            String string = this.myType.getTokenRepresentation(this.myText);
            if (string == null) {
                Token.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public CsvLexer.TokenType getType() {
            CsvLexer.TokenType tokenType = this.myType;
            if (tokenType == null) {
                Token.$$$reportNull$$$0(4);
            }
            return tokenType;
        }

        public long getStart() {
            return this.myStart;
        }

        public long getEnd() {
            return this.myEnd;
        }

        public long getLine() {
            return this.myLine;
        }

        public long getOffset() {
            return this.myOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/StreamCsvFormatParser$Token";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/StreamCsvFormatParser$Token";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRepresentation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CsvParserResult {
        private final Token[] myHeader;
        private final List<Token[]> myRecords;
        private final List<ErrorRecord> myErrors;
        private final long myCharacters;

        public CsvParserResult(@Nullable Token[] header, @NotNull List<Token[]> records, @NotNull List<ErrorRecord> errors, long characters) {
            if (records == null) {
                CsvParserResult.$$$reportNull$$$0(0);
            }
            if (errors == null) {
                CsvParserResult.$$$reportNull$$$0(1);
            }
            this.myHeader = header;
            this.myRecords = records;
            this.myErrors = errors;
            this.myCharacters = characters;
        }

        @Nullable
        public Token[] getHeader() {
            return this.myHeader;
        }

        @NotNull
        public List<Token[]> getRecords() {
            List<Token[]> list = this.myRecords;
            if (list == null) {
                CsvParserResult.$$$reportNull$$$0(2);
            }
            return list;
        }

        public long getCharacters() {
            return this.myCharacters;
        }

        @NotNull
        public List<ErrorRecord> getErrors() {
            List<ErrorRecord> list = this.myErrors;
            if (list == null) {
                CsvParserResult.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        public String getErrorText() {
            String string = StringUtil.join(this.myErrors, ErrorRecord::getMessage, (String)"\n");
            if (string == null) {
                CsvParserResult.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "records";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errors";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecords";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrors";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CsvParserException
    extends Exception {
        public static final String END_OF_FILE = "end of file";
        private static final String MASK = "actual: %s, expected: %s";
        private final long myCharacter;
        private final long myLine;

        /*
         * WARNING - void declaration
         */
        CsvParserException(@Nullable String text, @Nullable Token actual, @NotNull CsvRecordFormat format, long character, long line, CsvLexer.TokenType ... tokenTypeArray) {
            void expected;
            if (format == null) {
                CsvParserException.$$$reportNull$$$0(0);
            }
            if (tokenTypeArray == null) {
                CsvParserException.$$$reportNull$$$0(1);
            }
            super(CsvParserException.getMessageText(format, actual, text, (CsvLexer.TokenType[])expected));
            this.myCharacter = character;
            this.myLine = line;
        }

        public long getOffset() {
            return this.myCharacter;
        }

        public long getLine() {
            return this.myLine;
        }

        @NotNull
        private static String getMessageText(@NotNull CsvRecordFormat format, @Nullable Token token, @Nullable String text, CsvLexer.TokenType ... types) {
            if (format == null) {
                CsvParserException.$$$reportNull$$$0(2);
            }
            if (types == null) {
                CsvParserException.$$$reportNull$$$0(3);
            }
            String string = String.format(MASK, CsvParserException.getActualText(token, text), CsvParserException.getExpected(format, types));
            if (string == null) {
                CsvParserException.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        private static String getExpected(@NotNull CsvRecordFormat format, CsvLexer.TokenType ... types) {
            if (format == null) {
                CsvParserException.$$$reportNull$$$0(5);
            }
            if (types == null) {
                CsvParserException.$$$reportNull$$$0(6);
            }
            String string = StringUtil.escapeStringCharacters((String)StringUtil.join((Object[])types, type -> {
                if (format == null) {
                    CsvParserException.$$$reportNull$$$0(9);
                }
                return type.getDebugName(format);
            }, (String)", "));
            if (string == null) {
                CsvParserException.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        private static String getActualText(@Nullable Token token, @Nullable String text) {
            String string = token != null ? token.getType().getTokenRepresentation(token.getText()) : (text == null ? END_OF_FILE : StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeStringCharacters((String)text)));
            if (string == null) {
                CsvParserException.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expected";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserException";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessageText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpected";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActualText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessageText";
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpected";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getExpected$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

