/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.diff.DbDiffCheckOption;
import com.intellij.database.diff.DbDiffElement;
import com.intellij.database.diff.DbMigrationAction;
import com.intellij.database.diff.SchemaDiffRequest;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.diff.DiffManager;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaDiffAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        Project project = e.getProject();
        Pair<DbDiffElement, DbDiffElement> elements = SchemaDiffAction.getElements(e);
        e.getPresentation().setEnabled(project != null && elements != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Pair<DbDiffElement, DbDiffElement> pair = SchemaDiffAction.getElements(e);
        if (pair == null) {
            return;
        }
        DirDiffSettings settings = new DirDiffSettings();
        settings.showSize = false;
        settings.showDate = false;
        settings.showCompareModes = false;
        settings.customSettings.put("IGNORE_ORDER", true);
        settings.customSettings.put("IGNORE_CASE", true);
        settings.addExtraAction((AnAction)new DbDiffCheckOption("IGNORE_ORDER", "Ignore &order", "alt O"));
        settings.addExtraAction((AnAction)new DbDiffCheckOption("IGNORE_CASE", "Ignore &case", "alt C"));
        settings.addExtraAction((AnAction)Separator.getInstance());
        settings.addExtraAction((AnAction)new DbMigrationAction(DbMigrationAction.Direction.FORWARD));
        settings.addExtraAction((AnAction)new DbMigrationAction(DbMigrationAction.Direction.BACKWARD));
        ((DbDiffElement)((Object)pair.first)).setSettings(settings);
        ((DbDiffElement)((Object)pair.second)).setSettings(settings);
        DiffManager.getInstance().showDiff(project, (DiffRequest)new SchemaDiffRequest((DbDiffElement)((Object)pair.first), (DbDiffElement)((Object)pair.second)));
    }

    @Nullable
    public static Pair<DbDiffElement, DbDiffElement> getElements(AnActionEvent e) {
        DbElement e2;
        DbElement e1;
        block5: {
            DbElement same;
            PsiElement[] elements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY);
            if (elements == null || elements.length != 2 || !(elements[0] instanceof DbElement) || !(elements[1] instanceof DbElement)) {
                return null;
            }
            e1 = (DbElement)elements[0];
            e2 = (DbElement)elements[1];
            HashMap possible1 = ContainerUtil.newHashMap();
            HashMap possible2 = ContainerUtil.newHashMap();
            e1 = SchemaDiffAction.fillPossible(e1, possible1);
            e2 = SchemaDiffAction.fillPossible(e2, possible2);
            while ((same = (DbElement)possible2.get(e1.getKind())) == null) {
                DbElement p = e1.getDbParent();
                if (p != null && possible1.containsKey(p.getKind())) {
                    e1 = p;
                    continue;
                }
                break block5;
            }
            e2 = same;
        }
        if (e1.getKind() != e2.getKind()) {
            return null;
        }
        if (e1.getDelegate() instanceof DasTableChild) {
            return null;
        }
        return Pair.create((Object)((Object)new DbDiffElement(e1.getDataSource(), DbUtil.getDasObject((Object)e1))), (Object)((Object)new DbDiffElement(e2.getDataSource(), DbUtil.getDasObject((Object)e2))));
    }

    private static DbElement fillPossible(@NotNull DbElement el, @NotNull Map<ObjectKind, DbElement> pos) {
        if (el == null) {
            SchemaDiffAction.$$$reportNull$$$0(0);
        }
        if (pos == null) {
            SchemaDiffAction.$$$reportNull$$$0(1);
        }
        if (DasUtil.getParentOfKind((DasObject)el, (ObjectKind)ObjectKind.SCHEMA, (boolean)true) == null) {
            DbElement tmp = el;
            while (tmp != null) {
                pos.put(tmp.getKind(), tmp);
                el = tmp;
                tmp = tmp.getKind() == ObjectKind.SCHEMA ? null : SchemaDiffAction.singleChild(tmp);
            }
            return el;
        }
        pos.put(el.getKind(), el);
        return el;
    }

    @Nullable
    private static DbElement singleChild(@NotNull DbElement el) {
        Iterator it;
        if (el == null) {
            SchemaDiffAction.$$$reportNull$$$0(2);
        }
        if (!(it = el.getDbChildren(DbElement.class, ObjectKind.NONE).iterator()).hasNext()) {
            return null;
        }
        DbElement candidate = (DbElement)it.next();
        return it.hasNext() ? null : candidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/diff/SchemaDiffAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillPossible";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "singleChild";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

