/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ExtractorScripts;
import com.intellij.database.extractors.FormatBasedExtractor;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ScriptDataExtractor;
import com.intellij.database.extractors.SqlInsertValuesExtractor;
import com.intellij.database.extractors.SqlUpdateValuesExtractor;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataExtractorFactories {
    private DataExtractorFactories() {
    }

    @NotNull
    public static List<DataExtractorFactory> getLegacy() {
        List list = ContainerUtil.list((Object[])new DataExtractorFactory[]{new SqlInserts(), new SqlUpdates(), new Html()});
        if (list == null) {
            DataExtractorFactories.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static List<DataExtractorFactory> getCsvFormats() {
        List<CsvFormat> formats = DatabaseSettings.getSettings().getCsvFormats();
        List list = ContainerUtil.map(formats, Format::new);
        if (list == null) {
            DataExtractorFactories.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<DataExtractorFactory> getScripts() {
        List<VirtualFile> scriptFiles = ExtractorScripts.getScriptFiles();
        List list = ContainerUtil.map(scriptFiles, virtualFile -> new Script(virtualFile.getName()));
        if (list == null) {
            DataExtractorFactories.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static DataExtractorFactory getDefault() {
        String tsvId = DatabaseSettings.TSV_FORMAT.id;
        List<DataExtractorFactory> formats = DataExtractorFactories.getCsvFormats();
        DataExtractorFactory tsvFactory = DataExtractorFactories.findById(tsvId, formats);
        DataExtractorFactory dataExtractorFactory = tsvFactory != null ? tsvFactory : (formats.isEmpty() ? new Format(DatabaseSettings.TSV_FORMAT) : (DataExtractorFactory)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(formats)));
        if (dataExtractorFactory == null) {
            DataExtractorFactories.$$$reportNull$$$0(3);
        }
        return dataExtractorFactory;
    }

    @Deprecated
    @Nullable
    static DataExtractorFactory find(@NotNull String name) {
        if (name == null) {
            DataExtractorFactories.$$$reportNull$$$0(4);
        }
        return DataExtractorFactories.find(name, (PairFunction<String, List<? extends DataExtractorFactory>, DataExtractorFactory>)((PairFunction)DataExtractorFactories::find));
    }

    @Nullable
    static DataExtractorFactory findById(@NotNull String id) {
        if (id == null) {
            DataExtractorFactories.$$$reportNull$$$0(5);
        }
        return DataExtractorFactories.find(id, (PairFunction<String, List<? extends DataExtractorFactory>, DataExtractorFactory>)((PairFunction)DataExtractorFactories::findById));
    }

    @NotNull
    public static DataExtractorFactory create(@NotNull CsvFormat format) {
        if (format == null) {
            DataExtractorFactories.$$$reportNull$$$0(6);
        }
        Format format2 = new Format(format);
        if (format2 == null) {
            DataExtractorFactories.$$$reportNull$$$0(7);
        }
        return format2;
    }

    @Deprecated
    @Nullable
    private static DataExtractorFactory find(@NotNull String name, @NotNull List<? extends DataExtractorFactory> factories) {
        if (name == null) {
            DataExtractorFactories.$$$reportNull$$$0(8);
        }
        if (factories == null) {
            DataExtractorFactories.$$$reportNull$$$0(9);
        }
        return (DataExtractorFactory)ContainerUtil.find(factories, factory -> {
            if (name == null) {
                DataExtractorFactories.$$$reportNull$$$0(18);
            }
            return name.equals(factory.getName());
        });
    }

    @Nullable
    private static DataExtractorFactory findById(@NotNull String id, @NotNull List<? extends DataExtractorFactory> factories) {
        if (id == null) {
            DataExtractorFactories.$$$reportNull$$$0(10);
        }
        if (factories == null) {
            DataExtractorFactories.$$$reportNull$$$0(11);
        }
        return (DataExtractorFactory)ContainerUtil.find(factories, factory -> {
            if (id == null) {
                DataExtractorFactories.$$$reportNull$$$0(17);
            }
            return id.equals(factory.getId());
        });
    }

    @Nullable
    private static DataExtractorFactory find(@NotNull String key, @NotNull PairFunction<String, List<? extends DataExtractorFactory>, DataExtractorFactory> finder) {
        DataExtractorFactory f;
        if (key == null) {
            DataExtractorFactories.$$$reportNull$$$0(12);
        }
        if (finder == null) {
            DataExtractorFactories.$$$reportNull$$$0(13);
        }
        f = (f = (DataExtractorFactory)finder.fun((Object)key, DataExtractorFactories.getLegacy())) != null ? f : (DataExtractorFactory)finder.fun((Object)key, DataExtractorFactories.getCsvFormats());
        f = f != null ? f : (DataExtractorFactory)finder.fun((Object)key, DataExtractorFactories.getScripts());
        return f;
    }

    @NotNull
    private static DatabaseDialectEx getDatabaseDialect(@NotNull DataContext dataContext, @Nullable DbTable table) {
        VirtualFile file;
        if (dataContext == null) {
            DataExtractorFactories.$$$reportNull$$$0(14);
        }
        if (table != null) {
            DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect((DbElement)table);
            if (databaseDialectEx == null) {
                DataExtractorFactories.$$$reportNull$$$0(15);
            }
            return databaseDialectEx;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        JdbcConsole console = JdbcConsole.findConsole(project, file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext));
        DatabaseDialectEx databaseDialectEx = console != null ? DbImplUtil.getDatabaseDialect(console) : GenericDialect.INSTANCE;
        if (databaseDialectEx == null) {
            DataExtractorFactories.$$$reportNull$$$0(16);
        }
        return databaseDialectEx;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DataExtractorFactories";
                break;
            }
            case 4: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factories";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCsvFormats";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScripts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DataExtractorFactories";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findById$2";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$find$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class DasAwareFactory
    implements DataExtractorFactory {
        private DasAwareFactory() {
        }

        @Override
        @Nullable
        public final DataExtractor createExtractor(@NotNull DataContext context) {
            DasTable table;
            DatabaseDialectEx dialect;
            DataGrid grid;
            if (context == null) {
                DasAwareFactory.$$$reportNull$$$0(0);
            }
            if ((grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(context)) != null) {
                dialect = DataGridUtil.getDatabaseDialect(grid);
                table = DataGridUtil.getDatabaseTable(grid);
            } else {
                PsiElement contextElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
                DbTable dbTable = (DbTable)ObjectUtils.tryCast((Object)contextElement, DbTable.class);
                table = dbTable;
                dialect = DataExtractorFactories.getDatabaseDialect(context, dbTable);
            }
            return this.createExtractor(context, dialect, table);
        }

        @Nullable
        protected abstract DataExtractor createExtractor(@NotNull DataContext var1, @NotNull DatabaseDialectEx var2, @Nullable DasTable var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/extractors/DataExtractorFactories$DasAwareFactory", "createExtractor"));
        }
    }

    private static class Script
    extends DasAwareFactory {
        private final String myScriptFileName;

        public Script(@NotNull String scriptFileName) {
            if (scriptFileName == null) {
                Script.$$$reportNull$$$0(0);
            }
            this.myScriptFileName = scriptFileName;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myScriptFileName;
            if (string == null) {
                Script.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        protected DataExtractor createExtractor(@NotNull DataContext context, @NotNull DatabaseDialectEx dialect, @Nullable DasTable table) {
            VirtualFile script;
            if (context == null) {
                Script.$$$reportNull$$$0(2);
            }
            if (dialect == null) {
                Script.$$$reportNull$$$0(3);
            }
            if ((script = ExtractorScripts.findScript(this.myScriptFileName)) == null) {
                return null;
            }
            ExtensionScriptsUtil.prepareScript(script);
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            DataGrid grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(context);
            ObjectFormatter formatter = grid != null ? grid.getObjectFormatter() : new ObjectFormatter();
            boolean transposed = grid != null && grid.isTransposed() && DataExtractorProperties.isTranspositionAllowed();
            return new ScriptDataExtractor(project, script, formatter, table, transposed);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptFileName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/DataExtractorFactories$Script";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/DataExtractorFactories$Script";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createExtractor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SqlInserts
    extends DasAwareFactory {
        private SqlInserts() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("SQL Inserts" == null) {
                SqlInserts.$$$reportNull$$$0(0);
            }
            return "SQL Inserts";
        }

        @Override
        @Nullable
        protected DataExtractor createExtractor(@NotNull DataContext context, @NotNull DatabaseDialectEx dialect, @Nullable DasTable table) {
            if (context == null) {
                SqlInserts.$$$reportNull$$$0(1);
            }
            if (dialect == null) {
                SqlInserts.$$$reportNull$$$0(2);
            }
            return new SqlInsertValuesExtractor(new ObjectFormatter(), table);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/DataExtractorFactories$SqlInserts";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/DataExtractorFactories$SqlInserts";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createExtractor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SqlUpdates
    extends DasAwareFactory {
        private SqlUpdates() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("SQL Updates" == null) {
                SqlUpdates.$$$reportNull$$$0(0);
            }
            return "SQL Updates";
        }

        @Override
        @Nullable
        protected DataExtractor createExtractor(@NotNull DataContext context, @NotNull DatabaseDialectEx dialect, @Nullable DasTable table) {
            if (context == null) {
                SqlUpdates.$$$reportNull$$$0(1);
            }
            if (dialect == null) {
                SqlUpdates.$$$reportNull$$$0(2);
            }
            return new SqlUpdateValuesExtractor(new ObjectFormatter(), table);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/DataExtractorFactories$SqlUpdates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/DataExtractorFactories$SqlUpdates";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createExtractor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Format
    implements DataExtractorFactory {
        private final CsvFormat myFormat;

        public Format(@NotNull CsvFormat format) {
            if (format == null) {
                Format.$$$reportNull$$$0(0);
            }
            this.myFormat = format;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myFormat.name;
            if (string == null) {
                Format.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public DataExtractor createExtractor(@NotNull DataContext context) {
            if (context == null) {
                Format.$$$reportNull$$$0(2);
            }
            return new FormatBasedExtractor(this.myFormat, new ObjectFormatter());
        }

        @Override
        @NotNull
        public String getId() {
            String string = this.myFormat.id;
            if (string == null) {
                Format.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/DataExtractorFactories$Format";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/DataExtractorFactories$Format";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createExtractor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Html
    implements DataExtractorFactory {
        private Html() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("HTML Table" == null) {
                Html.$$$reportNull$$$0(0);
            }
            return "HTML Table";
        }

        @Override
        @Nullable
        public DataExtractor createExtractor(@NotNull DataContext context) {
            if (context == null) {
                Html.$$$reportNull$$$0(1);
            }
            DatabaseSettings.StdState state = new DatabaseSettings.StdState();
            state.columnNames = true;
            return new HtmlValuesExtractor(state, new ObjectFormatter());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/DataExtractorFactories$Html";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/DataExtractorFactories$Html";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createExtractor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

