/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.run.actions.DumpAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataExtractorProperties {
    @Deprecated
    private static final String CURRENT = "database.data.extractors.current";
    private static final String CURRENT_ID = "database.data.extractors.current.id";
    private static final String HONOR_TRANSPOSED = "database.data.extractors.honor.transposed";
    private static final String SKIP_GENERATED = "database.data.extractors.sql.skip.generated";
    private static final String SKIP_COMPUTED = "database.data.extractors.sql.skip.computed";
    private static final String CREATE_TABLE = "database.data.extractors.sql.create.table";
    private static final String OVERWRITE_EXISTING_FILES = "database.data.extractors.overwrite.existing.files";

    private DataExtractorProperties() {
    }

    @NotNull
    public static DataExtractorFactory getCurrentExtractorFactory(@Nullable Project project) {
        String factoryId;
        PropertiesComponent storage = project == null ? null : PropertiesComponent.getInstance((Project)project);
        String factoryName = storage != null ? storage.getValue(CURRENT) : null;
        String string = factoryId = storage != null ? storage.getValue(CURRENT_ID) : null;
        DataExtractorFactory factory = factoryName != null ? DataExtractorFactories.find(factoryName) : (factoryId != null ? DataExtractorFactories.findById(factoryId) : null);
        DataExtractorFactory dataExtractorFactory = factory != null ? factory : DataExtractorFactories.getDefault();
        if (dataExtractorFactory == null) {
            DataExtractorProperties.$$$reportNull$$$0(0);
        }
        return dataExtractorFactory;
    }

    public static void setCurrentExtractorFactory(@NotNull Project project, @NotNull DataExtractorFactory f) {
        if (project == null) {
            DataExtractorProperties.$$$reportNull$$$0(1);
        }
        if (f == null) {
            DataExtractorProperties.$$$reportNull$$$0(2);
        }
        PropertiesComponent component = PropertiesComponent.getInstance((Project)project);
        component.unsetValue(CURRENT);
        component.setValue(CURRENT_ID, f.getId());
    }

    public static boolean isTranspositionAllowed() {
        return DataExtractorProperties.getAppProperty(HONOR_TRANSPOSED);
    }

    public static boolean isSkipGeneratedColumns() {
        return DataExtractorProperties.getAppProperty(SKIP_GENERATED);
    }

    public static boolean isSkipComputed() {
        return DataExtractorProperties.getAppProperty(SKIP_COMPUTED);
    }

    public static boolean isIncludeCreateTable() {
        return DataExtractorProperties.getAppProperty(CREATE_TABLE);
    }

    public static boolean isOverwriteExistingFiles() {
        return DataExtractorProperties.getAppProperty(OVERWRITE_EXISTING_FILES);
    }

    public static AnAction getTranspositionAllowedAction() {
        return new BooleanPropertyAction("Allow Transposition", HONOR_TRANSPOSED){

            @Override
            boolean shouldBeVisible(AnActionEvent e) {
                return super.shouldBeVisible(e) && DumpAction.getDumpSource(e) instanceof DataGrid;
            }
        };
    }

    public static AnAction getSkipGeneratedColumnsAction() {
        return new TableBooleanPropertyAction("Skip Generated Columns (SQL)", SKIP_GENERATED);
    }

    public static AnAction getSkipComputedColumnsAction() {
        return new TableBooleanPropertyAction("Skip Computed Columns (SQL)", SKIP_COMPUTED);
    }

    public static AnAction getAddCreateTableAction() {
        return new BooleanPropertyAction("Add Table Definition (SQL)", CREATE_TABLE);
    }

    public static AnAction getOverwriteExistingFilesAction() {
        return new MultipleItemsBooleanPropertyAction("Overwrite Existing Files", OVERWRITE_EXISTING_FILES);
    }

    private static boolean getAppProperty(@NotNull String property) {
        if (property == null) {
            DataExtractorProperties.$$$reportNull$$$0(3);
        }
        boolean defaultValue = !CREATE_TABLE.equals(property) && !SKIP_GENERATED.equals(property);
        return PropertiesComponent.getInstance().getBoolean(property, defaultValue);
    }

    private static void setAppProperty(@NotNull String property, boolean value) {
        if (property == null) {
            DataExtractorProperties.$$$reportNull$$$0(4);
        }
        boolean defaultValue = !CREATE_TABLE.equals(property) && !SKIP_GENERATED.equals(property);
        PropertiesComponent.getInstance().setValue(property, value, defaultValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DataExtractorProperties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentExtractorFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DataExtractorProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentExtractorFactory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAppProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAppProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TableBooleanPropertyAction
    extends BooleanPropertyAction {
        public TableBooleanPropertyAction(@NotNull String name, @NotNull String property) {
            if (name == null) {
                TableBooleanPropertyAction.$$$reportNull$$$0(0);
            }
            if (property == null) {
                TableBooleanPropertyAction.$$$reportNull$$$0(1);
            }
            super(name, property);
        }

        @Override
        boolean shouldBeVisible(AnActionEvent e) {
            return super.shouldBeVisible(e) && !(DumpAction.getDumpSource(e) instanceof DumpAction.ConsoleSource);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "property";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/extractors/DataExtractorProperties$TableBooleanPropertyAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BooleanPropertyAction
    extends ToggleAction
    implements DumbAware {
        private final String myProperty;

        public BooleanPropertyAction(String displayName, String property) {
            super(displayName);
            this.myProperty = property;
        }

        public boolean isSelected(AnActionEvent e) {
            e.getPresentation().setVisible(this.shouldBeVisible(e));
            return DataExtractorProperties.getAppProperty(this.myProperty);
        }

        boolean shouldBeVisible(AnActionEvent e) {
            Project project = e.getProject();
            return project != null && DumpAction.getDumpSource(e) != null;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            DataExtractorProperties.setAppProperty(this.myProperty, state);
        }
    }

    private static class MultipleItemsBooleanPropertyAction
    extends BooleanPropertyAction {
        public MultipleItemsBooleanPropertyAction(String displayName, String property) {
            super(displayName, property);
        }

        @Override
        boolean shouldBeVisible(AnActionEvent e) {
            if (e.getProject() == null) {
                return false;
            }
            Object source = DumpAction.getDumpSource(e);
            return source instanceof DumpAction.ConsoleSource && this.isManyItems(DumpAction.getQueries((DumpAction.ConsoleSource)source)) || source instanceof List && this.isManyItems((List)source) || source instanceof JBIterable && !((JBIterable)source).skip(1).isEmpty();
        }

        boolean isManyItems(@Nullable List list) {
            return list != null && list.size() > 1;
        }
    }
}

