/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntrospectionScope {
    public static final IntrospectionScope CURRENT_SCOPE = new IntrospectionScope((ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.of((Object)"@", (Object)ImmutableSet.of((Object)"@")));
    public static final IntrospectionScope EMPTY_SCOPE = new IntrospectionScope((ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.of());
    public static final IntrospectionScope ALL_SCOPE = new IntrospectionScope((ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.of((Object)"*", (Object)ImmutableSet.of((Object)"*")));
    private static final String SPLIT = ":";
    private final Map<String, ? extends Set<String>> myDatabasesAndSchemas;
    private static final String[] escapeChars = new String[]{"\u0000", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u000e", "\u000f", "\u0010", "\u0011", "\u0012", "\u0013", "\u0014", "\u0015", "\u0016", "\u0017", "\u0018", "\u0019", "\u001a", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", " ", ",", ";", "<", ">", "'", "\"", "|", "\\", ":"};
    private static final String[] escapedChars = new String[]{"\\u0000", "\\u0001", "\\u0002", "\\u0003", "\\u0004", "\\u0005", "\\u0006", "\\u0007", "\\u0008", "\\u0009", "\\u000A", "\\u000B", "\\u000C", "\\u000D", "\\u000E", "\\u000F", "\\u0010", "\\u0011", "\\u0012", "\\u0013", "\\u0014", "\\u0015", "\\u0016", "\\u0017", "\\u0018", "\\u0019", "\\u001A", "\\u001B", "\\u001C", "\\u001D", "\\u001E", "\\u001F", "\\u0020", "\\u002C", "\\u003B", "\\u003C", "\\u003E", "\\u0027", "\\u0022", "\\u007C", "\\u005C", "\\u003A"};

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull String database, @NotNull Collection<String> schemas) {
        if (database == null) {
            IntrospectionScope.$$$reportNull$$$0(0);
        }
        if (schemas == null) {
            IntrospectionScope.$$$reportNull$$$0(1);
        }
        if (schemas.size() == 1) {
            IntrospectionScope introspectionScope = IntrospectionScope.scopeOf(database, (String)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(schemas)));
            if (introspectionScope == null) {
                IntrospectionScope.$$$reportNull$$$0(2);
            }
            return introspectionScope;
        }
        IntrospectionScope introspectionScope = new IntrospectionScope((ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.of((Object)database, (Object)ImmutableSet.copyOf(schemas)));
        if (introspectionScope == null) {
            IntrospectionScope.$$$reportNull$$$0(3);
        }
        return introspectionScope;
    }

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull String database, @NotNull String schema) {
        if (database == null) {
            IntrospectionScope.$$$reportNull$$$0(4);
        }
        if (schema == null) {
            IntrospectionScope.$$$reportNull$$$0(5);
        }
        if ("*".equals(database) && "*".equals(schema)) {
            IntrospectionScope introspectionScope = ALL_SCOPE;
            if (introspectionScope == null) {
                IntrospectionScope.$$$reportNull$$$0(6);
            }
            return introspectionScope;
        }
        if ("@".equals(database) && "@".equals(schema)) {
            IntrospectionScope introspectionScope = CURRENT_SCOPE;
            if (introspectionScope == null) {
                IntrospectionScope.$$$reportNull$$$0(7);
            }
            return introspectionScope;
        }
        IntrospectionScope introspectionScope = new IntrospectionScope((ImmutableMap<String, ImmutableSet<String>>)ImmutableMap.of((Object)database, (Object)ImmutableSet.of((Object)schema)));
        if (introspectionScope == null) {
            IntrospectionScope.$$$reportNull$$$0(8);
        }
        return introspectionScope;
    }

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull ImmutableMap<String, ImmutableSet<String>> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            IntrospectionScope.$$$reportNull$$$0(9);
        }
        if (databasesAndSchemas.isEmpty()) {
            IntrospectionScope introspectionScope = EMPTY_SCOPE;
            if (introspectionScope == null) {
                IntrospectionScope.$$$reportNull$$$0(10);
            }
            return introspectionScope;
        }
        if (databasesAndSchemas.size() == 1) {
            Map.Entry item = (Map.Entry)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)databasesAndSchemas.entrySet()));
            IntrospectionScope introspectionScope = IntrospectionScope.scopeOf((String)item.getKey(), (Collection)item.getValue());
            if (introspectionScope == null) {
                IntrospectionScope.$$$reportNull$$$0(11);
            }
            return introspectionScope;
        }
        IntrospectionScope introspectionScope = new IntrospectionScope(databasesAndSchemas);
        if (introspectionScope == null) {
            IntrospectionScope.$$$reportNull$$$0(12);
        }
        return introspectionScope;
    }

    private IntrospectionScope(@NotNull ImmutableMap<String, ImmutableSet<String>> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            IntrospectionScope.$$$reportNull$$$0(13);
        }
        this.myDatabasesAndSchemas = databasesAndSchemas;
    }

    @NotNull
    public Set<String> databases() {
        Set<String> set = this.myDatabasesAndSchemas.keySet();
        if (set == null) {
            IntrospectionScope.$$$reportNull$$$0(14);
        }
        return set;
    }

    public boolean containsDatabase(@NotNull String database) {
        if (database == null) {
            IntrospectionScope.$$$reportNull$$$0(15);
        }
        return this.myDatabasesAndSchemas.containsKey(database) || this.myDatabasesAndSchemas.containsKey("*");
    }

    @NotNull
    public Set<String> schemas(@NotNull String database) {
        Set<String> schemas;
        if (database == null) {
            IntrospectionScope.$$$reportNull$$$0(16);
        }
        Set<String> set = (schemas = this.myDatabasesAndSchemas.get(database)) != null ? schemas : Collections.emptySet();
        if (set == null) {
            IntrospectionScope.$$$reportNull$$$0(17);
        }
        return set;
    }

    @NotNull
    public Set<String> allSchemas() {
        TreeSet<String> allSchemas = new TreeSet<String>();
        for (Set<String> set : this.myDatabasesAndSchemas.values()) {
            allSchemas.addAll(set);
        }
        TreeSet<String> treeSet = allSchemas;
        if (treeSet == null) {
            IntrospectionScope.$$$reportNull$$$0(18);
        }
        return treeSet;
    }

    public boolean containsSchema(@NotNull String database, @NotNull String schema) {
        if (database == null) {
            IntrospectionScope.$$$reportNull$$$0(19);
        }
        if (schema == null) {
            IntrospectionScope.$$$reportNull$$$0(20);
        }
        return IntrospectionScope.contains((Collection<String>)this.myDatabasesAndSchemas.get(database), schema) || IntrospectionScope.contains((Collection<String>)this.myDatabasesAndSchemas.get("*"), schema);
    }

    public boolean isEmpty() {
        return this.myDatabasesAndSchemas.isEmpty();
    }

    private static boolean contains(@Nullable Collection<String> schemas, @NotNull String schema) {
        if (schema == null) {
            IntrospectionScope.$$$reportNull$$$0(21);
        }
        return schemas != null && (schemas.contains(schema) || schemas.contains("*"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntrospectionScope scope = (IntrospectionScope)o;
        return this.myDatabasesAndSchemas.equals(scope.myDatabasesAndSchemas);
    }

    public int hashCode() {
        return this.myDatabasesAndSchemas.hashCode();
    }

    @NotNull
    public String exportState() {
        StringBuilder b = new StringBuilder();
        ArrayList databases = ContainerUtil.newArrayList(this.databases());
        Collections.sort(databases);
        for (String database : databases) {
            b.append(IntrospectionScope.escape(database)).append(SPLIT);
            ArrayList schemas = ContainerUtil.newArrayList(this.schemas(database));
            Collections.sort(schemas);
            boolean was = false;
            for (String schema : schemas) {
                if (was) {
                    b.append(',');
                } else {
                    was = true;
                }
                b.append(IntrospectionScope.escape(schema));
            }
            b.append('|');
        }
        if (b.length() > 0) {
            b.deleteCharAt(b.length() - 1);
        }
        String string = b.toString();
        if (string == null) {
            IntrospectionScope.$$$reportNull$$$0(22);
        }
        return string;
    }

    public String toString() {
        return this.exportState();
    }

    @NotNull
    @Contract(pure=true)
    static IntrospectionScope importState(@NotNull String string) {
        String[] bunches;
        if (string == null) {
            IntrospectionScope.$$$reportNull$$$0(23);
        }
        MultiMap<String, String> map2 = new MultiMap<String, String>(){

            @NotNull
            protected Collection<String> createCollection() {
                TreeSet treeSet = ContainerUtil.newTreeSet();
                if (treeSet == null) {
                    1.$$$reportNull$$$0(0);
                }
                return treeSet;
            }

            @NotNull
            protected Map<String, Collection<String>> createMap() {
                TreeMap treeMap = ContainerUtil.newTreeMap();
                if (treeMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return treeMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/database/introspection/IntrospectionScope$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCollection";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMap";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        for (String bunch : bunches = string.split("\\|")) {
            String[] pair = bunch.split(SPLIT, 2);
            if (pair.length < 2) continue;
            String database = IntrospectionScope.unescape(pair[0]);
            Object[] schemas = StringUtil.isEmpty((String)pair[1]) ? ArrayUtil.EMPTY_STRING_ARRAY : pair[1].split(",");
            Collection modifiable = map2.getModifiable((Object)database);
            ContainerUtil.addAll((Collection)modifiable, (Object[])schemas);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : map2.entrySet()) {
            builder.put(entry.getKey(), (Object)ImmutableSet.copyOf((Collection)((Collection)entry.getValue())));
        }
        IntrospectionScope introspectionScope = IntrospectionScope.scopeOf((ImmutableMap<String, ImmutableSet<String>>)builder.build());
        if (introspectionScope == null) {
            IntrospectionScope.$$$reportNull$$$0(24);
        }
        return introspectionScope;
    }

    @Contract(pure=true)
    private static String escape(@NotNull String string) {
        if (string == null) {
            IntrospectionScope.$$$reportNull$$$0(25);
        }
        return StringUtil.replace((String)string, (String[])escapeChars, (String[])escapedChars);
    }

    @Contract(pure=true)
    private static String unescape(@NotNull String string) {
        if (string == null) {
            IntrospectionScope.$$$reportNull$$$0(26);
        }
        return StringUtil.replaceUnicodeEscapeSequences((String)string);
    }

    @NotNull
    public List<Couple<String>> asList() {
        LinkedList result2 = ContainerUtil.newLinkedList();
        for (String d : this.databases()) {
            for (String s : this.schemas(d)) {
                result2.add(Couple.of((Object)d, (Object)s));
            }
        }
        LinkedList linkedList = result2;
        if (linkedList == null) {
            IntrospectionScope.$$$reportNull$$$0(27);
        }
        return linkedList;
    }

    @NotNull
    public MultiMap<String, String> to(MultiMap<String, String> map2) {
        for (String db : this.databases()) {
            Collection scs = map2.getModifiable((Object)db);
            scs.addAll(this.schemas(db));
        }
        MultiMap<String, String> multiMap = map2;
        if (multiMap == null) {
            IntrospectionScope.$$$reportNull$$$0(28);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, String> applyToContext(@NotNull MultiMap<String, String> context) {
        if (context == null) {
            IntrospectionScope.$$$reportNull$$$0(29);
        }
        MultiMap result2 = new MultiMap();
        for (String d : context.keySet()) {
            for (String s : context.get((Object)d)) {
                if (!this.containsSchema(d, s)) continue;
                result2.putValue((Object)d, (Object)s);
            }
        }
        MultiMap multiMap = result2;
        if (multiMap == null) {
            IntrospectionScope.$$$reportNull$$$0(30);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemas";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/introspection/IntrospectionScope";
                break;
            }
            case 5: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databasesAndSchemas";
                break;
            }
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/introspection/IntrospectionScope";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "scopeOf";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "databases";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "schemas";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "allSchemas";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "exportState";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "importState";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "asList";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "to";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scopeOf";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 30: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "containsDatabase";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "schemas";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "containsSchema";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "importState";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "unescape";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyToContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

