/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.BaseSingleDatabaseIntrospector;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.introspection.SqliteIntroQueries;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.SqliteOnConflictAlgorithm;
import com.intellij.database.model.sqlite.SqliteModCheck;
import com.intellij.database.model.sqlite.SqliteModForeignKey;
import com.intellij.database.model.sqlite.SqliteModIndex;
import com.intellij.database.model.sqlite.SqliteModKey;
import com.intellij.database.model.sqlite.SqliteModLikeColumn;
import com.intellij.database.model.sqlite.SqliteModLikeTable;
import com.intellij.database.model.sqlite.SqliteModModel;
import com.intellij.database.model.sqlite.SqliteModRoot;
import com.intellij.database.model.sqlite.SqliteModSchema;
import com.intellij.database.model.sqlite.SqliteModTable;
import com.intellij.database.model.sqlite.SqliteModTableColumn;
import com.intellij.database.model.sqlite.SqliteModTrigger;
import com.intellij.database.model.sqlite.SqliteModView;
import com.intellij.database.model.sqlite.SqliteModVirtualTable;
import com.intellij.database.model.sqlite.SqliteSchema;
import com.intellij.database.model.sqlite.SqliteTableColumn;
import com.intellij.database.scripting.CompositeText;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlForeignKeyDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.script.SqlReader;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Sqlite;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransaction;
import org.jetbrains.dekaf.exceptions.DBException;

public class SqliteIntrospector
extends BaseSingleDatabaseIntrospector<SqliteModModel, SqliteModRoot, SqliteSchema, SqliteModSchema> {
    private static final SequenceIdentity SEQUENCE_IDENTITY = SequenceIdentity.of(1L, null, 1L, null);
    private static final Logger LOG = Logger.getInstance(SqliteIntrospector.class);
    private final SqlReader myReader = SqlPsiFacade.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).createSqlReader();
    private final SqlLanguageDialect myLanguage = (SqlLanguageDialect)ObjectUtils.assertNotNull((Object)((SqlLanguageDialect)Language.findLanguageByID((String)"SQLite")));
    public static final PerObjectVersion VERSION = new PerObjectVersion();

    protected SqliteIntrospector() {
        super(Sqlite.RDBMS, SqliteModModel.class, SqliteModRoot.class, SqliteModSchema.class);
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends SqliteSchema> schemas) {
        if (tran == null) {
            SqliteIntrospector.$$$reportNull$$$0(0);
        }
        if (schemas == null) {
            SqliteIntrospector.$$$reportNull$$$0(1);
        }
        this.retrieveCollations(tran);
        for (SqliteSchema sqliteSchema : schemas) {
            this.handleErrors("Introspect schema " + sqliteSchema.getName(), (Function0<Unit>)((Function0)() -> {
                if (tran == null) {
                    SqliteIntrospector.$$$reportNull$$$0(8);
                }
                SqliteSchemaRetriever retriever = new SqliteSchemaRetriever(tran, schema);
                retriever.init();
                retriever.process();
                return null;
            }));
        }
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        if (tran == null) {
            SqliteIntrospector.$$$reportNull$$$0(2);
        }
        List schemaInfos = (List)tran.query(SqliteIntroQueries.QUERIES.listSchemas).run();
        this.applySchemas(schemaInfos);
    }

    private void retrieveCollations(@NotNull DBTransaction tran) {
        if (tran == null) {
            SqliteIntrospector.$$$reportNull$$$0(3);
        }
        this.updateDetails("introspecting collations");
        List collationInfos = (List)tran.query(SqliteIntroQueries.QUERIES.listCollations).run();
        ((SqliteModModel)this.getModel()).modify(SqliteModRoot.class, r -> {
            NamingFamily collations = r.getCollations();
            collations.markChildrenAsSyncPending();
            for (SqliteIntroQueries.CollationInfo info : collationInfos) {
                collations.createOrGet(info.name);
            }
            collations.removeSyncPendingChildren();
            collations.sort();
        });
    }

    @Override
    public void retrieveAndApplySchemas() {
        List schemaInfos = (List)((DBFacade)ObjectUtils.assertNotNull((Object)this.getDbFacade())).inTransaction((InTransaction)new InTransaction<List<SqliteIntroQueries.SchemaInfo>>(){

            public List<SqliteIntroQueries.SchemaInfo> run(@NotNull DBTransaction tran) {
                if (tran == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (List)tran.query(SqliteIntroQueries.QUERIES.listSchemas).run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/database/introspection/SqliteIntrospector$1", "run"));
            }
        });
        this.applySchemas(schemaInfos);
    }

    private void applySchemas(List<SqliteIntroQueries.SchemaInfo> schemaInfos) {
        ((SqliteModModel)this.getModel()).modify(r -> {
            this.updateStatus("introspecting schemas", "");
            NamingFamily schemas = r.getSchemas();
            boolean wasEmpty = schemas.isEmpty();
            schemas.markChildrenAsSyncPending();
            for (SqliteIntroQueries.SchemaInfo schemaInfo : schemaInfos) {
                SqliteModSchema schema = (SqliteModSchema)schemas.createOrGet(schemaInfo.name);
                boolean main = SqliteIntrospector.isMain(schemaInfo.name);
                boolean temp = SqliteIntrospector.isTemp(schemaInfo.name);
                if (!wasEmpty || !main && !temp) continue;
                schema.setCurrent(main);
                schema.setVisible(true);
            }
            schemas.removeSyncPendingChildren();
        });
    }

    private static boolean isMain(String name) {
        return "main".equals(name);
    }

    private static boolean isTemp(String name) {
        return "temp".equals(name);
    }

    private static ObjectKind getKind(String type, Integer rootpage) {
        return "table".equals(type) ? (rootpage == 0 ? ObjectKind.VIRTUAL_TABLE : ObjectKind.TABLE) : ("view".equals(type) ? ObjectKind.VIEW : ("index".equals(type) ? ObjectKind.INDEX : ("trigger".equals(type) ? ObjectKind.TRIGGER : null)));
    }

    private static String fixName(String name, @NotNull Family<?> src) {
        Object object;
        if (src == null) {
            SqliteIntrospector.$$$reportNull$$$0(4);
        }
        return (object = SqliteIntrospector.findObject(name, src)) == null ? name : object.getName();
    }

    private static void fixNames(List<String> names, @NotNull Family<?> src) {
        if (src == null) {
            SqliteIntrospector.$$$reportNull$$$0(5);
        }
        for (int i2 = 0; i2 < names.size(); ++i2) {
            names.set(i2, SqliteIntrospector.fixName(names.get(i2), src));
        }
    }

    private static <T extends BasicElement> T findObject(String name, @NotNull Family<T> src) {
        if (src == null) {
            SqliteIntrospector.$$$reportNull$$$0(6);
        }
        if (name == null) {
            return null;
        }
        for (BasicElement element : src) {
            if (!name.equalsIgnoreCase(element.getName())) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    private static PsiElement findChild(@Nullable PsiElement parent, @NotNull IElementType type) {
        if (type == null) {
            SqliteIntrospector.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            return null;
        }
        for (PsiElement child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (PsiUtilCore.getElementType((PsiElement)child) != type) continue;
            return child;
        }
        return null;
    }

    @Nullable
    private static SqliteOnConflictAlgorithm getConflictResolution(@Nullable PsiElement def) {
        PsiElement onConflict = SqliteIntrospector.findChild(def, LazyData.SQL_CONFLICT_CLAUSE);
        if (onConflict == null) {
            return null;
        }
        PsiElement how = PsiTreeUtil.getDeepestLast((PsiElement)onConflict);
        String text = how.getText();
        for (SqliteOnConflictAlgorithm algo : SqliteOnConflictAlgorithm.values()) {
            if (!algo.toString().equalsIgnoreCase(text)) continue;
            return algo == SqliteOnConflictAlgorithm.ABORT ? null : algo;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tran";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemas";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/introspection/SqliteIntrospector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "introspectSchemasAuto";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "introspectNamespacesInTran";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "retrieveCollations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fixName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fixNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findObject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findChild";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$introspectSchemasAuto$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class SqliteSchemaRetriever
    extends BaseIntrospector.SchemaRetriever {
        public SqliteSchemaRetriever(@NotNull DBTransaction transaction, SqliteSchema schema) {
            if (SqliteIntrospector.this == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(0);
            }
            if (transaction == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(1);
            }
            if (schema == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(2);
            }
            super((BaseIntrospector)SqliteIntrospector.this, transaction, (BasicSchema)schema, IntrospectionMode.INCREMENT);
        }

        @Override
        protected void prepareParameters() {
            SqliteIntrospector.this.queryParameters.put("SCHEMA", SqliteIntroQueries.quote(((SqliteSchema)this.getSchema()).getName()));
            super.prepareParameters();
        }

        @Override
        protected void retrieveMainContent() {
            SqliteIntrospector.this.updateStatus(String.format("introspecting schema %s", ((SqliteSchema)this.getSchema()).getName()), "");
            this.retrieveTablesAndViews();
            this.retrieveColumns();
            this.retrieveIndicesAndForeignKeys();
            this.retrieveSourcesAndExtras();
        }

        private void retrieveTablesAndViews() {
            SqliteIntrospector.this.updateDetails("introspecting tables and views");
            boolean temp = SqliteIntrospector.isTemp(((SqliteSchema)this.getSchema()).getName());
            List<SqliteIntroQueries.MajorInfo> majorInfos = this.performQuery(temp ? SqliteIntroQueries.QUERIES.retrieveTempMajors : SqliteIntroQueries.QUERIES.retrieveMajors);
            ((SqliteModModel)this.getModel()).modify((BasicElement)this.getSchema(), SqliteModSchema.class, s -> s.getModel().writeSources(() -> {
                s.getTables().markChildrenAsSyncPending();
                s.getVirtualTables().markChildrenAsSyncPending();
                s.getViews().markChildrenAsSyncPending();
                SqliteModTable master = (SqliteModTable)s.getTables().createOrGet(temp ? "sqlite_temp_master" : "sqlite_master");
                master.setSystem(true);
                for (SqliteIntroQueries.MajorInfo majorInfo : majorInfos) {
                    SqliteModLikeTable table;
                    ObjectKind kind = SqliteIntrospector.getKind(majorInfo.type, majorInfo.rootpage);
                    if (kind == ObjectKind.TABLE) {
                        table = (SqliteModTable)s.getTables().createOrGet(majorInfo.name);
                        String name = majorInfo.name;
                        table.setSystem(this.isSystem(name, temp));
                        table.setTemporary(temp);
                        continue;
                    }
                    if (kind == ObjectKind.VIRTUAL_TABLE) {
                        table = (SqliteModVirtualTable)s.getVirtualTables().createOrGet(majorInfo.name);
                        table.setTemporary(temp);
                        continue;
                    }
                    if (kind != ObjectKind.VIEW) continue;
                    s.getViews().createOrGet(majorInfo.name);
                }
                s.getTables().removeSyncPendingChildren();
                s.getTables().sort();
                s.getVirtualTables().removeSyncPendingChildren();
                s.getVirtualTables().sort();
                s.getViews().removeSyncPendingChildren();
                s.getViews().sort();
            }));
        }

        private boolean isSystem(String name, boolean temp) {
            return "sqlite_sequence".equals(name);
        }

        private void retrieveColumns() {
            ((SqliteModModel)this.getModel()).modify((BasicElement)this.getSchema(), SqliteModSchema.class, s -> s.getModel().writeSources(() -> {
                for (SqliteModLikeTable table : s.getTables()) {
                    this.retrieveColumns(table);
                }
                for (SqliteModLikeTable table : s.getViews()) {
                    this.retrieveColumns(table);
                }
            }));
        }

        private void retrieveIndicesAndForeignKeys() {
            ((SqliteModModel)this.getModel()).modify((BasicElement)this.getSchema(), SqliteModSchema.class, s -> s.getModel().writeSources(() -> {
                for (SqliteModTable table : s.getTables()) {
                    this.retrieveIndicesAndForeignKeys(table);
                }
            }));
        }

        private void retrieveIndicesAndForeignKeys(@NotNull SqliteModTable table) {
            if (table == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(3);
            }
            this.getQueryParameters().put("TABLE", SqliteIntroQueries.quote(table.getName()));
            this.retrieveIndices(table);
            for (SqliteModIndex index : table.getIndices()) {
                this.retrieveIndexColumns(index);
            }
            this.retrieveForeignKeys(table);
        }

        private void retrieveIndexColumns(@NotNull SqliteModIndex index) {
            if (index == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(4);
            }
            SqliteIntrospector.this.updateDetails(String.format("introspecting columns of index %s", index.getName()));
            this.getQueryParameters().put("INDEX", SqliteIntroQueries.quote(index.getName()));
            try {
                List<SqliteIntroQueries.IndexColumnInfo> indexColumnInfos = this.performQuery(SqliteIntroQueries.QUERIES.listIndexColumns);
                indexColumnInfos.sort((o1, o2) -> Comparing.compare((Comparable)o1.seqno, (Comparable)o2.seqno));
                ArrayList cols = ContainerUtil.newArrayListWithCapacity((int)indexColumnInfos.size());
                ArrayList collations = ContainerUtil.newArrayListWithCapacity((int)indexColumnInfos.size());
                LinkedHashSet rev = ContainerUtil.newLinkedHashSet();
                int cnt = 1;
                String prefix = null;
                for (SqliteIntroQueries.IndexColumnInfo info : indexColumnInfos) {
                    String name;
                    if (info.key != 1) continue;
                    if (info.name != null) {
                        name = SqliteIntrospector.fixName(info.name, index.getTable().getColumns());
                    } else {
                        if (prefix == null) {
                            prefix = this.findPlaceholderPrefix(indexColumnInfos);
                        }
                        name = prefix + cnt;
                        ++cnt;
                    }
                    cols.add(name);
                    if (info.desc == 1) {
                        rev.add(name);
                    }
                    collations.add(StringUtil.notNullize((String)SqliteIntrospector.fixName(info.coll, ((SqliteModModel)this.getModel()).getRoot().getCollations())));
                }
                index.setColNames(cols);
                index.setReverseColNames(rev);
                index.setColumnCollations(collations);
            }
            catch (DBException e) {
                LOG.warn(String.format("Failed to retrieve columns of index %s", index.getName()), (Throwable)e);
            }
        }

        private String findPlaceholderPrefix(List<SqliteIntroQueries.IndexColumnInfo> indexColumnInfos) {
            int num = 0;
            for (SqliteIntroQueries.IndexColumnInfo info : indexColumnInfos) {
                int cnt;
                if (info.name == null) continue;
                for (cnt = 0; cnt < info.name.length() && info.name.charAt(cnt) == '#'; ++cnt) {
                }
                if (num >= cnt) continue;
                num = cnt;
            }
            return StringUtil.repeat((String)"#", (int)(num + 1));
        }

        private void retrieveIndices(@NotNull SqliteModTable table) {
            if (table == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(5);
            }
            SqliteIntrospector.this.updateDetails(String.format("introspecting indices of %s", table.getName()));
            NamingFamily indices = table.getIndices();
            indices.markChildrenAsSyncPending();
            try {
                List<SqliteIntroQueries.IndexInfo> indexInfos = this.performQuery(SqliteIntroQueries.QUERIES.listIndices);
                for (SqliteIntroQueries.IndexInfo indexInfo : indexInfos) {
                    SqliteModIndex index = (SqliteModIndex)indices.createOrGet(indexInfo.name);
                    index.setUnique(indexInfo.unique == 1);
                    index.setNameSurrogate(index.getName().startsWith("sqlite_autoindex_"));
                }
            }
            catch (DBException e) {
                LOG.warn(String.format("Failed to retrieve indices of %s", table.getName()), (Throwable)e);
            }
            indices.removeSyncPendingChildren();
            indices.sort();
        }

        private void retrieveForeignKeys(@NotNull SqliteModTable table) {
            if (table == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(6);
            }
            SqliteIntrospector.this.updateDetails(String.format("introspecting foreign keys of %s", table.getName()));
            NamingFamily foreignKeys = table.getForeignKeys();
            foreignKeys.markChildrenAsSyncPending();
            try {
                List<SqliteIntroQueries.ForeignKeyInfo> foreignKeyInfos = this.performQuery(SqliteIntroQueries.QUERIES.listForeignKeys);
                TIntObjectHashMap groups = new TIntObjectHashMap();
                for (SqliteIntroQueries.ForeignKeyInfo foreignKeyInfo : foreignKeyInfos) {
                    List list = (List)groups.get(foreignKeyInfo.id.intValue());
                    if (list == null) {
                        list = ContainerUtil.newArrayList();
                        groups.put(foreignKeyInfo.id.intValue(), (Object)list);
                    }
                    list.add(foreignKeyInfo);
                }
                HashSet visited = ContainerUtil.newHashSet();
                groups.forEachValue(arg_0 -> this.lambda$retrieveForeignKeys$8(table, (ModNamingFamily)foreignKeys, visited, arg_0));
            }
            catch (DBException e) {
                LOG.warn(String.format("Failed to retrieve foreign keys of %s", table.getName()), (Throwable)e);
            }
            foreignKeys.removeSyncPendingChildren();
        }

        private void retrieveColumns(@NotNull SqliteModLikeTable table) {
            if (table == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(7);
            }
            this.getQueryParameters().put("TABLE", SqliteIntroQueries.quote(table.getName()));
            SqliteIntrospector.this.updateDetails(String.format("introspecting columns of %s", table.getName()));
            PositioningNamingFamily columns2 = table.getColumns();
            columns2.markChildrenAsSyncPending();
            try {
                if (table instanceof SqliteModView) {
                    ((SqliteModView)table).setInvalid(false);
                }
                List<SqliteIntroQueries.ColumnInfo> columnInfos = this.performQuery(SqliteIntroQueries.QUERIES.listColumns);
                for (SqliteIntroQueries.ColumnInfo columnInfo : columnInfos) {
                    SqliteModLikeColumn column = (SqliteModLikeColumn)columns2.createOrGetAt((short)(columnInfo.cid.shortValue() + 1));
                    column.setName(columnInfo.name);
                    column.setDataType(StringUtil.isEmpty((String)columnInfo.type) ? DataType.UNKNOWN : DataTypeFactory.of(columnInfo.type));
                    column.setNotNull(columnInfo.notnull == 1);
                    column.setDefaultExpression(columnInfo.dflt_value);
                }
            }
            catch (DBException e) {
                String msg = e.getMessage();
                if (msg != null && msg.contains("no such table")) {
                    if (table instanceof SqliteModView) {
                        ((SqliteModView)table).setInvalid(true);
                    }
                }
                LOG.warn(String.format("Failed to retrieve columns of %s", table.getName()), (Throwable)e);
            }
            columns2.removeSyncPendingChildren();
        }

        private void retrieveSourcesAndExtras() {
            List<SqliteIntroQueries.SourceInfo> sourceInfos = this.performQuery(SqliteIntrospector.isTemp(((SqliteSchema)this.getSchema()).getName()) ? SqliteIntroQueries.QUERIES.retrieveTempSources : SqliteIntroQueries.QUERIES.retrieveSources);
            ((SqliteModModel)this.getModel()).modify((BasicElement)this.getSchema(), SqliteModSchema.class, s -> s.getModel().writeSources(() -> {
                for (SqliteModLikeTable t : s.getTables()) {
                    t.getTriggers().markChildrenAsSyncPending();
                }
                for (SqliteModLikeTable t : s.getViews()) {
                    t.getTriggers().markChildrenAsSyncPending();
                }
                for (SqliteIntroQueries.SourceInfo sourceInfo : sourceInfos) {
                    SqliteIntrospector.this.updateDetails(String.format("introspecting sources of %s %s", sourceInfo.type, sourceInfo.name));
                    SqliteModLikeTable table = (SqliteModLikeTable)s.getLikeTable(sourceInfo.tbl_name);
                    if (table == null) continue;
                    ObjectKind kind = SqliteIntrospector.getKind(sourceInfo.type, sourceInfo.rootpage);
                    if (kind == ObjectKind.TRIGGER) {
                        this.fillTrigger(sourceInfo, table);
                        continue;
                    }
                    if (kind == ObjectKind.INDEX) {
                        this.fillIndex(sourceInfo, table);
                        continue;
                    }
                    if (kind == ObjectKind.TABLE) {
                        this.fillTable(sourceInfo, table);
                        continue;
                    }
                    if (kind == ObjectKind.VIRTUAL_TABLE) {
                        this.fillVirtualTable(sourceInfo, table);
                        continue;
                    }
                    if (kind != ObjectKind.VIEW) continue;
                    this.fillView(sourceInfo, table);
                }
                for (SqliteModLikeTable t : s.getTables()) {
                    t.getTriggers().removeSyncPendingChildren();
                    t.getTriggers().sort();
                    t.getForeignKeys().sort();
                    t.getIndices().sort();
                    this.cleanupIndices((SqliteModTable)t);
                }
                for (SqliteModLikeTable t : s.getViews()) {
                    t.getTriggers().removeSyncPendingChildren();
                    t.getTriggers().sort();
                }
            }));
        }

        private void cleanupIndices(SqliteModTable t) {
            Iterator iterator = t.getKeys().iterator();
            while (iterator.hasNext()) {
                SqliteModKey key;
                List<String> cols = (key = (SqliteModKey)iterator.next()).getColNames();
                SqliteModIndex index = this.findAutoIndexByCols(t, cols);
                key.setUnderlyingIndexName(index == null ? null : index.getName());
            }
            PositioningNamingFamily columns2 = t.getColumns();
            for (SqliteModIndex index : t.getIndices()) {
                List<String> cols = index.getColNames();
                List<String> collations = index.getColumnCollations();
                ArrayList newCollations = null;
                for (int i2 = 0; i2 < collations.size(); ++i2) {
                    String columnCollation;
                    String collation = collations.get(i2);
                    SqliteTableColumn column = i2 < cols.size() ? (SqliteModTableColumn)SqliteIntrospector.findObject(cols.get(i2), columns2) : null;
                    String string = columnCollation = column == null ? null : column.getCollation();
                    if (columnCollation == null) {
                        columnCollation = "binary";
                    }
                    if (!columnCollation.equalsIgnoreCase(collation)) continue;
                    if (newCollations == null) {
                        newCollations = ContainerUtil.newArrayList(collations);
                    }
                    newCollations.set(i2, "");
                }
                if (newCollations == null) continue;
                index.setColumnCollations(newCollations);
            }
        }

        private void fillView(SqliteIntroQueries.SourceInfo info, SqliteModLikeTable tbl) {
            SqliteModView view2 = (SqliteModView)ObjectUtils.tryCast((Object)tbl, SqliteModView.class);
            if (view2 == null) {
                return;
            }
            String text = info.sql;
            if (text != null) {
                view2.setSourceText(BaseIntrospectionFunctions.toCompositeText(info.sql, CompositeText.Kind.ORIGINAL_TEXT));
            } else {
                view2.setSourceText(null);
            }
        }

        private void fillTable(SqliteIntroQueries.SourceInfo info, SqliteModLikeTable tbl) {
            SqliteModTable table = (SqliteModTable)ObjectUtils.tryCast((Object)tbl, SqliteModTable.class);
            if (table == null) {
                return;
            }
            table.getKeys().markChildrenAsSyncPending();
            table.getChecks().markChildrenAsSyncPending();
            SqlCreateTableStatement stmt = this.getStatement(info.sql, SqlCreateTableStatement.class);
            SqlDefinition[] defs = (SqlDefinition[])PsiTreeUtil.getChildrenOfType((PsiElement)stmt, SqlDefinition.class);
            if (defs != null) {
                for (SqlDefinition[] column : table.getColumns()) {
                    column.setSequenceIdentity(null);
                }
                ArrayList foreignKeys = ContainerUtil.newArrayList();
                for (SqlDefinition def : defs) {
                    if (def instanceof SqlColumnDefinition) {
                        this.fillColumn(table, (SqlColumnDefinition)def, foreignKeys);
                        continue;
                    }
                    if (def instanceof SqlForeignKeyDefinition) {
                        foreignKeys.add((SqlForeignKeyDefinition)def);
                        continue;
                    }
                    if (def instanceof SqlTableKeyDefinition) {
                        this.fillTableKey(table, (SqlTableKeyDefinition)def);
                        continue;
                    }
                    if (!(def instanceof SqlConstraintDefinition)) continue;
                    this.fillConstraint(table, (SqlConstraintDefinition)def);
                }
                foreignKeys.sort((o1, o2) -> StringUtil.isEmpty((String)o1.getName()) ? (StringUtil.isEmpty((String)o2.getName()) ? 0 : 1) : (StringUtil.isEmpty((String)o2.getName()) ? -1 : 0));
                HashSet visited = ContainerUtil.newHashSet();
                for (SqlForeignKeyDefinition def : foreignKeys) {
                    this.fillForeignKey(table, def, visited);
                }
            }
            table.setWithoutRowId(SqliteIntrospector.findChild((PsiElement)stmt, LazyData.SQL_WITHOUT_ROWID_CLAUSE) != null);
            table.getKeys().removeSyncPendingChildren();
            table.getKeys().sort();
            table.getChecks().removeSyncPendingChildren();
            table.getChecks().sort();
        }

        private void fillVirtualTable(SqliteIntroQueries.SourceInfo info, SqliteModLikeTable tbl) {
            SqliteModVirtualTable table = (SqliteModVirtualTable)ObjectUtils.tryCast((Object)tbl, SqliteModVirtualTable.class);
            if (table == null) {
                return;
            }
            SqlCreateStatement stmt = this.getStatement(info.sql, SqlCreateStatement.class);
            SqlClause moduleClause = (SqlClause)PsiTreeUtil.getChildOfType((PsiElement)stmt, SqlClause.class);
            SqlReferenceExpression moduleRef = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)moduleClause, SqlReferenceExpression.class);
            table.setModule(moduleRef == null ? null : moduleRef.getName());
            SqlClause[] moduleArguments = (SqlClause[])PsiTreeUtil.getChildrenOfType((PsiElement)moduleClause, SqlClause.class);
            if (moduleArguments != null) {
                ArrayList args = ContainerUtil.newArrayList();
                for (SqlClause argument : moduleArguments) {
                    args.add(argument.getText());
                }
                table.setArguments(args);
            } else {
                table.setArguments(Collections.emptyList());
            }
            table.setModule(moduleRef == null ? null : moduleRef.getName());
        }

        private void fillConstraint(SqliteModTable table, SqlConstraintDefinition def) {
            SqliteModCheck check;
            String exprText;
            if (def.getConstraintType() != SqlConstraintDefinition.Type.CHECK) {
                return;
            }
            String name = StringUtil.nullize((String)def.getName());
            SqlExpression expr = (SqlExpression)def.getConstraintParameter(SqlConstraintDefinition.EXPRESSION);
            String string = exprText = expr == null ? null : expr.getText();
            if (name != null) {
                check = (SqliteModCheck)table.getChecks().createOrGet(name);
            } else {
                check = table.getChecks().find(c -> c.isSyncPending() && c.getRealName() == null && Comparing.equal((String)exprText, (String)c.getPredicate()));
                if (check == null) {
                    check = (SqliteModCheck)table.getChecks().createNewOne();
                } else {
                    check.resetSyncPending();
                }
            }
            check.setPredicate(exprText);
            check.setOnConflict(SqliteIntrospector.getConflictResolution((PsiElement)def));
        }

        private void fillTableKey(SqliteModTable table, SqlTableKeyDefinition def) {
            SqliteModKey key;
            String name = StringUtil.nullize((String)def.getName());
            ArrayList cols = ContainerUtil.newArrayList((Iterable)def.getColumnsRef().names());
            SqliteIntrospector.fixNames(cols, table.getColumns());
            boolean primary = def.isPrimary();
            if (name != null) {
                key = (SqliteModKey)table.getKeys().createOrGet(name);
            } else {
                key = table.getKeys().find(k -> k.isSyncPending() && k.getRealName() == null && this.keyMatches((SqliteModKey)k, cols, primary));
                if (key == null) {
                    key = (SqliteModKey)table.getKeys().createNewOne();
                } else {
                    key.resetSyncPending();
                }
            }
            key.setPrimary(primary);
            key.setColNames(cols);
            key.setOnConflict(SqliteIntrospector.getConflictResolution((PsiElement)def));
        }

        private void fillForeignKey(SqliteModTable table, SqlForeignKeyDefinition def, Set<SqliteModForeignKey> visited) {
            SqliteModForeignKey matchedByName;
            String name = StringUtil.nullize((String)def.getName());
            SqliteModForeignKey sqliteModForeignKey = matchedByName = name != null ? (SqliteModForeignKey)table.getForeignKeys().get(name, false) : null;
            if (visited.contains(matchedByName)) {
                matchedByName = null;
            }
            SqliteModTable refTable = (SqliteModTable)SqliteIntrospector.findObject(def.getRefTableName(), table.getParentFamily());
            ArrayList refCols = ContainerUtil.newArrayList((Iterable)def.getRefColumns().names());
            ArrayList cols = ContainerUtil.newArrayList((Iterable)def.getColumnsRef().names());
            if (refTable != null) {
                SqliteIntrospector.fixNames(refCols, refTable.getColumns());
            }
            SqliteIntrospector.fixNames(cols, table.getColumns());
            CascadeRule onUpdate = this.toCascadeRule(def.getUpdateRule());
            CascadeRule onDelete = this.toCascadeRule(def.getDeleteRule());
            DasForeignKey.Deferrability deferrability = def.getDeferrability();
            SqliteModForeignKey target = null;
            for (int step = 0; step < 2 && target == null; ++step) {
                if (matchedByName != null && this.fkMatches(matchedByName, name, cols, refCols, onDelete, onUpdate, step == 0)) {
                    target = matchedByName;
                } else {
                    SqliteModForeignKey foreignKey = this.findFk(table.getForeignKeys(), refTable == null ? def.getRefTableName() : refTable.getName(), cols, refCols, onDelete, onUpdate, visited, step == 0);
                    if (foreignKey != null) {
                        target = foreignKey;
                    }
                }
                if (step != 1 || target == null) continue;
                LOG.warn("Partial match: " + def.getNameElement() + " sql: " + (Object)((Object)onUpdate) + ", " + (Object)((Object)onDelete) + " db: " + (Object)((Object)target.getOnUpdate()) + ", " + (Object)((Object)target.getOnDelete()));
            }
            if (target == null) {
                LOG.warn("Unmatched FK: " + def.getName());
                return;
            }
            boolean deferred = deferrability == DasForeignKey.Deferrability.INITIALLY_DEFERRED;
            target.setDeferrable(deferred);
            target.setInitiallyDeferred(deferred);
            visited.add(target);
            target.setRealName(name);
        }

        private void fillColumn(SqliteModTable table, SqlColumnDefinition columnDef, List<SqlForeignKeyDefinition> foreignKeys) {
            SqlDefinition[] defs = (SqlDefinition[])PsiTreeUtil.getChildrenOfType((PsiElement)columnDef, SqlDefinition.class);
            String name = columnDef.getName();
            SqliteModTableColumn column = table.getColumns().find(c -> c.getName().equalsIgnoreCase(name));
            String collationName = null;
            if (defs != null) {
                for (SqlDefinition def : defs) {
                    if (def instanceof SqlForeignKeyDefinition) {
                        foreignKeys.add((SqlForeignKeyDefinition)def);
                        continue;
                    }
                    if (def instanceof SqlTableKeyDefinition) {
                        this.fillTableKey(table, (SqlTableKeyDefinition)def);
                        continue;
                    }
                    if (!(def instanceof SqlConstraintDefinition)) continue;
                    SqlConstraintDefinition constraint = (SqlConstraintDefinition)def;
                    SqlConstraintDefinition.Type type = constraint.getConstraintType();
                    if (column != null) {
                        if (type == SqlConstraintDefinition.Type.COLLATE) {
                            SqlExpression collationRef = (SqlExpression)constraint.getConstraintParameter(SqlConstraintDefinition.EXPRESSION);
                            collationName = collationRef == null ? null : collationRef.getText();
                        } else if (type == SqlConstraintDefinition.Type.NULLABLE) {
                            column.setOnNullConflict(SqliteIntrospector.getConflictResolution((PsiElement)def));
                        }
                    }
                    this.fillConstraint(table, constraint);
                }
            }
            if (column != null) {
                if ("binary".equalsIgnoreCase(collationName)) {
                    collationName = null;
                }
                column.setCollation(SqliteIntrospector.fixName(collationName, ((SqliteModModel)this.getModel()).getRoot().getCollations()));
                column.setSequenceIdentity(SqliteIntrospector.findChild((PsiElement)columnDef, LazyData.SQL_AUTOINCREMENT_CLAUSE) == null ? null : SEQUENCE_IDENTITY);
            }
        }

        private void fillIndex(SqliteIntroQueries.SourceInfo info, SqliteModLikeTable tbl) {
            SqliteModTable table = (SqliteModTable)ObjectUtils.tryCast((Object)tbl, SqliteModTable.class);
            if (table == null) {
                return;
            }
            SqliteModIndex index = (SqliteModIndex)table.getIndices().createOrGet(info.name);
            SqlCreateIndexStatement stmt = this.getStatement(info.sql, SqlCreateIndexStatement.class);
            SqlWhereClause where = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)stmt, SqlWhereClause.class);
            SqlExpression whereExpr = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)where, SqlExpression.class);
            index.setCondition(whereExpr == null ? null : whereExpr.getText());
            SqlReferenceExpression tableRef = stmt == null ? null : stmt.getTableReference();
            SqlTableColumnsList columnsList = tableRef == null ? null : (SqlTableColumnsList)ObjectUtils.tryCast((Object)tableRef.getParent(), SqlTableColumnsList.class);
            SqlReferenceList columns2 = columnsList == null ? null : columnsList.getColumnsReferenceList();
            SqlExpression[] columnExprs = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)columns2, SqlExpression.class);
            if (columnExprs != null) {
                List<String> names = index.getColNames();
                if (columnExprs.length != names.size()) {
                    LOG.warn("Index columns mismatch `" + StringUtil.join(names, (String)", ") + "` and `" + columns2.getText());
                }
                Set<String> rev = index.getReverseColNames();
                ArrayList newNames = ContainerUtil.newArrayListWithCapacity((int)columnExprs.length);
                LinkedHashSet newRev = ContainerUtil.newLinkedHashSet();
                for (int i2 = 0; i2 < columnExprs.length; ++i2) {
                    boolean curRev;
                    SqlExpression expr = columnExprs[i2];
                    boolean bl = curRev = i2 < names.size() && rev.contains(names.get(i2));
                    if (expr instanceof SqlReferenceExpression && i2 < names.size()) {
                        newNames.add(SqliteIntrospector.fixName(names.get(i2), tbl.getColumns()));
                    } else {
                        newNames.add(expr.getText());
                    }
                    if (!curRev) continue;
                    newRev.add(newNames.get(newNames.size() - 1));
                }
                index.setColNames(newNames);
                index.setReverseColNames(newRev);
            }
        }

        private void fillTrigger(@NotNull SqliteIntroQueries.SourceInfo info, @NotNull SqliteModLikeTable tbl) {
            PsiElement element;
            if (info == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(8);
            }
            if (tbl == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(9);
            }
            SqliteModTrigger trigger2 = (SqliteModTrigger)tbl.getTriggers().createOrGet(info.name);
            String sourceText = info.sql;
            if (sourceText != null) {
                trigger2.setSourceText(BaseIntrospectionFunctions.toCompositeText(sourceText, CompositeText.Kind.ORIGINAL_TEXT));
            } else {
                trigger2.setSourceText(null);
            }
            SqlCreateTriggerStatement stmt = this.getStatement(info.sql, SqlCreateTriggerStatement.class);
            TrigTurn turn = null;
            TrigEvent event = null;
            List<String> cols = null;
            SqlNameElement name = stmt == null ? null : stmt.getNameElement();
            PsiElement afterName = this.skipUnsignificant(name == null ? null : name.getNextSibling());
            if (afterName instanceof SqlClause && (element = this.skipUnsignificant(afterName.getFirstChild())) != null) {
                String text = element.getText();
                event = this.getEvent(text);
                if (event == null) {
                    turn = this.getTurn(text);
                    PsiElement nextClause = this.skipUnsignificant(afterName.getNextSibling());
                    if (nextClause instanceof SqlClause && (element = this.skipUnsignificant(nextClause.getFirstChild())) != null) {
                        text = element.getText();
                        event = this.getEvent(text);
                        cols = this.getColumns(nextClause);
                    }
                } else {
                    cols = this.getColumns(afterName);
                }
            }
            turn = turn == null ? TrigTurn.BEFORE_ROW : turn;
            SqlWhenClause when = (SqlWhenClause)PsiTreeUtil.getChildOfType((PsiElement)stmt, SqlWhenClause.class);
            SqlExpression whenExpr = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)when, SqlExpression.class);
            trigger2.setCondition(whenExpr == null ? null : whenExpr.getText());
            trigger2.setTurn(turn);
            trigger2.setColNames(cols == null ? Collections.emptyList() : cols);
            trigger2.setEvents(event == null ? Collections.emptySet() : Collections.singleton(event));
        }

        @Nullable
        private List<String> getColumns(@NotNull PsiElement el) {
            SqlReferenceExpression[] cols;
            if (el == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(10);
            }
            if ((cols = (SqlReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)el, SqlReferenceExpression.class)) == null) {
                return null;
            }
            ArrayList names = ContainerUtil.newArrayList();
            for (SqlReferenceExpression col : cols) {
                names.add(col.getName());
            }
            return names;
        }

        @Nullable
        private TrigEvent getEvent(@NotNull String text) {
            if (text == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(11);
            }
            if (text.equalsIgnoreCase("insert")) {
                return TrigEvent.INSERT;
            }
            if (text.equalsIgnoreCase("delete")) {
                return TrigEvent.DELETE;
            }
            if (text.equalsIgnoreCase("update")) {
                return TrigEvent.UPDATE;
            }
            return null;
        }

        @Nullable
        private TrigTurn getTurn(@NotNull String text) {
            if (text == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(12);
            }
            if (text.equalsIgnoreCase("before")) {
                return TrigTurn.BEFORE_ROW;
            }
            if (text.equalsIgnoreCase("after")) {
                return TrigTurn.AFTER_ROW;
            }
            if (text.equalsIgnoreCase("instead")) {
                return TrigTurn.INSTEAD_OF;
            }
            return null;
        }

        @Nullable
        private PsiElement skipUnsignificant(@Nullable PsiElement el) {
            while (el instanceof PsiWhiteSpace || el instanceof PsiComment) {
                el = el.getNextSibling();
            }
            return el;
        }

        @Nullable
        private <T extends SqlStatement> T getStatement(@Nullable String sql, @NotNull Class<T> clazz) {
            if (clazz == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(13);
            }
            if (sql == null) {
                return null;
            }
            try {
                return (T)((SqlStatement)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)SqliteIntrospector.this.myReader.getReadOnlyPsi(SqliteIntrospector.this.myLanguage, (CharSequence)sql)).expandAndSkip(e -> !(e instanceof SqlStatement))).filter(clazz).first());
            }
            catch (Exception e2) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error((Throwable)e2);
                }
                LOG.warn("Failed to parse sources", (Throwable)e2);
                return null;
            }
        }

        private SqliteModIndex findAutoIndexByCols(SqliteModTable t, List<String> cols) {
            SqliteModIndex res = null;
            int grade = 0;
            for (int i2 = 0; i2 < 2; ++i2) {
                Iterator iterator = t.getIndices().iterator();
                while (iterator.hasNext()) {
                    int g;
                    SqliteModIndex index;
                    if (i2 == 0 == !(index = (SqliteModIndex)iterator.next()).getName().startsWith("sqlite_autoindex_") || (g = this.indexGrade(cols, index.getColNames())) <= grade) continue;
                    grade = g;
                    res = index;
                }
            }
            return res;
        }

        private SqliteModForeignKey findFk(Family<? extends SqliteModForeignKey> fks, @Nullable String refTable, @NotNull List<String> cols, @NotNull List<String> refCols, @NotNull CascadeRule onDelete, @NotNull CascadeRule onUpdate, @NotNull Set<SqliteModForeignKey> ignore, boolean full) {
            if (cols == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(14);
            }
            if (refCols == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(15);
            }
            if (onDelete == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(16);
            }
            if (onUpdate == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(17);
            }
            if (ignore == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(18);
            }
            return fks.find(fk -> {
                if (ignore == null) {
                    SqliteSchemaRetriever.$$$reportNull$$$0(34);
                }
                if (cols == null) {
                    SqliteSchemaRetriever.$$$reportNull$$$0(35);
                }
                if (refCols == null) {
                    SqliteSchemaRetriever.$$$reportNull$$$0(36);
                }
                if (onDelete == null) {
                    SqliteSchemaRetriever.$$$reportNull$$$0(37);
                }
                if (onUpdate == null) {
                    SqliteSchemaRetriever.$$$reportNull$$$0(38);
                }
                if (ignore.contains(fk)) {
                    return false;
                }
                return this.fkMatches((SqliteModForeignKey)fk, refTable, cols, refCols, onDelete, onUpdate, full);
            });
        }

        private boolean fkMatches(SqliteModForeignKey fk, @Nullable String refTable, @NotNull List<String> cols, @NotNull List<String> refCols, @NotNull CascadeRule onDelete, @NotNull CascadeRule onUpdate, boolean full) {
            if (cols == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(19);
            }
            if (refCols == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(20);
            }
            if (onDelete == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(21);
            }
            if (onUpdate == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(22);
            }
            if (!Comparing.strEqual((String)fk.getRefTableName(), (String)refTable, (boolean)false)) {
                return false;
            }
            if (!this.equalInsensitive(fk.getColNames(), cols)) {
                return false;
            }
            if (!this.equalInsensitive(fk.getRefColNames(), refCols)) {
                return false;
            }
            if (full && !Comparing.equal((Object)((Object)fk.getOnDelete()), (Object)((Object)onDelete))) {
                return false;
            }
            return !full || Comparing.equal((Object)((Object)fk.getOnUpdate()), (Object)((Object)onUpdate));
        }

        private boolean keyMatches(SqliteModKey key, @NotNull List<String> cols, boolean primary) {
            if (cols == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(23);
            }
            if (!this.equalInsensitive(key.getColNames(), cols)) {
                return false;
            }
            return primary != key.isPrimary();
        }

        private boolean equalInsensitive(@NotNull List<String> a, @NotNull List<String> b) {
            if (a == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(24);
            }
            if (b == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(25);
            }
            if (a.size() != b.size()) {
                return false;
            }
            for (int i2 = 0; i2 < a.size(); ++i2) {
                if (Comparing.strEqual((String)a.get(i2), (String)b.get(i2), (boolean)false)) continue;
                return false;
            }
            return true;
        }

        private int indexGrade(@NotNull List<String> keyCol, @NotNull List<String> idxCol) {
            if (keyCol == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(26);
            }
            if (idxCol == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(27);
            }
            if (keyCol.size() > idxCol.size()) {
                return 0;
            }
            for (int i2 = 0; i2 < keyCol.size(); ++i2) {
                if (Comparing.strEqual((String)keyCol.get(i2), (String)idxCol.get(i2), (boolean)false)) continue;
                return i2;
            }
            return keyCol.size();
        }

        private CascadeRule toCascadeRule(String rule) {
            if (rule == null || rule.equalsIgnoreCase("no action")) {
                return CascadeRule.no_action;
            }
            if (rule.equalsIgnoreCase("restrict")) {
                return CascadeRule.restrict;
            }
            if (rule.equalsIgnoreCase("set null")) {
                return CascadeRule.set_null;
            }
            if (rule.equalsIgnoreCase("set default")) {
                return CascadeRule.set_default;
            }
            if (rule.equalsIgnoreCase("cascade")) {
                return CascadeRule.cascade;
            }
            return CascadeRule.no_action;
        }

        @NotNull
        private CascadeRule toCascadeRule(@Nullable DasForeignKey.RuleAction rule) {
            if (rule == null) {
                CascadeRule cascadeRule = CascadeRule.no_action;
                if (cascadeRule == null) {
                    SqliteSchemaRetriever.$$$reportNull$$$0(28);
                }
                return cascadeRule;
            }
            switch (rule) {
                case RESTRICT: {
                    CascadeRule cascadeRule = CascadeRule.restrict;
                    if (cascadeRule == null) {
                        SqliteSchemaRetriever.$$$reportNull$$$0(29);
                    }
                    return cascadeRule;
                }
                case SET_NULL: {
                    CascadeRule cascadeRule = CascadeRule.set_null;
                    if (cascadeRule == null) {
                        SqliteSchemaRetriever.$$$reportNull$$$0(30);
                    }
                    return cascadeRule;
                }
                case SET_DEFAULT: {
                    CascadeRule cascadeRule = CascadeRule.set_default;
                    if (cascadeRule == null) {
                        SqliteSchemaRetriever.$$$reportNull$$$0(31);
                    }
                    return cascadeRule;
                }
                case CASCADE: {
                    CascadeRule cascadeRule = CascadeRule.cascade;
                    if (cascadeRule == null) {
                        SqliteSchemaRetriever.$$$reportNull$$$0(32);
                    }
                    return cascadeRule;
                }
            }
            CascadeRule cascadeRule = CascadeRule.no_action;
            if (cascadeRule == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(33);
            }
            return cascadeRule;
        }

        private /* synthetic */ boolean lambda$retrieveForeignKeys$8(@NotNull SqliteModTable table, ModNamingFamily foreignKeys, Set visited, List list) {
            if (table == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(39);
            }
            list.sort((o1, o2) -> Comparing.compare((Comparable)o1.seq, (Comparable)o2.seq));
            ArrayList from = ContainerUtil.newArrayListWithCapacity((int)list.size());
            ArrayList to = ContainerUtil.newArrayListWithCapacity((int)list.size());
            for (SqliteIntroQueries.ForeignKeyInfo aList : list) {
                from.add(aList.from);
                to.add(aList.to);
            }
            SqliteIntroQueries.ForeignKeyInfo foreignKeyInfo = (SqliteIntroQueries.ForeignKeyInfo)list.get(0);
            CascadeRule onDelete = this.toCascadeRule(foreignKeyInfo.on_delete);
            CascadeRule onUpdate = this.toCascadeRule(foreignKeyInfo.on_update);
            String fixedRefName = SqliteIntrospector.fixName(foreignKeyInfo.table, table.getParentFamily());
            SqliteModForeignKey foreignKey = this.findFk(foreignKeys, fixedRefName, from, to, onDelete, onUpdate, visited, true);
            if (foreignKey == null) {
                foreignKey = (SqliteModForeignKey)foreignKeys.createNewOne();
                foreignKey.setRefTableName(fixedRefName);
                foreignKey.setColNames(from);
                foreignKey.setRefColNames(to);
                foreignKey.setOnDelete(onDelete);
                foreignKey.setOnUpdate(onUpdate);
            } else {
                foreignKey.resetSyncPending();
            }
            visited.add(foreignKey);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "0";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transaction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 39: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "index";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tbl";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "el";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 14: 
                case 19: 
                case 23: 
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cols";
                    break;
                }
                case 15: 
                case 20: 
                case 36: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refCols";
                    break;
                }
                case 16: 
                case 21: 
                case 37: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onDelete";
                    break;
                }
                case 17: 
                case 22: 
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onUpdate";
                    break;
                }
                case 18: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignore";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyCol";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idxCol";
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever";
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toCascadeRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "retrieveIndicesAndForeignKeys";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "retrieveIndexColumns";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "retrieveIndices";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "retrieveForeignKeys";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "retrieveColumns";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "fillTrigger";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumns";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getEvent";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getTurn";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatement";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "findFk";
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "fkMatches";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "keyMatches";
                    break;
                }
                case 24: 
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "equalInsensitive";
                    break;
                }
                case 26: 
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "indexGrade";
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    break;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$findFk$16";
                    break;
                }
                case 39: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$retrieveForeignKeys$8";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LazyData {
        public static final IElementType SQL_AUTOINCREMENT_CLAUSE = (IElementType)ObjectUtils.assertNotNull((Object)SqlTokenRegistry.findCompositeType((String)"SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE"));
        public static final IElementType SQL_WITHOUT_ROWID_CLAUSE = (IElementType)ObjectUtils.assertNotNull((Object)SqlTokenRegistry.findCompositeType((String)"SQLITE_WITHOUT_ROWID_CLAUSE"));
        public static final IElementType SQL_CONFLICT_CLAUSE = (IElementType)ObjectUtils.assertNotNull((Object)SqlTokenRegistry.findCompositeType((String)"SQLITE_CONFLICT_CLAUSE"));

        private LazyData() {
        }
    }
}

