/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.introspection.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntHashSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class TableColumnIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.TableColumn> {
    private final DatabaseFamilyId myFamilyId;
    private final DatabaseMetaDataWrapper.Schema mySchema;
    private final TIntHashSet myPositions;
    private String myPrevName;

    public TableColumnIt(@NotNull ResultSet rs, @NotNull DatabaseFamilyId familyId, @NotNull DatabaseMetaDataWrapper.Schema schema) throws SQLException {
        if (rs == null) {
            TableColumnIt.$$$reportNull$$$0(0);
        }
        if (familyId == null) {
            TableColumnIt.$$$reportNull$$$0(1);
        }
        if (schema == null) {
            TableColumnIt.$$$reportNull$$$0(2);
        }
        super(rs);
        this.myPositions = new TIntHashSet();
        this.myFamilyId = familyId;
        this.mySchema = schema;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.TableColumn createStorage() {
        DatabaseMetaDataWrapper.TableColumn tableColumn = new DatabaseMetaDataWrapper.TableColumn(new DatabaseMetaDataWrapper.Table(this.mySchema, ""));
        if (tableColumn == null) {
            TableColumnIt.$$$reportNull$$$0(3);
        }
        return tableColumn;
    }

    @Override
    protected DatabaseMetaDataWrapper.TableColumn calcValue() throws SQLException {
        DatabaseMetaDataWrapper.TableColumn res = (DatabaseMetaDataWrapper.TableColumn)this.getStorageToFill();
        try {
            String table = this.myRs.getString("TABLE_NAME", 3);
            String cat = this.myRs.getString("TABLE_CAT", 1);
            String schema = StringUtil.notNullize((String)this.myRs.getString("TABLE_SCHEM", 2), (String)this.mySchema.schema);
            if (!Comparing.equal((String)this.mySchema.schema, (String)schema)) {
                return (DatabaseMetaDataWrapper.TableColumn)this.skip();
            }
            if (StringUtil.isEmpty((String)table)) {
                return (DatabaseMetaDataWrapper.TableColumn)this.skip();
            }
            if (!Comparing.equal((String)this.myPrevName, (String)table)) {
                this.myPositions.clear();
                this.myPrevName = table;
            }
            res.table.name = table;
            res.name = this.myRs.getString("COLUMN_NAME", 4);
            if (StringUtil.isEmpty((String)res.name)) {
                return (DatabaseMetaDataWrapper.TableColumn)this.skip();
            }
            res.type = this.myRs.getInt("DATA_TYPE", 5, 0);
            res.typeName = StringUtil.notNullize((String)this.myRs.getString("TYPE_NAME", 6));
            res.length = this.myRs.getInt("COLUMN_SIZE", 7, 0);
            res.scale = this.myRs.getInt("DECIMAL_DIGITS", 9, 0);
            MetaDataUtil.adjustLengthAndScale(this.myFamilyId, res);
            res.nullable = this.myRs.getInt("NULLABLE", 11, 0) != 0;
            res.def = this.myRs.getString("COLUMN_DEF", 13);
            res.position = this.myRs.getInt("ORDINAL_POSITION", 17, 0);
            if (res.position == -1) {
                res.position = 0;
            }
            while (this.myPositions.contains(res.position)) {
                ++res.position;
            }
            this.myPositions.add(res.position);
            res.comment = this.myRs.getString("REMARKS", 12);
            String aincYN = this.myRs.getString("IS_AUTOINCREMENT", 23);
            res.autoIncrement = "yes".equalsIgnoreCase(aincYN);
            if (aincYN == null && this.myFamilyId.isTransactSql()) {
                res.autoIncrement = res.typeName != null && res.typeName.endsWith(" identity");
            }
        }
        catch (SQLException e) {
            this.onError(res, e);
            return (DatabaseMetaDataWrapper.TableColumn)this.skip();
        }
        return res;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.TableColumn cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.table.schema.database, cur.table.schema.schema, cur.table.name);
        this.addError(title, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/TableColumnIt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/TableColumnIt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.TableColumn, DatabaseMetaDataWrapper.TableColumn> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.TableColumn> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.TableColumn> it) {
            final String tableName = ((DatabaseMetaDataWrapper.TableColumn)it.current()).table.name;
            ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn> groupIt = new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.TableColumn item) {
                    return Comparing.equal((String)tableName, (String)item.table.name);
                }
            };
            if (groupIt == null) {
                Grouping.$$$reportNull$$$0(1);
            }
            return groupIt;
        }

        @Override
        protected DatabaseMetaDataWrapper.Table getItem(ClosableIt<DatabaseMetaDataWrapper.TableColumn> it) {
            return ((DatabaseMetaDataWrapper.TableColumn)it.current()).table;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/TableColumnIt$Grouping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/TableColumnIt$Grouping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGroupIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

