/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.EmptyFamily;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.util.DasUtil;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicLikeTable
extends BasicElement,
DasTable {
    @NotNull
    public @NotNull @NotNull PositioningNamingFamily<? extends BasicColumn> getColumns();

    @NotNull
    default public @NotNull @NotNull Family<? extends BasicIndex> getIndices() {
        Family family = EmptyFamily.by(this);
        if (family == null) {
            BasicLikeTable.$$$reportNull$$$0(0);
        }
        return family;
    }

    @NotNull
    default public @NotNull @NotNull Family<? extends BasicKey> getKeys() {
        Family family = EmptyFamily.by(this);
        if (family == null) {
            BasicLikeTable.$$$reportNull$$$0(1);
        }
        return family;
    }

    @NotNull
    default public @NotNull @NotNull Family<? extends BasicForeignKey> getForeignKeys() {
        Family family = EmptyFamily.by(this);
        if (family == null) {
            BasicLikeTable.$$$reportNull$$$0(2);
        }
        return family;
    }

    @NotNull
    default public @NotNull @NotNull Family<? extends BasicCheck> getChecks() {
        Family family = EmptyFamily.by(this);
        if (family == null) {
            BasicLikeTable.$$$reportNull$$$0(3);
        }
        return family;
    }

    @Nullable
    default public BasicConstraint findConstraint(@NotNull String name) {
        if (name == null) {
            BasicLikeTable.$$$reportNull$$$0(4);
        }
        return this.findChild(ModelConsts.CONSTRAINT_KINDS, name, BasicConstraint.class);
    }

    default public boolean isSystem() {
        return false;
    }

    default public boolean isTemporary() {
        return false;
    }

    @Nullable
    default public BasicKey getPrimaryKey() {
        return null;
    }

    @NotNull
    default public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn column) {
        BasicKey pk;
        if (column == null) {
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                BasicLikeTable.$$$reportNull$$$0(5);
            }
            return set;
        }
        String name = column.getName();
        EnumSet<DasColumn.Attribute> set = EnumSet.noneOf(DasColumn.Attribute.class);
        if (column instanceof BasicColumn) {
            BasicColumn basicColumn = (BasicColumn)column;
            if (basicColumn.getSequenceIdentity() != null) {
                set.add(DasColumn.Attribute.AUTO_GENERATED);
            }
            if (basicColumn.isComputed()) {
                set.add(DasColumn.Attribute.COMPUTED);
            }
        }
        if ((pk = this.getPrimaryKey()) != null && pk.dependsOnColumn(name)) {
            set.add(DasColumn.Attribute.PRIMARY_KEY);
        }
        for (BasicForeignKey basicForeignKey : this.getForeignKeys()) {
            if (!basicForeignKey.dependsOnColumn(name)) continue;
            set.add(DasColumn.Attribute.FOREIGN_KEY);
            break;
        }
        for (BasicIndex basicIndex : this.getIndices()) {
            if (!basicIndex.dependsOnColumn(name)) continue;
            set.add(DasColumn.Attribute.INDEX);
            break;
        }
        EnumSet<DasColumn.Attribute> enumSet = set;
        if (enumSet == null) {
            BasicLikeTable.$$$reportNull$$$0(6);
        }
        return enumSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/basic/BasicLikeTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndices";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeys";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChecks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/basic/BasicLikeTable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAttrs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findConstraint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

