/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.properties.OraTableType;
import org.jetbrains.annotations.Nullable;

public interface OraMixinTableColumn
extends BasicColumn {
    @Override
    @Nullable
    public OraTable getTable();

    @Override
    @Nullable
    default public SequenceIdentity getSequenceIdentity() {
        OraTable t = this.getTable();
        if (t == null || !(t instanceof OraTable)) {
            return null;
        }
        OraTable table = t;
        OraSchema schema = table.getSchema();
        if (schema == null) {
            return null;
        }
        long tableId = table.getObjectId();
        if (tableId <= 0L) {
            return null;
        }
        String sequenceName = "ISEQ$$_" + tableId;
        BasicSequence sequence = (BasicSequence)schema.getSequences().get(sequenceName);
        if (sequence == null) {
            return null;
        }
        return sequence.getSequenceIdentity();
    }

    @Override
    default public boolean isElementSurrogate() {
        return this.getTable().getTableType() == OraTableType.MAT_LOG && this.getName().endsWith("$$");
    }
}

