/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataTypeFactory {
    private static final Pattern INNER_PATTERN = Pattern.compile("^\\s*(\\d+|\\*|max)\\s*(,\\s*(-?\\d+))?(chars?|bytes?|digits?)?\\s*$", 2);
    private static final ConcurrentMap<DataType, DataType> ourInterner = ContainerUtil.createConcurrentWeakKeyWeakValueMap();

    @NotNull
    public static DataType of(@NotNull String specification) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(0);
        }
        DataType dataType = DataTypeFactory.of(specification, 0);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(1);
        }
        return dataType;
    }

    @NotNull
    public static DataType of(@NotNull String specification, int jdbcType) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(2);
        }
        Trio trio = DataTypeFactory.smartSplit(specification);
        if (trio.inner != null) {
            if (trio.primary.equalsIgnoreCase("enum") || trio.primary.equalsIgnoreCase("set")) {
                DataType dataType = DataTypeFactory.createEnumOrRet(specification);
                if (dataType == null) {
                    DataTypeFactory.$$$reportNull$$$0(3);
                }
                return dataType;
            }
            Couple<String> packAndName = DataTypeFactory.splitPackAndName(trio.primary);
            Matcher m = INNER_PATTERN.matcher(trio.inner);
            boolean ok = m.matches();
            if (ok) {
                LengthUnit unit;
                String sizeStr = m.group(1);
                int size = sizeStr.equals("*") ? 0x7FFFFFFE : (sizeStr.equalsIgnoreCase("max") ? Integer.MAX_VALUE : Integer.parseInt(sizeStr));
                int scale = m.group(3) != null ? Integer.parseInt(m.group(3)) : 0;
                LengthUnit lengthUnit = unit = m.group(4) != null ? LengthUnit.of((String)m.group(4)) : null;
                if (unit == null && scale != 0) {
                    unit = LengthUnit.DIGIT;
                }
                boolean explicitUnits = m.group(4) != null;
                DataType dataType = DataTypeFactory.of((String)packAndName.first, (String)packAndName.second, size, scale, unit, trio.suffix, explicitUnits, packAndName.first != null, jdbcType);
                if (dataType == null) {
                    DataTypeFactory.$$$reportNull$$$0(4);
                }
                return dataType;
            }
            DataType dataType = DataTypeFactory.of((String)packAndName.first, (String)packAndName.second, trio.inner, trio.suffix, jdbcType);
            if (dataType == null) {
                DataTypeFactory.$$$reportNull$$$0(5);
            }
            return dataType;
        }
        Couple<String> packAndName = DataTypeFactory.splitPackAndName(specification);
        DataType dataType = DataTypeFactory.of((String)packAndName.first, (String)packAndName.second, -1, 0, LengthUnit.NONE, null, false, packAndName.first != null, jdbcType);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(6);
        }
        return dataType;
    }

    @Contract(pure=true)
    private static Trio smartSplit(@NotNull String specification) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(7);
        }
        int n = specification.length();
        int p1 = Integer.MIN_VALUE;
        int p2 = Integer.MIN_VALUE;
        Stack<Character> stack = new Stack<Character>();
        block5: for (int i2 = 0; i2 < n; ++i2) {
            char x;
            char c = specification.charAt(i2);
            char c2 = x = stack.isEmpty() ? (char)'\u0000' : ((Character)stack.peek()).charValue();
            if (c == '(' && p1 < 0 && stack.isEmpty()) {
                p1 = i2;
            }
            if (c == ')' && p1 >= 0 && p2 < 0 && stack.size() == 1 && x == ')') {
                p2 = i2;
            }
            if (c == x) {
                stack.pop();
                if (!stack.isEmpty() || p2 <= 0) continue;
                break;
            }
            switch (c) {
                case '\"': 
                case '\'': {
                    stack.push(Character.valueOf(c));
                    continue block5;
                }
                case '[': {
                    stack.push(Character.valueOf(']'));
                    continue block5;
                }
                case '(': {
                    stack.push(Character.valueOf(')'));
                }
            }
        }
        Trio trio = new Trio();
        if (p2 > 0) {
            assert (p1 >= 0);
            trio.primary = specification.substring(0, p1).trim();
            trio.inner = specification.substring(p1 + 1, p2).trim();
            trio.suffix = specification.substring(p2 + 1).trim();
            if (trio.suffix.length() == 0) {
                trio.suffix = null;
            }
        } else {
            trio.primary = specification.trim();
        }
        return trio;
    }

    @NotNull
    private static DataType createEnumOrRet(@NotNull String specification) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(8);
        }
        ArrayList res = ContainerUtil.newArrayList();
        int start = specification.indexOf("(");
        int end = StringUtil.lastIndexOf((CharSequence)specification, (char)')', (int)start, (int)specification.length());
        if (end > start && start > 1) {
            String meat = specification.substring(start + 1, end);
            for (String s : StringUtil.split((String)meat, (String)",")) {
                res.add(StringUtil.trim((String)s));
            }
            DataType dataType = DataTypeFactory.of(specification.substring(0, start), (List<String>)ContainerUtil.immutableList((List)res));
            if (dataType == null) {
                DataTypeFactory.$$$reportNull$$$0(9);
            }
            return dataType;
        }
        DataType dataType = DataType.UNKNOWN;
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(10);
        }
        return dataType;
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @NotNull String typeName, @Nullable String vagueArg, @Nullable String suffix, int jdbcType) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(11);
        }
        DataType type = new DataType(schemaName, typeName, -1, 0, null, false, vagueArg, suffix, false, null, jdbcType);
        DataType dataType = DataTypeFactory.intern(type);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(12);
        }
        return dataType;
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @NotNull String typeName, @Nullable String vagueArg, @Nullable String suffix) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(13);
        }
        DataType dataType = DataTypeFactory.of(schemaName, typeName, vagueArg, suffix, 0);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(14);
        }
        return dataType;
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(15);
        }
        DataType dataType = DataTypeFactory.intern(new DataType(schemaName, typeName, size, scale, sizeUnit, sizeUnitExplicit, null, suffix, custom, null, jdbcType));
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(16);
        }
        return dataType;
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(17);
        }
        DataType dataType = DataTypeFactory.of(schemaName, typeName, size, scale, sizeUnit, suffix, sizeUnitExplicit, custom, 0);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(18);
        }
        return dataType;
    }

    @NotNull
    public static DataType of(@NotNull String typeName, @NotNull List<String> values) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(19);
        }
        if (values == null) {
            DataTypeFactory.$$$reportNull$$$0(20);
        }
        DataType type = new DataType(null, typeName, -1, 0, null, false, null, null, false, values, 0);
        DataType dataType = DataTypeFactory.intern(type);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(21);
        }
        return dataType;
    }

    private static Couple<String> splitPackAndName(@NotNull String string) {
        int dot;
        if (string == null) {
            DataTypeFactory.$$$reportNull$$$0(22);
        }
        return (dot = string.lastIndexOf(46)) < 0 ? Couple.of(null, (Object)string.trim()) : Couple.of((Object)string.substring(0, dot).trim(), (Object)string.substring(dot + 1).trim());
    }

    @NotNull
    private static DataType intern(@NotNull DataType dataType) {
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(23);
        }
        DataType dataType2 = (DataType)ConcurrencyUtil.cacheOrGet(ourInterner, (Object)dataType, (Object)dataType);
        if (dataType2 == null) {
            DataTypeFactory.$$$reportNull$$$0(24);
        }
        return dataType2;
    }

    @NotNull
    public static String serialize(@NotNull DataType value) {
        if (value == null) {
            DataTypeFactory.$$$reportNull$$$0(25);
        }
        String string = value.getSpecification() + "|" + value.jdbcType;
        if (string == null) {
            DataTypeFactory.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static DataType deserialize(@NotNull String value) {
        int idx;
        if (value == null) {
            DataTypeFactory.$$$reportNull$$$0(27);
        }
        if ((idx = value.lastIndexOf("|")) != -1) {
            DataType dataType;
            try {
                dataType = DataTypeFactory.of(value.substring(0, idx), Integer.parseInt(value.substring(idx + 1)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (dataType == null) {
                DataTypeFactory.$$$reportNull$$$0(28);
            }
            return dataType;
        }
        DataType dataType = DataTypeFactory.of(value, 0);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(29);
        }
        return dataType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specification";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/DataTypeFactory";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/DataTypeFactory";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnumOrRet";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "smartSplit";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEnumOrRet";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "splitPackAndName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Trio {
        String primary;
        String inner;
        String suffix;

        private Trio() {
        }
    }
}

