/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.mssql;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.AbstractXmlPlanModelBuilder;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MssqlPlanModelBuilder
extends AbstractXmlPlanModelBuilder<Element> {
    private static final Map<String, PlanModel.NodeType> LOGICAL_MAPPING = ContainerUtil.newHashMap();
    private static final Map<Pair<PlanModel.NodeType, String>, PlanModel.NodeType> PHYSICAL_MAPPING = ContainerUtil.newHashMap();
    private static final Map<String, PlanModel.NodeType> STATEMENT_MAPPING = ContainerUtil.newHashMap();
    private final String myStatement;
    private XPathExpression STATEMENTS_QUERY;
    private XPathExpression FIRST_OP_QUERY;
    private XPathExpression ACCESS_OBJECT_QUERY;
    private XPathExpression SUB_OPS_QUERY;
    private String myXml;

    public MssqlPlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull String statement) {
        if (owner == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(1);
        }
        if (statement == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(2);
        }
        super(owner, consumer, EnumSet.of(PlanModel.Feature.STARTUP_COST));
        this.STATEMENTS_QUERY = this.compileXPath("//Statements/StmtSimple");
        this.FIRST_OP_QUERY = this.compileXPath("QueryPlan/RelOp");
        this.ACCESS_OBJECT_QUERY = this.compileXPath("*/Object");
        this.SUB_OPS_QUERY = this.compileXPath("*/RelOp");
        this.myStatement = statement;
    }

    @NotNull
    private String getPlanAsXml(@NotNull DatabaseConnection connection) throws PlanRetrievalException {
        if (connection == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(3);
        }
        final Ref result2 = Ref.create();
        MssqlPlanModelBuilder.useStatementWithPreserved(connection, new AbstractPlanModelBuilder.ResourceUser<Statement>(){

            @Override
            public void use(Statement statement) throws PlanRetrievalException, SQLException {
                try {
                    statement.execute("SET SHOWPLAN_XML ON\n");
                    statement.execute("SET NOEXEC ON");
                    statement.execute(MssqlPlanModelBuilder.this.myStatement);
                    MssqlPlanModelBuilder.useResults(statement, new AbstractPlanModelBuilder.ResourceUser<ResultSet>(){

                        @Override
                        public void use(ResultSet resultSet) throws PlanRetrievalException, SQLException {
                            if (resultSet == null || !resultSet.next()) {
                                throw new PlanRetrievalException("No data returned for plan query");
                            }
                            if (resultSet.getMetaData().getColumnCount() != 1) {
                                throw new PlanRetrievalException("Database returned data in unknown format");
                            }
                            String res = resultSet.getString(1);
                            if (res == null) {
                                throw new PlanRetrievalException("Database returned null plan");
                            }
                            if (resultSet.next()) {
                                throw new PlanRetrievalException("Database returned too many data");
                            }
                            result2.set((Object)res);
                        }
                    });
                }
                finally {
                    try {
                        statement.execute("SET NOEXEC OFF");
                        statement.execute("SET SHOWPLAN_XML OFF");
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }, MssqlPlanModelBuilder.setAutoCommit(false));
        String string = (String)result2.get();
        if (string == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected String dump() {
        String string = this.myXml;
        if (string == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public void processRaw(@NotNull DataRequest.Context context, @NotNull DatabaseConnection connection) throws Exception {
        if (context == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(6);
        }
        if (connection == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(7);
        }
        this.myXml = this.getPlanAsXml(connection);
        this.showRaw();
        this.parseXml(this.myXml);
        this.modelReady();
    }

    private void parseXml(@NotNull String xml) {
        if (xml == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(8);
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xml)));
            NodeList statements2 = MssqlPlanModelBuilder.queryElements(this.STATEMENTS_QUERY, doc.getDocumentElement());
            if (statements2.getLength() == 0) {
                return;
            }
            this.openNode();
            for (int i2 = 0; i2 < statements2.getLength(); ++i2) {
                this.parseStatement((Element)statements2.item(i2));
            }
            this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        }
        catch (ParserConfigurationException e) {
            throw new PlanRetrievalException("Failed to configure XML parser", e);
        }
        catch (SAXException e) {
            throw new PlanRetrievalException("Failed to parse XML", e);
        }
        catch (IOException e) {
            throw new PlanRetrievalException("Failed to parse XML", e);
        }
    }

    @Override
    @NotNull
    protected String parseRawDescription(final @NotNull Element element) {
        if (element == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(9);
        }
        String string = new Object(){
            StringBuilder sb = new StringBuilder();
            {
                this.visit("", element);
            }

            void visit(String prefix, Element el) {
                int i2;
                NamedNodeMap attributes = el.getAttributes();
                for (i2 = 0; i2 < attributes.getLength(); ++i2) {
                    Attr attr = (Attr)attributes.item(i2);
                    this.sb.append(prefix).append(attr.getName()).append(" = ").append(attr.getValue()).append(";\n");
                }
                for (i2 = 0; i2 < el.getChildNodes().getLength(); ++i2) {
                    Element child = (Element)ObjectUtils.tryCast((Object)el.getChildNodes().item(i2), Element.class);
                    if (child == null || "RelOp".equals(child.getTagName()) || "OutputList".equals(child.getTagName()) || "DefinedValues".equals(child.getTagName())) continue;
                    this.visit(prefix + child.getTagName() + ".", child);
                }
            }
        }.sb.toString();
        if (string == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull Element element) {
        Element obj;
        if (element == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(11);
        }
        if ((obj = MssqlPlanModelBuilder.queryElement(this.ACCESS_OBJECT_QUERY, element)) == null) {
            this.unsupportedFormat();
        }
        return obj.getAttribute("Schema") + "." + obj.getAttribute("Table");
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull Element element) {
        if (element == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(12);
        }
        try {
            if ("RelOp".equals(element.getTagName())) {
                return new BigDecimal(element.getAttribute("EstimateRows"));
            }
            return new BigDecimal(element.getAttribute("StatementEstRows"));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull Element element) {
        Element obj;
        if (element == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(13);
        }
        if ((obj = MssqlPlanModelBuilder.queryElement(this.ACCESS_OBJECT_QUERY, element)) == null) {
            this.unsupportedFormat();
        }
        return obj.getAttribute("Index");
    }

    @Override
    protected void parsePlan(@NotNull Element state) {
        if (state == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(14);
        }
        this.openNode();
        this.parseSubPlans(state);
        String logOp = state.getAttribute("LogicalOp");
        String phyOp = state.getAttribute("PhysicalOp");
        PlanModel.NodeType type = LOGICAL_MAPPING.get(logOp);
        type = (PlanModel.NodeType)((Object)ObjectUtils.chooseNotNull((Object)((Object)PHYSICAL_MAPPING.get(Pair.create((Object)((Object)type), (Object)phyOp))), (Object)((Object)type)));
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        String text = phyOp.equals(logOp) ? phyOp : logOp + " - " + phyOp;
        PlanModel.GenericNode node = this.createNode(state, type, text);
        this.closeNode(node);
    }

    @Override
    protected void parseSubPlans(@NotNull Element element) {
        if (element == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(15);
        }
        NodeList sub = MssqlPlanModelBuilder.queryElements(this.SUB_OPS_QUERY, element);
        for (int i2 = 0; i2 < sub.getLength(); ++i2) {
            this.parsePlan((Element)sub.item(i2));
        }
    }

    @Override
    protected void parseStatement(@NotNull Element element) {
        String stmtType;
        PlanModel.NodeType type;
        if (element == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(16);
        }
        this.openNode();
        Element plan = this.querySingleElement(this.FIRST_OP_QUERY, element);
        if (plan != null) {
            this.parsePlan(plan);
        }
        if ((type = STATEMENT_MAPPING.get(stmtType = element.getAttribute("StatementType"))) == null) {
            type = PlanModel.NodeType.STATEMENT;
        }
        this.closeNode(this.createNode(element, type, type == PlanModel.NodeType.STATEMENT ? stmtType : null));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull Element element) {
        if (element == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(17);
        }
        try {
            if ("RelOp".equals(element.getTagName())) {
                return Double.valueOf(element.getAttribute("EstimatedTotalSubtreeCost"));
            }
            return Double.valueOf(element.getAttribute("StatementSubTreeCost"));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull Element element) {
        if (element == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(18);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull Element element) {
        if (element == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(19);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull Element element) {
        if (element == null) {
            MssqlPlanModelBuilder.$$$reportNull$$$0(20);
        }
        return false;
    }

    static {
        LOGICAL_MAPPING.put("Aggregate", PlanModel.NodeType.AGGREGATE);
        LOGICAL_MAPPING.put("Assert", PlanModel.NodeType.OPERATION);
        LOGICAL_MAPPING.put("Async Concat", PlanModel.NodeType.UNION_ALL);
        LOGICAL_MAPPING.put("Batch Hash Table Build", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Bitmap Create", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Clustered Index Scan", PlanModel.NodeType.FULL_INDEX_SCAN);
        LOGICAL_MAPPING.put("Clustered Index Seek", PlanModel.NodeType.INDEX_SCAN);
        LOGICAL_MAPPING.put("Clustered Update", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Collapse", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Compute Scalar", PlanModel.NodeType.VALUE);
        LOGICAL_MAPPING.put("Concatenation", PlanModel.NodeType.UNION_ALL);
        LOGICAL_MAPPING.put("Constant Scan", PlanModel.NodeType.VALUE);
        LOGICAL_MAPPING.put("Cross Join", PlanModel.NodeType.NESTED_LOOPS);
        LOGICAL_MAPPING.put("Delete", PlanModel.NodeType.STATEMENT);
        LOGICAL_MAPPING.put("Deleted Scan", PlanModel.NodeType.ACCESS);
        LOGICAL_MAPPING.put("Distinct Sort", PlanModel.NodeType.SORT_UNIQUE);
        LOGICAL_MAPPING.put("Distinct", PlanModel.NodeType.UNIQUE);
        LOGICAL_MAPPING.put("Distribute Streams", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Eager Spool", PlanModel.NodeType.TEMPORARY);
        LOGICAL_MAPPING.put("Filter", PlanModel.NodeType.FILTER);
        LOGICAL_MAPPING.put("Flow Distinct", PlanModel.NodeType.UNIQUE);
        LOGICAL_MAPPING.put("Full Outer Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Gather Streams", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Generic", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Index Scan", PlanModel.NodeType.FULL_INDEX_SCAN);
        LOGICAL_MAPPING.put("Index Seek", PlanModel.NodeType.INDEX_SCAN);
        LOGICAL_MAPPING.put("Inner Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Insert", PlanModel.NodeType.INSERT);
        LOGICAL_MAPPING.put("Inserted Scan", PlanModel.NodeType.ACCESS);
        LOGICAL_MAPPING.put("Lazy Spool", PlanModel.NodeType.TEMPORARY);
        LOGICAL_MAPPING.put("Left Anti Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Left Outer Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Left Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Log Row Scan", PlanModel.NodeType.OPERATION);
        LOGICAL_MAPPING.put("Merge Interval", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Parameter Table Scan", PlanModel.NodeType.ACCESS);
        LOGICAL_MAPPING.put("Partial Aggregate", PlanModel.NodeType.AGGREGATE);
        LOGICAL_MAPPING.put("Print", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Remote Delete", PlanModel.NodeType.DELETE);
        LOGICAL_MAPPING.put("Remote Index Scan", PlanModel.NodeType.FULL_INDEX_SCAN);
        LOGICAL_MAPPING.put("Remote Index Seek", PlanModel.NodeType.INDEX_SCAN);
        LOGICAL_MAPPING.put("Remote Insert", PlanModel.NodeType.INSERT);
        LOGICAL_MAPPING.put("Remote Query", PlanModel.NodeType.SELECT);
        LOGICAL_MAPPING.put("Remote Scan", PlanModel.NodeType.SEQ_SCAN);
        LOGICAL_MAPPING.put("Remote Update", PlanModel.NodeType.UPDATE);
        LOGICAL_MAPPING.put("Repartition Streams", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("RID Lookup", PlanModel.NodeType.ROWID_ACCESS);
        LOGICAL_MAPPING.put("Right Anti Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Right Outer Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Right Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Segment", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Sequence", PlanModel.NodeType.SEQUENTIALLY);
        LOGICAL_MAPPING.put("Sort", PlanModel.NodeType.SORT);
        LOGICAL_MAPPING.put("Split", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Switch", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Table-valued function", PlanModel.NodeType.TABLE_FUNCTION);
        LOGICAL_MAPPING.put("Table Scan", PlanModel.NodeType.SEQ_SCAN);
        LOGICAL_MAPPING.put("Top", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("TopN Sort", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("UDX", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Union", PlanModel.NodeType.UNION);
        LOGICAL_MAPPING.put("Update", PlanModel.NodeType.UPDATE);
        LOGICAL_MAPPING.put("Merge", PlanModel.NodeType.MERGE);
        LOGICAL_MAPPING.put("Merge Stats", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Local Stats", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Window Spool", PlanModel.NodeType.TEMPORARY);
        PHYSICAL_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.JOIN), (Object)"Nested Loops"), PlanModel.NodeType.NESTED_LOOPS);
        PHYSICAL_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.JOIN), (Object)"Merge Join"), PlanModel.NodeType.MERGE_JOIN);
        PHYSICAL_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.JOIN), (Object)"Hash Match"), PlanModel.NodeType.HASH_JOIN);
        STATEMENT_MAPPING.put("SELECT", PlanModel.NodeType.SELECT);
        STATEMENT_MAPPING.put("MERGE", PlanModel.NodeType.MERGE);
        STATEMENT_MAPPING.put("DELETE", PlanModel.NodeType.DELETE);
        STATEMENT_MAPPING.put("INSERT", PlanModel.NodeType.INSERT);
        STATEMENT_MAPPING.put("UPDATE", PlanModel.NodeType.UPDATE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/mssql/MssqlPlanModelBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/mssql/MssqlPlanModelBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlanAsXml";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPlanAsXml";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processRaw";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseXml";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

