/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.ide.TypePresentationService;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbFavoriteNodeProvider
extends FavoriteNodeProvider {
    @Nullable
    public Collection<AbstractTreeNode> getFavoriteNodes(DataContext context, ViewSettings viewSettings) {
        return JBIterable.of((Object[])((Object[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context))).filter(DbElement.class).map(psi -> new DbElementNode(psi.getProject(), (DatabaseElementVirtualFileImpl)psi.getVirtualFile(), viewSettings)).toList();
    }

    public boolean elementContainsFile(Object element, VirtualFile vFile) {
        return false;
    }

    public int getElementWeight(Object element, boolean isSortByType) {
        return 0;
    }

    @Nullable
    public String getElementLocation(Object element) {
        if (!(element instanceof DbElement)) {
            return null;
        }
        DbElement parent = ((DbElement)element).getDbParent();
        return parent == null ? null : ((DatabaseElementVirtualFileImpl)parent.getVirtualFile()).getPresentablePath();
    }

    public boolean isInvalidElement(Object element) {
        if (!(element instanceof DatabaseElementVirtualFileImpl)) {
            return false;
        }
        return !((DatabaseElementVirtualFileImpl)((Object)element)).isValid();
    }

    @NotNull
    public String getFavoriteTypeId() {
        if ("database" == null) {
            DbFavoriteNodeProvider.$$$reportNull$$$0(0);
        }
        return "database";
    }

    @Nullable
    public String getElementUrl(Object element) {
        if (!(element instanceof DbElement)) {
            return null;
        }
        return ((DbElement)element).getVirtualFile().getUrl();
    }

    @Nullable
    public String getElementModuleName(Object element) {
        if (PlatformUtils.isDatabaseIDE()) {
            return null;
        }
        SqlElement sql = element instanceof DbElement ? DbSqlUtil.getSqlElement((DbElement)element) : null;
        Module module = sql == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)sql);
        return module != null ? module.getName() : null;
    }

    @Nullable
    public Object[] createPathFromUrl(Project project, String url, String moduleName) {
        Object[] objectArray;
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file instanceof DatabaseElementVirtualFileImpl) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = file;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbFavoriteNodeProvider", "getFavoriteTypeId"));
    }

    public static class DbElementNode
    extends AbstractTreeNode<DatabaseElementVirtualFileImpl> {
        public DbElementNode(Project project, DatabaseElementVirtualFileImpl value, ViewSettings settings) {
            super(project, (Object)value);
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            List list = Collections.emptyList();
            if (list == null) {
                DbElementNode.$$$reportNull$$$0(0);
            }
            return list;
        }

        protected void update(PresentationData presentation) {
            DatabaseElementVirtualFileImpl value = (DatabaseElementVirtualFileImpl)((Object)this.getValue());
            if (value == null) {
                return;
            }
            presentation.setPresentableText(value.getName());
            presentation.setIcon(TypePresentationService.getService().getIcon((Object)value));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbFavoriteNodeProvider$DbElementNode", "getChildren"));
        }
    }
}

