/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.settings.DatabaseSettingsConfigurable;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Consumer;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.ui.JBUI;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleDataRequest
extends DataRequest.QueryRequest {
    private final Shared shared;
    public final int queryIndex;
    public final boolean hasNext;
    public final Object resultType;
    private static final Key<ErrorPanelInfo> ERROR_PANEL_KEY = Key.create((String)"ERROR_PANEL_KEY");

    @NotNull
    public static ConsoleDataRequest newConsoleRequest(@NotNull AbstractQueryLanguageConsole<?> console, @NotNull Editor editor, @NotNull ScriptModel<?> model) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ConsoleDataRequest.$$$reportNull$$$0(1);
        }
        if (model == null) {
            ConsoleDataRequest.$$$reportNull$$$0(2);
        }
        DataRequest.Constraints constraints = ConsoleDataRequest.newConstraints();
        Shared shared = new Shared(editor, model, constraints);
        shared.queries.advance();
        DataRequest.TxMarker batchTx = console.getCurrentTx();
        ConsoleDataRequest consoleDataRequest = new ConsoleDataRequest(console, batchTx, shared, 0);
        if (consoleDataRequest == null) {
            ConsoleDataRequest.$$$reportNull$$$0(3);
        }
        return consoleDataRequest;
    }

    private ConsoleDataRequest(@NotNull AbstractQueryLanguageConsole<?> console, @NotNull DataRequest.TxMarker txMarker, @NotNull Shared shared, int queryIndex) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(4);
        }
        if (txMarker == null) {
            ConsoleDataRequest.$$$reportNull$$$0(5);
        }
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(6);
        }
        super(console, txMarker, ConsoleDataRequest.currentQueryText(console, shared), shared.constraints, null);
        this.shared = shared;
        this.queryIndex = queryIndex;
        this.resultType = ((ScriptModel.StatementIt)shared.queries.current()).resultType(console);
        this.hasNext = shared.queries.hasNext();
    }

    @NotNull
    private static String currentQueryText(@NotNull AbstractQueryLanguageConsole<?> console, @NotNull Shared shared) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(7);
        }
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(8);
        }
        String currentText = ((ScriptModel.StatementIt)shared.queries.current()).text(console.myPStorage, Conditions.alwaysFalse());
        String lineSeparator = (String)ObjectUtils.notNull((Object)console.getLanguageConsole().getVirtualFile().getDetectedLineSeparator(), (Object)LineSeparator.getSystemLineSeparator().getSeparatorString());
        String string = StringUtil.convertLineSeparators((String)currentText, (String)lineSeparator);
        if (string == null) {
            ConsoleDataRequest.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private AbstractQueryLanguageConsole getConsole() {
        AbstractQueryLanguageConsole abstractQueryLanguageConsole = (AbstractQueryLanguageConsole)this.owner;
        if (abstractQueryLanguageConsole == null) {
            ConsoleDataRequest.$$$reportNull$$$0(10);
        }
        return abstractQueryLanguageConsole;
    }

    @NotNull
    private DataProducer getDataProducer() {
        DataProducer dataProducer = this.getConsole().getMessageBus().getDataProducer();
        if (dataProducer == null) {
            ConsoleDataRequest.$$$reportNull$$$0(11);
        }
        return dataProducer;
    }

    @NotNull
    public UserDataHolder getSharedDataHolder() {
        Shared shared = this.shared;
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(12);
        }
        return shared;
    }

    public void onError(@Nullable String message, @Nullable Throwable th) {
        if (message != null) {
            Throwable throwable = new Throwable(message);
            throwable.setStackTrace(th == null ? new StackTraceElement[]{} : th.getStackTrace());
            this.reportError(throwable);
        } else if (th != null) {
            this.reportError(th);
        }
    }

    public void onFinished() {
        if (this.isLastInChain()) {
            return;
        }
        this.getDataProducer().processRequest(this.nextRequest());
    }

    public boolean isLastInChain() {
        return !this.shared.ignoreAll && this.shared.errCount > this.shared.errIgnored || !this.hasNext;
    }

    @NotNull
    private ConsoleDataRequest nextRequest() {
        this.shared.queries.advance();
        AbstractQueryLanguageConsole console = this.getConsole();
        ConsoleDataRequest consoleDataRequest = new ConsoleDataRequest(console, console.getCurrentTx(), this.shared, this.queryIndex + 1);
        if (consoleDataRequest == null) {
            ConsoleDataRequest.$$$reportNull$$$0(13);
        }
        return consoleDataRequest;
    }

    @NotNull
    private ConsoleDataRequest cloneRequest() {
        AbstractQueryLanguageConsole console = this.getConsole();
        ConsoleDataRequest consoleDataRequest = new ConsoleDataRequest(console, console.getCurrentTx(), this.shared, this.queryIndex);
        if (consoleDataRequest == null) {
            ConsoleDataRequest.$$$reportNull$$$0(14);
        }
        return consoleDataRequest;
    }

    public void onStarted() {
        DbUIUtil.invokeLater(() -> {
            if (!this.hasNext || this.shared.lastUpdateTime < 0L || System.currentTimeMillis() - this.shared.lastUpdateTime > 100L) {
                this.updateConsoleUI(false);
            }
        });
        this.shared.lastUpdateTime = System.currentTimeMillis();
    }

    private void updateConsoleUI(boolean scrollToQuery) {
        TextRange range;
        this.closeErrorPanel();
        if (scrollToQuery && (range = this.getRange()) != null) {
            this.scrollToRange(range);
        }
        this.updateHighlighting();
    }

    private void reportError(@NotNull Throwable error) {
        if (error == null) {
            ConsoleDataRequest.$$$reportNull$$$0(15);
        }
        ++this.shared.errCount;
        DbUIUtil.invokeLater(() -> {
            if (error == null) {
                ConsoleDataRequest.$$$reportNull$$$0(32);
            }
            this.updateConsoleUI(!this.shared.ignoreAll);
            if (!this.hasNext) {
                this.handleQueryError(error, null);
            } else if (!this.shared.ignoreAll) {
                this.handleQueryError(error, (Consumer<Decision>)((Consumer)feedback -> {
                    this.closeErrorPanel();
                    switch (feedback) {
                        case STOP: {
                            break;
                        }
                        case RETRY: {
                            --this.shared.errCount;
                            this.getDataProducer().processRequest(this.cloneRequest());
                            break;
                        }
                        case IGNORE_ALL: {
                            this.shared.ignoreAll = true;
                            this.getDataProducer().processRequest(this.nextRequest());
                            break;
                        }
                        case IGNORE: {
                            ++this.shared.errIgnored;
                            this.getDataProducer().processRequest(this.nextRequest());
                        }
                    }
                }));
            }
        });
    }

    public void closeErrorPanel() {
        ConsoleDataRequest.hideErrorPanel(this.shared.sourceEditor);
    }

    private void handleQueryError(@NotNull Throwable error, @Nullable Consumer<Decision> feedbackListener) {
        if (error == null) {
            ConsoleDataRequest.$$$reportNull$$$0(16);
        }
        if (error instanceof ProcessCanceledException) {
            return;
        }
        if (feedbackListener == null && !DatabaseSettings.getSettings().isShowErrorInEditor()) {
            return;
        }
        if (!this.shared.sourceEditor.getContentComponent().isShowing()) {
            return;
        }
        Project project = this.getConsole().getProject();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.shared.sourceEditor.getDocument());
        if (file == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        FileEditor fileEditor = editorManager.getSelectedEditor(file.getVirtualFile());
        if (fileEditor != null) {
            DatabaseDialect databaseDialect;
            ErrorNotificationPanel errorPanel = this.createErrorNotificationPanel(this.shared.sourceEditor, error, feedbackListener);
            editorManager.addBottomComponent(fileEditor, (JComponent)errorPanel);
            Container parent = errorPanel.getParent();
            if (parent instanceof JComponent) {
                ((JComponent)parent).setBorder((Border)JBUI.Borders.empty());
            }
            ERROR_PANEL_KEY.set((UserDataHolder)this.shared.sourceEditor, (Object)new ErrorPanelInfo(errorPanel, feedbackListener));
            this.shared.sourceEditor.getContentComponent().requestFocusInWindow();
            TextRange queryRange = this.getRange();
            SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect((PsiElement)file);
            DatabaseDialect databaseDialect2 = databaseDialect = dialect != null ? dialect.getDatabaseDialect() : null;
            if (queryRange != null && databaseDialect != null) {
                int offset;
                int position = ConsoleDataRequest.getOffsetFromErrorMessage(databaseDialect.getFamilyId(), StringUtil.notNullize((String)error.getMessage()), this.query, dialect, project);
                int n = offset = position >= 0 ? position + queryRange.getStartOffset() : -1;
                if (offset >= queryRange.getEndOffset()) {
                    offset = queryRange.getEndOffset();
                }
                if (offset > -1) {
                    this.scrollToRange(TextRange.create((int)offset, (int)offset));
                }
            }
        }
    }

    private static int getOffsetFromErrorMessage(@NotNull DatabaseFamilyId dialect, @NotNull String message, @NotNull String queryText, @NotNull SqlLanguageDialect language, @NotNull Project project) {
        if (dialect == null) {
            ConsoleDataRequest.$$$reportNull$$$0(17);
        }
        if (message == null) {
            ConsoleDataRequest.$$$reportNull$$$0(18);
        }
        if (queryText == null) {
            ConsoleDataRequest.$$$reportNull$$$0(19);
        }
        if (language == null) {
            ConsoleDataRequest.$$$reportNull$$$0(20);
        }
        if (project == null) {
            ConsoleDataRequest.$$$reportNull$$$0(21);
        }
        if (dialect.isPostgres()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bPosition: (\\d+)\\z", -1, -1, 1, message, queryText, null);
        }
        if (dialect.isMysql()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bnear '([^']*)' at line (\\d+)\\z", 1, 2, -1, message, queryText, StringUtil::indexOfIgnoreCase);
        }
        if (dialect.isTransactSql()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bnear '([^']*)'\\.\\z", 1, -1, -1, message, queryText, ConsoleDataRequest.byTokenFinder(language, project, 126));
        }
        if (dialect.isSqlite()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bnear \"([^\"]*)\":", 1, -1, -1, message, queryText, ConsoleDataRequest.byTokenFinder(language, project, Integer.MAX_VALUE));
        }
        if (dialect.isDerby()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl("\\bat line (\\d+), column (\\d+)\\.\\z", -1, 1, 2, message, queryText, null);
        }
        if (dialect.isHsqldb()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl(": (.*) : line: (\\d+)\\z", 1, 2, -1, message, queryText, StringUtil::indexOfIgnoreCase);
        }
        return -1;
    }

    private static StringFinder byTokenFinder(@NotNull SqlLanguageDialect dialect, @NotNull Project project, int cropping) {
        if (dialect == null) {
            ConsoleDataRequest.$$$reportNull$$$0(22);
        }
        if (project == null) {
            ConsoleDataRequest.$$$reportNull$$$0(23);
        }
        return (query, piece, startOffset) -> {
            boolean croppedMode;
            ParserDefinition parser;
            if (dialect == null) {
                ConsoleDataRequest.$$$reportNull$$$0(30);
            }
            if (project == null) {
                ConsoleDataRequest.$$$reportNull$$$0(31);
            }
            if ((parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.findSingle((Object)dialect)) == null) {
                return StringUtil.indexOfIgnoreCase((String)query, (String)piece, (int)startOffset);
            }
            Lexer lexer = parser.createLexer(project);
            lexer.start((CharSequence)query);
            boolean bl = croppedMode = piece.length() > cropping;
            while (lexer.getTokenType() != null) {
                if (lexer.getTokenStart() >= startOffset) {
                    boolean matched;
                    boolean bl2 = matched = croppedMode ? StringUtil.startsWithIgnoreCase((String)lexer.getTokenText(), (String)piece) : lexer.getTokenText().equalsIgnoreCase(piece);
                    if (matched) {
                        return lexer.getTokenStart();
                    }
                }
                lexer.advance();
            }
            return StringUtil.indexOfIgnoreCase((String)query, (String)piece, (int)startOffset);
        };
    }

    private static int getOffsetFromMessageImpl(@NotNull @RegExp String pattern, int groupNear, int groupLine, int groupColumn, @NotNull String message, @NotNull String queryText, @Nullable StringFinder finder) {
        Matcher matcher;
        if (pattern == null) {
            ConsoleDataRequest.$$$reportNull$$$0(24);
        }
        if (message == null) {
            ConsoleDataRequest.$$$reportNull$$$0(25);
        }
        if (queryText == null) {
            ConsoleDataRequest.$$$reportNull$$$0(26);
        }
        if ((matcher = Pattern.compile(pattern).matcher(message)).find()) {
            return ConsoleDataRequest.getOffsetFromMessageImpl(queryText, groupNear > 0 ? matcher.group(groupNear) : null, groupLine > 0 ? matcher.group(groupLine) : null, groupColumn > 0 ? matcher.group(groupColumn) : null, finder);
        }
        return -1;
    }

    private static int getOffsetFromMessageImpl(@NotNull String queryText, @Nullable String near, @Nullable String strLine, @Nullable String strColumn, @Nullable StringFinder finder) {
        int offset;
        int column;
        if (queryText == null) {
            ConsoleDataRequest.$$$reportNull$$$0(27);
        }
        int line = strLine == null ? -1 : StringUtil.parseInt((String)strLine, (int)-1);
        int n = column = strColumn == null ? -1 : StringUtil.parseInt((String)strColumn, (int)-1);
        int n2 = strLine == null || line == -1 ? (column < 0 ? -1 : column - 1) : (offset = StringUtil.lineColToOffset((CharSequence)queryText, (int)(line - 1), (int)(column < 0 ? 0 : column - 1)));
        if (line > -1 && column > -1) {
            return offset;
        }
        if (near == null || finder == null) {
            return offset;
        }
        int refined = finder.find(queryText, near, offset);
        return refined == -1 ? offset : refined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrollToRange(@NotNull TextRange range) {
        Editor editor;
        if (range == null) {
            ConsoleDataRequest.$$$reportNull$$$0(28);
        }
        if ((editor = this.shared.sourceEditor).isDisposed() || !editor.getContentComponent().isShowing()) {
            return;
        }
        int offset = range.getEndOffset();
        editor.getCaretModel().moveToOffset(offset);
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.disableAnimation();
        try {
            scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        finally {
            scrollingModel.enableAnimation();
        }
        TextRange existing = EditorUtil.getSelectionInAnyMode((Editor)editor);
        if (!existing.containsOffset(offset)) {
            editor.getSelectionModel().setSelection(offset, offset);
        }
    }

    private void updateHighlighting() {
        Project project = this.getConsole().getProject();
        if (!project.isOpen() || this.shared.sourceEditor.isDisposed()) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.shared.sourceEditor.getDocument());
        if (file != null) {
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project).restart(file);
        }
    }

    @Nullable
    public TextRange getRange() {
        return this.shared.adjustedRange(this.queryIndex);
    }

    private ErrorNotificationPanel createErrorNotificationPanel(Editor sourceEditor, Throwable error, Consumer<Decision> feedbackListener) {
        ErrorNotificationPanel.Builder builder = ErrorNotificationPanel.create(null, error, sourceEditor.getContentComponent());
        if (feedbackListener == null) {
            builder.addDetailsButton().addIconLink("config", "/general/settings.png", "Settings", AllIcons.General.Settings, () -> ShowSettingsUtilImpl.showSettingsDialog(null, (String)DatabaseSettingsConfigurable.CONFIGURABLE_ID, (String)""));
        } else {
            builder.addLink("&retry", "<span style=\"text-decoration:underline;\">R</span>etry", () -> feedbackListener.consume((Object)Decision.RETRY)).addLink("&ignore", "<span style=\"text-decoration:underline;\">I</span>gnore", () -> feedbackListener.consume((Object)Decision.IGNORE)).addLink("ignore_&all", "Ignore <span style=\"text-decoration:underline;\">A</span>ll", () -> feedbackListener.consume((Object)Decision.IGNORE_ALL)).addLink("&stop", "<span style=\"text-decoration:underline;\">S</span>top", () -> feedbackListener.consume((Object)Decision.STOP));
        }
        builder.addCloseButton(() -> ConsoleDataRequest.hideErrorPanel(this.shared.sourceEditor));
        ErrorNotificationPanel notificationPanel = builder.build();
        notificationPanel.getContent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TextRange range;
                if (e.getClickCount() == 2 && (range = ConsoleDataRequest.this.getRange()) != null) {
                    ConsoleDataRequest.this.scrollToRange(range);
                    ((ConsoleDataRequest)ConsoleDataRequest.this).shared.sourceEditor.getContentComponent().requestFocusInWindow();
                    ConsoleDataRequest.this.updateHighlighting();
                }
            }
        });
        return notificationPanel;
    }

    public static void hideErrorPanel(@NotNull Editor sourceEditor) {
        ErrorPanelInfo epInfo;
        if (sourceEditor == null) {
            ConsoleDataRequest.$$$reportNull$$$0(29);
        }
        if ((epInfo = (ErrorPanelInfo)ERROR_PANEL_KEY.get((UserDataHolder)sourceEditor)) == null || sourceEditor.getProject() == null) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)sourceEditor.getProject()).getPsiFile(sourceEditor.getDocument());
        if (file == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)sourceEditor.getProject());
        FileEditor fileEditor = editorManager.getSelectedEditor(file.getVirtualFile());
        if (fileEditor != null) {
            editorManager.removeBottomComponent(fileEditor, (JComponent)epInfo.errorPanel);
            ERROR_PANEL_KEY.set((UserDataHolder)sourceEditor, null);
            sourceEditor.getContentComponent().requestFocusInWindow();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ConsoleDataRequest";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "txMarker";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shared";
                break;
            }
            case 15: 
            case 16: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 17: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 19: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 21: 
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newConsoleRequest";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "currentQueryText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataProducer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedDataHolder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "nextRequest";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConsoleRequest";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "currentQueryText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "handleQueryError";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetFromErrorMessage";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "byTokenFinder";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetFromMessageImpl";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "scrollToRange";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hideErrorPanel";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$byTokenFinder$3";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$reportError$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EscapeHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public EscapeHandler(EditorActionHandler originalHandler) {
            this.myOriginalHandler = originalHandler;
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                EscapeHandler.$$$reportNull$$$0(0);
            }
            if (this.myOriginalHandler != null && this.myOriginalHandler.isEnabled(editor, caret, dataContext)) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            ConsoleDataRequest.hideErrorPanel(editor);
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                EscapeHandler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                EscapeHandler.$$$reportNull$$$0(2);
            }
            return ERROR_PANEL_KEY.get((UserDataHolder)editor) != null || this.myOriginalHandler.isEnabled(editor, caret, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest$EscapeHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ErrorPanelInfo {
        public final ErrorNotificationPanel errorPanel;
        public final Consumer<Decision> decisionConsumer;

        ErrorPanelInfo(@NotNull ErrorNotificationPanel errorPanel, @Nullable Consumer<Decision> decisionConsumer) {
            if (errorPanel == null) {
                ErrorPanelInfo.$$$reportNull$$$0(0);
            }
            this.errorPanel = errorPanel;
            this.decisionConsumer = decisionConsumer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPanel", "com/intellij/database/run/ConsoleDataRequest$ErrorPanelInfo", "<init>"));
        }
    }

    @FunctionalInterface
    private static interface StringFinder {
        public int find(@NotNull String var1, @NotNull String var2, int var3);
    }

    private static class Shared
    extends UserDataHolderBase {
        final Editor sourceEditor;
        final ScriptModel<?> scriptModel;
        final DataRequest.Constraints constraints;
        final JBIterator<? extends ScriptModel.StatementIt<?>> queries;
        final List<RangeMarker> rangeMarkers;
        long lastUpdateTime = -1L;
        boolean ignoreAll = false;
        int errCount;
        int errIgnored;

        public Shared(Editor sourceEditor, ScriptModel<?> scriptModel, DataRequest.Constraints constraints) {
            this.queries = JBIterator.from((Iterator)scriptModel.statements().iterator());
            this.sourceEditor = sourceEditor;
            this.scriptModel = scriptModel;
            this.constraints = constraints;
            Document document = sourceEditor.getDocument();
            this.rangeMarkers = scriptModel.statements().transform(it -> {
                TextRange range = it.range().shiftRight((int)it.rangeOffset());
                return range.getEndOffset() <= document.getTextLength() ? document.createRangeMarker(range) : null;
            }).toList();
        }

        @Nullable
        TextRange adjustedRange(int idx) {
            RangeMarker marker = this.rangeMarkers.get(idx);
            return marker != null && marker.isValid() ? TextRange.create((Segment)marker) : null;
        }
    }

    public static enum Decision {
        STOP,
        RETRY,
        IGNORE,
        IGNORE_ALL;

    }
}

