/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeasuringDataAuditor
extends DataAuditor.Adapter {
    private final ConcurrentMap<DataRequest, Stat> myStatMap = ConcurrentFactoryMap.createWeakMap(k -> new Stat());

    protected Stat getStat(DataRequest.Context context) {
        return (Stat)this.myStatMap.get(context.request);
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    @Override
    public void updateCountReceived(@NotNull DataRequest.Context context, int updateCount) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(0);
        }
        this.getStat((DataRequest.Context)context).updateT = this.now();
        if (updateCount < 0) {
            return;
        }
        this.getStat((DataRequest.Context)context).updateCount += (long)updateCount;
    }

    @Override
    public void fetchStarted(@NotNull DataRequest.Context context, int index) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(1);
        }
        this.getStat((DataRequest.Context)context).fetchT1 += this.now();
        this.getStat((DataRequest.Context)context).rowCount = 0L;
    }

    @Override
    public void fetchFinished(@NotNull DataRequest.Context context, int index, int rowCount) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(2);
        }
        this.getStat((DataRequest.Context)context).fetchT2 += this.now();
        this.getStat((DataRequest.Context)context).rowCount += (long)rowCount;
    }

    @Override
    public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
        if (request == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(3);
        }
        if (producer == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
        if (request == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(5);
        }
        if (producer == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(6);
        }
    }

    @Override
    public void requestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(7);
        }
        this.getStat((DataRequest.Context)context).reqT1 = this.now();
    }

    @Override
    public void requestFinished(@NotNull DataRequest.Context context) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(8);
        }
        this.getStat((DataRequest.Context)context).reqT2 = this.now();
        this.reportFinish(context);
    }

    @Override
    public void txCompleted(@NotNull DataRequest.Context context, boolean commit) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(9);
        }
        this.print(context, "transaction " + (commit ? "committed" : "rolled back") + ": " + context.txMarker);
    }

    @Override
    public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(10);
        }
        ++this.getStat((DataRequest.Context)context).errorCount;
    }

    private void reportFinish(@NotNull DataRequest.Context context) {
        String reportText;
        String totalTimeStr;
        String timings;
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(11);
        }
        Stat stat = this.getStat(context);
        long totalTime = stat.reqT2 - stat.reqT1;
        long fetchTime = stat.fetchT2 - stat.fetchT1;
        String executionTimeStr = StringUtil.formatDuration((long)(totalTime - fetchTime));
        String string = timings = Comparing.equal((String)executionTimeStr, (String)(totalTimeStr = StringUtil.formatDuration((long)totalTime))) ? executionTimeStr : totalTimeStr + " (execution: " + executionTimeStr + ", fetching: " + StringUtil.formatDuration((long)fetchTime) + ")";
        if (stat.updateCount > 0L) {
            reportText = (stat.updateCount == 1L ? "1 row" : stat.updateCount + " rows") + " affected in " + executionTimeStr;
            this.bringAttentionToOutput(context, false);
        } else if (stat.rowCount > 0L) {
            int offset = ((DataRequest.QueryRequest)context.request).constraints.offset;
            reportText = (stat.rowCount == 1L ? "1 row" : stat.rowCount + " rows") + " retrieved starting from " + offset + " in " + timings;
        } else if (stat.errorCount == 0L) {
            if (stat.rowCount == 0L) {
                reportText = "0 rows retrieved in " + timings;
            } else {
                reportText = "completed in " + executionTimeStr;
                this.bringAttentionToOutput(context, false);
            }
        } else {
            reportText = null;
        }
        if (reportText != null) {
            this.print(context, reportText);
        }
        if (totalTime > 20000L) {
            this.bringAttentionByNotification(context);
        }
    }

    protected void bringAttentionToOutput(@NotNull DataRequest.Context context, boolean isError) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(12);
        }
    }

    protected void bringAttentionByNotification(@NotNull DataRequest.Context context) {
        if (context == null) {
            MeasuringDataAuditor.$$$reportNull$$$0(13);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/MeasuringDataAuditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateCountReceived";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchStarted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchFinished";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "jobSubmitted";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "jobFinished";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "requestStarted";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "requestFinished";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "txCompleted";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "reportFinish";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "bringAttentionToOutput";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "bringAttentionByNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Stat {
        public long reqT1;
        public long reqT2;
        public long fetchT1;
        public long fetchT2;
        public long rowCount = -1L;
        public long updateT;
        public long updateCount;
        public long errorCount;
    }
}

