/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.IntIntFunction;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.GridTableCellEditor;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.database.run.ui.grid.CellRenderingUtils;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.GridRawIndexConverter;
import com.intellij.database.run.ui.grid.GridSelection;
import com.intellij.database.run.ui.grid.GridTableModel;
import com.intellij.database.run.ui.grid.JBTableWithResizableCells;
import com.intellij.database.run.ui.grid.ResizableCellEditorsSupport;
import com.intellij.database.run.ui.grid.TableCellImageCache;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderers;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import gnu.trove.TIntObjectProcedure;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableResultView
extends JBTableWithResizableCells
implements EditorColorsListener,
UISettingsListener {
    static final Key<EventObject> EDITING_STARTER_CLIENT_PROPERTY_KEY = Key.create((String)"EventThatCausedEditingToStart");
    private final TableResultPanel myResultPanel;
    private final MyTableColumnCache myColumnCache;
    private final Renderers myRenderers;
    private final TableCellImageCache myCellImageCache;
    private final GridCellEditorFactoryProvider myEditorProvider;
    private final GridRawIndexConverter myRawIndexConverter;
    private final ActionGroup myColumnHeaderPopupActions;
    @Nullable
    private GridColorsScheme myColorScheme;
    private final boolean myUseConsoleFonts;
    private ModelIndex<DataConsumer.Column> myClickedHeaderColumnIdx;
    private double myFontSizeIncrement = 0.0;
    private double myFontSizeScale = 1.0;
    private int myColumnsHashCode;
    private PaintingSession myPaintingSession;
    private Ref<Object> myCommonValue;

    public TableResultView(TableResultPanel resultPanel, GridCellEditorFactoryProvider editorProvider, boolean useConsoleFonts, ActionGroup columnHeaderPopupActions) {
        super(new GridTableModel.Regular(resultPanel), new MyTableColumnModel());
        this.myResultPanel = resultPanel;
        this.myCellImageCache = new TableCellImageCache((JTable)((Object)this), this.myResultPanel);
        this.myEditorProvider = editorProvider;
        this.myUseConsoleFonts = useConsoleFonts;
        this.myColumnHeaderPopupActions = columnHeaderPopupActions;
        this.myRawIndexConverter = new GridRawIndexConverter(this);
        this.myColumnCache = new MyTableColumnCache();
        this.myRenderers = new Renderers(this.myResultPanel);
        this.myClickedHeaderColumnIdx = ModelIndex.forColumn(this.myResultPanel, -1);
        this.getTableHeader().setDefaultRenderer(this.createHeaderRenderer());
        new ResizableCellEditorsSupport(this);
        this.setupFocusListener();
        this.setupMagnificator();
        this.setEnableAntialiasing(true);
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
        this.setFont(this.getColorsScheme().getFont(EditorFontType.PLAIN));
        this.updateFonts();
        this.adjustDefaultActions();
        this.addPropertyChangeListener("tableCellEditor", e -> DataGridUtil.updateWidgets(resultPanel));
    }

    @NotNull
    public GridColorsScheme getColorsScheme() {
        if (this.myColorScheme == null) {
            this.myColorScheme = this.myUseConsoleFonts ? new GridColorsScheme.ForConsole() : new GridColorsScheme();
        }
        GridColorsScheme gridColorsScheme = this.myColorScheme;
        if (gridColorsScheme == null) {
            TableResultView.$$$reportNull$$$0(0);
        }
        return gridColorsScheme;
    }

    @NotNull
    protected MyCellRenderer createHeaderRenderer() {
        MyCellRenderer myCellRenderer = new MyCellRenderer(this);
        if (myCellRenderer == null) {
            TableResultView.$$$reportNull$$$0(1);
        }
        return myCellRenderer;
    }

    public void startPaintingSession() {
        this.myPaintingSession = new PaintingSession();
    }

    public void endPaintingSession() {
        this.myPaintingSession = null;
    }

    public void dropCaches() {
        this.myCellImageCache.reset();
    }

    MyTableColumnCache getColumnCache() {
        return this.myColumnCache;
    }

    ModelIndex<DataConsumer.Column> getClickedHeaderColumnIdx() {
        return this.myClickedHeaderColumnIdx;
    }

    GridRawIndexConverter getRawIndexConverter() {
        return this.myRawIndexConverter;
    }

    void doTranspose() {
        this.myColumnCache.retainColumns(ContainerUtil.emptyList());
        this.setModel(this.isTransposed() ? new GridTableModel.Regular(this.myResultPanel) : new GridTableModel.Transposed(this.myResultPanel));
        this.myRawIndexConverter.transpose();
    }

    public void addNotify() {
        super.addNotify();
        int hash = this.computeColumnsHashCode();
        if (hash == this.myColumnsHashCode) {
            return;
        }
        this.layoutColumns().doWhenDone(() -> {
            this.myColumnsHashCode = hash;
        });
    }

    protected void paintComponent(@NotNull Graphics g) {
        if (g == null) {
            TableResultView.$$$reportNull$$$0(2);
        }
        this.myCellImageCache.adjustCacheSize();
        super.paintComponent(g);
        this.paintCellsEffects(g);
    }

    private void paintCellsEffects(Graphics g) {
        Rectangle visibleArea = g.getClipBounds();
        Point at = new Point((int)visibleArea.getMinX(), (int)visibleArea.getMinY());
        int fromRow = this.rowAtPoint(at);
        int fromColumn = this.columnAtPoint(at);
        at.setLocation(visibleArea.getMaxX(), visibleArea.getMaxY());
        int toRow = this.rowAtPoint(at);
        int toColumn = this.columnAtPoint(at);
        if (fromColumn == -1) {
            fromColumn = 0;
        }
        if (toRow == -1) {
            toRow = 0;
        }
        if (toColumn == -1) {
            toColumn = this.getColumnCount() - 1;
        }
        if (fromRow == -1) {
            toRow = this.getRowCount() - 1;
        }
        for (int row = fromRow; row <= toRow; ++row) {
            for (int column = fromColumn; column <= toColumn; ++column) {
                this.paintCellEffects(g, row, column);
            }
        }
    }

    private void paintCellEffects(Graphics g, int row, int column) {
        CellAttributes attributes = this.myResultPanel.getMarkupModel().getCellAttributes(ViewIndex.forRow(this.myResultPanel, this.isTransposed() ? column : row).toModel(this.myResultPanel), ViewIndex.forColumn(this.myResultPanel, this.isTransposed() ? row : column).toModel(this.myResultPanel), this.getColorsScheme());
        if (attributes != null) {
            CellRenderingUtils.paintCellEffect(g, this.getCellRect(row, column, true), attributes);
        }
    }

    private int computeColumnsHashCode() {
        int hash = 0;
        List<DataConsumer.Column> columns2 = this.myResultPanel.getDataModel().getColumns();
        for (DataConsumer.Column column : columns2) {
            hash = System.identityHashCode(column) + 31 * hash;
        }
        return hash;
    }

    public boolean isViewModified() {
        for (MyTableColumn tableColumn : this.myColumnCache) {
            int modelIndex = tableColumn.getModelIndex();
            IntIntFunction toView = this.isTransposed() ? this.myRawIndexConverter.row2View() : this.myRawIndexConverter.column2View();
            int viewIdx = toView.fun(modelIndex);
            if ((viewIdx == -1 || viewIdx == modelIndex) && tableColumn.isWidthSetByLayout()) continue;
            return true;
        }
        int defaultRowHeight = this.getRowHeight();
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            if (this.getRowHeight(i2) == defaultRowHeight) continue;
            return true;
        }
        return false;
    }

    private void setupFocusListener() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                Component component;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (TableResultView.this.isEditing() && (component = TableResultView.this.getEditorComponent()) != null) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(component, true));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultView$1", "focusGained"));
            }
        });
    }

    private void setupMagnificator() {
        this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, new Magnificator(){

            public Point magnify(double scale, Point at) {
                Rectangle r1;
                int column = TableResultView.this.columnAtPoint(at);
                int row = TableResultView.this.rowAtPoint(at);
                Rectangle rectangle = r1 = column < 0 || row < 0 ? TableResultView.this.getBounds() : TableResultView.this.getCellRect(row, column, true);
                if (r1.width == 0 || r1.height == 0) {
                    return at;
                }
                double xPerc = (double)(at.x - r1.x) / (double)r1.width;
                double yPerc = (double)(at.y - r1.y) / (double)r1.height;
                TableResultView.this.changeFontSize(0, scale);
                Rectangle r2 = column < 0 || row < 0 ? TableResultView.this.getBounds() : TableResultView.this.getCellRect(row, column, true);
                return new Point((int)((double)r2.x + (double)r2.width * xPerc), (int)((double)r2.y + (double)r2.height * yPerc));
            }
        });
    }

    private void adjustDefaultActions() {
        AbstractAction disabledAction = new AbstractAction(){

            @Override
            public boolean isEnabled() {
                return false;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        ActionMap actionMap = this.getActionMap();
        actionMap.put("selectPreviousRowCell", disabledAction);
        actionMap.put("startEditing", disabledAction);
    }

    public void columnMarginChanged(ChangeEvent e) {
        TableColumn resizingColumn;
        JTableHeader tableHeader = this.getTableHeader();
        TableColumn tableColumn = resizingColumn = tableHeader != null ? tableHeader.getResizingColumn() : null;
        if (resizingColumn != null && this.autoResizeMode == 0) {
            resizingColumn.setPreferredWidth(resizingColumn.getWidth());
        }
        this.resizeAndRepaint();
    }

    public String getToolTipText(@NotNull MouseEvent event) {
        if (event == null) {
            TableResultView.$$$reportNull$$$0(3);
        }
        return "";
    }

    public void setRowHeight(int row, int rowHeight) {
        JViewport rowHeader;
        Container grandParent;
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        super.setRowHeight(row, rowHeight);
        Container parent = this.getParent();
        if (parent instanceof JViewport && (grandParent = parent.getParent()) instanceof JScrollPane && (rowHeader = ((JScrollPane)grandParent).getRowHeader()) != null) {
            rowHeader.revalidate();
            rowHeader.repaint();
        }
    }

    @NotNull
    protected JTableHeader createDefaultTableHeader() {
        MyTableHeader myTableHeader = new MyTableHeader();
        if (myTableHeader == null) {
            TableResultView.$$$reportNull$$$0(4);
        }
        return myTableHeader;
    }

    public void setModel(@NotNull TableModel model) {
        if (model == null) {
            TableResultView.$$$reportNull$$$0(5);
        }
        super.setModel(model);
        TableRowSorter<TableModel> rowSorter = this.createRowSorter(model);
        rowSorter.setMaxSortKeys(1);
        rowSorter.setSortsOnUpdates(this.isSortOnUpdates());
        DbUIUtil.invokeLater(() -> {
            if (this.getRowSorter() == rowSorter) {
                this.updateRowFilter();
            }
        });
        this.setRowSorter(rowSorter);
    }

    public void updateRowFilter() {
        DefaultRowSorter sorter = (DefaultRowSorter)this.getRowSorter();
        sorter.setRowFilter(this.myResultPanel.createFilter());
    }

    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
        if (renderer == null) {
            TableResultView.$$$reportNull$$$0(6);
        }
        JComponent component = (JComponent)super.prepareRenderer(renderer, row, column);
        boolean selected = this.isRowSelected(row) && this.isColumnSelected(column);
        Color background = this.getCellBackground(row, column, selected);
        Color foreground = this.getCellForeground(selected);
        JComponent unwrapped = component;
        if (component instanceof ExpandedItemRendererComponentWrapper && component.getComponentCount() == 1) {
            unwrapped = (JComponent)ObjectUtils.chooseNotNull((Object)ObjectUtils.tryCast((Object)component.getComponent(0), JComponent.class), (Object)component);
        }
        unwrapped.setBackground(background);
        unwrapped.setForeground(foreground);
        unwrapped.setOpaque(!Comparing.equal((Object)unwrapped.getBackground(), (Object)this.getBackground()));
        if (unwrapped instanceof CellRendererPanel) {
            ((CellRendererPanel)unwrapped).setSelected(!Comparing.equal((Object)background, (Object)this.getBackground()));
        }
        JComponent jComponent = component;
        if (jComponent == null) {
            TableResultView.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    private Color getCellBackground(int row, int column, boolean selected) {
        return selected ? this.getSelectionBackground() : this.myResultPanel.getColorModel().getCellBackground(ViewIndex.forRow(this.myResultPanel, this.myResultPanel.isTransposed() ? column : row).toModel(this.myResultPanel), ViewIndex.forColumn(this.myResultPanel, this.myResultPanel.isTransposed() ? row : column).toModel(this.myResultPanel));
    }

    private Color getCellForeground(boolean selected) {
        return selected ? this.getSelectionForeground() : this.getForeground();
    }

    public boolean isCellEditable(int row, int column) {
        return this.myResultPanel.isCellEditingAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editCellAt(int row, int column, EventObject e) {
        UIUtil.putClientProperty((JComponent)((Object)this), EDITING_STARTER_CLIENT_PROPERTY_KEY, (Object)e);
        try {
            boolean bl = super.editCellAt(row, column, e);
            return bl;
        }
        finally {
            UIUtil.putClientProperty((JComponent)((Object)this), EDITING_STARTER_CLIENT_PROPERTY_KEY, null);
        }
    }

    public void createDefaultColumnsFromModel() {
        GridTableModel model = this.getModel();
        if (model == null) {
            return;
        }
        this.getTableHeader().setDraggedColumn(null);
        ((MyTableColumnModel)this.getColumnModel()).removeAllColumns();
        IntArrayList newColumnIndices = new IntArrayList();
        for (int columnDataIdx = 0; columnDataIdx < model.getColumnCount(); ++columnDataIdx) {
            boolean notShownEarlier = !this.myColumnCache.hasCachedColumn(columnDataIdx);
            this.myColumnCache.getOrCreateColumn(columnDataIdx);
            boolean enabled = this.isTransposed() || this.myResultPanel.getColumnAttributes().isEnabled(this.getColumn(columnDataIdx));
            this.myResultPanel.setColumnEnabled(columnDataIdx, enabled);
            if (!notShownEarlier || !enabled) continue;
            newColumnIndices.add(columnDataIdx);
        }
        if (!newColumnIndices.isEmpty()) {
            ModelIndexSet<Object> dataIndices = this.isTransposed() ? ModelIndexSet.forRows(this.myResultPanel, newColumnIndices.toArray()) : ModelIndexSet.forColumns(this.myResultPanel, newColumnIndices.toArray());
            this.myResultPanel.getColumnLayout().columnsShown(dataIndices);
        }
    }

    public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        if (visibleRect == null) {
            TableResultView.$$$reportNull$$$0(8);
        }
        if (orientation == 1) {
            return this.getColorsScheme().getEditorFontSize();
        }
        return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    public Font getFont() {
        return this.myPaintingSession != null ? this.myPaintingSession.getFont() : this.doGetFont();
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        this.myColorScheme = null;
        this.updateFonts();
    }

    public void changeFontSize(int increment, double scale) {
        int oldFontSize;
        double newIncrement = this.myFontSizeIncrement * scale + (double)increment;
        double newScale = this.myFontSizeScale * scale;
        int newFontSize = this.fontSize(newIncrement, newScale);
        if (newFontSize == (oldFontSize = this.getFont().getSize())) {
            return;
        }
        this.myFontSizeIncrement = newIncrement;
        this.myFontSizeScale = newScale;
        this.updateFonts();
    }

    private void updateFonts() {
        this.setFont(this.getFont());
        this.setRowHeight(this.getRowHeight());
        JTableHeader tableHeader = this.getTableHeader();
        if (tableHeader != null) {
            tableHeader.setFont(this.getScaledFont(tableHeader.getFont()));
        }
        this.layoutColumns();
    }

    public void uiSettingsChanged(UISettings uiSettings) {
        if (this.changeHeaderFont(uiSettings)) {
            this.layoutColumns();
        }
    }

    private boolean changeHeaderFont(UISettings settings) {
        boolean normalMode;
        boolean presentationMode;
        JTableHeader header = this.getTableHeader();
        if (settings == null || header == null || header.getFont() == null) {
            return false;
        }
        int fontSize = header.getFont().getSize();
        boolean bl = presentationMode = settings.getPresentationMode() && fontSize != settings.getPresentationModeFontSize();
        if (presentationMode) {
            header.setFont(header.getFont().deriveFont((float)settings.getPresentationModeFontSize()));
        }
        boolean bl2 = normalMode = !settings.getPresentationMode() && fontSize == settings.getPresentationModeFontSize();
        if (normalMode) {
            header.setFont(this.getScaledFont(header.getFont()));
        }
        return presentationMode || normalMode;
    }

    private int fontSize(double fontSizeIncrement, double fontSizeScale) {
        int baseFontSize = this.getColorsScheme().getEditorFontSize();
        int newFontSize = (int)Math.max(fontSizeScale * (double)baseFontSize + fontSizeIncrement, 8.0);
        return Math.min(Math.max(EditorFontsConstants.getMaxEditorFontSize(), baseFontSize), newFontSize);
    }

    public int getRowHeight() {
        return this.myPaintingSession != null ? this.myPaintingSession.getRowHeight() : this.doGetRowHeight();
    }

    int getTextLineHeight() {
        return (int)((float)this.getFontMetrics(this.getFont()).getHeight() * this.getColorsScheme().getLineSpacing());
    }

    public Color getSelectionForeground() {
        return this.myPaintingSession != null ? this.myPaintingSession.getSelectionForeground() : this.doGetSelectionForeground();
    }

    public Color getSelectionBackground() {
        return this.myPaintingSession != null ? this.myPaintingSession.getSelectionBackground() : this.doGetSelectionBackground();
    }

    public Color getForeground() {
        return this.myPaintingSession != null ? this.myPaintingSession.getForeground() : this.doGetForeground();
    }

    public Color getBackground() {
        return this.myPaintingSession != null ? this.myPaintingSession.getBackground() : this.doGetBackground();
    }

    public void setBackground(@NotNull Color bg) {
        if (bg == null) {
            TableResultView.$$$reportNull$$$0(9);
        }
    }

    public Color getGridColor() {
        return this.myPaintingSession != null ? this.myPaintingSession.getGridColor() : this.doGetGridColor();
    }

    public void tableChanged(TableModelEvent e) {
        if (this.myResultPanel == null) {
            super.tableChanged(e);
            return;
        }
        this.myResultPanel.getAutoscrollLocker().runWithLock(() -> super.tableChanged(e));
        this.myResultPanel.fireContentChanged();
    }

    public GridTableModel getModel() {
        return (GridTableModel)super.getModel();
    }

    public Object getValueAt(int row, int column) {
        boolean commonValue = this.isEditing() && this.isCellSelected(row, column) && this.isMultiEditingAllowed();
        return commonValue ? this.myCommonValue.get() : super.getValueAt(row, column);
    }

    public void setCommonEditorValue(@Nullable Object object) {
        this.myCommonValue = Ref.create((Object)object);
    }

    public void removeEditor() {
        try {
            super.removeEditor();
        }
        finally {
            this.myCommonValue = null;
        }
    }

    boolean isTransposed() {
        return this.getModel() instanceof GridTableModel.Transposed;
    }

    private void onHeaderClicked(int columnDataIdx, MouseEvent e) {
        if (this.isTransposed() && !this.myResultPanel.allowHeaderActionsInTransposeMode()) {
            return;
        }
        if (e.getID() == 500 && e.getButton() == 2 && e.getClickCount() == 1) {
            if (columnDataIdx >= 0) {
                this.myResultPanel.setColumnEnabled(columnDataIdx, false);
            }
        } else if (e.isPopupTrigger() && this.myColumnHeaderPopupActions != ActionGroup.EMPTY_GROUP) {
            this.myClickedHeaderColumnIdx = ModelIndex.forColumn(this.myResultPanel, columnDataIdx);
            if (this.myResultPanel.isHeaderSelecting()) {
                boolean interval = DbUIUtil.isIntervalModifierSet(e);
                boolean exclusive = DbUIUtil.isExclusiveModifierSet(e);
                if (interval) {
                    int lead = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                    if (exclusive) {
                        GridSelection.addRowSelectionInterval((JTable)((Object)this), this.getRowCount() - 1, 0);
                        GridSelection.addColumnSelectionInterval((JTable)((Object)this), columnDataIdx, lead);
                    } else {
                        GridSelection.setRowSelectionInterval((JTable)((Object)this), this.getRowCount() - 1, 0);
                        GridSelection.setColumnSelectionInterval((JTable)((Object)this), columnDataIdx, lead);
                    }
                } else if (exclusive) {
                    this.removeColumnSelectionInterval(columnDataIdx, columnDataIdx);
                } else {
                    GridSelection.setRowSelectionInterval((JTable)((Object)this), this.getRowCount() - 1, 0);
                    GridSelection.setColumnSelectionInterval((JTable)((Object)this), columnDataIdx, columnDataIdx);
                }
            }
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", this.myColumnHeaderPopupActions);
            popupMenu.getComponent().addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    DbUIUtil.invokeLater(() -> TableResultView.this.myClickedHeaderColumnIdx = ModelIndex.forColumn(TableResultView.this.myResultPanel, -1));
                }
            });
            popupMenu.getComponent().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public boolean isMultiEditingAllowed() {
        int[] selectedColumns = this.isTransposed() ? this.getSelectedRows() : this.getSelectedColumns();
        int[] selectedRows = this.isTransposed() ? this.getSelectedColumns() : this.getSelectedRows();
        ModelIndexSet<DataConsumer.Column> indexSet = ViewIndexSet.forColumns(this.myResultPanel, selectedColumns).toModel(this.myResultPanel);
        List<DataConsumer.Column> columns2 = this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA).getColumns(indexSet);
        DataConsumer.Column uniqueColumn = (DataConsumer.Column)ContainerUtil.find(columns2, column -> {
            DasColumn dasColumn = DataGridUtil.getDatabaseColumn(this.myResultPanel, column);
            return DasUtil.isPrimary((DasColumn)dasColumn) || DasUtil.isAutoGenerated((DasColumn)dasColumn) || DasUtil.isIndexColumn((DasColumn)dasColumn);
        });
        return this.myCommonValue != null && (uniqueColumn == null || selectedRows.length == 1) && this.canEditTogether(columns2);
    }

    private boolean canEditTogether(@NotNull List<DataConsumer.Column> columns2) {
        DbDataSource system;
        if (columns2 == null) {
            TableResultView.$$$reportNull$$$0(10);
        }
        if ((system = DataGridUtil.getDatabaseSystem(this.myResultPanel)) == null) {
            return true;
        }
        DomainRegistry registry = DomainRegistry.get(DataGridUtil.getDatabaseDialect(this.myResultPanel), system.getDatabaseProductVersion());
        if (registry == null) {
            return false;
        }
        for (int i2 = 0; i2 < columns2.size(); ++i2) {
            DataConsumer.Column outer = columns2.get(i2);
            Domain outerDomain = registry.getDomain(outer);
            if (outerDomain == null) {
                return false;
            }
            for (int j = i2 + 1; j < columns2.size(); ++j) {
                DataConsumer.Column inner = columns2.get(j);
                Domain innerDomain = registry.getDomain(inner);
                if (innerDomain == null) {
                    return false;
                }
                Compatibility compatibility = outerDomain.getCompatibility(innerDomain);
                if (compatibility.isCompatible()) continue;
                return false;
            }
        }
        return true;
    }

    protected TableRowSorter<TableModel> createRowSorter(TableModel model) {
        final GridTableModel m = this.getModel();
        return new TableRowSorter<TableModel>((TableModel)m){
            {
                super(x0);
                this.setModelWrapper(new DefaultRowSorter.ModelWrapper<TableModel, Integer>(){

                    @Override
                    public TableModel getModel() {
                        return m;
                    }

                    @Override
                    public int getColumnCount() {
                        return m.getColumnCount();
                    }

                    @Override
                    public int getRowCount() {
                        return m.getRowCount();
                    }

                    @Override
                    public Object getValueAt(int row, int column) {
                        return TableResultView.this.getRow(row);
                    }

                    @Override
                    public Integer getIdentifier(int row) {
                        return row;
                    }
                });
            }

            @Override
            public void toggleSortOrder(int columnDataIdx) {
                if (TableResultView.this.isTransposed()) {
                    return;
                }
                TableResultView.this.myResultPanel.getAutoscrollLocker().runWithLock(() -> TableResultView.this.myResultPanel.changeSortOrder(ModelIndex.forColumn(TableResultView.this.myResultPanel, columnDataIdx), null, false));
            }

            @Override
            protected boolean useToString(int column) {
                return false;
            }

            @Override
            public Comparator<?> getComparator(int modelColumnIdx) {
                Comparator<Object> comparator = null;
                if (!TableResultView.this.isTransposed()) {
                    DataConsumer.Column column = TableResultView.this.getColumn(modelColumnIdx);
                    comparator = TableResultView.this.myResultPanel.getColumnAttributes().getComparator(column);
                }
                return comparator != null ? comparator : super.getComparator(modelColumnIdx);
            }

            @Override
            public boolean isSortable(int columnDataIdx) {
                DataConsumer.Column column = !TableResultView.this.isTransposed() ? TableResultView.this.getColumn(columnDataIdx) : null;
                return column != null && TableResultView.this.myResultPanel.getColumnAttributes().getComparator(column) != null;
            }
        };
    }

    public TableCellEditor getCellEditor(int row, int column) {
        ModelIndex<DataConsumer.Row> rowIdx = ViewIndex.forRow(this.myResultPanel, this.isTransposed() ? column : row).toModel(this.myResultPanel);
        ModelIndex<DataConsumer.Column> columnIdx = ViewIndex.forColumn(this.myResultPanel, this.isTransposed() ? row : column).toModel(this.myResultPanel);
        GridCellEditorFactory editorFactory = this.myEditorProvider.getEditorFactory(this.myResultPanel, rowIdx, columnIdx);
        DataConsumer.Column dataColumn = this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx);
        return !DbImplUtil.isRowId(dataColumn) && editorFactory != null ? new GridTableCellEditor(this.myResultPanel, rowIdx, columnIdx, editorFactory) : null;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = this.myRenderers.getRenderer(row, column);
        renderer = renderer == null ? super.getCellRenderer(row, column) : renderer;
        return renderer == null ? null : this.myCellImageCache.wrapCellRenderer(renderer);
    }

    public void setValueAt(Object value, int viewRowIdx, int viewColumnIdx) {
        int[] nArray;
        int[] nArray2;
        boolean allowed = this.isMultiEditingAllowed();
        if (allowed) {
            nArray2 = this.getSelectedRows();
        } else {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = viewRowIdx;
        }
        int[] rows = nArray2;
        if (allowed) {
            nArray = this.getSelectedColumns();
        } else {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = viewColumnIdx;
        }
        int[] columns2 = nArray;
        ViewIndexSet<DataConsumer.Row> rowsSet = ViewIndexSet.forRows(this.myResultPanel, this.isTransposed() ? columns2 : rows);
        ViewIndexSet<DataConsumer.Column> columnsSet = ViewIndexSet.forColumns(this.myResultPanel, this.isTransposed() ? rows : columns2);
        this.myResultPanel.setValueAt(rowsSet, columnsSet, value);
    }

    private Font doGetFont() {
        return this.getScaledFont(this.getColorsScheme().getFont(EditorFontType.PLAIN));
    }

    private Font getScaledFont(Font font) {
        return UISettings.getInstance().getPresentationMode() ? font : (font == null ? null : font.deriveFont((float)this.fontSize(this.myFontSizeIncrement, this.myFontSizeScale)));
    }

    private int doGetRowHeight() {
        return this.getTextLineHeight() + this.getRowMargin();
    }

    private Color doGetGridColor() {
        return (Color)ObjectUtils.chooseNotNull((Object)this.getColorsScheme().getColor(EditorColors.INDENT_GUIDE_COLOR), (Object)UIUtil.getTableGridColor());
    }

    private Color doGetForeground() {
        return (Color)ObjectUtils.chooseNotNull((Object)this.getColorsScheme().getDefaultForeground(), (Object)UIUtil.getTableForeground());
    }

    private Color doGetBackground() {
        return (Color)ObjectUtils.chooseNotNull((Object)this.getColorsScheme().getDefaultBackground(), (Object)UIUtil.getTableBackground());
    }

    @Nullable
    private Color doGetSelectionForeground() {
        return (Color)ObjectUtils.chooseNotNull((Object)this.getColorsScheme().getColor(DatabaseColors.GRID_SELECTION_FOREGROUND), (Object)UIUtil.getTableSelectionForeground());
    }

    @Nullable
    private Color doGetSelectionBackground() {
        return (Color)ObjectUtils.chooseNotNull((Object)this.getColorsScheme().getColor(DatabaseColors.GRID_SELECTION_BACKGROUND), (Object)UIUtil.getTableSelectionBackground());
    }

    static Rectangle getLabelTextRect(JLabel label) {
        Dimension pref = label.getPreferredSize();
        Rectangle bounds = label.getBounds();
        Insets insets = label.getInsets();
        int w = Math.min(pref.width, bounds.width);
        bounds.setSize(w - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
        bounds.translate(insets.left, insets.top);
        return bounds;
    }

    @Nullable
    private DataConsumer.Row getRow(int modelRowIdx) {
        return this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA).getRow(ModelIndex.forRow(this.myResultPanel, modelRowIdx));
    }

    @Nullable
    private DataConsumer.Column getColumn(int modelColumnIdx) {
        return this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA).getColumn(ModelIndex.forColumn(this.myResultPanel, modelColumnIdx));
    }

    @NotNull
    static Icon getSortOrderIcon(int sortOrder) {
        Icon icon = sortOrder < 0 ? AllIcons.General.SplitUp : (sortOrder > 0 ? AllIcons.General.SplitDown : AllIcons.General.SplitCenterV);
        if (icon == null) {
            TableResultView.$$$reportNull$$$0(11);
        }
        return icon;
    }

    @NotNull
    ActionCallback layoutColumns() {
        this.myResultPanel.trueLayout();
        ActionCallback callback = new ActionCallback();
        DbUIUtil.invokeLater(() -> {
            if (SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && this.myResultPanel.getColumnLayout().doLayout()) {
                callback.setDone();
            }
        });
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            TableResultView.$$$reportNull$$$0(12);
        }
        return actionCallback;
    }

    static String getSortOrderText(int sortOrder) {
        return sortOrder != 0 ? String.valueOf(Math.abs(sortOrder)) : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/TableResultView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRect";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeaderRenderer";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/TableResultView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultTableHeader";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRenderer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortOrderIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "layoutColumns";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "paintComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getToolTipText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenderer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getScrollableUnitIncrement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setBackground";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canEditTogether";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class MyTableColumnCache
    implements Iterable<MyTableColumn> {
        private final TIntObjectHashMap<Entry> myColumnDataIndicesToEntries = new TIntObjectHashMap();

        MyTableColumnCache() {
        }

        public boolean hasCachedColumn(int columnDataIdx) {
            boolean isCached = this.hasValidEntry(columnDataIdx);
            if (!isCached) {
                this.myColumnDataIndicesToEntries.remove(columnDataIdx);
                return false;
            }
            return true;
        }

        public MyTableColumn getOrCreateColumn(int columnDataIdx) {
            Entry e = (Entry)this.myColumnDataIndicesToEntries.get(columnDataIdx);
            if (!this.hasCachedColumn(columnDataIdx) || e == null) {
                e = this.createEntry(columnDataIdx);
                this.myColumnDataIndicesToEntries.put(columnDataIdx, (Object)e);
            }
            return e.myTableColumn;
        }

        @NotNull
        private Entry createEntry(int columnDataIdx) {
            MyTableColumn tableColumn = TableResultView.this.isTransposed() ? this.createTableColumnForRow(ModelIndex.forRow(TableResultView.this.myResultPanel, columnDataIdx)) : this.createTableColumnForColumn(ModelIndex.forColumn(TableResultView.this.myResultPanel, columnDataIdx));
            Object columnData = this.getColumnData(columnDataIdx);
            Entry entry = new Entry(ObjectUtils.assertNotNull((Object)columnData), tableColumn);
            if (entry == null) {
                MyTableColumnCache.$$$reportNull$$$0(0);
            }
            return entry;
        }

        public void retainColumns(final Collection<? extends DataConsumer.Column> columnsToRetain) {
            this.myColumnDataIndicesToEntries.retainEntries((TIntObjectProcedure)new TIntObjectProcedure<Entry>(){

                public boolean execute(int columnDataIdx, @NotNull Entry e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return columnsToRetain.contains(e.myColumnData);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultView$MyTableColumnCache$1", "execute"));
                }
            });
        }

        @Override
        public Iterator<MyTableColumn> iterator() {
            return new Iterator<MyTableColumn>(){
                private final TIntObjectIterator<Entry> myWrappee;
                private Entry myCurrentEntry;
                {
                    this.myWrappee = MyTableColumnCache.this.myColumnDataIndicesToEntries.iterator();
                }

                @Override
                public boolean hasNext() {
                    this.advance();
                    return this.myCurrentEntry != null;
                }

                @Override
                public MyTableColumn next() {
                    MyTableColumn column = this.myCurrentEntry.myTableColumn;
                    this.myCurrentEntry = null;
                    return column;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private void advance() {
                    this.myCurrentEntry = null;
                    while (this.myWrappee.hasNext()) {
                        this.myWrappee.advance();
                        if (MyTableColumnCache.this.hasValidEntry(this.myWrappee.key())) {
                            this.myCurrentEntry = (Entry)this.myWrappee.value();
                            break;
                        }
                        this.myWrappee.remove();
                    }
                }
            };
        }

        private boolean hasValidEntry(int columnDataIdx) {
            Entry e = (Entry)this.myColumnDataIndicesToEntries.get(columnDataIdx);
            if (e == null) {
                return false;
            }
            Object cachedColumnData = e.myColumnData;
            Object currentColumnData = this.getColumnData(columnDataIdx);
            if (Comparing.equal((Object)cachedColumnData, (Object)currentColumnData)) {
                return true;
            }
            if (cachedColumnData instanceof DataConsumer.Row && currentColumnData instanceof DataConsumer.Row) {
                DataConsumer.Row cachedRow = (DataConsumer.Row)cachedColumnData;
                DataConsumer.Row currentRow = (DataConsumer.Row)currentColumnData;
                if (cachedRow.rowNum == currentRow.rowNum && cachedRow.values.length == currentRow.values.length) {
                    int mismatchedValuesCount = 0;
                    for (int i2 = 0; i2 < cachedRow.values.length; ++i2) {
                        if (Comparing.equal((Object)cachedRow.values[i2], (Object)currentRow.values[i2])) continue;
                        ++mismatchedValuesCount;
                    }
                    if (mismatchedValuesCount < 2) {
                        return true;
                    }
                }
            }
            return false;
        }

        private Object getColumnData(int columnDataIdx) {
            return TableResultView.this.isTransposed() ? TableResultView.this.getRow(columnDataIdx) : TableResultView.this.getColumn(columnDataIdx);
        }

        @NotNull
        private MyTableColumn createTableColumnForColumn(ModelIndex<DataConsumer.Column> columnIdx) {
            DataConsumer.Column column = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)TableResultView.this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx));
            MyTableColumn myTableColumn = new MyTableColumn(column, columnIdx.asInteger());
            if (myTableColumn == null) {
                MyTableColumnCache.$$$reportNull$$$0(1);
            }
            return myTableColumn;
        }

        @NotNull
        private MyTableColumn createTableColumnForRow(ModelIndex<DataConsumer.Row> rowIdx) {
            MyTableColumn myTableColumn = new MyTableColumn(rowIdx.asInteger());
            if (myTableColumn == null) {
                MyTableColumnCache.$$$reportNull$$$0(2);
            }
            return myTableColumn;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/run/ui/TableResultView$MyTableColumnCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTableColumnForColumn";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTableColumnForRow";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        private final class Entry {
            @NotNull
            public final Object myColumnData;
            @NotNull
            public final MyTableColumn myTableColumn;

            public Entry(@NotNull Object columnData, MyTableColumn tableColumn) {
                if (MyTableColumnCache.this == null) {
                    Entry.$$$reportNull$$$0(0);
                }
                if (columnData == null) {
                    Entry.$$$reportNull$$$0(1);
                }
                if (tableColumn == null) {
                    Entry.$$$reportNull$$$0(2);
                }
                this.myColumnData = columnData;
                this.myTableColumn = tableColumn;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                String string;
                switch (n) {
                    default: {
                        string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "0";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "columnData";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "tableColumn";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/ui/TableResultView$MyTableColumnCache$Entry";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format(string, objectArray));
            }
        }
    }

    protected class MyTableColumn
    extends TableColumn
    implements GridColumn {
        private final DataConsumer.Column myColumn;
        private final UserDataHolder myDataHolderDelegate;
        private int myWidthFromLayout;

        public MyTableColumn(int modelIndex) {
            this(null, modelIndex);
        }

        private MyTableColumn(DataConsumer.Column column, int modelIndex) {
            super(modelIndex);
            this.myDataHolderDelegate = new UserDataHolderBase();
            this.myColumn = column;
        }

        public Icon getIcon() {
            DasColumn databaseColumn = DataGridUtil.getDatabaseColumn(TableResultView.this.myResultPanel, this.myColumn);
            return databaseColumn != null ? DbPresentation.getIcon((DasObject)databaseColumn) : null;
        }

        @Override
        @NotNull
        public String getHeaderValue() {
            String string = this.myColumn == null ? DataGridUtil.getRowName(TableResultView.this.myResultPanel, this.getModelIndex()) : TableResultView.this.myResultPanel.getColumnAttributes().getName(this.myColumn);
            if (string == null) {
                MyTableColumn.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public int getPreferredHeaderWidth() {
            MyCellRenderer renderer = (MyCellRenderer)TableResultView.this.getTableHeader().getDefaultRenderer();
            Component headerComponent = renderer.getHeaderCellRendererComponent(this.getModelIndex());
            return headerComponent.getPreferredSize().width;
        }

        @Nullable
        public String getTooltipText() {
            return TableResultView.this.myResultPanel.getColumnTooltipHtml(this.myColumn);
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                MyTableColumn.$$$reportNull$$$0(1);
            }
            return (T)this.myDataHolderDelegate.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                MyTableColumn.$$$reportNull$$$0(2);
            }
            this.myDataHolderDelegate.putUserData(key, value);
        }

        @Override
        public int getColumnWidth() {
            return this.getPreferredWidth();
        }

        @Override
        public void setColumnWidth(int width) {
            this.myWidthFromLayout = width;
            this.setPreferredWidth(width);
        }

        public boolean isWidthSetByLayout() {
            return this.myWidthFromLayout == this.getPreferredWidth();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/TableResultView$MyTableColumn";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHeaderValue";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/TableResultView$MyTableColumn";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserData";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "putUserData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class MyHeaderCellComponent
    extends CellRendererPanel {
        private final TableResultView myTable;
        private final JLabel myNameLabel;
        private final JLabel mySortLabel;
        private MyTableColumn myCurrentColumn;

        public MyHeaderCellComponent(TableResultView table) {
            this.myTable = table;
            this.myNameLabel = new MyJBLabel();
            this.mySortLabel = new MyJBLabel();
            this.myNameLabel.setHorizontalAlignment(2);
            this.myNameLabel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)CellRenderingUtils.NAME_LABEL_INSETS));
            this.mySortLabel.setVerticalAlignment(0);
            this.mySortLabel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)CellRenderingUtils.SORT_LABEL_INSETS));
            this.setLayout(new BorderLayout(JBUI.scale((int)2), 0));
            this.add(this.myNameLabel, "Center");
            this.add(this.mySortLabel, "East");
            this.setBorder((Border)new CustomLineBorder(0, 0, 1, 1){

                protected Color getColor() {
                    Color gridColor = myTable.getGridColor();
                    return gridColor != null ? gridColor : super.getColor();
                }
            });
        }

        protected void paintComponent(Graphics g) {
            UISettings.setupAntialiasing((Graphics)g);
            this.setSelected(true);
            super.paintComponent(g);
        }

        protected Rectangle getNameRect() {
            return TableResultView.getLabelTextRect(this.myNameLabel);
        }

        protected int getModelIdx() {
            return this.myCurrentColumn.getModelIndex();
        }

        public MyHeaderCellComponent prepare(int columnDataIdx) {
            this.myCurrentColumn = this.myTable.getColumnCache().getOrCreateColumn(columnDataIdx);
            this.myNameLabel.setIcon(this.myCurrentColumn.getIcon());
            this.myNameLabel.setText(this.myCurrentColumn.getHeaderValue());
            Icon sortLabelIcon = null;
            String sortLabelText = "";
            if (!this.myTable.isTransposed()) {
                DataConsumer.Column column = this.myTable.getColumn(columnDataIdx);
                if (column != null) {
                    if (this.myTable.myResultPanel.getColumnAttributes().getComparator(column) != null) {
                        int sortOrder = this.myTable.myResultPanel.getSortOrder(column);
                        sortLabelIcon = TableResultView.getSortOrderIcon(sortOrder);
                        sortLabelText = TableResultView.getSortOrderText(sortOrder);
                    }
                    this.myNameLabel.setHorizontalAlignment(ObjectFormatter.isNumericColumn(column) ? 4 : 2);
                }
            } else {
                this.myNameLabel.setHorizontalAlignment(2);
            }
            this.mySortLabel.setIcon(sortLabelIcon);
            this.mySortLabel.setText(sortLabelText);
            return this;
        }

        public String getToolTipText(MouseEvent event) {
            return this.myCurrentColumn != null ? this.myCurrentColumn.getTooltipText() : super.getToolTipText(event);
        }

        public Color getBackground() {
            return this.myCurrentColumn == null ? super.getBackground() : (this.myTable.myResultPanel.isTransposed() ? this.myTable.myResultPanel.getColorModel().getRowHeaderBackground(ModelIndex.forRow(this.myTable.myResultPanel, this.myCurrentColumn.getModelIndex())) : this.myTable.myResultPanel.getColorModel().getColumnHeaderBackground(ModelIndex.forColumn(this.myTable.myResultPanel, this.myCurrentColumn.getModelIndex())));
        }

        private class MyJBLabel
        extends JBLabel {
            private MyJBLabel() {
            }

            public Color getBackground() {
                return MyHeaderCellComponent.this.myTable.getBackground();
            }

            public Color getForeground() {
                return MyHeaderCellComponent.this.myTable.getForeground();
            }

            public Font getFont() {
                return MyHeaderCellComponent.this.myTable.getTableHeader().getFont();
            }
        }
    }

    private static class GridCellRendererWrapper
    implements TableCellRenderer {
        final GridCellRenderer delegate;

        private GridCellRendererWrapper(GridCellRenderer renderer) {
            this.delegate = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DataGrid grid;
            boolean transposed = ((TableResultPanel)(grid = this.delegate.myGrid)).getTable().isTransposed();
            ModelIndex<DataConsumer.Row> rowIdx = ViewIndex.forRow(grid, transposed ? column : row).toModel(grid);
            ModelIndex<DataConsumer.Column> columnIdx = ViewIndex.forColumn(grid, transposed ? row : column).toModel(grid);
            return this.delegate.getComponent(rowIdx, columnIdx, value);
        }
    }

    private static class Renderers {
        private final GridCellRenderers myGridRenderers;
        private final Map<GridCellRenderer, TableCellRenderer> myTableCellRenderers = ContainerUtil.newIdentityTroveMap();

        Renderers(TableResultPanel resultPanel) {
            this.myGridRenderers = new GridCellRenderers(resultPanel);
            Disposer.register((Disposable)resultPanel, (Disposable)this.myGridRenderers);
        }

        public TableCellRenderer getRenderer(int row, int column) {
            ModelIndex<DataConsumer.Column> columnIdx;
            DataGrid grid;
            boolean transposed = ((TableResultPanel)(grid = this.myGridRenderers.grid)).getTable().isTransposed();
            ModelIndex<DataConsumer.Row> rowIdx = ViewIndex.forRow(grid, transposed ? column : row).toModel(grid);
            GridCellRenderer gridCellRenderer = this.myGridRenderers.getRenderer(rowIdx, columnIdx = ViewIndex.forColumn(grid, transposed ? row : column).toModel(grid));
            if (gridCellRenderer == null) {
                return null;
            }
            TableCellRenderer renderer = this.myTableCellRenderers.get(gridCellRenderer);
            if (renderer == null) {
                renderer = new GridCellRendererWrapper(gridCellRenderer);
                this.myTableCellRenderers.put(gridCellRenderer, renderer);
            }
            return renderer;
        }
    }

    private class PaintingSession {
        private Font myFont;
        private Color myGridColor;
        private Color myForeground;
        private Color myBackground;
        private Color mySelectionForeground;
        private Color mySelectionBackground;
        private int myRowHeight = -1;

        private PaintingSession() {
        }

        public Font getFont() {
            return this.myFont != null ? this.myFont : (this.myFont = TableResultView.this.doGetFont());
        }

        public int getRowHeight() {
            return this.myRowHeight != -1 ? this.myRowHeight : (this.myRowHeight = TableResultView.this.doGetRowHeight());
        }

        public Color getGridColor() {
            return this.myGridColor != null ? this.myGridColor : (this.myGridColor = TableResultView.this.doGetGridColor());
        }

        public Color getForeground() {
            return this.myForeground != null ? this.myForeground : (this.myForeground = TableResultView.this.doGetForeground());
        }

        public Color getBackground() {
            return this.myBackground != null ? this.myBackground : (this.myBackground = TableResultView.this.doGetBackground());
        }

        public Color getSelectionForeground() {
            return this.mySelectionForeground != null ? this.mySelectionForeground : (this.mySelectionForeground = TableResultView.this.doGetSelectionForeground());
        }

        public Color getSelectionBackground() {
            return this.mySelectionBackground != null ? this.mySelectionBackground : (this.mySelectionBackground = TableResultView.this.doGetSelectionBackground());
        }
    }

    protected class MyTableHeader
    extends JBTable.JBTableHeader {
        private int myLastPositiveHeight;

        protected MyTableHeader() {
            super((JBTable)TableResultView.this);
            this.myLastPositiveHeight = 0;
            this.setOpaque(false);
            this.setFocusable(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(@NotNull MouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.processEvent(e);
                }

                @Override
                public void mousePressed(@NotNull MouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.processEvent(e);
                }

                @Override
                public void mouseReleased(@NotNull MouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    this.processEvent(e);
                }

                private void processEvent(MouseEvent e) {
                    IntIntFunction toModel = TableResultView.this.isTransposed() ? TableResultView.this.myRawIndexConverter.row2Model() : TableResultView.this.myRawIndexConverter.column2Model();
                    int columnDataIdx = toModel.fun(MyTableHeader.this.columnAtPoint(e.getPoint()));
                    if (columnDataIdx >= 0) {
                        TableResultView.this.onHeaderClicked(columnDataIdx, e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/database/run/ui/TableResultView$MyTableHeader$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseClicked";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mousePressed";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "mouseReleased";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public boolean getReorderingAllowed() {
            return !TableResultView.this.isTransposed();
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (d.height <= 0) {
                d.height = this.myLastPositiveHeight;
            }
            return d;
        }

        public void setSize(int width, int height) {
            super.setSize(width, height);
            if (height > 0) {
                this.myLastPositiveHeight = height;
            }
        }

        public void paint(@NotNull Graphics g) {
            if (g == null) {
                MyTableHeader.$$$reportNull$$$0(0);
            }
            Rectangle clip = g.getClipBounds();
            clip.width = Math.max(0, Math.min(clip.width, this.getTable().getWidth() - clip.x));
            g.setClip(clip);
            super.paint(g);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/database/run/ui/TableResultView$MyTableHeader", "paint"));
        }
    }

    static class MyTableColumnModel
    extends DefaultTableColumnModel {
        MyTableColumnModel() {
        }

        @Override
        public void addColumn(TableColumn aColumn) {
            if (!(aColumn instanceof MyTableColumn)) {
                throw new IllegalArgumentException("Unexpected column type");
            }
            super.addColumn(aColumn);
        }

        @Override
        public MyTableColumn getColumn(int columnIndex) {
            return (MyTableColumn)super.getColumn(columnIndex);
        }

        public void removeAllColumns() {
            int columnCount = this.tableColumns.size();
            if (columnCount == 0) {
                return;
            }
            if (this.selectionModel != null) {
                this.selectionModel.removeIndexInterval(0, columnCount - 1);
            }
            for (TableColumn column : this.tableColumns) {
                column.removePropertyChangeListener(this);
            }
            this.totalColumnWidth = -1;
            for (int i2 = columnCount - 1; i2 >= 0; --i2) {
                this.tableColumns.remove(i2);
                this.fireColumnRemoved(new TableColumnModelEvent(this, i2, 0));
            }
        }
    }

    public static class MyCellRenderer
    extends MyHeaderCellComponent
    implements TableCellRenderer {
        private final TableCellRenderer myOriginalRenderer;

        public MyCellRenderer(@NotNull TableResultView table) {
            if (table == null) {
                MyCellRenderer.$$$reportNull$$$0(0);
            }
            super(table);
            this.myOriginalRenderer = table.getTableHeader().getDefaultRenderer();
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table == null) {
                MyCellRenderer.$$$reportNull$$$0(1);
            }
            Component component = row == -1 ? this.getHeaderCellRendererComponent(table.convertColumnIndexToModel(column)) : this.myOriginalRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component == null) {
                MyCellRenderer.$$$reportNull$$$0(2);
            }
            return component;
        }

        protected Component getHeaderCellRendererComponent(int columnDataIdx) {
            return this.prepare(columnDataIdx);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/TableResultView$MyCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/TableResultView$MyCellRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableCellRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getTableCellRendererComponent";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

