/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.reference.SoftReference;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.ui.Gray;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableCellImageCache {
    private CacheImpl myImageCache;
    private Map<TableCellRenderer, CellRendererWrapper> myCellRendererWrappers;
    private final JTable myTable;
    private int myCacheLevel;
    private boolean myWrappedGraphics;
    private final Random myRandom;

    public TableCellImageCache(@NotNull JTable table, @NotNull Disposable disposable) {
        if (table == null) {
            TableCellImageCache.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            TableCellImageCache.$$$reportNull$$$0(1);
        }
        this.myRandom = new Random();
        this.myTable = table;
        this.reset();
        new UiNotifyConnector((Component)this.myTable, (Activatable)new Activatable.Adapter(){

            public void hideNotify() {
                TableCellImageCache.this.reset();
            }
        });
        this.installFastScrollingCaching(disposable);
    }

    private void installFastScrollingCaching(@NotNull Disposable disposable) {
        SingleAlarm scrollingAlarm;
        if (disposable == null) {
            TableCellImageCache.$$$reportNull$$$0(2);
        }
        SingleAlarm[] alarmRef = new SingleAlarm[]{null};
        alarmRef[0] = scrollingAlarm = new SingleAlarm(() -> {
            if (this.myCacheLevel == 0) {
                this.myTable.repaint();
            } else {
                this.myCacheLevel -= 25;
                alarmRef[0].cancelAndRequest();
            }
        }, 100);
        Disposer.register((Disposable)disposable, (Disposable)scrollingAlarm);
        int[] xySum = new int[]{0};
        final ChangeListener scrollListener = e -> {
            Point p = this.myTable.getLocation();
            int curSum = p.x + p.y;
            int delta = xySum[0] == 0 ? 0 : Math.abs(curSum - xySum[0]);
            xySum[0] = curSum;
            if (delta <= this.myTable.getRowHeight() * 4) {
                return;
            }
            scrollingAlarm.cancelAndRequest();
            this.myCacheLevel = 100;
        };
        new UiNotifyConnector.Once((Component)this.myTable, (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                JScrollPane scrollPane = (JScrollPane)ObjectUtils.notNull((Object)UIUtil.getParentOfType(JScrollPane.class, (Component)TableCellImageCache.this.myTable));
                scrollPane.getHorizontalScrollBar().getModel().addChangeListener(scrollListener);
                scrollPane.getVerticalScrollBar().getModel().addChangeListener(scrollListener);
            }
        });
    }

    public TableCellRenderer wrapCellRenderer(@NotNull TableCellRenderer renderer) {
        if (renderer == null) {
            TableCellImageCache.$$$reportNull$$$0(3);
        }
        return this.myCellRendererWrappers.get(renderer);
    }

    public void reset() {
        this.myImageCache = new CacheImpl();
        this.myCellRendererWrappers = FactoryMap.createMap(x$0 -> new CellRendererWrapper((TableCellRenderer)x$0), ContainerUtil::newIdentityTroveMap);
    }

    public void adjustCacheSize() {
        TableColumnModel columnModel = this.myTable.getColumnModel();
        int columnCount = columnModel == null ? 0 : columnModel.getColumnCount();
        int rowCount = this.myTable.getRowCount();
        Rectangle visibleRect = this.myTable.getVisibleRect();
        if (columnCount == 0 || rowCount == 0 || visibleRect.isEmpty()) {
            return;
        }
        int minColumnWidth = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < columnCount; ++i2) {
            TableColumn column = columnModel.getColumn(i2);
            minColumnWidth = Math.min(minColumnWidth, column.getMinWidth());
        }
        int rowHeight = this.myTable.getRowHeight();
        int rowsMax = rowHeight == 0 ? rowCount : Math.min(rowCount, (int)Math.ceil((float)visibleRect.height / (float)rowHeight));
        int colsMax = minColumnWidth == 0 ? columnCount : Math.min(columnCount, (int)Math.ceil((float)visibleRect.width / (float)minColumnWidth));
        this.myImageCache.adjustCacheSize(rowsMax * colsMax);
    }

    @NotNull
    static Object getState(@NotNull Component renderer) {
        if (renderer == null) {
            TableCellImageCache.$$$reportNull$$$0(4);
        }
        Color bg = TableCellImageCache.hashSafeColor(renderer.getBackground());
        Color fg = TableCellImageCache.hashSafeColor(renderer.getForeground());
        Boolean opaque = renderer.isOpaque() ? Boolean.TRUE : Boolean.FALSE;
        Trinity trinity = Trinity.create((Object)bg, (Object)fg, (Object)opaque);
        if (trinity == null) {
            TableCellImageCache.$$$reportNull$$$0(5);
        }
        return trinity;
    }

    @Nullable
    private static Color hashSafeColor(@Nullable Color color) {
        Class<?> colorClass;
        Class<?> clazz = colorClass = color != null ? color.getClass() : null;
        if (colorClass == null || colorClass == Color.class || colorClass == ColorUIResource.class) {
            return color;
        }
        return new Color(color.getRed(), color.getBlue(), color.getGreen(), color.getAlpha());
    }

    private static int getContrastForColor(Color color) {
        int yiqValue = (color.getRed() * 299 + color.getGreen() * 587 + color.getBlue() * 114) / 1000;
        return yiqValue * 150 / 255 + 100;
    }

    private static void updateLcdContrast(Graphics2D g2d, Color color) {
        if (SystemInfo.isJetBrainsJvm) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, TableCellImageCache.getContrastForColor(color));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/TableCellImageCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/TableCellImageCache";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installFastScrollingCaching";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrapCellRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CacheImpl {
        private MySLRUCache myCache = new MySLRUCache(0);

        private CacheImpl() {
        }

        @Nullable
        public BufferedImage get(@NotNull CellStateInfo key) {
            SoftReference imageRef;
            if (key == null) {
                CacheImpl.$$$reportNull$$$0(0);
            }
            if ((imageRef = (SoftReference)this.myCache.get(key)) == null) {
                return null;
            }
            BufferedImage image = (BufferedImage)imageRef.get();
            if (image == null) {
                this.myCache.remove(key);
            }
            return image;
        }

        public void put(@NotNull CellStateInfo key, @NotNull BufferedImage value) {
            if (key == null) {
                CacheImpl.$$$reportNull$$$0(1);
            }
            if (value == null) {
                CacheImpl.$$$reportNull$$$0(2);
            }
            this.myCache.put(key, new SoftReference((Object)value));
        }

        public void clear() {
            this.myCache.clear();
        }

        public void adjustCacheSize(int newMaxSize) {
            int oldCacheSize = this.myCache.getMaximumSize();
            if (oldCacheSize >= newMaxSize && oldCacheSize / 2 < newMaxSize) {
                return;
            }
            MySLRUCache newCache = new MySLRUCache(newMaxSize);
            for (Map.Entry entry : this.myCache.entrySet()) {
                newCache.put(entry.getKey(), entry.getValue());
            }
            this.myCache = newCache;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/TableCellImageCache$CacheImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "put";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class MySLRUCache
        extends SLRUMap<CellStateInfo, SoftReference<BufferedImage>> {
            private final int mySize;

            public MySLRUCache(int size) {
                super(size, size, EqualityPolicy.CANONICAL);
                this.mySize = size;
            }

            public int getMaximumSize() {
                return this.mySize;
            }
        }
    }

    private static final class CellStateInfo {
        final TableCellRenderer myRenderer;
        final Object myValue;
        final boolean myIsSelected;
        final boolean myHasFocus;
        final int myWidth;
        final int myHeight;
        final boolean myIsRetina;
        final Object myUserState;

        CellStateInfo(@NotNull TableCellRenderer renderer, @Nullable Object value, boolean isSelected, boolean hasFocus, int width, int height, boolean isRetina, @Nullable Object userState) {
            if (renderer == null) {
                CellStateInfo.$$$reportNull$$$0(0);
            }
            this.myRenderer = renderer;
            this.myValue = value;
            this.myIsSelected = isSelected;
            this.myHasFocus = hasFocus;
            this.myWidth = width;
            this.myHeight = height;
            this.myIsRetina = isRetina;
            this.myUserState = userState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CellStateInfo info = (CellStateInfo)o;
            if (this.myIsSelected != info.myIsSelected) {
                return false;
            }
            if (this.myHasFocus != info.myHasFocus) {
                return false;
            }
            if (this.myWidth != info.myWidth) {
                return false;
            }
            if (this.myHeight != info.myHeight) {
                return false;
            }
            if (this.myRenderer != info.myRenderer) {
                return false;
            }
            if (!CellStateInfo.equalObjectsAndHashCodes(this.myValue, info.myValue)) {
                return false;
            }
            if (this.myIsRetina != info.myIsRetina) {
                return false;
            }
            return CellStateInfo.equalObjectsAndHashCodes(this.myUserState, info.myUserState);
        }

        public int hashCode() {
            int result2 = System.identityHashCode(this.myRenderer);
            result2 = 31 * result2 + (this.myValue != null ? this.myValue.hashCode() : 0);
            result2 = 31 * result2 + (this.myIsSelected ? 1 : 0);
            result2 = 31 * result2 + (this.myHasFocus ? 1 : 0);
            result2 = 31 * result2 + this.myWidth;
            result2 = 31 * result2 + this.myHeight;
            result2 = 31 * result2 + (this.myIsRetina ? 1 : 0);
            result2 = 31 * result2 + (this.myUserState != null ? this.myUserState.hashCode() : 0);
            return result2;
        }

        private static boolean equalObjectsAndHashCodes(@Nullable Object o1, @Nullable Object o2) {
            return o1 == null && o2 == null || o1 != null && o2 != null && o1.equals(o2) && o1.hashCode() == o2.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/database/run/ui/grid/TableCellImageCache$CellStateInfo", "<init>"));
        }
    }

    private class CellRendererWrapper
    extends CellRendererPanel
    implements TableCellRenderer {
        final TableCellRenderer myWrappee;
        Object myValue;
        boolean myIsSelected;
        boolean myHasFocus;

        CellRendererWrapper(TableCellRenderer wrappee) {
            this.myWrappee = wrappee;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myValue = value;
            this.myIsSelected = isSelected;
            this.myHasFocus = hasFocus;
            Component originalComponent = this.myWrappee.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!this.hasWrappeeComponent()) {
                this.add(originalComponent);
            } else if (originalComponent != this.getWrappeeComponent()) {
                this.removeAll();
                this.add(originalComponent);
            }
            return this;
        }

        protected void paintChildren(Graphics g) {
            boolean tooLargeToCache;
            boolean wrappedGraphics = g instanceof Graphics2DDelegate;
            JComponent originalComponent = this.getWrappeeComponent();
            originalComponent.validate();
            boolean forceNoCaching = wrappedGraphics && (TableCellImageCache.this.myCacheLevel == 0 || TableCellImageCache.this.myCacheLevel < 100 && TableCellImageCache.this.myRandom.nextInt(100) > TableCellImageCache.this.myCacheLevel);
            Rectangle tableVisibleRect = TableCellImageCache.this.myTable.getVisibleRect();
            int width = this.getWidth();
            int height = this.getHeight();
            boolean paintingExpansionHint = this.getParent() instanceof ExpandedItemRendererComponentWrapper;
            boolean bl = tooLargeToCache = tableVisibleRect.width <= width || tableVisibleRect.height <= height;
            if (paintingExpansionHint || tooLargeToCache || forceNoCaching) {
                super.paintChildren(g);
                return;
            }
            if (TableCellImageCache.this.myWrappedGraphics != wrappedGraphics) {
                TableCellImageCache.this.myImageCache.clear();
            }
            TableCellImageCache.this.myWrappedGraphics = wrappedGraphics;
            Graphics2D g2d = (Graphics2D)g;
            boolean isMacRetina = UIUtil.isRetina((Graphics2D)g2d);
            Object userCellState = TableCellImageCache.getState((Component)((Object)this));
            CellStateInfo cacheKey = new CellStateInfo(this, this.myValue, this.myIsSelected, this.myHasFocus, width, height, isMacRetina, userCellState);
            BufferedImage image = TableCellImageCache.this.myImageCache.get(cacheKey);
            if (image == null) {
                image = UIUtil.createImage((Graphics)g2d, (int)width, (int)height, (int)(wrappedGraphics ? 2 : 1));
                this.paintComponentOn(originalComponent, image);
                TableCellImageCache.this.myImageCache.put(cacheKey, image);
            }
            UIUtil.drawImage((Graphics)g, (BufferedImage)image, null, (int)0, (int)0);
        }

        public Border getBorder() {
            return this.hasWrappeeComponent() ? this.getWrappeeBorder() : super.getBorder();
        }

        public void setBorder(Border border) {
            if (this.hasWrappeeComponent() && !(border instanceof UIResource)) {
                this.getWrappeeComponent().setBorder(border);
                return;
            }
            super.setBorder(border);
        }

        public void setBackground(Color bg) {
            if (this.hasWrappeeComponent()) {
                this.getWrappeeComponent().setBackground(bg);
            }
            super.setBackground(bg);
        }

        private Border getWrappeeBorder() {
            Border border = this.getWrappeeComponent().getBorder();
            return border instanceof UIResource ? super.getBorder() : border;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintComponentOn(@NotNull JComponent c, @NotNull BufferedImage image) {
            if (c == null) {
                CellRendererWrapper.$$$reportNull$$$0(0);
            }
            if (image == null) {
                CellRendererWrapper.$$$reportNull$$$0(1);
            }
            boolean hasAlpha = image.getColorModel().hasAlpha();
            boolean wasDoubleBuffered = c.isDoubleBuffered();
            c.setDoubleBuffered(false);
            c.setOpaque(true);
            c.setBackground(this.myIsSelected || !hasAlpha ? c.getBackground() : Gray.TRANSPARENT);
            if (c instanceof CellRendererPanel) {
                ((CellRendererPanel)c).setSelected(this.myIsSelected || !hasAlpha);
            }
            Graphics2D g = image.createGraphics();
            try {
                TableCellImageCache.updateLcdContrast(g, c.getForeground());
                c.paint(g);
            }
            finally {
                g.dispose();
            }
            if (wasDoubleBuffered) {
                c.setDoubleBuffered(true);
            }
        }

        private JComponent getWrappeeComponent() {
            return (JComponent)this.getComponent(0);
        }

        private boolean hasWrappeeComponent() {
            return this.getComponentCount() > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "c";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "image";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ui/grid/TableCellImageCache$CellRendererWrapper";
            objectArray[2] = "paintComponentOn";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

