/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class DataGridFormattersUtil {
    private static final int DEFAULT_ERA = 1;

    private DataGridFormattersUtil() {
    }

    public static int getEra(@NotNull Date date) {
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(0);
        }
        return DataGridFormattersUtil.getEra(Instant.ofEpochMilli(date.getTime()).atZone(ZoneOffset.UTC).withZoneSameInstant(ZoneId.systemDefault()));
    }

    public static int getEra(@NotNull TemporalAccessor date) {
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(1);
        }
        return date.isSupported(ChronoField.ERA) ? date.get(ChronoField.ERA) : 1;
    }

    @NotNull
    public static Date getBoundedValue(@NotNull Object value, @NotNull ModelIndex<DataConsumer.Column> column, @NotNull DataGrid grid) {
        if (value == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(2);
        }
        if (column == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(3);
        }
        if (grid == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(4);
        }
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
        DataConsumer.Column gridColumn = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column);
        BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(dialect.getFamilyId(), gridColumn);
        Date date = resolver.bound(value);
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(5);
        }
        return date;
    }

    @NotNull
    public static OffsetTime convert(@NotNull TimeZonedTime time) {
        if (time == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(6);
        }
        OffsetTime offsetTime = (OffsetTime)time.getValue();
        if (offsetTime == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(7);
        }
        return offsetTime;
    }

    @NotNull
    public static ZoneOffset getDefaultOffset() {
        ZoneOffset zoneOffset = OffsetDateTime.now().getOffset();
        if (zoneOffset == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(8);
        }
        return zoneOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundedValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEra";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBoundedValue";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

