/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.generation;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.generation.ImplicitDepProvider;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlGraphBuilder {
    private final MultiMap<DdlOperationKey, DdlOperationKey> myOperations;
    private final Map<DdlOperationKey, UserDataHolder> myData;
    private final Map<DdlOperationKey, DdlOperationKey> myImplementations;
    private final MultiMap<DdlOperationKey, DdlOperationKey> myDependencies;
    private final MultiMap<DdlOperationKey, DdlOperationKey> myImplicitDependencies;
    private final MultiMap<DeObject, DdlOperationKey> myAnyOperations;
    private final MultiMap<DdlOperation, DdlOperation> myOpImpls;
    private final DatabaseDialectEx myDialect;
    private DdlGraph myWholeGraph;
    private List<DdlGraph> myGraphComponents;
    private boolean myImplicitDepsValid;

    public DdlGraphBuilder(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            DdlGraphBuilder.$$$reportNull$$$0(0);
        }
        this.myOperations = MultiMap.createLinkedSet();
        this.myData = ContainerUtil.newHashMap();
        this.myImplementations = ContainerUtil.newLinkedHashMap();
        this.myDependencies = MultiMap.createLinkedSet();
        this.myImplicitDependencies = MultiMap.createLinkedSet();
        this.myAnyOperations = MultiMap.createLinkedSet();
        this.myOpImpls = MultiMap.createSet();
        this.myDialect = dialect;
    }

    public void invalidate() {
        this.myImplicitDepsValid = false;
        this.myWholeGraph = null;
        this.myGraphComponents = null;
    }

    private void ensureImplicitDepsValid() {
        if (!this.myImplicitDepsValid) {
            this.updateImplicitDependencies();
        }
    }

    @NotNull
    public JBIterable<DdlOperationKey> getOperations() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.myOperations.keySet());
        if (jBIterable == null) {
            DdlGraphBuilder.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @NotNull
    public DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = this.myDialect;
        if (databaseDialectEx == null) {
            DdlGraphBuilder.$$$reportNull$$$0(2);
        }
        return databaseDialectEx;
    }

    @NotNull
    public Collection<DdlOperationKey> getNodes(@NotNull DdlOperationKey key) {
        if (key == null) {
            DdlGraphBuilder.$$$reportNull$$$0(3);
        }
        Collection<DdlOperationKey> collection = this.getRealOperations(Collections.singleton(key));
        if (collection == null) {
            DdlGraphBuilder.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    private static Collection<DdlOperationKey> asCollection(@NotNull Iterable<DdlOperationKey> iterable) {
        if (iterable == null) {
            DdlGraphBuilder.$$$reportNull$$$0(5);
        }
        Collection collection = iterable instanceof Collection ? (Collection)iterable : ContainerUtil.newArrayList(iterable);
        if (collection == null) {
            DdlGraphBuilder.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public DdlGraphBuilder addOperation(@NotNull DdlOperationKey op, @Nullable UserDataHolder data, @NotNull Iterable<DdlOperationKey> implemented) {
        if (op == null) {
            DdlGraphBuilder.$$$reportNull$$$0(7);
        }
        if (implemented == null) {
            DdlGraphBuilder.$$$reportNull$$$0(8);
        }
        if (this.myOperations.containsKey((Object)op)) {
            DdlGraphBuilder ddlGraphBuilder = this;
            if (ddlGraphBuilder == null) {
                DdlGraphBuilder.$$$reportNull$$$0(9);
            }
            return ddlGraphBuilder;
        }
        this.invalidate();
        assert (op.operation != DdlOperation.ANY_OP);
        assert (!this.myImplementations.containsKey(op));
        if (data != null) {
            this.myData.put(op, data);
        }
        this.myOperations.putValues((Object)op, Collections.emptyList());
        this.myAnyOperations.putValue((Object)op.target, (Object)op);
        this.myOpImpls.putValue((Object)op.operation, (Object)op.operation);
        for (DdlOperation iface : op.operation.getInterfaces()) {
            this.myOpImpls.putValue((Object)iface, (Object)op.operation);
        }
        for (DdlOperationKey iface : implemented) {
            this.addImplementation(iface, op);
        }
        this.addImplementation(op, op);
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            DdlGraphBuilder.$$$reportNull$$$0(10);
        }
        return ddlGraphBuilder;
    }

    public boolean isScheduled(@NotNull DdlOperationKey op) {
        if (op == null) {
            DdlGraphBuilder.$$$reportNull$$$0(11);
        }
        return this.myOperations.containsKey((Object)op) || this.myImplementations.containsKey(op) || !JBIterable.of((Object[])op.operation.getInterfaces()).filter(o -> {
            if (op == null) {
                DdlGraphBuilder.$$$reportNull$$$0(60);
            }
            return this.myImplementations.containsKey(new DdlOperationKey(op.target, (DdlOperation)o));
        }).isEmpty();
    }

    @NotNull
    public DdlGraphBuilder removeOperation(@NotNull DdlOperationKey op) {
        if (op == null) {
            DdlGraphBuilder.$$$reportNull$$$0(12);
        }
        this.invalidate();
        this.myData.remove(op);
        Collection removed = this.myOperations.remove((Object)op);
        if (removed != null) {
            for (DdlOperationKey key : removed) {
                this.myImplementations.remove(key);
            }
        }
        this.myAnyOperations.remove((Object)op.target, (Object)op);
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            DdlGraphBuilder.$$$reportNull$$$0(13);
        }
        return ddlGraphBuilder;
    }

    @NotNull
    public DdlGraphBuilder updateImplicitDependencies() {
        this.invalidate();
        this.myImplicitDependencies.clear();
        ImplicitDepProvider.addAllImplicitDeps(this, this.myImplicitDependencies);
        this.myImplicitDepsValid = true;
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            DdlGraphBuilder.$$$reportNull$$$0(14);
        }
        return ddlGraphBuilder;
    }

    @Nullable
    public UserDataHolder getData(@NotNull DdlOperationKey key) {
        if (key == null) {
            DdlGraphBuilder.$$$reportNull$$$0(15);
        }
        return this.myData.get(key);
    }

    @Nullable
    public <T> T getData(@NotNull DdlOperationKey op, @NotNull Key<T> key) {
        if (op == null) {
            DdlGraphBuilder.$$$reportNull$$$0(16);
        }
        if (key == null) {
            DdlGraphBuilder.$$$reportNull$$$0(17);
        }
        return (T)key.get(this.myData.get(op));
    }

    @NotNull
    public UserDataHolder newData(@Nullable UserDataHolder toClone) {
        DdlOperationData ddlOperationData = new DdlOperationData((DdlOperationData)ObjectUtils.tryCast((Object)toClone, DdlOperationData.class));
        if (ddlOperationData == null) {
            DdlGraphBuilder.$$$reportNull$$$0(18);
        }
        return ddlOperationData;
    }

    public <T> void putData(@NotNull DdlOperationKey op, @NotNull Key<T> key, @Nullable T data) {
        if (op == null) {
            DdlGraphBuilder.$$$reportNull$$$0(19);
        }
        if (key == null) {
            DdlGraphBuilder.$$$reportNull$$$0(20);
        }
        this.invalidate();
        UserDataHolder holder = this.myData.get(op);
        if (holder == null && data != null) {
            holder = this.newData(null);
            this.myData.put(op, holder);
        }
        key.set(holder, data);
    }

    @NotNull
    public DdlGraphBuilder addDependencies(@NotNull DdlOperationKey op, @NotNull Iterable<DdlOperationKey> deps) {
        if (op == null) {
            DdlGraphBuilder.$$$reportNull$$$0(21);
        }
        if (deps == null) {
            DdlGraphBuilder.$$$reportNull$$$0(22);
        }
        this.invalidate();
        this.myDependencies.putValues((Object)op, DdlGraphBuilder.asCollection(deps));
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            DdlGraphBuilder.$$$reportNull$$$0(23);
        }
        return ddlGraphBuilder;
    }

    @NotNull
    public DdlGraphBuilder addDependencies(@NotNull Iterable<DdlOperationKey> ops, @NotNull DdlOperationKey dep) {
        if (ops == null) {
            DdlGraphBuilder.$$$reportNull$$$0(24);
        }
        if (dep == null) {
            DdlGraphBuilder.$$$reportNull$$$0(25);
        }
        this.invalidate();
        for (DdlOperationKey op : ops) {
            this.addDependency(op, dep);
        }
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            DdlGraphBuilder.$$$reportNull$$$0(26);
        }
        return ddlGraphBuilder;
    }

    @NotNull
    public DdlGraphBuilder addDependency(@NotNull DdlOperationKey op, @NotNull DdlOperationKey dep) {
        if (op == null) {
            DdlGraphBuilder.$$$reportNull$$$0(27);
        }
        if (dep == null) {
            DdlGraphBuilder.$$$reportNull$$$0(28);
        }
        this.invalidate();
        this.myDependencies.putValue((Object)op, (Object)dep);
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            DdlGraphBuilder.$$$reportNull$$$0(29);
        }
        return ddlGraphBuilder;
    }

    @NotNull
    public DdlGraphBuilder removeDependencies(@NotNull DdlOperationKey op, @NotNull Iterable<DdlOperationKey> deps) {
        if (op == null) {
            DdlGraphBuilder.$$$reportNull$$$0(30);
        }
        if (deps == null) {
            DdlGraphBuilder.$$$reportNull$$$0(31);
        }
        this.invalidate();
        for (DdlOperationKey dep : deps) {
            this.removeDependency(op, dep);
        }
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            DdlGraphBuilder.$$$reportNull$$$0(32);
        }
        return ddlGraphBuilder;
    }

    @NotNull
    public DdlGraphBuilder removeDependencies(@NotNull Iterable<DdlOperationKey> ops, @NotNull DdlOperationKey dep) {
        if (ops == null) {
            DdlGraphBuilder.$$$reportNull$$$0(33);
        }
        if (dep == null) {
            DdlGraphBuilder.$$$reportNull$$$0(34);
        }
        this.invalidate();
        for (DdlOperationKey op : ops) {
            this.removeDependency(op, dep);
        }
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            DdlGraphBuilder.$$$reportNull$$$0(35);
        }
        return ddlGraphBuilder;
    }

    @NotNull
    public DdlGraphBuilder removeDependency(@NotNull DdlOperationKey op, @NotNull DdlOperationKey dep) {
        if (op == null) {
            DdlGraphBuilder.$$$reportNull$$$0(36);
        }
        if (dep == null) {
            DdlGraphBuilder.$$$reportNull$$$0(37);
        }
        this.invalidate();
        this.myDependencies.remove((Object)op, (Object)dep);
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            DdlGraphBuilder.$$$reportNull$$$0(38);
        }
        return ddlGraphBuilder;
    }

    private void addImplementation(@NotNull DdlOperationKey iface, @NotNull DdlOperationKey impl) {
        if (iface == null) {
            DdlGraphBuilder.$$$reportNull$$$0(39);
        }
        if (impl == null) {
            DdlGraphBuilder.$$$reportNull$$$0(40);
        }
        DdlOperationKey old = this.myImplementations.put(iface, impl);
        this.myOperations.putValue((Object)impl, (Object)iface);
        assert (old == null || old.equals(impl));
    }

    private void appendImplementations(@NotNull Set<DdlOperationKey> res, @NotNull DdlOperationKey key) {
        List<DdlOperation> impls;
        if (res == null) {
            DdlGraphBuilder.$$$reportNull$$$0(41);
        }
        if (key == null) {
            DdlGraphBuilder.$$$reportNull$$$0(42);
        }
        if ((impls = this.myOpImpls.get((Object)key.operation)).isEmpty()) {
            impls = Collections.singletonList(key.operation);
        }
        for (DdlOperation implOp : impls) {
            DdlOperationKey op = this.myImplementations.get(new DdlOperationKey(key.target, implOp));
            if (op == null) continue;
            res.add(op);
        }
    }

    @NotNull
    private Iterable<DdlOperationKey> getInterfaces(@NotNull DdlOperationKey key) {
        if (key == null) {
            DdlGraphBuilder.$$$reportNull$$$0(43);
        }
        assert (this.myOperations.containsKey((Object)key));
        Collection collection = this.myOperations.get((Object)key);
        if (collection == null) {
            DdlGraphBuilder.$$$reportNull$$$0(44);
        }
        return collection;
    }

    @NotNull
    public DdlGraph build() {
        if (this.myWholeGraph == null) {
            this.myWholeGraph = this.buildFromNodes(this.myOperations.keySet(), ThreeState.UNSURE);
        }
        DdlGraph ddlGraph = this.myWholeGraph;
        if (ddlGraph == null) {
            DdlGraphBuilder.$$$reportNull$$$0(45);
        }
        return ddlGraph;
    }

    @NotNull
    public List<DdlGraph> buildComponents() {
        if (this.myGraphComponents == null) {
            ArrayList result2 = ContainerUtil.newArrayList();
            HashSet visited = ContainerUtil.newHashSet();
            DdlGraph graph = this.build();
            for (DdlOperationKey root2 : graph.getSources().append((Iterable)this.myOperations.keySet())) {
                if (visited.contains(root2)) continue;
                DdlGraph comp = this.createFromConnectedComponent(graph, root2);
                visited.addAll(comp.getNodes());
                result2.add(comp);
            }
            this.myGraphComponents = result2;
        }
        List<DdlGraph> list = this.myGraphComponents;
        if (list == null) {
            DdlGraphBuilder.$$$reportNull$$$0(46);
        }
        return list;
    }

    @NotNull
    private DdlGraph createFromConnectedComponent(@NotNull DdlGraph graph, @NotNull DdlOperationKey start) {
        if (graph == null) {
            DdlGraphBuilder.$$$reportNull$$$0(47);
        }
        if (start == null) {
            DdlGraphBuilder.$$$reportNull$$$0(48);
        }
        final Ref hasCycle = Ref.create((Object)ThreeState.NO);
        final LinkedHashSet currentComponent = ContainerUtil.newLinkedHashSet();
        DdlGraph.visitDfs(graph, start, new DdlGraph.DfsVisitor<DdlOperationKey>(){

            @Override
            public boolean visit(@NotNull DdlOperationKey key, @NotNull DdlGraph.DfsVisitor.Reason reason) {
                if (key == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (reason == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (reason == DdlGraph.DfsVisitor.Reason.ENTER) {
                    currentComponent.add(key);
                }
                if (reason == DdlGraph.DfsVisitor.Reason.CYCLE) {
                    hasCycle.set((Object)ThreeState.YES);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reason";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/schemaEditor/generation/DdlGraphBuilder$1";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        DdlGraph ddlGraph = this.buildFromNodes(currentComponent, (ThreeState)hasCycle.get());
        if (ddlGraph == null) {
            DdlGraphBuilder.$$$reportNull$$$0(49);
        }
        return ddlGraph;
    }

    private boolean opIsImpl(@NotNull DdlOperation op) {
        if (op == null) {
            DdlGraphBuilder.$$$reportNull$$$0(50);
        }
        return this.myOpImpls.get((Object)op).contains(op);
    }

    @NotNull
    private Iterable<DdlOperationKey> getDependencies(@NotNull DdlOperationKey op) {
        if (op == null) {
            DdlGraphBuilder.$$$reportNull$$$0(51);
        }
        assert (this.opIsImpl(op.operation));
        LinkedHashSet deps = ContainerUtil.newLinkedHashSet();
        for (DdlOperationKey key : this.getInterfaces(op)) {
            this.appendDependencies(deps, key);
            for (DdlOperation iface : key.operation.getInterfaces()) {
                this.appendDependencies(deps, new DdlOperationKey(key.target, iface));
            }
        }
        LinkedHashSet linkedHashSet = deps;
        if (linkedHashSet == null) {
            DdlGraphBuilder.$$$reportNull$$$0(52);
        }
        return linkedHashSet;
    }

    private void appendDependencies(@NotNull Set<DdlOperationKey> deps, @NotNull DdlOperationKey op) {
        if (deps == null) {
            DdlGraphBuilder.$$$reportNull$$$0(53);
        }
        if (op == null) {
            DdlGraphBuilder.$$$reportNull$$$0(54);
        }
        deps.addAll(this.myDependencies.get((Object)op));
        deps.addAll(this.myImplicitDependencies.get((Object)op));
    }

    @NotNull
    private Collection<DdlOperationKey> getRealOperations(@NotNull Iterable<DdlOperationKey> iter) {
        if (iter == null) {
            DdlGraphBuilder.$$$reportNull$$$0(55);
        }
        LinkedHashSet ops = ContainerUtil.newLinkedHashSet();
        for (DdlOperationKey op : iter) {
            if (op.operation == DdlOperation.ANY_OP) {
                ops.addAll(this.myAnyOperations.get((Object)op.target));
                continue;
            }
            this.appendImplementations(ops, op);
        }
        LinkedHashSet linkedHashSet = ops;
        if (linkedHashSet == null) {
            DdlGraphBuilder.$$$reportNull$$$0(56);
        }
        return linkedHashSet;
    }

    private static <K, V> BidirectionalMultiMap<K, V> newLinkedBiMap() {
        return new BidirectionalMultiMap<K, V>(ContainerUtil.newLinkedHashMap(), ContainerUtil.newLinkedHashMap()){

            @NotNull
            protected Set<V> createValuesSet() {
                LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
                if (linkedHashSet == null) {
                    2.$$$reportNull$$$0(0);
                }
                return linkedHashSet;
            }

            @NotNull
            protected Set<K> createKeysSet() {
                LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
                if (linkedHashSet == null) {
                    2.$$$reportNull$$$0(1);
                }
                return linkedHashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/database/schemaEditor/generation/DdlGraphBuilder$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createValuesSet";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createKeysSet";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public DdlGraph buildFromNodes(@NotNull Collection<DdlOperationKey> ops, @NotNull ThreeState hasCycles) {
        if (ops == null) {
            DdlGraphBuilder.$$$reportNull$$$0(57);
        }
        if (hasCycles == null) {
            DdlGraphBuilder.$$$reportNull$$$0(58);
        }
        this.ensureImplicitDepsValid();
        BidirectionalMultiMap edges = DdlGraphBuilder.newLinkedBiMap();
        HashMap data = ContainerUtil.newHashMap();
        for (DdlOperationKey op : ops) {
            data.put(op, this.myData.get(op));
            for (DdlOperationKey dep : this.getRealOperations(this.getDependencies(op))) {
                assert (ops.contains(dep));
                edges.put((Object)op, (Object)dep);
            }
        }
        DdlGraph ddlGraph = new DdlGraph(ops, data, edges, hasCycles);
        if (ddlGraph == null) {
            DdlGraphBuilder.$$$reportNull$$$0(59);
        }
        return ddlGraph;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 52: 
            case 56: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 52: 
            case 56: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 52: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/generation/DdlGraphBuilder";
                break;
            }
            case 3: 
            case 15: 
            case 17: 
            case 20: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 16: 
            case 19: 
            case 21: 
            case 27: 
            case 30: 
            case 36: 
            case 50: 
            case 51: 
            case 54: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implemented";
                break;
            }
            case 22: 
            case 31: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deps";
                break;
            }
            case 24: 
            case 33: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ops";
                break;
            }
            case 25: 
            case 28: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dep";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iface";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "impl";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iter";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasCycles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/generation/DdlGraphBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "asCollection";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addOperation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "removeOperation";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "updateImplicitDependencies";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "newData";
                break;
            }
            case 23: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "addDependencies";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "addDependency";
                break;
            }
            case 32: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDependencies";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDependency";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaces";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "buildComponents";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromConnectedComponent";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealOperations";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFromNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 52: 
            case 56: 
            case 59: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "asCollection";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addOperation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isScheduled";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeOperation";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "putData";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addDependencies";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "removeDependencies";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeDependency";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addImplementation";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "appendImplementations";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getInterfaces";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createFromConnectedComponent";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "opIsImpl";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "appendDependencies";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getRealOperations";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "buildFromNodes";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isScheduled$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 52: 
            case 56: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DdlOperationData
    implements UserDataHolder,
    Cloneable {
        private final Map<Key, Object> myData = ContainerUtil.newHashMap();

        public DdlOperationData(@Nullable DdlOperationData toClone) {
            if (toClone != null) {
                this.myData.putAll(toClone.myData);
            }
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                DdlOperationData.$$$reportNull$$$0(0);
            }
            return (T)key.get(this.myData);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                DdlOperationData.$$$reportNull$$$0(1);
            }
            key.set(this.myData, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "key";
            objectArray2[1] = "com/intellij/database/schemaEditor/generation/DdlGraphBuilder$DdlOperationData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

