/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.sqlite;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.schemaEditor.operations.sqlite.SqliteReplaceTableOperation;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqliteAlterTableOperation
extends DasDdlOperations.AlterTableOperation {
    @Override
    @NotNull
    public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable from, @Nullable UserDataHolder data) {
        boolean unsupOpsUsed;
        if (generator == null) {
            SqliteAlterTableOperation.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            SqliteAlterTableOperation.$$$reportNull$$$0(1);
        }
        if (from == null) {
            SqliteAlterTableOperation.$$$reportNull$$$0(2);
        }
        assert (data != null);
        DeTable to = (DeTable)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
        boolean bl = unsupOpsUsed = SqliteAlterTableOperation.willRecreate(from, to) || SqliteAlterTableOperation.willRecreateReferenced(to);
        if (!unsupOpsUsed) {
            DdlGenerator ddlGenerator = super.addToBuilder(generator, builder, from, data);
            if (ddlGenerator == null) {
                SqliteAlterTableOperation.$$$reportNull$$$0(3);
            }
            return ddlGenerator;
        }
        generator.addOperation(builder, SqliteReplaceTableOperation.SQLITE_REPLACE_TABLE, to, DasDdlOperations.set(builder.newData(data), DdlGraph.ALTER_FROM, from));
        DdlGenerator ddlGenerator = generator;
        if (ddlGenerator == null) {
            SqliteAlterTableOperation.$$$reportNull$$$0(4);
        }
        return ddlGenerator;
    }

    public static boolean willRecreate(@NotNull DeTable from, @NotNull DeTable to) {
        if (from == null) {
            SqliteAlterTableOperation.$$$reportNull$$$0(5);
        }
        if (to == null) {
            SqliteAlterTableOperation.$$$reportNull$$$0(6);
        }
        LinkedHashSet alter = ContainerUtil.newLinkedHashSet();
        LinkedHashSet drop = ContainerUtil.newLinkedHashSet();
        LinkedHashSet create = ContainerUtil.newLinkedHashSet();
        ArrayList order = ContainerUtil.newArrayList();
        SqliteAlterTableOperation.classifyChildren(from, to, create, alter, drop, order);
        return SqliteAlterTableOperation.isUnsupOpsUsed(create, alter, drop);
    }

    public static boolean willRecreateReferenced(@NotNull DeTable to) {
        if (to == null) {
            SqliteAlterTableOperation.$$$reportNull$$$0(7);
        }
        HashSet targets = ContainerUtil.newHashSet();
        for (DeForeignKey key : to.foreignKeys) {
            ContainerUtil.addIfNotNull((Collection)targets, (Object)key.target);
        }
        for (DeTable target : targets) {
            if (target.editedObject == null || !SqliteAlterTableOperation.willRecreate((DeTable)target.editedObject, target)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnsupOpsUsed(@NotNull Set<DeObject> create, @NotNull Set<DeObject> alter, @NotNull Set<DeObject> drop) {
        if (create == null) {
            SqliteAlterTableOperation.$$$reportNull$$$0(8);
        }
        if (alter == null) {
            SqliteAlterTableOperation.$$$reportNull$$$0(9);
        }
        if (drop == null) {
            SqliteAlterTableOperation.$$$reportNull$$$0(10);
        }
        for (DeObject object : create) {
            if (object.getKind() == ObjectKind.COLUMN || object.getKind() == ObjectKind.INDEX) continue;
            return true;
        }
        for (DeObject object : alter) {
            if (!object.isAltered((DeObject)ObjectUtils.assertNotNull((Object)object.editedObject)) || object.getKind() == ObjectKind.INDEX) continue;
            return true;
        }
        for (DeObject object : drop) {
            if (object.getKind() == ObjectKind.INDEX) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public DdlGenerator removeFromBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable from, @Nullable UserDataHolder data) {
        if (generator == null) {
            SqliteAlterTableOperation.$$$reportNull$$$0(11);
        }
        if (builder == null) {
            SqliteAlterTableOperation.$$$reportNull$$$0(12);
        }
        if (from == null) {
            SqliteAlterTableOperation.$$$reportNull$$$0(13);
        }
        assert (data != null);
        DeTable to = (DeTable)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
        generator.removeOperation(builder, SqliteReplaceTableOperation.SQLITE_REPLACE_TABLE, to, DasDdlOperations.set(builder.newData(data), DdlGraph.ALTER_FROM, from));
        DdlGenerator ddlGenerator = super.removeFromBuilder(generator, builder, from, data);
        if (ddlGenerator == null) {
            SqliteAlterTableOperation.$$$reportNull$$$0(14);
        }
        return ddlGenerator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "create";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drop";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/operations/sqlite/SqliteAlterTableOperation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addToBuilder";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFromBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addToBuilder";
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "willRecreate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "willRecreateReferenced";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUnsupOpsUsed";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeFromBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

