/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QNameUtil {
    public static final Condition<String> NOT_EMPTY = s -> StringUtil.isNotEmpty((String)s);

    private QNameUtil() {
    }

    @Deprecated
    public static String getQualifiedName(String catalog, String schema, String name) {
        ImmutableList parts = ContainerUtil.immutableList((Object[])new String[]{StringUtil.nullize((String)catalog), StringUtil.nullize((String)schema), StringUtil.nullize((String)name)});
        return StringUtil.join((Collection)parts, (String)".");
    }

    @NotNull
    public static String getQualifiedName(@Nullable DbElement element) {
        if (element instanceof DatabaseSystem) {
            String string = element.getName();
            if (string == null) {
                QNameUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = QNameUtil.getQualifiedName((DasObject)element);
        if (string == null) {
            QNameUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getQualifiedName(@Nullable DasObject element) {
        String string = QNameUtil.getQualifiedName(element, (Function<DasObject, String>)DasUtil.TO_NAME);
        if (string == null) {
            QNameUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getQualifiedName(@Nullable DasObject element, DatabaseDialect dialect) {
        String string = QNameUtil.getQualifiedName(element, (Function<DasObject, String>)((Function)object -> dialect.quoteIdentifier(object.getName(), false, true)));
        if (string == null) {
            QNameUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getQualifiedName(@Nullable DasObject element, @NotNull Function<DasObject, String> namer) {
        if (namer == null) {
            QNameUtil.$$$reportNull$$$0(4);
        }
        List parents = DasUtil.dasParents((DasObject)element).toList();
        String string = StringUtil.join((Collection)ContainerUtil.reverse((List)parents), namer, (String)".");
        if (string == null) {
            QNameUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static JBIterable<DasObject> findByQName(@NotNull DasModel model, @NotNull String fqn) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(6);
        }
        if (fqn == null) {
            QNameUtil.$$$reportNull$$$0(7);
        }
        JBIterable<DasObject> jBIterable = QNameUtil.findByQName(model, fqn, (Function<DasObject, String>)DasUtil.TO_NAME);
        if (jBIterable == null) {
            QNameUtil.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DasObject> findByQName(@NotNull DasModel model, @NotNull String fqn, @NotNull Function<DasObject, String> namer) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(9);
        }
        if (fqn == null) {
            QNameUtil.$$$reportNull$$$0(10);
        }
        if (namer == null) {
            QNameUtil.$$$reportNull$$$0(11);
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)model.traverser().expand(object -> {
            String name;
            if (namer == null) {
                QNameUtil.$$$reportNull$$$0(15);
            }
            if (fqn == null) {
                QNameUtil.$$$reportNull$$$0(16);
            }
            return (name = (String)namer.fun(object)).isEmpty() || fqn.contains(name) && fqn.startsWith(QNameUtil.getQualifiedName(object, namer) + ".");
        })).filter(object -> {
            String name;
            if (namer == null) {
                QNameUtil.$$$reportNull$$$0(13);
            }
            if (fqn == null) {
                QNameUtil.$$$reportNull$$$0(14);
            }
            return fqn.endsWith(name = (String)namer.fun(object)) && fqn.equals(QNameUtil.getQualifiedName(object, namer));
        })).traverse();
        if (jBIterable == null) {
            QNameUtil.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @Contract(value="null->false")
    public static boolean isFakeName(@Nullable String name) {
        return name != null && StringUtil.startsWith((CharSequence)name, (CharSequence)"#FAKE_");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/QNameUtil";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namer";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/QNameUtil";
                break;
            }
            case 8: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findByQName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findByQName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findByQName$3";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findByQName$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

