/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.sybase;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.dialects.SybaseDialect;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.sybase.SybaseProcedure;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vendors.DefinitionProviderImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseDefinitionProvider
extends DefinitionProviderImpl.Tsql {
    public static final SybaseDefinitionProvider INSTANCE = new SybaseDefinitionProvider();

    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            SybaseDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.VIEW || kind == ObjectKind.ROUTINE || kind == ObjectKind.TRIGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection, @NotNull PairConsumer<DasObject, Object> consumer) throws Exception {
        if (objects == null) {
            SybaseDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            SybaseDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            SybaseDefinitionProvider.$$$reportNull$$$0(3);
        }
        GenericDialect dialect = GenericDialect.INSTANCE;
        PreparedStatement statement = connection.prepareStatement("exec sp_helptext ?, ?");
        StringBuilder builder = new StringBuilder();
        try {
            for (DasObject dasObject : objects) {
                DasObject parent = dasObject.getDbParent();
                boolean procGroup = DasUtil.getKind((DasObject)parent) == ObjectKind.PACKAGE;
                String objName = procGroup ? DasUtil.getName((DasObject)parent) : dasObject.getName();
                String name = dialect.quoteIdentifier(DasUtil.getSchema((DasObject)dasObject), true, false) + "." + dialect.quoteIdentifier(objName, true, false);
                Integer procNum = procGroup ? SybaseDefinitionProvider.getProcNum(dasObject) : null;
                statement.setString(1, name);
                if (procNum == null) {
                    statement.setNull(2, 4);
                } else {
                    statement.setInt(2, procNum);
                }
                ResultSet rs = null;
                try {
                    boolean ok = true;
                    rs = statement.executeQuery();
                    if (!"text".equalsIgnoreCase(rs.getMetaData().getColumnLabel(1))) {
                        ok = statement.getMoreResults();
                        if (!ok && statement.getUpdateCount() != -1) {
                            ok = statement.getMoreResults();
                        }
                        rs = statement.getResultSet();
                    }
                    builder.setLength(0);
                    if (ok) {
                        while (rs.next()) {
                            builder.append(rs.getString(1));
                        }
                    }
                    consumer.consume((Object)dasObject, (Object)StringUtil.nullize((String)builder.toString()));
                }
                catch (SQLException e) {
                    try {
                        consumer.consume((Object)dasObject, (Object)e);
                    }
                    catch (Throwable throwable) {
                        JdbcUtil.closeResultSetSafe(rs);
                        throw throwable;
                        return;
                    }
                    JdbcUtil.closeResultSetSafe((ResultSet)rs);
                    continue;
                }
                JdbcUtil.closeResultSetSafe((ResultSet)rs);
            }
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
    }

    @Override
    @Nullable
    protected String getCurrentDb(@NotNull DatabaseConnection connection) throws SQLException {
        SybaseDialect dialect;
        ObjectPath current;
        if (connection == null) {
            SybaseDefinitionProvider.$$$reportNull$$$0(4);
        }
        return (current = SearchPath.getCurrent((dialect = SybaseDialect.INSTANCE).tryToLoadSearchPath(connection.getConnectionPoint().getDataSource(), connection))) == null ? null : current.getName();
    }

    private static Integer getProcNum(DasObject obj) {
        int res;
        int n = res = obj instanceof SybaseProcedure ? ((SybaseProcedure)obj).getPosition() : StringUtil.parseInt((String)obj.getName(), (int)-1);
        return res == -1 ? null : Integer.valueOf(res == 0 ? 1 : res);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/vendors/sybase/SybaseDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentDb";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

