/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.dataSource.DataSourceListener;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.ex.dummy.DummyCachingFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseVirtualFileSystem
extends DummyCachingFileSystem<VirtualFile> {
    private static final String PROTOCOL = "das";
    private static final String SRC_PREFIX = "src:";
    private static final String PROTOCOL_SEPARATOR = ":/";

    public static DatabaseVirtualFileSystem getDatabaseFileSystem() {
        return (DatabaseVirtualFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public DatabaseVirtualFileSystem() {
        super(PROTOCOL);
    }

    public void onProjectOpened(Project project) {
        super.onProjectOpened(project);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> DatabaseEditorHelper.installEditorFactoryListener(project));
        DataSourceStorage.getProjectStorage(project).addDataSourceListener(new DataSourceListener(){

            @Override
            public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    1.$$$reportNull$$$0(1);
                }
                Application app = ApplicationManager.getApplication();
                app.invokeLater(() -> DatabaseVirtualFileSystem.this.clearInvalidFiles(), app.getDisposed());
            }

            @Override
            public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
                if (dataSource == null || dataSource.isInBatch()) {
                    return;
                }
                Application app = ApplicationManager.getApplication();
                app.invokeLater(() -> DatabaseVirtualFileSystem.this.updateReadonlyFlag(dataSource), app.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataSource";
                objectArray2[1] = "com/intellij/database/vfs/DatabaseVirtualFileSystem$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected String getPresentableUrl(@NotNull VirtualFile file) {
        if (file == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(0);
        }
        if (file instanceof VirtualFilePathWrapper) {
            return ((VirtualFilePathWrapper)file).getPresentablePath();
        }
        return super.getPresentableUrl(file);
    }

    protected VirtualFile findFileByPathInner(@NotNull String path) {
        if (path == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(1);
        }
        boolean source = path.startsWith(SRC_PREFIX);
        int separatorIdx = path.indexOf(PROTOCOL_SEPARATOR);
        if (separatorIdx == -1) {
            return null;
        }
        int separatorEnd = separatorIdx + PROTOCOL_SEPARATOR.length();
        String elementType = path.substring(source ? SRC_PREFIX.length() : 0, separatorIdx);
        int projectIdEnd = path.indexOf(47, separatorEnd);
        String projectId = path.substring(separatorEnd, projectIdEnd);
        int dataSourceEnd = path.indexOf(47, projectIdEnd + 1);
        if (dataSourceEnd == -1) {
            return null;
        }
        int nameStart = path.lastIndexOf(47);
        if (nameStart == -1 || nameStart <= projectIdEnd) {
            return null;
        }
        String name = DatabaseVirtualFileSystem.unescapeSlash((String)path.substring(nameStart + 1));
        String dataSourceId = path.substring(projectIdEnd + 1, nameStart);
        Project project = this.getProject(projectId);
        if (project == null) {
            return null;
        }
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
        if (dataSource == null) {
            return null;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)dataSource);
        ObjectKind kind = dialect.getMetaModel().findKind(elementType);
        if (kind == null) {
            return null;
        }
        DatabaseElementVirtualFileImpl file = new DatabaseElementVirtualFileImpl(projectId, dataSourceId, name, kind, source);
        if (dataSource.getDelegate() instanceof DatabaseConnectionPoint) {
            file.setWritableInner(!((DatabaseConnectionPoint)dataSource.getDelegate()).isReadOnly());
        }
        return file;
    }

    @NotNull
    public static String getPath(Project project, String dataSourceId, String tableName, ObjectKind kind, boolean source) {
        String string = DatabaseVirtualFileSystem.getPath(project.getLocationHash(), dataSourceId, tableName, kind, source);
        if (string == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getPath(String projectId, String dataSourceId, String qname, ObjectKind kind, boolean source) {
        String string = (source ? SRC_PREFIX : "") + kind.code() + PROTOCOL_SEPARATOR + projectId + "/" + dataSourceId + "/" + DatabaseVirtualFileSystem.escapeSlash((String)qname);
        if (string == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) {
        if (vFile == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException("rename not supported: " + vFile.getUrl());
    }

    private void updateReadonlyFlag(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DatabaseVirtualFileSystem.$$$reportNull$$$0(6);
        }
        boolean writable = !dataSource.isReadOnly();
        String id = dataSource.getUniqueId();
        for (VirtualFile file : this.getCachedFiles()) {
            if (!(file instanceof DatabaseElementVirtualFileImpl) || !Comparing.equal((String)id, (String)((DatabaseElementVirtualFileImpl)file).getDataSourceId()) || file.isWritable() == writable) continue;
            ((DatabaseElementVirtualFileImpl)file).setWritable(writable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vfs/DatabaseVirtualFileSystem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vfs/DatabaseVirtualFileSystem";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableUrl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathInner";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateReadonlyFlag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

