/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.actions.DdlActions;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseNavBarExtension
extends AbstractNavBarModelExtension {
    private static final Key<PsiElement> NAV_BAR_WRAPPER = Key.create((String)"NAV_BAR_WRAPPER");

    @Nullable
    public String getPopupMenuGroup(@NotNull DataProvider provider) {
        PsiElement object;
        if (provider == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(0);
        }
        if (!((object = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(provider)) instanceof ProjectWrapper) && !DatabaseStructure.isDatabaseObject(object)) {
            return null;
        }
        return "DatabaseViewPopupMenu";
    }

    @Nullable
    public Object getData(String dataId, @NotNull DataProvider provider) {
        PsiElement object;
        if (provider == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(1);
        }
        if ((object = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(provider)) instanceof ProjectWrapper) {
            return null;
        }
        if (!DatabaseStructure.isDatabaseObject(object)) {
            return null;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            List<PsiElement> c = Collections.singletonList(object);
            if (JBIterable.from(c).filter(DbDataSource.class).size() == c.size()) {
                return new DdlActions.DeleteProvider1();
            }
            return new DdlActions.DeleteProvider2();
        }
        return DbNodeDescriptor.getData(dataId, object.getProject(), object);
    }

    @Nullable
    public String getPresentableText(Object object) {
        if (object instanceof ProjectWrapper) {
            return ((ProjectWrapper)((Object)object)).getName();
        }
        if (!DatabaseStructure.isDatabaseObject(object)) {
            return null;
        }
        return object instanceof DbElement ? DbPresentation.getPresentableName((DasObject)((DbElement)object), true) : (object instanceof PsiNamedElement ? ((PsiNamedElement)object).getName() : null);
    }

    @Nullable
    public PsiElement getParent(PsiElement psiElement) {
        if (!DatabaseStructure.isDatabaseObject(psiElement)) {
            return null;
        }
        if (psiElement instanceof DbDataSource) {
            return (PsiElement)((UserDataHolderEx)psiElement.getProject()).putUserDataIfAbsent(NAV_BAR_WRAPPER, (Object)new ProjectWrapper(psiElement.getProject()));
        }
        DatabaseViewOptions options = DatabaseView.getDatabaseView(psiElement.getProject()).getViewOptions();
        return DatabaseStructure.getParentImpl(psiElement, options);
    }

    @Nullable
    public PsiElement adjustElement(PsiElement psiElement) {
        if (psiElement instanceof DbElement || psiElement instanceof DatabaseStructure.GroupElement) {
            return psiElement;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
        if (DbImplUtil.isDatabaseVirtualFile(file)) {
            DbElement element = DbImplUtil.findElement(psiElement.getProject(), file);
            if (element != null) {
                return element;
            }
        } else {
            DataGrid dataGrid = DataGridPomTarget.unwrapDataGrid(psiElement);
            if (dataGrid != null) {
                return (PsiElement)CommonDataKeys.PSI_FILE.getData(DataManager.getInstance().getDataContext((Component)dataGrid.getComponent()));
            }
        }
        return psiElement;
    }

    public boolean processChildren(Object object, Object rootElement, Processor<Object> processor) {
        DbDataSource adjusted;
        DbDataSource dataSource;
        if (object instanceof ProjectWrapper) {
            return ContainerUtil.process((List)DbPsiFacade.getInstance((Project)((ProjectWrapper)((Object)object)).getProject()).getDataSources(), processor);
        }
        DbDataSource dbDataSource = dataSource = rootElement instanceof DbDataSource ? (DbDataSource)rootElement : null;
        if (dataSource == null) {
            return true;
        }
        Object object2 = object == dataSource ? dataSource : (adjusted = object instanceof DbElement ? ((DbElement)object).getDelegate() : object);
        if (!DatabaseStructure.isDatabaseObject(adjusted) && adjusted != dataSource || DatabaseStructure.isAlwaysLeafImpl(adjusted)) {
            return true;
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)dataSource.getProject());
        DatabaseViewOptions options = DatabaseView.getDatabaseView(((PsiElement)object).getProject()).getViewOptions();
        JBIterable children = DatabaseStructure.getChildrenImpl(adjusted, options, facade).map(o -> o instanceof DasObject ? DbImplUtil.findElement(dataSource, (DasObject)o) : o);
        return ContainerUtil.process((Iterable)children, processor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "provider";
        objectArray2[1] = "com/intellij/database/view/DatabaseNavBarExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPopupMenuGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ProjectWrapper
    extends FakePsiElement {
        final Project myProject;

        ProjectWrapper(@NotNull Project project) {
            if (project == null) {
                ProjectWrapper.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                ProjectWrapper.$$$reportNull$$$0(1);
            }
            return project;
        }

        public PsiFile getContainingFile() {
            return null;
        }

        public String getName() {
            return ToolWindowId.DATABASE_VIEW;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return DatabaseIcons.DatabaseGroup;
        }

        public PsiElement getParent() {
            return null;
        }

        public boolean isValid() {
            return !this.myProject.isDisposed();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseNavBarExtension$ProjectWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseNavBarExtension$ProjectWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

