/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.impl.ModelDescribing;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.sqlite.SqliteVirtualTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTrigger;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.psi.PsiElement;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNodeDescriptor
extends PresentableNodeDescriptor
implements DataProvider,
ComparableObject {
    public static final DbNodeDescriptor[] EMPTY_ARRAY = new DbNodeDescriptor[0];
    private final DbElement myElement;

    public DbNodeDescriptor(DbElement element, NodeDescriptor parent) {
        super(element.getProject(), parent);
        this.myElement = element;
    }

    public DbElement getElement() {
        return this.myElement;
    }

    protected void update(PresentationData presentation) {
        DbElement element = this.getElement();
        if (!element.isValid()) {
            return;
        }
        presentation.setChanged(true);
        DbNodeDescriptor.updatePresentation(presentation, (DasObject)element, element.getProject());
    }

    public static void updatePresentation(PresentationData presentation, DasObject element, Project project) {
        presentation.clear();
        presentation.setIcon(element instanceof DbDataSource ? ((DbDataSource)element).getIcon() : DbPresentation.getIcon(element));
        String nodeText = DbPresentation.getPresentableName(element, false);
        presentation.setPresentableText(nodeText);
        SimpleTextAttributes style = DbNodeDescriptor.handleErrors(presentation, element);
        presentation.addText(StringUtil.isEmpty((String)nodeText) ? "<unnamed>" : nodeText, style);
        if (element instanceof DbDataSource) {
            DbNodeDescriptor.describeDataSource(presentation, (DbDataSource)element);
        }
        if (element instanceof DasNamespace) {
            DbNodeDescriptor.describeNamespace(presentation, (DasNamespace)element, project);
        } else if (element instanceof DasUserDefinedType) {
            DbNodeDescriptor.describeCustomType(presentation, (DasUserDefinedType)element);
        } else if (element instanceof DasColumn) {
            DbNodeDescriptor.describeColumn(presentation, (DasColumn)element);
        } else if (element instanceof DasTable) {
            DbNodeDescriptor.describeTable(presentation, (DasTable)element, project);
        } else if (element instanceof DasRoutine) {
            DbNodeDescriptor.describeRoutine(presentation, (DasRoutine)element, project);
        } else if (element instanceof DasTableKey) {
            DbNodeDescriptor.describeTableKey(presentation, (DasTableKey)element);
        } else if (element instanceof DasForeignKey) {
            DbNodeDescriptor.describeForeignKey(presentation, (DasForeignKey)element);
        } else if (element instanceof DasIndex) {
            DbNodeDescriptor.describeIndex(presentation, (DasIndex)element);
        } else if (element instanceof DasSynonym) {
            DbNodeDescriptor.describeSynonym(presentation, (DasSynonym)element);
        } else {
            DbNodeDescriptor.describeByDelegate(presentation, element);
        }
        String comment = element.getComment();
        if (comment != null && comment.length() > 0) {
            presentation.setTooltip(StringUtil.shortenTextWithEllipsis((String)comment, (int)2000, (int)0, (boolean)true));
        }
    }

    protected static void describeByDelegate(PresentationData presentation, Object delegate) {
        if (delegate instanceof DasTypedObject) {
            DbNodeDescriptor.describeTyped(presentation, (DasTypedObject)delegate);
        } else if (delegate instanceof BasicSequence) {
            DbNodeDescriptor.describeSequence(presentation, (BasicSequence)delegate);
        } else if (delegate instanceof DasOperator) {
            DbNodeDescriptor.describeOperator(presentation, (DasOperator)delegate);
        } else if (delegate instanceof BasicTrigger) {
            DbNodeDescriptor.describeTrigger(presentation, (BasicTrigger)delegate);
        } else if (delegate instanceof BasicCheck) {
            DbNodeDescriptor.describeCheck(presentation, (BasicCheck)delegate);
        }
    }

    protected static void describeCheck(PresentationData presentation, BasicCheck delegate) {
        String predicate = delegate.getPredicate();
        if (predicate != null) {
            if (!predicate.startsWith("(")) {
                predicate = "(" + predicate + ")";
            }
            predicate = StringUtil.shortenTextWithEllipsis((String)predicate, (int)20, (int)1, (boolean)true);
            presentation.addText(" " + predicate, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeTrigger(PresentationData presentation, BasicTrigger delegate) {
        String condition;
        Set<TrigEvent> events;
        TrigTurn turn = delegate.getTurn();
        if (turn != null) {
            String turnText = StringUtil.join((Iterable)JBIterable.of((Object[])StringUtil.toLowerCase((String)turn.toString()).split("_")).filter(w -> !w.equals("stmt") && !w.equals("row")), (String)" ");
            presentation.addText(" " + turnText, DbNodeDescriptor.getGrayAttrs());
        }
        if (!(events = delegate.getEvents()).isEmpty()) {
            String eventsText = StringUtil.join((Iterable)JBIterable.from(events).transform(e -> {
                List<String> cols = delegate.getColNames();
                if (e == TrigEvent.UPDATE && !cols.isEmpty()) {
                    return "update of " + StringUtil.join(cols, (String)", ");
                }
                return StringUtil.toLowerCase((String)e.toString());
            }), (String)", ");
            presentation.addText(" " + eventsText, DbNodeDescriptor.getGrayAttrs());
        }
        if ((condition = delegate.getCondition()) != null) {
            if (!condition.startsWith("(")) {
                condition = "(" + condition + ")";
            }
            condition = StringUtil.shortenTextWithEllipsis((String)condition, (int)20, (int)1, (boolean)true);
            presentation.addText(" " + condition, DbNodeDescriptor.getGrayAttrs());
        }
        if (delegate instanceof PostgresTrigger) {
            String routineName = PostgresModelFun.getCallRoutineName((PostgresTrigger)delegate);
            presentation.addText(' ' + DbNodeDescriptor.arrow() + ' ' + routineName, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeOperator(PresentationData presentation, DasOperator delegate) {
        DasOperator.OperatorNotation notation = delegate.getOperatorNotation();
        StringBuilder res = new StringBuilder();
        List args = delegate.getArgumentTypes();
        String resType = delegate.getResultType().getSpecification();
        if (notation == DasOperator.OperatorNotation.INFIX) {
            res.append(StringUtil.join((Collection)args, t -> t.getSpecification(), (String)(" " + delegate.getName() + " ")));
        } else {
            if (notation == DasOperator.OperatorNotation.PREFIX) {
                res.append(delegate.getName());
            }
            if (args.size() != 1) {
                res.append("(");
            }
            res.append(StringUtil.join((Collection)args, t -> t.getSpecification(), (String)", "));
            if (args.size() != 1) {
                res.append(")");
            }
            if (notation == DasOperator.OperatorNotation.POSTFIX) {
                res.append(delegate.getName());
            }
        }
        presentation.addText("    " + res + " " + DbNodeDescriptor.arrow() + " " + resType, DbNodeDescriptor.getGrayAttrs());
    }

    protected static void describeSequence(PresentationData presentation, BasicSequence delegate) {
        SequenceIdentity si = delegate.getSequenceIdentity();
        if (si != null) {
            String specification = si.getSpecification();
            presentation.addText(" " + specification, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeTyped(PresentationData presentation, DasTypedObject delegate) {
        String type = delegate.getDataType().getSpecification();
        presentation.addText(" " + type, DbNodeDescriptor.getGrayAttrs());
    }

    protected static void describeSynonym(PresentationData presentation, DasSynonym element) {
        Iterable path = element.getTargetPath();
        String pathString = StringUtil.join((Iterable)path, (String)".");
        if (pathString.length() > 0) {
            String text = " " + DbNodeDescriptor.arrow() + " " + pathString;
            presentation.addText(text, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeIndex(PresentationData presentation, DasIndex element) {
        String unique = element.isUnique() ? " UNIQUE" : "";
        BasicIndex basicIndex = (BasicIndex)ObjectUtils.tryCast((Object)element, BasicIndex.class);
        if (basicIndex != null) {
            String indexingItems = ModelDescribing.describeIndexingItems(basicIndex);
            presentation.addText(" (" + indexingItems + ")" + unique, DbNodeDescriptor.getGrayAttrs());
            String condition = basicIndex.getCondition();
            if (condition != null) {
                presentation.addText(" where " + condition, DbNodeDescriptor.getGrayAttrs());
            }
        } else {
            String columns2 = DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)element.getColumnsRef());
            presentation.addText(" " + columns2 + unique, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeForeignKey(PresentationData presentation, DasForeignKey element) {
        BasicForeignKey fk;
        String referencingColumns = DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)element.getColumnsRef());
        String refSchemaName = null;
        if (element instanceof BasicForeignKey && (fk = (BasicForeignKey)element).isReferencingAnotherSchema()) {
            refSchemaName = fk.getRefSchemaName();
        }
        String arrowToReferenced = DbNodeDescriptor.arrowToColumns(refSchemaName, element.getRefTableName(), (MultiRef<? extends DasTypedObject>)element.getRefColumns());
        presentation.addText(" " + referencingColumns + " " + arrowToReferenced, DbNodeDescriptor.getGrayAttrs());
    }

    protected static void describeTableKey(PresentationData presentation, DasTableKey element) {
        presentation.addText(" " + DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)element.getColumnsRef()), DbNodeDescriptor.getGrayAttrs());
    }

    protected static void describeRoutine(PresentationData presentation, DasRoutine procedure, Project project) {
        StringBuilder sb = new StringBuilder();
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)procedure);
        DatabaseDialectEx dialect = dataSource != null ? DbImplUtil.getDatabaseDialect((DbElement)dataSource) : GenericDialect.INSTANCE;
        DdlBuilder builder = new DdlBuilder(sb).applyCodeStyle(project).withDialect(dialect);
        builder.getDialect().sqlDefinePrototype(builder, procedure, false, true);
        presentation.addText(sb.toString(), DbNodeDescriptor.getGrayAttrs());
    }

    protected static void describeTable(PresentationData presentation, DasTable delegate, Project project) {
        ObjectKind type = delegate.getKind();
        if (!DbImplUtil.isDataTable(type)) {
            DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)delegate);
            DatabaseDialectEx dialect = dataSource != null ? DbImplUtil.getDatabaseDialect((DbElement)dataSource) : GenericDialect.INSTANCE;
            String typeName = DbPresentation.getPresentableName(delegate.getKind(), dialect);
            presentation.addText(" " + typeName, DbNodeDescriptor.getGrayAttrs());
        }
        if (delegate instanceof PostgresTable) {
            PostgresTable pt = (PostgresTable)delegate;
            boolean hasAncestors = !pt.getAncestorIds().isEmpty();
            boolean hasSuccessors = !pt.getSuccessorIds().isEmpty();
            String s = "";
            if (hasAncestors) {
                s = " based on (" + ModelFun.namesAsString(PostgresModelFun.getAncestors(pt)) + ')';
            }
            if (hasAncestors && hasSuccessors) {
                s = s + " and";
            }
            if (hasSuccessors) {
                s = s + " the base for {" + ModelFun.namesAsString(PostgresModelFun.getSuccessors(pt)) + '}';
            }
            if (hasAncestors || hasSuccessors) {
                presentation.addText(" " + s, DbNodeDescriptor.getGrayAttrs());
            }
        } else if (delegate instanceof SqliteVirtualTable) {
            SqliteVirtualTable vt = (SqliteVirtualTable)delegate;
            String module = vt.getModule();
            List<String> args = vt.getArguments();
            StringBuilder spec = new StringBuilder();
            spec.append(" ");
            if (module != null) {
                spec.append(module);
            }
            spec.append("(");
            StringUtil.join(args, (String)",", (StringBuilder)spec);
            spec.append(")");
            presentation.addText(spec.toString(), DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeColumn(PresentationData presentation, DasColumn column) {
        String d = column.getDataType().getSpecification();
        if (d.length() > 0) {
            presentation.addText(" " + d, DbNodeDescriptor.getGrayAttrs());
        }
        if (DasUtil.isAutoGenerated((DasColumn)column)) {
            presentation.addText(" (auto increment)", DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeCustomType(PresentationData presentation, DasUserDefinedType element) {
        String description = DbImplUtil.getCustomTypeShortDescription(element);
        if (description != null) {
            presentation.addText(' ' + description, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeNamespace(PresentationData presentation, DasNamespace element, Project project) {
        DbNodeDescriptor.appendCollapsedNamespaces(presentation, (DasObject)element, project);
    }

    protected static void describeDataSource(PresentationData presentation, DbDataSource element) {
        DbNodeDescriptor.appendCollapsedNamespaces(presentation, (DasObject)element, element.getProject());
    }

    private static void appendCollapsedNamespaces(PresentationData presentation, DasObject element, Project project) {
        String textExt;
        DasObject root2;
        DatabaseViewOptions options = DatabaseView.getDatabaseView(project).getViewOptions();
        DasObject dasObject = root2 = options.SHOW_INTERMEDIATE ? element : DatabaseStructure.getTopSingleRoot(element);
        if (root2 != element && StringUtil.isNotEmpty((String)(textExt = QNameUtil.getQualifiedName(root2)))) {
            presentation.addText(" (" + textExt + ")", DbNodeDescriptor.getGrayAttrs());
        }
    }

    private static SimpleTextAttributes handleErrors(PresentationData presentation, Object element) {
        SimpleTextAttributes style;
        boolean hasErrors = false;
        boolean hasWarnings = false;
        boolean connected = false;
        if (element instanceof DbDataSource && ((DbDataSource)element).getDelegate() instanceof LocalDataSource) {
            LocalDataSource dataSource = (LocalDataSource)((DbDataSource)element).getDelegate();
            hasErrors = !DbImplUtil.canConnectTo(dataSource);
            hasWarnings = hasErrors;
            if (!hasErrors) {
                for (DataSourceProblem problem : DatabaseConfigValidator.getProblems(element, null)) {
                    DataSourceProblem.Level level = problem.getLevel();
                    if (level == DataSourceProblem.Level.WARNING) {
                        hasWarnings = true;
                        continue;
                    }
                    if (level != DataSourceProblem.Level.ERROR) continue;
                    hasErrors = true;
                    hasWarnings = true;
                }
            }
            connected = DbImplUtil.isConnected(((DbDataSource)element).getProject(), dataSource);
        } else if (element instanceof BasicSourceAware) {
            hasErrors = ((BasicSourceAware)element).isInvalid();
        }
        SimpleTextAttributes simpleTextAttributes = style = element instanceof DasObject && DbPresentation.isUnnamed((DasObject)element) ? DbNodeDescriptor.getGrayAttrs() : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (hasErrors || hasWarnings) {
            SimpleTextAttributes waved = new SimpleTextAttributes(8, null, (Color)(hasErrors ? JBColor.RED : JBColor.ORANGE));
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)waved);
        }
        if (hasErrors && element instanceof LocalDataSource && !DbImplUtil.hasDriverFiles((LocalDataSource)element)) {
            presentation.setTooltip("Can't find the driver, open preferences to download");
        }
        if (connected) {
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            presentation.setTooltip("Connected");
        }
        return style;
    }

    private static SimpleTextAttributes getGrayAttrs() {
        return UIUtil.isUnderDarcula() ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
    }

    public PresentableNodeDescriptor getChildToHighlightAt(int index) {
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return DbNodeDescriptor.getData(dataId, this.getProject(), this.getElement());
    }

    @Nullable
    public static Object getData(@NonNls String dataId, final Project project, final Object node) {
        if (!(node instanceof DasObject)) {
            if (CommonDataKeys.NAVIGATABLE.is(dataId) && node instanceof Navigatable) {
                return node;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && node instanceof PsiElement) {
                return node;
            }
            return null;
        }
        if (!CommonDataKeys.NAVIGATABLE.is(dataId) && !CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return null;
        }
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)node);
        if (dataSource == null) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            if (node instanceof DbDataSource) {
                final DatabaseSystem delegate = ((DbDataSource)node).getDelegate();
                VirtualFile virtualFile = delegate instanceof SqlDataSource ? (VirtualFile)ContainerUtil.getFirstItem((List)((SqlDataSource)delegate).getFiles()) : DatabaseEditorHelper.findExistingConsoleVirtualFile(delegate);
                if (virtualFile == null && DbImplUtil.canConnectTo((DbElement)((DbDataSource)node))) {
                    return new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            VirtualFile file = DatabaseEditorHelper.getConsoleVirtualFile((DatabaseSystem)delegate);
                            if (file == null) {
                                return;
                            }
                            new OpenFileDescriptor(project, file).navigate(requestFocus);
                        }
                    };
                }
                return virtualFile == null ? node : new OpenFileDescriptor(project, virtualFile);
            }
            if (node instanceof Navigatable) {
                return node;
            }
            if (node instanceof DasNamespace && ((DasNamespace)node).getKind() == ObjectKind.SCHEMA) {
                if (DbImplUtil.canConnectTo((DbElement)dataSource)) {
                    final DatabaseSystem dataSourceInfo = (DatabaseSystem)ObjectUtils.assertNotNull((Object)dataSource.getDelegate());
                    return new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            DatabaseEditorHelper.openConsoleFile(project, dataSourceInfo, (DasNamespace)node, false);
                        }
                    };
                }
                return DbImplUtil.findElement(dataSource, (DasObject)node);
            }
            return DbImplUtil.findElement(dataSource, (DasObject)node);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return DbImplUtil.findElement(dataSource, (DasObject)node);
        }
        return null;
    }

    @NotNull
    public static DbElement adjustForNavigation(@NotNull DbElement element) {
        DatabaseFamilyId familyId;
        if (element == null) {
            DbNodeDescriptor.$$$reportNull$$$0(0);
        }
        boolean isTrigger = element instanceof DbTrigger;
        DbElement parent = element.getDbParent();
        DbElement adjusted = element;
        if (parent instanceof DbTable) {
            if (!isTrigger) {
                adjusted = parent;
            }
        } else if (parent instanceof DbPackage && !(familyId = DbImplUtil.getDatabaseDialect(element).getFamilyId()).isSybase()) {
            DbElement body = (DbElement)parent.getDbChildren(DbElement.class, ObjectKind.BODY).first();
            adjusted = (DbElement)ObjectUtils.chooseNotNull((Object)body, (Object)parent);
        }
        DbElement dbElement = adjusted;
        if (dbElement == null) {
            DbNodeDescriptor.$$$reportNull$$$0(1);
        }
        return dbElement;
    }

    public boolean expandOnDoubleClick() {
        return !(this.getElement() instanceof DasTable);
    }

    public boolean isValid() {
        return this.getElement().isValid();
    }

    public int getWeight() {
        DbElement element = this.getElement();
        if (element == null || !element.isValid()) {
            return super.getWeight();
        }
        return element.getWeight();
    }

    public String toString() {
        return super.toString();
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myElement};
        if (objectArray == null) {
            DbNodeDescriptor.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public final boolean equals(Object o) {
        return ComparableObjectCheck.equals((ComparableObject)this, (Object)o);
    }

    public final int hashCode() {
        return ComparableObjectCheck.hashCode((ComparableObject)this, (int)super.hashCode());
    }

    @NotNull
    public static String arrowToColumns(@Nullable String tableName, @NotNull Collection<String> columnNames) {
        if (columnNames == null) {
            DbNodeDescriptor.$$$reportNull$$$0(3);
        }
        String string = StringUtil.isEmpty((String)tableName) ? "" : DbNodeDescriptor.arrow() + " " + tableName + " " + DbNodeDescriptor.multiRef(columnNames);
        if (string == null) {
            DbNodeDescriptor.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static String arrowToColumns(@Nullable String schemaName, @Nullable String tableName, @NotNull MultiRef<? extends DasTypedObject> columnsRef) {
        if (columnsRef == null) {
            DbNodeDescriptor.$$$reportNull$$$0(5);
        }
        String prefix = schemaName != null ? schemaName + "." : "";
        return StringUtil.isEmpty((String)tableName) ? "" : DbNodeDescriptor.arrow() + " " + prefix + tableName + " " + DbNodeDescriptor.multiRef(columnsRef);
    }

    @NotNull
    public static String multiRef(@NotNull Collection<String> names) {
        if (names == null) {
            DbNodeDescriptor.$$$reportNull$$$0(6);
        }
        String string = names.size() == 0 ? "" : "(" + StringUtil.join(names, (String)", ") + ")";
        if (string == null) {
            DbNodeDescriptor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String multiRef(@NotNull MultiRef<? extends DasTypedObject> ref) {
        if (ref == null) {
            DbNodeDescriptor.$$$reportNull$$$0(8);
        }
        String string = ref.size() == 0 ? "" : "(" + StringUtil.join((Iterable)JBIterable.from((Iterable)ref.names()).filter(n -> n != null), (String)", ") + ")";
        if (string == null) {
            DbNodeDescriptor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String arrow() {
        String string = ApplicationManager.getApplication().isUnitTestMode() ? "->" : UIUtil.rightArrow();
        if (string == null) {
            DbNodeDescriptor.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DbNodeDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsRef";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DbNodeDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustForNavigation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "arrowToColumns";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "multiRef";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "arrow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustForNavigation";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "arrowToColumns";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "multiRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

