/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseKeyEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.models.TableKeyEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ArrayUtil;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableKeyEditor
extends DatabaseEditorBaseEx
implements DatabaseEditorUtil.EmbeddableEditor {
    private final DatabaseKeyEditor myKeyEditor;
    private final TableEditorModel myTableModel;
    @NotNull
    private final DatabaseEditorCapabilities.TableKeyEditorCaps myCaps;
    private final JCheckBox myPrimaryKeyCheckBox;
    private final EditorModelBase.Listener myObjectListener;

    public DatabaseTableKeyEditor(@NotNull DatabaseEditorState state, @NotNull TableEditorModel tableModel, @NotNull TableKeyEditorModel columnModel, @NotNull DatabaseEditorCapabilities.TableKeyEditorCaps keyCaps) {
        if (state == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(0);
        }
        if (tableModel == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(1);
        }
        if (columnModel == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(2);
        }
        if (keyCaps == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(3);
        }
        super(state);
        this.myObjectListener = new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableKeyEditor.this.fromModelToUi();
            }
        };
        this.myTableModel = tableModel;
        this.myCaps = keyCaps;
        this.myKeyEditor = new DatabaseKeyEditor(state, columnModel, keyCaps);
        Disposer.register((Disposable)this, (Disposable)this.myKeyEditor);
        this.myPrimaryKeyCheckBox = new JBCheckBox("Primary key");
        this.myKeyEditor.addComponent(this.myPrimaryKeyCheckBox);
        this.myPrimaryKeyCheckBox.setMnemonic(80);
        this.myPrimaryKeyCheckBox.setVisible(this.myCaps.getPrimaryKey().isSupported());
        this.myPrimaryKeyCheckBox.setEnabled(this.myCaps.getPrimaryKey().isAvailable());
        this.initSubscriptions();
        this.updateFromModel();
    }

    private void initSubscriptions() {
        this.myTableModel.addListener(this.myObjectListener, this);
        this.getTableKeyModel().addListener(this.myObjectListener, this);
        this.myPrimaryKeyCheckBox.addItemListener(e -> {
            if (this.myUpdating) {
                return;
            }
            this.myTableModel.setPrimaryKey(this.myPrimaryKeyCheckBox.isSelected() ? this.myKeyEditor.getTableKey() : null);
            this.myTableModel.commit();
        });
    }

    @NotNull
    public TableKeyEditorModel getTableKeyModel() {
        TableKeyEditorModel tableKeyEditorModel = this.myKeyEditor.getTableKeyModel();
        if (tableKeyEditorModel == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(4);
        }
        return tableKeyEditorModel;
    }

    @NotNull
    public DeTableKey getTableKey() {
        DeTableKey deTableKey = (DeTableKey)this.getTableKeyModel().getObject();
        if (deTableKey == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(5);
        }
        return deTableKey;
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(6);
        }
        return deTable;
    }

    @Override
    @NotNull
    public ObjectEditorModel<DeTable> getModel() {
        TableEditorModel tableEditorModel = this.getTableModel();
        if (tableEditorModel == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(7);
        }
        return tableEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        DatabaseTableKeyEditor.setValue(this.myPrimaryKeyCheckBox, this.getTableKey().isPrimary());
    }

    public DatabaseKeyEditor getKeyEditor() {
        return this.myKeyEditor;
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableModel;
        if (tableEditorModel == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(8);
        }
        return tableEditorModel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myKeyEditor.getPreferredFocusedComponent();
        if (jComponent == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(9);
        }
        return jComponent;
    }

    @Override
    public boolean canDoAnything() {
        return this.myCaps.canDoAnything();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myKeyEditor.getComponent();
        if (jComponent == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(10);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent[] getFocusableComponents() {
        JComponent[] jComponentArray = (JComponent[])ArrayUtil.mergeArrays((Object[])this.myKeyEditor.getFocusableComponents(), (Object[])new JComponent[]{this.myPrimaryKeyCheckBox});
        if (jComponentArray == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(11);
        }
        return jComponentArray;
    }

    @Override
    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getRowText() {
        Iterable<Pair<String, TextAttributesKey>> iterable = this.myKeyEditor.getRowText();
        if (iterable == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(12);
        }
        return iterable;
    }

    @Override
    public boolean isObjectValid() {
        return this.myKeyEditor.isObjectValid();
    }

    @NotNull
    public JCheckBox getPrimaryKeyCheckBox() {
        JCheckBox jCheckBox = this.myPrimaryKeyCheckBox;
        if (jCheckBox == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(13);
        }
        return jCheckBox;
    }

    @Override
    @Nullable
    public DeObject getKeyObject() {
        return this.getTableKey();
    }

    @NotNull
    public static DatabaseEditorCapabilities.TableKeyEditorCaps getTableKeyCaps(@NotNull DatabaseEditorCapabilities.TableEditorCaps tableCaps, @Nullable DasTable table, @Nullable DasTableKey key) {
        if (tableCaps == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(14);
        }
        assert (table != null || key == null);
        DasTableKey pk = table == null ? null : DasUtil.getPrimaryKey((DasTable)table);
        boolean isPk = pk != null && key != null && key.isPrimary();
        DatabaseEditorCapabilities.TableKeyEditorCaps tableKeyEditorCaps = new DatabaseEditorCapabilities.TableKeyEditorCaps(tableCaps, tableCaps.getKeyCaps(key != null), pk != null, isPk);
        if (tableKeyEditorCaps == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(15);
        }
        return tableKeyEditorCaps;
    }

    @NotNull
    public DatabaseEditorCapabilities.TableKeyEditorCaps getCaps() {
        DatabaseEditorCapabilities.TableKeyEditorCaps tableKeyEditorCaps = this.myCaps;
        if (tableKeyEditorCaps == null) {
            DatabaseTableKeyEditor.$$$reportNull$$$0(16);
        }
        return tableKeyEditorCaps;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyCaps";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableKeyEditor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableKeyEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableKeyModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableKey";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusableComponents";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryKeyCheckBox";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableKeyCaps";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTableKeyCaps";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

