/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.database.view.ui.DbSchemasTree;
import com.intellij.database.view.ui.FilteringTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbSchemasSelector {
    protected final TreeEditor myTree;
    protected final JComponent myPanel;

    public DbSchemasSelector(@NotNull Project project) {
        if (project == null) {
            DbSchemasSelector.$$$reportNull$$$0(0);
        }
        this.myTree = this.createTree(project);
        this.myPanel = new JPanel(new BorderLayout());
        JComponent northPanel = this.createNorthPanel();
        northPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        this.myPanel.add((Component)northPanel, "North");
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree.getComponent(), (boolean)true), "Center");
    }

    @NotNull
    protected JComponent createNorthPanel() {
        this.myTree.installSimple();
        JPanel res = new JPanel(new BorderLayout());
        ActionToolbar actionsToolbar = ActionManager.getInstance().createActionToolbar("SqlResolveEditor", (ActionGroup)this.getTreeActions(), true);
        actionsToolbar.setTargetComponent((JComponent)this.getTree());
        actionsToolbar.setReservePlaceAutoPopupIcon(false);
        res.add((Component)actionsToolbar.getComponent(), "East");
        JPanel jPanel = res;
        if (jPanel == null) {
            DbSchemasSelector.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    protected void handleIntrospectionError(@Nullable String msg) {
        Component component = ((BorderLayout)this.myPanel.getLayout()).getLayoutComponent("South");
        if (component != null) {
            this.myPanel.remove(component);
        }
        if (msg != null) {
            ErrorNotificationPanel panel = ErrorNotificationPanel.create(msg, null, this.myPanel).addDetailsButton().addCloseButton(() -> this.handleIntrospectionError(null)).build();
            this.myPanel.add((Component)panel, "South");
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    public boolean hasSpeedSearchActive() {
        return SpeedSearchSupply.getSupply((JComponent)this.getTree()) != null;
    }

    @NotNull
    protected static JBIterable<String> getNodeNames(Iterable<DbSchemasTree.MyNode> nodes2) {
        JBIterable jBIterable = JBIterable.from(nodes2).filter(DbCheckBoxTree.MyNode::isChecked).transform(n -> DbSchemasSelector.getNodeName(n)).filter(Conditions.notNull());
        if (jBIterable == null) {
            DbSchemasSelector.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    protected DbSchemasTree.MyNode getRoot() {
        return (DbSchemasTree.MyNode)this.myTree.getSearchModel().getRootObject();
    }

    @NotNull
    public Tree getTree() {
        DbSchemasTree dbSchemasTree = this.myTree.getTree();
        if (dbSchemasTree == null) {
            DbSchemasSelector.$$$reportNull$$$0(3);
        }
        return dbSchemasTree;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            DbSchemasSelector.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @NotNull
    protected DefaultActionGroup getTreeActions() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{new RefreshAction(this.myTree), new ExpandAllAction((JTree)this.getTree()), new CollapseAllAction((JTree)this.getTree())});
        if (defaultActionGroup == null) {
            DbSchemasSelector.$$$reportNull$$$0(5);
        }
        return defaultActionGroup;
    }

    @NotNull
    protected abstract TreeEditor createTree(@NotNull Project var1);

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull Project project, @NotNull DatabaseSystem dataSource) {
        DbDataSource dbDataSource;
        if (project == null) {
            DbSchemasSelector.$$$reportNull$$$0(6);
        }
        if (dataSource == null) {
            DbSchemasSelector.$$$reportNull$$$0(7);
        }
        DatabaseDialectEx databaseDialectEx = (dbDataSource = DbPsiFacade.getInstance((Project)project).findDataSource(dataSource.getUniqueId())) == null ? GenericDialect.INSTANCE : DbImplUtil.getDatabaseDialect((DbElement)dbDataSource);
        if (databaseDialectEx == null) {
            DbSchemasSelector.$$$reportNull$$$0(8);
        }
        return databaseDialectEx;
    }

    public static boolean isSingleRoot(@NotNull Project project, @NotNull DatabaseSystem dataSource) {
        DatabaseFamilyId familyId;
        if (project == null) {
            DbSchemasSelector.$$$reportNull$$$0(9);
        }
        if (dataSource == null) {
            DbSchemasSelector.$$$reportNull$$$0(10);
        }
        return (familyId = DbSchemasSelector.getDatabaseDialect(project, dataSource).getFamilyId()).isPostgres() || familyId.isH2() || familyId.isHsqldb();
    }

    @Nullable
    public static String getNodeName(DbSchemasTree.MyNode n) {
        if (n.getObject() == "*") {
            return "*";
        }
        if (n.getObject() instanceof DatabaseSystem) {
            return ((DatabaseSystem)n.getObject()).getUniqueId();
        }
        return n.getName();
    }

    public static Map<String, DbSchemasTree.MyNode> fillNodesCache(Iterable<DbSchemasTree.MyNode> children, ObjectKind childKind) {
        HashMap oldCache = ContainerUtil.newHashMap();
        for (DbSchemasTree.MyNode node : children) {
            if (node.getKind() != childKind || node.getObject() == "*") continue;
            oldCache.put(DbSchemasSelector.getNodeName(node), node);
        }
        return oldCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DbSchemasSelector";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DbSchemasSelector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNorthPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeNames";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSingleRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RefreshAction
    extends DumbAwareAction {
        private final TreeEditor myTreeEditor;

        public RefreshAction(TreeEditor treeEditor) {
            super("Refresh", "Refresh schemas list", AllIcons.Actions.Refresh);
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{ActionManager.getInstance().getKeyboardShortcut("Synchronize")}), (JComponent)((Object)treeEditor.getTree()));
            this.myTreeEditor = treeEditor;
        }

        public void update(AnActionEvent e) {
            List dataSources = JBIterable.of((Object[])this.myTreeEditor.getTree().getSelectedNodes(CheckedTreeNode.class, null)).transform(n -> RefreshAction.getDatabaseSystem((DbSchemasTree.MyNode)this.myTreeEditor.getUserObject((TreeNode)n))).filter(LocalDataSource.class).unique().toList();
            boolean enabled = !dataSources.isEmpty() && this.myTreeEditor.canReintrospect(dataSources);
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setDescription("Refresh schemas list" + (enabled ? "" : " (already running)"));
        }

        public void actionPerformed(AnActionEvent e) {
            MultiMap objects = MultiMap.createLinked();
            JBIterable nodes2 = JBIterable.of((Object[])this.myTreeEditor.getTree().getSelectedNodes(CheckedTreeNode.class, null)).transform(n -> (DbSchemasTree.MyNode)this.myTreeEditor.getUserObject((TreeNode)n)).filter(Conditions.notNull());
            for (DbSchemasTree.MyNode node : nodes2) {
                LocalDataSource ds = (LocalDataSource)ObjectUtils.tryCast((Object)RefreshAction.getDatabaseSystem(node), LocalDataSource.class);
                if (ds == null) continue;
                ContainerUtil.addIfNotNull((Collection)objects.getModifiable((Object)ds), (Object)ObjectUtils.tryCast((Object)node.getObject(), BasicNamespace.class));
            }
            this.myTreeEditor.reintrospect((MultiMap<LocalDataSource, BasicNamespace>)objects);
        }

        @Nullable
        private static DatabaseSystem getDatabaseSystem(@Nullable DbSchemasTree.MyNode n) {
            return n == null ? null : (DatabaseSystem)JBIterable.generate((Object)n, x -> (DbSchemasTree.MyNode)x.getParent()).transform(x -> x.getObject()).filter(DatabaseSystem.class).first();
        }
    }

    public abstract class TreeEditor
    extends FilteringTree<CheckedTreeNode, DbSchemasTree.MyNode> {
        public TreeEditor(@NotNull Project project, @NotNull Tree tree, CheckedTreeNode root2) {
            if (DbSchemasSelector.this == null) {
                TreeEditor.$$$reportNull$$$0(0);
            }
            if (project == null) {
                TreeEditor.$$$reportNull$$$0(1);
            }
            if (tree == null) {
                TreeEditor.$$$reportNull$$$0(2);
            }
            if (root2 == null) {
                TreeEditor.$$$reportNull$$$0(3);
            }
            super(project, tree, root2);
        }

        @Override
        protected Class<? extends CheckedTreeNode> getNodeClass() {
            return CheckedTreeNode.class;
        }

        @Override
        @NotNull
        protected CheckedTreeNode createNode(@Nullable DbSchemasTree.MyNode obj) {
            CheckedTreeNode checkedTreeNode = DbSchemasTree.createNode(obj);
            if (checkedTreeNode == null) {
                TreeEditor.$$$reportNull$$$0(4);
            }
            return checkedTreeNode;
        }

        @Override
        @NotNull
        protected Iterable<DbSchemasTree.MyNode> getChildren(@NotNull DbSchemasTree.MyNode obj) {
            if (obj == null) {
                TreeEditor.$$$reportNull$$$0(5);
            }
            JBIterable jBIterable = obj.getChildNodes();
            if (jBIterable == null) {
                TreeEditor.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        @Override
        @Nullable
        protected String getText(@Nullable DbSchemasTree.MyNode object) {
            return object == null ? null : object.getName();
        }

        @NotNull
        public DbSchemasTree getTree() {
            DbSchemasTree dbSchemasTree = (DbSchemasTree)super.getTree();
            if (dbSchemasTree == null) {
                TreeEditor.$$$reportNull$$$0(7);
            }
            return dbSchemasTree;
        }

        @Override
        protected void rebuildTree() {
            DbSchemasTree.MyNode root2 = (DbSchemasTree.MyNode)this.getSearchModel().getRootObject();
            root2.setHasAll(this.hasAll(null));
            Map<String, DbSchemasTree.MyNode> cache = DbSchemasSelector.fillNodesCache(root2.getChildNodes(), root2.getChildKind());
            ArrayList dataSources = ContainerUtil.newArrayList();
            List sorted = ContainerUtil.sorted(this.getDataSources(), (a, b) -> StringUtil.naturalCompare((String)a.getName(), (String)b.getName()));
            for (final DatabaseSystem ds : sorted) {
                BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)ds.getModel(), BasicModel.class);
                DbSchemasTree.MyNode node = cache.remove(ds.getUniqueId());
                if (node == null) {
                    node = new DbSchemasTree.MyNode(ds.getName(), this.getDsKind(), ds){

                        @Override
                        @Nullable
                        public ObjectKind getChildKind() {
                            return TreeEditor.this.isSchemaRoot(ds, ds.getModel()) ? ObjectKind.SCHEMA : ObjectKind.DATABASE;
                        }
                    };
                }
                dataSources.add(node);
                this.addNodes(node, (Iterable<BasicNamespace>)(model == null ? JBIterable.empty() : this.sorted(model.getRoot().getNamespaces())), this.hasAll(ds));
            }
            root2.setChildren(dataSources);
            root2.setShadowChildren(cache.values());
            cache.values().forEach(DbCheckBoxTree.MyNode::makeShadow);
            this.createShadowStructure(root2);
            this.getSearchModel().updateStructure();
        }

        protected boolean hasAll(@Nullable Object obj) {
            return false;
        }

        @NotNull
        protected ObjectKind getDsKind() {
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                TreeEditor.$$$reportNull$$$0(8);
            }
            return objectKind;
        }

        @NotNull
        protected Iterable<? extends DatabaseSystem> getDataSources() {
            JBIterable jBIterable = JBIterable.from((Iterable)DbPsiFacade.getInstance((Project)this.getProject()).getDataSources()).transform(DbDataSource::getDelegate);
            if (jBIterable == null) {
                TreeEditor.$$$reportNull$$$0(9);
            }
            return jBIterable;
        }

        private void addNodes(@NotNull DbSchemasTree.MyNode p, @NotNull Iterable<BasicNamespace> objects, boolean hasAll) {
            if (p == null) {
                TreeEditor.$$$reportNull$$$0(10);
            }
            if (objects == null) {
                TreeEditor.$$$reportNull$$$0(11);
            }
            ObjectKind childKind = p.getChildKind();
            Map<String, DbSchemasTree.MyNode> oldCache = DbSchemasSelector.fillNodesCache(p.getChildNodes(), childKind);
            ArrayList children = ContainerUtil.newArrayList();
            for (BasicNamespace object : objects) {
                if (StringUtil.isEmpty((String)object.getName())) continue;
                DbSchemasTree.MyNode node = oldCache.remove(object.getName());
                if (node != null) {
                    node.setObject(object);
                } else {
                    node = new DbSchemasTree.MyNode(object.getName(), object.getKind(), object);
                }
                children.add(node);
                if (!this.shouldExpand(object)) continue;
                this.addNodes(node, this.sorted((Iterable<? extends BasicNamespace>)object.getDbChildren().filter(BasicNamespace.class)), this.hasAll(object));
            }
            oldCache.values().forEach(o -> o.setObject(o.getName()));
            p.setHasAll(hasAll);
            p.setChildren(children);
            p.setShadowChildren(oldCache.values());
        }

        protected boolean shouldExpand(BasicNamespace object) {
            return object.getKind() != ObjectKind.SCHEMA;
        }

        private Iterable<BasicNamespace> sorted(Iterable<? extends BasicNamespace> children) {
            ArrayList namespaces = ContainerUtil.newArrayList(children);
            Collections.sort(namespaces, (n1, n2) -> StringUtil.naturalCompare((String)n1.getName(), (String)n2.getName()));
            return namespaces;
        }

        protected abstract void createShadowStructure(@NotNull DbSchemasTree.MyNode var1);

        @Nullable
        public Boolean isSchemaRoot(@NotNull String id) {
            if (id == null) {
                TreeEditor.$$$reportNull$$$0(12);
            }
            for (DatabaseSystem databaseSystem : this.getDataSources()) {
                if (!id.equals(databaseSystem.getUniqueId())) continue;
                return this.isSchemaRoot(databaseSystem, databaseSystem.getModel());
            }
            return null;
        }

        protected boolean isSchemaRoot(@NotNull DatabaseSystem dataSource, @Nullable DasModel model) {
            BasicModel tempModel;
            BasicNamespace rootNamespace;
            if (dataSource == null) {
                TreeEditor.$$$reportNull$$$0(13);
            }
            BasicNamespace basicNamespace = rootNamespace = (tempModel = (BasicModel)ObjectUtils.tryCast((Object)model, BasicModel.class)) == null ? null : (BasicNamespace)tempModel.getRoot().getNamespaces().jbi().first();
            return rootNamespace == null ? DbSchemasSelector.getDatabaseDialect(this.getProject(), dataSource).getMetaModel().getRootNamespaceKinds().contains((Object)ObjectKind.SCHEMA) : rootNamespace.getKind() == ObjectKind.SCHEMA;
        }

        public boolean canReintrospect(@NotNull List<LocalDataSource> dataSources) {
            if (dataSources == null) {
                TreeEditor.$$$reportNull$$$0(14);
            }
            for (LocalDataSource dataSource : dataSources) {
                if (!this.canReintrospect(dataSource)) continue;
                return true;
            }
            return false;
        }

        public boolean canReintrospect(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                TreeEditor.$$$reportNull$$$0(15);
            }
            return DbImplUtil.canConnectTo(dataSource) && DataSourceSyncManager.getInstance().isAbleToPerform(dataSource);
        }

        public void reintrospect(@NotNull MultiMap<LocalDataSource, BasicNamespace> objects) {
            if (objects == null) {
                TreeEditor.$$$reportNull$$$0(16);
            }
            while (objects.size() != 0) {
                CompletionStage<DataSourceSyncManager.SyncResult> promise;
                LocalDataSource dataSource = (LocalDataSource)ContainerUtil.getFirstItem((Collection)objects.keySet());
                Collection namespaces = objects.remove((Object)dataSource);
                if (dataSource == null || !this.canReintrospect(dataSource)) continue;
                LoaderContext context = new LoaderContext(this.getProject(), dataSource).setNamespacesOnly(true);
                if (namespaces != null) {
                    context.getSelection().addAll(namespaces);
                }
                if ((promise = DataSourceSyncManager.getInstance().tryPerform(context, true, true)) == null) continue;
                promise.whenCompleteAsync((res, e) -> {
                    if (objects == null) {
                        TreeEditor.$$$reportNull$$$0(17);
                    }
                    AsyncUtil.addUnhandledError(context.getErrorHandler(), e, context.getDataSource().getName(), DbImplUtil.getDatabaseDialect(context.getDataSource()).getFamilyId());
                    DbSchemasSelector.this.handleIntrospectionError(StringUtil.nullize((String)context.getErrorHandler().getSummary()));
                    if (res != null) {
                        this.update();
                    }
                    if (e == null) {
                        this.reintrospect(objects);
                    }
                }, AsyncUtil.EDT_EXECUTOR);
                break;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "this$0";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DbSchemasSelector$TreeEditor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 11: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DbSchemasSelector$TreeEditor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNode";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTree";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDsKind";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addNodes";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "isSchemaRoot";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "canReintrospect";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "reintrospect";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$reintrospect$3";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

