/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.families.ModFamily;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.sql.database.DasPath;
import com.intellij.sql.database.SqlModelBuilderUtils;
import com.intellij.sql.database.SqlTxModelWrapper;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlModelBuilder {
    private final Project myProject;
    private final BasicModModel myModel;
    private final Map<DasObject, BasicElement> mySources;
    private Map<BasicElement, SmartPsiElementPointer<SqlElement>> myMapping;

    public SqlModelBuilder(@NotNull Project project, @NotNull BasicModModel model, @NotNull Map<BasicElement, SmartPsiElementPointer<SqlElement>> mapping) {
        if (project == null) {
            SqlModelBuilder.$$$reportNull$$$0(0);
        }
        if (model == null) {
            SqlModelBuilder.$$$reportNull$$$0(1);
        }
        if (mapping == null) {
            SqlModelBuilder.$$$reportNull$$$0(2);
        }
        this.mySources = ContainerUtil.newHashMap();
        this.myProject = project;
        this.myModel = model;
        this.myMapping = mapping;
        for (Map.Entry<BasicElement, SmartPsiElementPointer<SqlElement>> entry : mapping.entrySet()) {
            DasObject object = (DasObject)ObjectUtils.tryCast((Object)entry.getValue().getElement(), DasObject.class);
            if (object == null) continue;
            this.mySources.put(object, entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void introspect(@NotNull List<SqlFile> files, boolean clear, long syncTimeout, @NotNull PairConsumer<Integer, Map<BasicElement, SmartPsiElementPointer<SqlElement>>> pairConsumer) {
        int i2;
        if (files == null) {
            SqlModelBuilder.$$$reportNull$$$0(3);
        }
        if (pairConsumer == null) {
            SqlModelBuilder.$$$reportNull$$$0(4);
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        SqlTxModelWrapper stagingModel = new SqlTxModelWrapper(this.myModel, this.mySources);
        SqlFileProcessor processor = new SqlFileProcessor(this.myProject, stagingModel);
        long time = System.currentTimeMillis();
        try {
            for (i2 = 0; i2 < files.size(); ++i2) {
                void onDone;
                SqlFile file = files.get(i2);
                if (indicator != null) {
                    indicator.setFraction(((double)i2 + 0.0) / (double)files.size());
                    indicator.setText2(file.getName());
                }
                stagingModel.modify(() -> processor.process(file));
                long cur = System.currentTimeMillis();
                if (cur - time <= syncTimeout && i2 + 1 != files.size()) continue;
                time = cur;
                this.myMapping = this.apply(processor, clear && i2 == 0);
                onDone.consume((Object)i2, this.myMapping);
            }
        }
        finally {
            if (i2 != 0) {
                this.myModel.modify(BasicModRoot.class, r -> this.finish());
            }
        }
    }

    @NotNull
    public Map<BasicElement, SmartPsiElementPointer<SqlElement>> apply(SqlFileProcessor processor, boolean clear) {
        final Map<BasicElement, SmartPsiElementPointer<SqlElement>> tmp = processor.reverseMap();
        this.myModel.modify(BasicModRoot.class, r -> {
            if (clear) {
                this.prepare();
            }
            processor.apply();
        });
        final HashMap result2 = ContainerUtil.newHashMap(this.myMapping);
        new SqlTxModelWrapper.TwoModelVisitor(){

            @Override
            public void visit(@NotNull BasicElement guide, @NotNull BasicElement guided) {
                if (guide == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (guided == null) {
                    1.$$$reportNull$$$0(1);
                }
                ContainerUtil.putIfNotNull((Object)guide, tmp.get(guided), (Map)result2);
                super.visit(guide, guided);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "guide";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "guided";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/database/SqlModelBuilder$1";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visit(this.myModel.getRoot(), processor.getRoot());
        HashMap hashMap = result2;
        if (hashMap == null) {
            SqlModelBuilder.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    public void prepare() {
        for (BasicModElement element : this.myModel.traverser().preOrderDfsTraversal().filter(BasicModElement.class)) {
            for (ModFamily<? extends BasicModElement> modFamily : element.getFamilies()) {
                modFamily.markChildrenAsSyncPending();
            }
        }
    }

    public void finish() {
        for (BasicModElement element : this.myModel.traverser().preOrderDfsTraversal().filter(BasicModElement.class)) {
            for (ModFamily<? extends BasicModElement> modFamily : element.getFamilies()) {
                modFamily.removeSyncPendingChildren();
                modFamily.sort();
            }
        }
        this.finalizeObjects();
    }

    public void finalizeObjects() {
        for (BasicModElement element : this.myModel.traverser().preOrderDfsTraversal().filter(BasicModElement.class)) {
            SqlModelBuilderUtils.finalizeObject(element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDone";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlModelBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "introspect";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SqlFileProcessor {
        private final Project myProject;
        private final Map<DasPath, BasicModElement> myObjects;
        private final Map<DasObject, DasPath> myPaths;
        private final Set<DasObject> myProcessed;
        private final Set<DasObject> myDelayed;
        private final SqlTxModelWrapper myModel;
        private final DatabaseFamilyId myFamilyId;
        private final Map<DasObject, PsiElement> myOraPackageRestarter;

        public SqlFileProcessor(@NotNull Project project, @NotNull SqlTxModelWrapper model) {
            if (project == null) {
                SqlFileProcessor.$$$reportNull$$$0(0);
            }
            if (model == null) {
                SqlFileProcessor.$$$reportNull$$$0(1);
            }
            this.myObjects = ContainerUtil.newHashMap();
            this.myPaths = ContainerUtil.newHashMap();
            this.myProcessed = ContainerUtil.newHashSet();
            this.myDelayed = ContainerUtil.newLinkedHashSet();
            this.myOraPackageRestarter = ContainerUtil.newHashMap();
            this.myProject = project;
            this.myModel = model;
            this.myFamilyId = (DatabaseFamilyId)ObjectUtils.chooseNotNull((Object)GenericIntrospectorLegacyModelUtils.findFamily(this.myModel.getRdbms()), (Object)DatabaseFamilyId.UNKNOWN);
        }

        public void processDelayed() {
            while (!this.myDelayed.isEmpty()) {
                Iterator<DasObject> it = this.myDelayed.iterator();
                DasObject d = it.next();
                it.remove();
                d.getDbChildren(DasObject.class, ObjectKind.NONE).forEach(o -> this.process((DasObject)o));
            }
        }

        public void process(@NotNull SqlFile file) {
            if (file == null) {
                SqlFileProcessor.$$$reportNull$$$0(2);
            }
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            for (DasObject obj : file.traverser().preOrderDfsTraversal()) {
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                this.process(obj);
            }
            this.processDelayed();
        }

        @Nullable
        private BasicModElement process(@NotNull DasObject obj) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(3);
            }
            if (obj instanceof SqlRenameToClause || obj instanceof PsiElement && !(obj instanceof FakePsiElement) && !(obj instanceof SqlStubbedElement)) {
                return null;
            }
            DasPath path = DasPath.of(obj, this.myFamilyId, this.myPaths);
            if (this.myProcessed.contains(obj)) {
                return this.myModel.nullize(this.myObjects.get(path));
            }
            BasicModElement parent = this.getParent(obj);
            ObjectKind kind = this.myModel.getMetaModel().unaliased(obj.getKind());
            this.processOddities(obj, parent, kind);
            BasicModElement target = this.myModel.createOrGet(parent, path);
            this.markObjectReady(path, obj, target);
            if (target == null) {
                ObjectKind parentKind;
                boolean ignored = false;
                DasPath p = path;
                while (p.parent != null && !ignored) {
                    if (SqlModelBuilderUtils.isIgnored(this.myFamilyId, p.parent.kind, p.kind)) {
                        ignored = true;
                    }
                    p = p.parent;
                }
                ObjectKind objectKind = parentKind = parent == null ? ObjectKind.NONE : parent.getKind();
                if (!ignored && !SqlModelBuilderUtils.isIgnored(this.myFamilyId, parentKind, obj.getKind())) {
                    SqlModelBuilderUtils.hardWarning("No family " + kind.code() + " in " + parentKind.code());
                }
            } else {
                SqlModelBuilderUtils.fillObject(target, obj);
            }
            return target;
        }

        private void markObjectReady(DasPath path, @NotNull DasObject obj, @Nullable BasicModElement target) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(4);
            }
            this.myObjects.put(path, this.myModel.notNullize(target));
            this.myProcessed.add(obj);
        }

        private void processOddities(@NotNull DasObject obj, @Nullable BasicModElement parent, @NotNull ObjectKind kind) {
            PsiElement element;
            PsiObject pkg;
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(5);
            }
            if (kind == null) {
                SqlFileProcessor.$$$reportNull$$$0(6);
            }
            if (this.myFamilyId.isOracle() && parent != null && parent.getKind() == ObjectKind.PACKAGE && kind != ObjectKind.BODY && (pkg = (PsiObject)JBIterable.generate((Object)ObjectUtils.tryCast((Object)obj, PsiElement.class), x -> x.getContext()).filter(PsiObject.class).skip(1).first()) != null && pkg.getKind() == ObjectKind.PACKAGE && ((element = this.myOraPackageRestarter.get(parent)) == null || element != pkg)) {
                this.myOraPackageRestarter.put(parent, (PsiElement)pkg);
                JBIterable.from(parent.getFamilyKinds()).filter(x -> x != ObjectKind.BODY).transform(parent::familyOf).forEach(ModFamily::markChildrenAsSyncPending);
            }
        }

        @Nullable
        private BasicModElement getParent(@NotNull DasObject obj) {
            DasObject parent;
            ObjectKind kind;
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(7);
            }
            ObjectKind objectKind = kind = (parent = obj.getDbParent()) == null ? ObjectKind.NONE : parent.getKind();
            if (kind == ObjectKind.NONE || kind == ObjectKind.ROOT) {
                return this.myModel.getEmptyParent(obj.getKind());
            }
            DasPath parentPath = DasPath.of(parent, this.myFamilyId, this.myPaths);
            BasicModElement element = this.myObjects.get(parentPath);
            if (element != null) {
                return this.myModel.nullize(element);
            }
            element = this.myModel.getProcessed(obj);
            if (element != null) {
                return element;
            }
            if (!(parent instanceof DasNamespace)) {
                this.myDelayed.add(parent);
            }
            return this.process(parent);
        }

        @NotNull
        public Map<BasicElement, SmartPsiElementPointer<SqlElement>> reverseMap() {
            HashMap res = ContainerUtil.newHashMap();
            SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.myProject);
            for (Map.Entry<DasObject, DasPath> entry : this.myPaths.entrySet()) {
                BasicModElement target;
                SqlElement object = (SqlElement)ObjectUtils.tryCast((Object)entry.getKey(), SqlElement.class);
                if (object == null || this.myModel.nullize(target = this.myObjects.get(entry.getValue())) == null) continue;
                res.put(target, pointerManager.createSmartPsiElementPointer((PsiElement)object));
            }
            HashMap hashMap = res;
            if (hashMap == null) {
                SqlFileProcessor.$$$reportNull$$$0(8);
            }
            return hashMap;
        }

        public void apply() {
            this.myModel.apply();
        }

        @NotNull
        public BasicElement getRoot() {
            BasicModElement basicModElement = this.myModel.getRoot();
            if (basicModElement == null) {
                SqlFileProcessor.$$$reportNull$$$0(9);
            }
            return basicModElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "reverseMap";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "markObjectReady";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processOddities";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getParent";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

