/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.impl.BlackHoleTextStorage;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.database.DasPath;
import com.intellij.sql.database.SqlModelBuilderUtils;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class SqlTxModelWrapper {
    private final BasicModModel myTarget;
    private final BasicModModel myScapeGoat;
    private final MetaModel myMetaModel;
    private final Map<ObjectKind, BasicModElement> myEmptyParents;
    private final Map<DasObject, BasicElement> mySourceMapping;
    private final Set<BasicElement> myDirty;

    public SqlTxModelWrapper(@NotNull BasicModModel target, @NotNull Map<DasObject, BasicElement> mapping) {
        if (target == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(0);
        }
        if (mapping == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(1);
        }
        this.myEmptyParents = ContainerUtil.newHashMap();
        this.myDirty = ContainerUtil.newLinkedHashSet();
        this.myTarget = target;
        this.mySourceMapping = mapping;
        this.myScapeGoat = new ModelFactory(BlackHoleTextStorage.INSTANCE).createModel(this.myTarget.getRdbms());
        DatabaseFamilyId family = GenericIntrospectorLegacyModelUtils.findFamily(this.myTarget.getRdbms());
        DatabaseDialectEx dialect = (DatabaseDialectEx)ObjectUtils.chooseNotNull((Object)DatabaseDialects.findByFamily(family), (Object)GenericDialect.INSTANCE);
        this.myMetaModel = dialect.getMetaModel();
        ((BasicModRoot)this.myTarget.getRoot()).setDefaultCasing(dialect.getCasing(ObjectKind.NONE, null));
    }

    @NotNull
    public Rdbms getRdbms() {
        Rdbms rdbms = this.myTarget.getRdbms();
        if (rdbms == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(2);
        }
        return rdbms;
    }

    public void apply() {
        new ModelApplier.TopDown(this.myDirty).apply(this.myScapeGoat.getRoot(), (BasicModElement)((Object)this.myTarget.getRoot()));
        this.myDirty.clear();
    }

    public MetaModel getMetaModel() {
        return this.myMetaModel;
    }

    public void modify(Runnable r) {
        this.myScapeGoat.modify(BasicModRoot.class, x -> r.run());
    }

    @Nullable
    private static BasicElement findObject(@NotNull Family<?> target, @NotNull BasicElement child) {
        if (target == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(3);
        }
        if (child == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(4);
        }
        if (child instanceof BasicOverloadable) {
            String identity = child.identity();
            return target.find(x -> x.identity().equals(identity));
        }
        String name = child.getName();
        return target.find(x -> x.getName().equals(name));
    }

    @NotNull
    private static BasicModElement findRecipient(@NotNull ModFamily<?> target, @NotNull BasicElement child) {
        BasicModElement e;
        if (target == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(5);
        }
        if (child == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(6);
        }
        if (child instanceof BasicOverloadable) {
            String identity = child.identity();
            e = target.find(x -> x.identity().equals(identity));
        } else {
            String name = child.getName();
            boolean empty = StringUtil.isEmpty((String)name) && !(child instanceof BasicNamespace);
            e = target.find(x -> (!empty || x.isSyncPending()) && x.getName().equals(name));
        }
        if (e != null) {
            e.resetSyncPending();
        }
        BasicModElement basicModElement = e == null ? target.createNewOne() : e;
        if (basicModElement == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(7);
        }
        return basicModElement;
    }

    @NotNull
    public BasicModElement getRoot() {
        BasicModElement basicModElement = (BasicModElement)((Object)this.myScapeGoat.getRoot());
        if (basicModElement == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(8);
        }
        return basicModElement;
    }

    @Nullable
    public BasicModElement createEmptyChild(@Nullable BasicModElement parent, @NotNull ObjectKind kind) {
        Family family;
        if (kind == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(9);
        }
        if (parent == null) {
            if (kind != ObjectKind.SCHEMA && kind != ObjectKind.DATABASE) {
                return null;
            }
            parent = this.getRoot();
        }
        if ((family = parent.familyOf(kind)) == null) {
            return null;
        }
        BasicModElement element = (BasicModElement)family.jbi().filter(DasUtil.byName((String)DasUtil.NO_NAME)).first();
        if (element != null) {
            return element;
        }
        element = family.createNewOne();
        if (element instanceof BasicModMateNamespace) {
            ((BasicModMateNamespace)element).setVisible(true);
        }
        return element;
    }

    @Nullable
    public BasicModElement getProcessed(@NotNull DasObject object) {
        BasicElement element;
        if (object == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(10);
        }
        if ((element = this.mySourceMapping.get(object)) == null) {
            return null;
        }
        return new ModelApplier.BottomUp(this.getRoot()).copy(element);
    }

    @Nullable
    public BasicModElement createOrGet(@Nullable BasicModElement parent, @NotNull DasPath path) {
        Object obj;
        Family family;
        if (path == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(11);
        }
        ObjectKind kind = this.myMetaModel.unaliased(path.kind);
        if (parent == null) {
            if (kind != ObjectKind.SCHEMA && kind != ObjectKind.DATABASE) {
                return null;
            }
            parent = this.getRoot();
        }
        if ((family = parent.familyOf(kind)) == null) {
            return null;
        }
        if (family instanceof ModSingletonFamily) {
            obj = ((ModSingletonFamily)family).createOrGet();
        } else {
            obj = family.find(o -> {
                if (path == null) {
                    SqlTxModelWrapper.$$$reportNull$$$0(16);
                }
                return path.name.name.equals(o.getName()) && (path.subName == null || path.subName.equals(o.identity()));
            });
            if (obj != null && !obj.isSyncPending() && StringUtil.isEmpty((String)path.name.name) && !(obj instanceof BasicNamespace)) {
                obj = null;
            }
            if (obj instanceof BasicOverloadable) {
                obj = null;
            }
            if (obj == null) {
                obj = family.createNewOne();
                if (obj instanceof BasicModNamedElement) {
                    ((BasicModNamedElement)obj).setName(path.name.name);
                }
            } else {
                obj.resetSyncPending();
            }
        }
        ContainerUtil.addIfNotNull(this.myDirty, obj);
        return obj;
    }

    @Nullable
    public BasicModElement getEmptyParent(@NotNull ObjectKind kind) {
        BasicModElement element;
        if (kind == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(12);
        }
        if ((element = this.myEmptyParents.get(kind)) != null) {
            return this.nullize(element);
        }
        List path = (List)this.myMetaModel.getPathsToRoot(kind).first();
        if (ContainerUtil.isEmpty((Collection)path)) {
            element = kind == ObjectKind.TABLE ? null : this.getEmptyParent(ObjectKind.TABLE);
            return this.putEmptyParent(kind, element);
        }
        if (kind != path.get(0)) {
            SqlModelBuilderUtils.hardWarning("Path not started with " + kind.code());
        }
        return this.getEmptyParent(path, 0);
    }

    @Nullable
    private BasicModElement getEmptyParent(@NotNull List<ObjectKind> path, int idx) {
        if (path == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(13);
        }
        if (idx + 1 >= path.size()) {
            return null;
        }
        ObjectKind kind = path.get(idx);
        BasicModElement element = this.myEmptyParents.get(kind);
        if (element != null) {
            return this.nullize(element);
        }
        BasicModElement grandParent = this.getEmptyParent(path, idx + 1);
        element = this.createEmptyChild(grandParent, path.get(idx + 1));
        return this.putEmptyParent(kind, element);
    }

    @Nullable
    private BasicModElement putEmptyParent(@NotNull ObjectKind kind, @Nullable BasicModElement parent) {
        if (kind == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(14);
        }
        this.myEmptyParents.put(kind, this.notNullize(parent));
        return parent;
    }

    @NotNull
    public BasicModElement notNullize(@Nullable BasicModElement elem) {
        BasicModElement basicModElement = elem == null ? this.getRoot() : elem;
        if (basicModElement == null) {
            SqlTxModelWrapper.$$$reportNull$$$0(15);
        }
        return basicModElement;
    }

    @Nullable
    public BasicModElement nullize(@Nullable BasicModElement elem) {
        return elem == this.getRoot() ? null : elem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlTxModelWrapper";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlTxModelWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRdbms";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findRecipient";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 15: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findObject";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRecipient";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyChild";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProcessed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createOrGet";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEmptyParent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "putEmptyParent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createOrGet$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModelApplier {
        private final Map<String, String> myPropertiesMap = ContainerUtil.newHashMap();

        private ModelApplier() {
        }

        protected void applyProperties(@NotNull BasicElement source, @NotNull BasicModElement target) {
            if (source == null) {
                ModelApplier.$$$reportNull$$$0(0);
            }
            if (target == null) {
                ModelApplier.$$$reportNull$$$0(1);
            }
            source.exportProperties(this.myPropertiesMap::put);
            target.importProperties(this.myPropertiesMap);
            this.myPropertiesMap.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/database/SqlTxModelWrapper$ModelApplier";
            objectArray[2] = "applyProperties";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static class BottomUp
        extends ModelApplier {
            private final BasicModElement myTargetRoot;

            public BottomUp(@NotNull BasicModElement root2) {
                if (root2 == null) {
                    BottomUp.$$$reportNull$$$0(0);
                }
                this.myTargetRoot = root2;
            }

            @Nullable
            private BasicModElement copy(@NotNull BasicElement element) {
                Family family;
                if (element == null) {
                    BottomUp.$$$reportNull$$$0(1);
                }
                if (((BasicModElement)element).isSyncPending()) {
                    return null;
                }
                if (element.getKind() == ObjectKind.ROOT) {
                    return this.myTargetRoot;
                }
                BasicModElement copied = this.copy((BasicElement)ObjectUtils.assertNotNull((Object)element.getDbParent()));
                Family family2 = family = copied == null ? null : copied.familyOf(element.getKind());
                if (family == null) {
                    return null;
                }
                BasicModElement recipient = (BasicModElement)SqlTxModelWrapper.findObject(family, element);
                if (recipient == null) {
                    recipient = family.createNewOne();
                }
                this.applyProperties(element, recipient);
                return recipient;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sql/database/SqlTxModelWrapper$ModelApplier$BottomUp";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "copy";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        public static class TopDown
        extends ModelApplier {
            private final Set<BasicElement> myDirty;
            private final Set<BasicElement> myWorkSet;

            public TopDown(@NotNull Set<BasicElement> dirty) {
                if (dirty == null) {
                    TopDown.$$$reportNull$$$0(0);
                }
                this.myDirty = dirty;
                this.myWorkSet = ContainerUtil.newHashSet();
                for (BasicElement element : dirty) {
                    for (element = element.getDbParent(); element != null && !dirty.contains(element) && this.myWorkSet.add(element); element = element.getDbParent()) {
                    }
                }
            }

            public void apply(@NotNull BasicElement source, @NotNull BasicModElement target) {
                if (source == null) {
                    TopDown.$$$reportNull$$$0(1);
                }
                if (target == null) {
                    TopDown.$$$reportNull$$$0(2);
                }
                new TwoModelVisitor(){

                    @Override
                    public void visit(@NotNull BasicElement guide, @NotNull BasicElement guided) {
                        if (guide == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (guided == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (myDirty.contains(guide)) {
                            this.applyProperties(guide, (BasicModElement)guided);
                        }
                        if (!(guided instanceof BasicNamespace)) {
                            ((BasicModElement)guided).getFamilies().forEach(ModFamily::markChildrenAsSyncPending);
                        }
                        super.visit(guide, guided);
                    }

                    @Override
                    @Nullable
                    public BasicElement find(@NotNull Family<?> guided, @NotNull BasicElement guide) {
                        if (guided == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (guide == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (((BasicModElement)guide).isSyncPending() || !myWorkSet.contains(guide) && !myDirty.contains(guide)) {
                            return null;
                        }
                        BasicModElement recipient = SqlTxModelWrapper.findRecipient((ModFamily)guided, guide);
                        if (recipient instanceof BasicModMateNamespace) {
                            ((BasicModMateNamespace)recipient).setVisible(true);
                        }
                        return recipient;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "guide";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "guided";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/sql/database/SqlTxModelWrapper$ModelApplier$TopDown$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visit";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "find";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }.visit(source, target);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dirty";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sql/database/SqlTxModelWrapper$ModelApplier$TopDown";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class TwoModelVisitor {
        public void visit(@NotNull BasicElement guide, @NotNull BasicElement guided) {
            if (guide == null) {
                TwoModelVisitor.$$$reportNull$$$0(0);
            }
            if (guided == null) {
                TwoModelVisitor.$$$reportNull$$$0(1);
            }
            for (Family<? extends BasicElement> family : guide.getFamilies()) {
                Family<? extends BasicElement> targetFamily;
                if (family.isEmpty() || (targetFamily = guided.familyOf(family.first().getKind())) == null) continue;
                this.visit(family, targetFamily);
            }
        }

        public void visit(@NotNull Family<?> guide, @NotNull Family<?> guided) {
            if (guide == null) {
                TwoModelVisitor.$$$reportNull$$$0(2);
            }
            if (guided == null) {
                TwoModelVisitor.$$$reportNull$$$0(3);
            }
            for (BasicElement child : guide) {
                BasicElement element = this.find(guided, child);
                if (element == null) continue;
                this.visit(child, element);
            }
        }

        @Nullable
        public BasicElement find(@NotNull Family<?> guided, @NotNull BasicElement guide) {
            if (guided == null) {
                TwoModelVisitor.$$$reportNull$$$0(4);
            }
            if (guide == null) {
                TwoModelVisitor.$$$reportNull$$$0(5);
            }
            return SqlTxModelWrapper.findObject(guided, guide);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "guide";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "guided";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/database/SqlTxModelWrapper$TwoModelVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visit";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "find";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

