/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlDataSourceMappings {
    private static final Key<CachedValue<List<DbDataSource>>> CACHED_DATA_SOURCES_KEY = Key.create((String)"CACHED_DATA_SOURCES_KEY");
    private final Project myProject;

    public static SqlDataSourceMappings getInstance(Project project) {
        return (SqlDataSourceMappings)ServiceManager.getService((Project)project, SqlDataSourceMappings.class);
    }

    public SqlDataSourceMappings(Project project) {
        this.myProject = project;
    }

    public List<DbDataSource> getDataSources(@NotNull PsiFile file) {
        PsiFile sqlFile;
        DbDataSource element;
        if (file == null) {
            SqlDataSourceMappings.$$$reportNull$$$0(0);
        }
        if ((element = DbImplUtil.getForcedDataSource(sqlFile = file.getOriginalFile())) != null) {
            return ContainerUtil.createMaybeSingletonList((Object)(element.isValid() ? element : null));
        }
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)this.myProject);
        if (dbPsiFacade != null) {
            CachedValue cached = (CachedValue)sqlFile.getUserData(CACHED_DATA_SOURCES_KEY);
            if (cached == null) {
                cached = CachedValuesManager.getManager((Project)sqlFile.getProject()).createCachedValue(() -> {
                    List result2 = DbSqlUtil.getDataSourcesForResolve(sqlFile).toList();
                    return new CachedValueProvider.Result((Object)result2, new Object[]{dbPsiFacade});
                }, false);
                sqlFile.putUserData(CACHED_DATA_SOURCES_KEY, (Object)cached);
            }
            return (List)cached.getValue();
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/dialects/SqlDataSourceMappings", "getDataSources"));
    }
}

