/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.Producer;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectsConfigurable
extends PerFileConfigurableBase<SqlLanguageDialect> {
    public SqlDialectsConfigurable(@NotNull Project project) {
        if (project == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(0);
        }
        super(project, (PerFileMappings)SqlDialectMappings.getInstance(project));
    }

    @Nls
    public String getDisplayName() {
        return SqlMessages.message("sql.dialects.configurable", new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.project.sql.dialects";
    }

    protected void renderValue(@Nullable Object target, @NotNull SqlLanguageDialect dialect, @NotNull ColoredTextContainer renderer) {
        if (dialect == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(1);
        }
        if (renderer == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(2);
        }
        renderer.append(dialect.getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    protected <S> Object getParameter(@NotNull Key<S> key) {
        if (key == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(3);
        }
        if (key == DESCRIPTION) {
            return SqlMessages.message("dialog.sql.dialects.caption", ApplicationNamesInfo.getInstance().getProductName(), StringUtil.escapeXml((String)DbSqlUtil.getGenericDialect().getDisplayName()));
        }
        if (key == MAPPING_TITLE) {
            return SqlMessages.message("dialog.sql.dialects.value.title", new Object[0]);
        }
        if (key == OVERRIDE_QUESTION) {
            return SqlMessages.message("dialog.sql.dialects.override.question", new Object[0]);
        }
        if (key == OVERRIDE_TITLE) {
            return SqlMessages.message("dialog.sql.dialects.override.title", new Object[0]);
        }
        return null;
    }

    @NotNull
    protected List<Trinity<String, Producer<SqlLanguageDialect>, Consumer<SqlLanguageDialect>>> getDefaultMappings() {
        List<Trinity<String, Producer<SqlLanguageDialect>, Consumer<SqlLanguageDialect>>> list = Collections.singletonList(Trinity.create((Object)"Global SQL Dialect", () -> SqlDialectMappings.getConfiguredDefaultSqlDialect(), o -> SqlDialectMappings.setDefaultSqlDialect(o)));
        if (list == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(4);
        }
        return list;
    }

    protected void renderDefaultValue(Object target, @NotNull ColoredTextContainer renderer) {
        SqlLanguageDialect t;
        if (renderer == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(5);
        }
        if ((t = (SqlLanguageDialect)this.getNewMapping((VirtualFile)target)) == null) {
            return;
        }
        renderer.append(t.getDisplayName(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
    }

    public static void openDialectsConfigurable(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            SqlDialectsConfigurable.$$$reportNull$$$0(6);
        }
        SqlDialectsConfigurable configurable = new SqlDialectsConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
            if (virtualFile != null) {
                configurable.selectFile(virtualFile);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlDialectsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlDialectsConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "renderValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renderDefaultValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openDialectsConfigurable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

