/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.code;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlDocumentationProvider;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.Functions;
import com.intellij.util.containers.JBIterable;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            OracleLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            OracleLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            OracleLineMarkerProvider.$$$reportNull$$$0(2);
        }
        for (PsiElement e : elements) {
            if (!(e instanceof SqlIdentifier) || !(e.getParent() instanceof SqlReferenceExpression) || !(e.getParent().getParent() instanceof SqlDefinition)) continue;
            JBIterable defs = SyntaxTraverser.psiApi().parents((Object)e).filter(SqlDefinition.class);
            SqlDefinition first = (SqlDefinition)defs.first();
            SqlDefinition second = (SqlDefinition)defs.skip(1).first();
            if (first == null || first.getNameElement() != e.getParent()) continue;
            if (OracleLineMarkerProvider.isPackageOrType(first)) {
                OracleLineMarkerProvider.collectSlowLineMarkers(e, first, first, result2);
                continue;
            }
            if (second == null || !OracleLineMarkerProvider.isPackageOrType(second)) continue;
            OracleLineMarkerProvider.collectSlowLineMarkers(e, first, second, result2);
        }
    }

    private static boolean isPackageOrType(SqlDefinition o) {
        ObjectKind kind = o.getKind();
        return kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.BODY;
    }

    private static void collectSlowLineMarkers(@NotNull PsiElement identifier, @NotNull SqlDefinition definition, @NotNull SqlDefinition psiPackage, @NotNull Collection<LineMarkerInfo> result2) {
        if (identifier == null) {
            OracleLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (definition == null) {
            OracleLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (psiPackage == null) {
            OracleLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            OracleLineMarkerProvider.$$$reportNull$$$0(6);
        }
        DbElement fileTarget = null;
        boolean isBody = psiPackage.getKind() == ObjectKind.BODY;
        for (DbElement o : SqlDocumentationProvider.findRelatedDbElements(null, psiPackage)) {
            fileTarget = isBody ? o : (DbElement)o.getDbChildren(DbElement.class, ObjectKind.BODY).first();
            if (fileTarget == null) continue;
            break;
        }
        if (fileTarget == null) {
            return;
        }
        Icon icon = isBody ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.ImplementedMethod;
        String text = isBody ? "Go to specification" : "Go to implementation";
        String actionId = isBody ? "GotoSuperMethod" : "GotoImplementation";
        String tooltip = OracleLineMarkerProvider.composeText(text, actionId);
        LineMarkerInfo info = new LineMarkerInfo((PsiElement)definition, identifier.getTextRange(), icon, 11, Functions.constant((Object)tooltip), (GutterIconNavigationHandler)new MyNavHandler(), GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)text, (String)actionId);
        result2.add(info);
    }

    @NotNull
    private static String composeText(@NotNull String start, @NotNull String actionId) {
        if (start == null) {
            OracleLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if (actionId == null) {
            OracleLineMarkerProvider.$$$reportNull$$$0(8);
        }
        String postfix = "<br><div style='margin-top: 5px'><font size='2'>Click";
        postfix = postfix + " to navigate</font></div>";
        String string = "<html><body>" + start + postfix + "</body></html>";
        if (string == null) {
            OracleLineMarkerProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/code/OracleLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/code/OracleLineMarkerProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "composeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "composeText";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyNavHandler
    implements GutterIconNavigationHandler<SqlDefinition> {
        private MyNavHandler() {
        }

        public void navigate(MouseEvent e, SqlDefinition definition) {
            SqlCreateStatement psiPackage = (SqlCreateStatement)PsiTreeUtil.getParentOfType((PsiElement)definition, SqlCreateStatement.class, (boolean)false);
            boolean isBody = psiPackage != null && psiPackage.getKind() == ObjectKind.BODY;
            DbElement fileTarget = null;
            for (DbElement o : SqlDocumentationProvider.findRelatedDbElements(null, (SqlDefinition)psiPackage)) {
                fileTarget = isBody ? o : (DbElement)o.getDbChildren(DbElement.class, ObjectKind.BODY).first();
                if (fileTarget == null) continue;
                break;
            }
            if (fileTarget == null) {
                return;
            }
            VirtualFile file = fileTarget.getVirtualFile();
            if (file != null) {
                int offset = OpenDataFileDescriptor.calcTargetOffset(fileTarget.getProject(), file, (DasObject)definition);
                new OpenFileDescriptor(fileTarget.getProject(), file, offset).navigate(true);
            }
        }
    }
}

