/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.lexer.SqlLexer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresLexerBase
extends SqlLexer {
    private static final Pattern DOLLAR_QUOTE = Pattern.compile("^(\\$\\w*\\$).*$");
    public static final String OP_CHARS = "+-*/<>=~!@#%^&|`?";

    protected PostgresLexerBase(Class tokenClass, FlexLexer flexLexer) {
        super(tokenClass, flexLexer);
    }

    @Override
    protected void lookAhead(Lexer baseLexer) {
        if (!(this.lookAheadRangeOperator(baseLexer) || this.lookAheadCustomQuotation(baseLexer) || this.lookAheadVariable(baseLexer) || this.lookAheadCustomOperator(baseLexer))) {
            super.lookAhead(baseLexer);
        }
    }

    protected boolean lookAheadVariable(Lexer baseLexer) {
        char nextChar;
        CharSequence text = baseLexer.getBufferSequence();
        int tokenStart = baseLexer.getTokenStart();
        int len = baseLexer.getBufferEnd();
        if (len > tokenStart + 1 && text.charAt(tokenStart) == '$' && (nextChar = text.charAt(tokenStart + 1)) >= '0' && nextChar <= '9') {
            char c;
            int tokenEnd;
            for (tokenEnd = tokenStart + 2; tokenEnd < len && (c = text.charAt(tokenEnd)) >= '0' && c <= '9'; ++tokenEnd) {
            }
            this.addToken(tokenEnd, (IElementType)SqlTokens.SQL_IDENT);
            baseLexer.start(text, tokenEnd, baseLexer.getBufferEnd(), 0);
            return true;
        }
        return false;
    }

    private boolean lookAheadCustomOperator(Lexer baseLexer) {
        CharSequence bufferSequence = baseLexer.getBufferSequence();
        int tokenStart = baseLexer.getTokenStart();
        int tokenEnd = baseLexer.getTokenEnd();
        int bufferEnd = baseLexer.getBufferEnd();
        for (int i2 = tokenStart; i2 <= bufferEnd; ++i2) {
            int j;
            int idx;
            char ch = i2 < bufferEnd ? bufferSequence.charAt(i2) : (char)'\u0000';
            int n = idx = ch > '\u0000' ? OP_CHARS.indexOf(ch) : -1;
            if (idx != -1) continue;
            if (i2 == tokenStart) {
                return false;
            }
            String op = bufferSequence.subSequence(tokenStart, i2).toString();
            int fix1 = op.indexOf("--");
            int fix2 = op.indexOf("/*");
            int p = Math.min(fix2 < 0 ? i2 : tokenStart + fix2, fix1 < 0 ? i2 : tokenStart + fix1);
            boolean qRemoved = op.charAt(op.length() - 1) == '?' && op.length() > 1 && op.charAt(op.length() - 2) != '?';
            int n2 = p = qRemoved ? p - 1 : p;
            if (p == tokenEnd) {
                return false;
            }
            boolean anychar = false;
            int oplen = p - tokenStart;
            for (j = 0; j < oplen; ++j) {
                char c = op.charAt(j);
                anychar |= OP_CHARS.indexOf(c) >= 7;
            }
            j = p;
            while (j - tokenStart >= 2) {
                oplen = j - tokenStart;
                boolean valid = anychar || op.charAt(oplen - 1) != '+' && op.charAt(oplen - 1) != '-';
                int offs = j;
                if (!valid && qRemoved) {
                    offs = p + 1;
                    valid = true;
                }
                if (valid) {
                    this.addToken(offs, (IElementType)SqlTokens.PG_OP_CUSTOM);
                    baseLexer.start(bufferSequence, offs, bufferEnd, 0);
                    return true;
                }
                --j;
            }
            return false;
        }
        return false;
    }

    private boolean lookAheadCustomQuotation(@NotNull Lexer baseLexer) {
        String identifier;
        if (baseLexer == null) {
            PostgresLexerBase.$$$reportNull$$$0(0);
        }
        if ((identifier = PostgresLexerBase.getDollarQuotingIdent(baseLexer)) == null) {
            return false;
        }
        int len = identifier.length();
        int stringStart = baseLexer.getTokenStart() + len;
        baseLexer.advance();
        return this.processCustomQuotation(baseLexer, identifier, stringStart, false, SqlTokens.SQL_CUSTOM_LQUOTE, SqlTokens.SQL_CUSTOM_RQUOTE, SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN);
    }

    @Nullable
    private static String getDollarQuotingIdent(@NotNull Lexer baseLexer) {
        IElementType tokenType;
        String identText;
        if (baseLexer == null) {
            PostgresLexerBase.$$$reportNull$$$0(1);
        }
        String string = identText = (tokenType = baseLexer.getTokenType()) == SqlTokens.SQL_IDENT_DELIMITED || tokenType == TokenType.BAD_CHARACTER ? baseLexer.getTokenText() : null;
        if (identText == null) {
            return null;
        }
        if (tokenType == TokenType.BAD_CHARACTER) {
            Matcher matcher = DOLLAR_QUOTE.matcher(identText);
            return matcher.lookingAt() ? matcher.group(1) : null;
        }
        int len = identText.length();
        return len >= 2 && identText.charAt(0) == '$' && identText.charAt(len - 1) == '$' ? identText : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "baseLexer";
        objectArray2[1] = "com/intellij/sql/dialects/postgres/PostgresLexerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "lookAheadCustomQuotation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDollarQuotingIdent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

