/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.impl.NameChecker;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCheckUsingColumnsInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlCheckUsingColumnsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlCheckUsingColumnsInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlCheckUsingColumnsInspection.$$$reportNull$$$0(2);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlUsingClause(SqlUsingClause o) {
                SqlTableType rightType;
                SqlReferenceList list = o.getReferenceList();
                List refs = list != null ? list.getReferenceList() : ContainerUtil.emptyList();
                PsiElement parent = o.getParent();
                if (!(parent instanceof SqlJoinExpression)) {
                    return;
                }
                SqlExpression left = ((SqlJoinExpression)parent).getLOperand();
                SqlExpression right = ((SqlJoinExpression)parent).getROperand();
                SqlType leftType = left.getSqlType();
                Object object = rightType = right != null ? right.getSqlType() : SqlTableTypeBase.EMPTY_TABLE;
                if (!(leftType instanceof SqlTableType)) {
                    return;
                }
                if (!(rightType instanceof SqlTableType)) {
                    return;
                }
                for (SqlReferenceExpression ref : refs) {
                    if (!this.matches((SqlTableType)leftType, ref)) {
                        this.addWarning(ref, "left");
                        continue;
                    }
                    if (this.matches(rightType, ref)) continue;
                    this.addWarning(ref, "right");
                }
            }

            private void addWarning(SqlReferenceExpression ref, String which) {
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)ref, "column '" + ref.getName() + "' specified in using clause does not exist in " + which + " table", (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
            }

            private boolean matches(SqlTableType type, SqlReferenceExpression ref) {
                final NameChecker nameChecker = new NameChecker(ref, this.myDialect, (CasingProvider)this.myDialect);
                SqlScopeProcessor processor = new SqlScopeProcessor(true, this.myDialect, SqlImplUtil.getDataSources((PsiElement)ref)){

                    @Override
                    public boolean isResultEmpty() {
                        return true;
                    }

                    @Override
                    public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement element, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (state == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return !nameChecker.checkName(target, forcedCaseSens);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "state";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/sql/inspections/SqlCheckUsingColumnsInspection$1$1";
                        objectArray[2] = "executeTarget";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                return !SqlImplUtil.processDeclarationsInType(type, (PsiScopeProcessor)processor, ResolveState.initial());
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlCheckUsingColumnsInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

