/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.google.common.collect.Iterables;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiTable;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAlterTableInstruction;
import com.intellij.sql.psi.SqlAlterTableStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlDropIndexedColumnInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            SqlDropIndexedColumnInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlDropIndexedColumnInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlDropIndexedColumnInspection.$$$reportNull$$$0(2);
        }
        if (!dialect.getDatabaseDialect().getFamilyId().isTransactSql()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result2){

            public void visitSqlAlterTableStatement(SqlAlterTableStatement o) {
                PsiElement table;
                SqlReferenceExpression reference = o.getAlterTargetReference();
                PsiPolyVariantReference tableRef = reference != null ? reference.getReference() : null;
                PsiElement psiElement = table = tableRef != null ? tableRef.resolve() : null;
                if (!(table instanceof PsiTable)) {
                    return;
                }
                JBIterable<? extends DasIndex> indices = SqlDropIndexedColumnInspection.this.getIndices((PsiTable)table);
                JBIterable keys = DasUtil.getTableKeys((DasTable)((DasTable)table));
                if (Iterables.isEmpty(indices)) {
                    return;
                }
                SyntaxTraverser traverser = (SyntaxTraverser)SqlImplUtil.sqlTraverser().expand(Conditions.notInstanceOf(SqlReferenceExpression.class));
                for (SqlAlterTableInstruction instruction : o.getAlterTableInstructions()) {
                    if (instruction.getInstructionType() != SqlCommonKeywords.SQL_DROP) continue;
                    for (SqlReferenceExpression element : ((SyntaxTraverser)traverser.withRoot((Object)instruction)).filter(SqlReferenceExpression.class)) {
                        String message;
                        String tail;
                        String indexName;
                        PsiElement obj;
                        if (element.getReferenceElementType().getTargetKind() != ObjectKind.COLUMN || !((obj = element.resolve()) instanceof DasColumn)) continue;
                        String columnName = ((DasColumn)obj).getName();
                        for (DasIndex index : indices) {
                            if (!DasUtil.containsName((String)columnName, (MultiRef)index.getColumnsRef())) continue;
                            indexName = index.getName();
                            tail = indexName == DasUtil.NO_NAME ? "" : " Drop the '" + indexName + "' index before dropping this column.";
                            message = "Attempt to dropping an indexed column." + tail;
                            this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)element, message, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                        }
                        for (DasTableKey key : keys) {
                            if (!DasUtil.containsName((String)columnName, (MultiRef)key.getColumnsRef())) continue;
                            indexName = key.getName();
                            tail = indexName == DasUtil.NO_NAME ? "" : " Drop the '" + indexName + "' key before dropping this column.";
                            message = "Attempt to dropping an indexed column." + tail;
                            this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)element, message, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                        }
                    }
                }
            }
        };
    }

    @NotNull
    protected JBIterable<? extends DasIndex> getIndices(PsiTable table) {
        PsiFile file;
        JBIterable declaredIndices = DasUtil.getIndices((DasTable)table);
        if (table instanceof SqlDefinition && (file = table.getContainingFile()) instanceof SqlFile) {
            JBIterable auxiliary = JBIterable.from((Iterable)((SqlFile)file).getDdl()).filter(DasIndex.class).filter(o -> {
                SqlReferenceExpression reference = ((SqlCreateIndexStatement)o).getTableReference();
                return reference != null && reference.getReference().isReferenceTo((PsiElement)table);
            });
            JBIterable jBIterable = JBIterable.empty().append((Iterable)declaredIndices).append((Iterable)auxiliary);
            if (jBIterable == null) {
                SqlDropIndexedColumnInspection.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        JBIterable jBIterable = declaredIndices;
        if (jBIterable == null) {
            SqlDropIndexedColumnInspection.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlDropIndexedColumnInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlDropIndexedColumnInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

