/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlIntentionUtil {
    @Nullable
    static SqlIdentifier getIdentifier(PsiElement at) {
        PsiElement element = at != null ? at.getParent() : null;
        return element instanceof SqlIdentifier ? (SqlIdentifier)element : null;
    }

    public static void qualifyReference(@NotNull Iterable<String> names, @NotNull SqlIdentifier identifier) {
        if (names == null) {
            SqlIntentionUtil.$$$reportNull$$$0(0);
        }
        if (identifier == null) {
            SqlIntentionUtil.$$$reportNull$$$0(1);
        }
        SqlLanguageDialectEx dialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)identifier);
        String quoted = StringUtil.join((Iterable)JBIterable.from(names).transform(name -> {
            if (identifier == null) {
                SqlIntentionUtil.$$$reportNull$$$0(6);
            }
            return dialectEx.quoteIdentifier(identifier.getProject(), (String)name);
        }), (String)".");
        PsiFile file = identifier.getContainingFile();
        if (file == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)identifier.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)identifier.getProject(), (String)"Qualify identifier", null, () -> {
            if (identifier == null) {
                SqlIntentionUtil.$$$reportNull$$$0(5);
            }
            document.insertString(identifier.getTextRange().getStartOffset(), (CharSequence)(quoted + "."));
        }, (PsiFile[])new PsiFile[]{file});
    }

    public static void qualifyReference(@NotNull List<? extends Iterable<String>> names, final @NotNull SqlIdentifier identifier, @NotNull Editor editor) {
        if (names == null) {
            SqlIntentionUtil.$$$reportNull$$$0(2);
        }
        if (identifier == null) {
            SqlIntentionUtil.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            SqlIntentionUtil.$$$reportNull$$$0(4);
        }
        if (names.isEmpty()) {
            return;
        }
        LinkedHashSet namesSet = ContainerUtil.newLinkedHashSet(names);
        final ArrayList uniqueNames = ContainerUtil.newArrayList((Iterable)namesSet);
        if (uniqueNames.size() == 1) {
            SqlIntentionUtil.qualifyReference((Iterable)uniqueNames.get(0), identifier);
            return;
        }
        final ArrayList qualified = ContainerUtil.newArrayList();
        for (Iterable name : uniqueNames) {
            qualified.add(StringUtil.join((Iterable)name, (String)".") + "." + identifier.getName());
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Integer>("Qualify With...", JBIterable.generate((Object)0, x -> x + 1).take(qualified.size()).toList()){

            @NotNull
            public String getTextFor(Integer value) {
                String string = (String)qualified.get(value);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep onChosen(Integer selectedValue, boolean finalChoice) {
                SqlIntentionUtil.qualifyReference((Iterable)uniqueNames.get(selectedValue), identifier);
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlIntentionUtil$1", "getTextFor"));
            }
        }).showInBestPositionFor(editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/intentions/SqlIntentionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "qualifyReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$qualifyReference$1";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$qualifyReference$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

